/*
 * Decompiled with CFR 0.152.
 */
package er.bugtracker.pages;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOResponse;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSNotificationCenter;
import er.directtoweb.pages.ERD2WPage;
import er.extensions.foundation.ERXFileUtilities;
import er.grouping.DRReportModel;

public class ReportPage
extends ERD2WPage {
    public DRReportModel model;
    public NSArray objects;
    public NSData reportData;
    public boolean enableExcel = false;
    public boolean enableChart = false;
    public NSDictionary _selectedReport;
    public String currentName;

    public ReportPage(WOContext context) {
        super(context);
    }

    public String reportComponentName() {
        if (this.enableExcel) {
            return "ExcelReport";
        }
        if (this.enableChart) {
            return "ChartReport";
        }
        return "WRReport";
    }

    public void postModelChangedNotification(DRReportModel model) {
        if (model != null) {
            log.info((Object)("postModel: " + model.hashCode()));
            NSNotificationCenter.defaultCenter().postNotification("DRReportModelRebuild", (Object)model, null);
        }
    }

    public WOComponent exportExcelAction() {
        this.enableExcel = true;
        return this.context().page();
    }

    public NSDictionary selectedReport() {
        if (this._selectedReport == null) {
            this.setSelectedReportName("ReportBugsPerUser");
        }
        return this._selectedReport;
    }

    public void setSelectedReportName(String reportName) {
        this._selectedReport = (NSDictionary)this.reports().objectForKey((Object)reportName);
        this.postModelChangedNotification(this.model);
    }

    public void selectReport() {
        this.setSelectedReportName(this.currentName);
    }

    public NSDictionary reports() {
        return (NSDictionary)ERXFileUtilities.readPropertyListFromFileInFramework((String)"Reports.plist", null);
    }

    public WOComponent showAsChartAction() {
        this.enableChart = true;
        return this.context().page();
    }

    public WOComponent showAsTableAction() {
        this.enableChart = false;
        return this.context().page();
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        super.appendToResponse(response, context);
        if (this.reportData != null) {
            response.setContent(this.reportData);
            this.reportData = null;
            String fileName = "results.xls";
            response.setHeader("inline; filename=\"" + fileName + "\"", "content-disposition");
            response.setHeader("application/vnd.ms-excel", "content-type");
            this.enableExcel = false;
        }
    }

    public NSArray objects() {
        if (this.objects == null) {
            this.objects = EOUtilities.objectsForEntityNamed((EOEditingContext)this.session().defaultEditingContext(), (String)this.entityName());
        }
        return this.objects;
    }
}

