/*
 * Decompiled with CFR 0.152.
 */
package er.bugtracker.tests;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOCookie;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSTimestamp;
import er.bugtracker.Framework;
import er.bugtracker.People;
import er.bugtracker.Session;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXUtilities;
import er.selenium.SeleniumAction;
import org.apache.log4j.Logger;

public class Selenium
extends SeleniumAction {
    public static final Logger log = Logger.getLogger(Selenium.class);
    public static final String USERNAME = "sel_name";
    public static final String PASSWORD = "sel_pass";
    private static final String NAME = "SeleniumName";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTestPeople() {
        People people = People.clazz.userWithUsernamePassword(this.session().defaultEditingContext(), USERNAME, PASSWORD);
        if (people != null) {
            EOEditingContext ec = ERXEC.newEditingContext();
            ec.lock();
            try {
                people = (People)EOUtilities.localInstanceOfObject((EOEditingContext)ec, (EOEnterpriseObject)people);
                ERXUtilities.deleteObjects((EOEditingContext)ec, (NSArray)people.allBugs());
                people.delete();
                EOKeyValueQualifier frameworkQualifier = new EOKeyValueQualifier("owner", EOQualifier.QualifierOperatorEqual, (Object)people);
                assert (frameworkQualifier != null);
                NSArray frameworks = ERXEOControlUtilities.objectsWithQualifier((EOEditingContext)ec, (String)Framework.class.getSimpleName(), (EOQualifier)frameworkQualifier, null, (boolean)false);
                ERXUtilities.deleteObjects((EOEditingContext)ec, (NSArray)frameworks);
                ec.saveChanges();
            }
            finally {
                ec.unlock();
            }
            log.debug((Object)"People sel_name deleted");
        }
    }

    private People addTestPeople(boolean isAdmin) {
        EOEditingContext ec = ERXEC.newEditingContext();
        People people = (People)People.clazz.createAndInsertObject(ec);
        people.setName(NAME);
        people.setLogin(USERNAME);
        people.setPassword(PASSWORD);
        people.setIsAdmin(Boolean.valueOf(isAdmin));
        ec.saveChanges();
        log.debug((Object)"People sel_name added");
        return people;
    }

    private WOActionResults ensureTestPeopleAreLoggedIn() {
        Session session = (Session)this.session();
        session.setLanguage("English");
        People people = People.clazz.userWithUsernamePassword(session.defaultEditingContext(), USERNAME, PASSWORD);
        session.setUser(people);
        return this.success();
    }

    public Selenium(WORequest request) {
        super(request);
    }

    public WOActionResults resetSessionAction() {
        WOCookie dummyCookie = new WOCookie("BTL", "dummy");
        dummyCookie.setPath("/");
        dummyCookie.setDomain(null);
        dummyCookie.setExpires(new NSTimestamp().timestampByAddingGregorianUnits(0, -2, 0, 0, 0, 0));
        WOResponse response = this.success();
        response.addCookie(dummyCookie);
        this.session().terminate();
        return response;
    }

    public WOActionResults ensureTestAdminAction() {
        this.deleteTestPeople();
        this.addTestPeople(true);
        return this.ensureTestPeopleAreLoggedIn();
    }

    public WOActionResults ensurePeopleSetupAction() {
        Session session = (Session)this.session();
        People people = People.clazz.userWithUsernamePassword(session.defaultEditingContext(), "user100", "user");
        assert (people != null);
        people.setIsActive(Boolean.valueOf(false));
        people = People.clazz.userWithUsernamePassword(session.defaultEditingContext(), "user101", "user");
        assert (people != null);
        people.setIsActive(Boolean.valueOf(true));
        people.setIsAdmin(Boolean.valueOf(false));
        people.setIsEngineering(Boolean.valueOf(false));
        people.setIsCustomerService(Boolean.valueOf(true));
        session.defaultEditingContext().saveChanges();
        return this.ensureTestAdminAction();
    }

    public WOActionResults deleteTestPeopleAction() {
        this.deleteTestPeople();
        return this.success();
    }

    public WOActionResults disableTinyMCEAction() {
        ERXProperties.setStringForKey((String)"nonexisting.js", (String)"er.directtoweb.ERDEditHTML.tinyMceSourceFileName");
        return this.success();
    }

    public WOActionResults enableTinyMCEAction() {
        System.clearProperty("er.directtoweb.ERDEditHTML.tinyMceSourceFileName");
        return this.success();
    }
}

