/*
 * Decompiled with CFR 0.152.
 */
package com.meetup.memcached;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Logger {
    public static final int LEVEL_DEBUG = 0;
    public static final int LEVEL_INFO = 1;
    public static final int LEVEL_WARN = 2;
    public static final int LEVEL_ERROR = 3;
    public static final int LEVEL_FATAL = 4;
    private static Map<String, Logger> loggers = new HashMap<String, Logger>();
    private String name;
    private int level;
    private boolean initialized = false;

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    protected Logger(String name, int level) {
        this.name = name;
        this.level = level;
        this.initialized = true;
    }

    protected Logger(String name) {
        this.name = name;
        this.level = 1;
        this.initialized = true;
    }

    public static synchronized Logger getLogger(String name, int level) {
        Logger log = Logger.getLogger(name);
        if (log.getLevel() != level) {
            log.setLevel(level);
        }
        return log;
    }

    public static synchronized Logger getLogger(String name) {
        Logger log = null;
        if (loggers.containsKey(name)) {
            log = loggers.get(name);
        } else {
            log = new Logger(name);
            loggers.put(name, log);
        }
        return log;
    }

    private void log(String mesg, Throwable ex) {
        System.out.println(this.name + " " + new Date() + " - " + mesg);
        if (ex != null) {
            ex.printStackTrace(System.out);
        }
    }

    public void debug(String mesg, Throwable ex) {
        if (this.level > 0) {
            return;
        }
        this.log(mesg, ex);
    }

    public void debug(String mesg) {
        this.debug(mesg, null);
    }

    public boolean isDebugEnabled() {
        return this.level <= 0;
    }

    public void info(String mesg, Throwable ex) {
        if (this.level > 1) {
            return;
        }
        this.log(mesg, ex);
    }

    public void info(String mesg) {
        this.info(mesg, null);
    }

    public boolean isInfoEnabled() {
        return this.level <= 1;
    }

    public void warn(String mesg, Throwable ex) {
        if (this.level > 2) {
            return;
        }
        this.log(mesg, ex);
    }

    public void warn(String mesg) {
        this.warn(mesg, null);
    }

    public void error(String mesg, Throwable ex) {
        if (this.level > 3) {
            return;
        }
        this.log(mesg, ex);
    }

    public void error(String mesg) {
        this.error(mesg, null);
    }

    public void fatal(String mesg, Throwable ex) {
        if (this.level > 4) {
            return;
        }
        this.log(mesg, ex);
    }

    public void fatal(String mesg) {
        this.fatal(mesg, null);
    }
}

