/*
 * Decompiled with CFR 0.152.
 */
package com.thimbleware.jmemcached;

import com.thimbleware.jmemcached.CacheStorage;
import com.thimbleware.jmemcached.MCElement;
import java.util.Set;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.mina.common.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cache {
    private int currentItems;
    private int totalItems;
    private int getCmds;
    private int setCmds;
    private int getHits;
    private int getMisses;
    private long bytesRead;
    private long bytesWritten;
    private long casCounter;
    protected CacheStorage cacheStorage;
    private DelayQueue<DelayedMCElement> deleteQueue;
    private final ReadWriteLock deleteQueueReadWriteLock;
    private final ReadWriteLock cacheReadWriteLock;

    public Cache(CacheStorage cacheStorage) {
        this.initStats();
        this.cacheStorage = cacheStorage;
        this.deleteQueue = new DelayQueue();
        this.cacheReadWriteLock = new ReentrantReadWriteLock();
        this.deleteQueueReadWriteLock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeleteResponse delete(String key, int time) {
        try {
            this.startCacheWrite();
            if (this.isThere(key)) {
                if (time != 0) {
                    MCElement el = this.cacheStorage.get(key);
                    el.blocked = true;
                    el.blocked_until = this.Now() + time;
                    el.data_length = 0;
                    el.data = new byte[0];
                    this.cacheStorage.put(key, el, el.data_length);
                    try {
                        this.deleteQueueReadWriteLock.writeLock().lock();
                        this.deleteQueue.add(new DelayedMCElement(el));
                    }
                    finally {
                        this.deleteQueueReadWriteLock.writeLock().unlock();
                    }
                } else {
                    this.cacheStorage.remove(key);
                }
                DeleteResponse deleteResponse = DeleteResponse.DELETED;
                return deleteResponse;
            }
            DeleteResponse deleteResponse = DeleteResponse.NOT_FOUND;
            return deleteResponse;
        }
        finally {
            this.finishCacheWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDeleteQueue() {
        block7: {
            try {
                this.deleteQueueReadWriteLock.writeLock().lock();
                DelayedMCElement toDelete = (DelayedMCElement)this.deleteQueue.poll();
                if (toDelete == null) break block7;
                try {
                    this.startCacheWrite();
                    if (this.cacheStorage.get(((DelayedMCElement)toDelete).element.keystring) != null) {
                        this.cacheStorage.remove(((DelayedMCElement)toDelete).element.keystring);
                    }
                }
                finally {
                    this.finishCacheWrite();
                }
            }
            finally {
                this.deleteQueueReadWriteLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreResponse add(MCElement e) {
        try {
            this.startCacheWrite();
            if (!this.isThere(e.keystring)) {
                StoreResponse storeResponse = this.set(e);
                return storeResponse;
            }
            StoreResponse storeResponse = StoreResponse.NOT_STORED;
            return storeResponse;
        }
        finally {
            this.finishCacheWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreResponse replace(MCElement e) {
        try {
            this.startCacheWrite();
            if (this.isThere(e.keystring)) {
                StoreResponse storeResponse = this.set(e);
                return storeResponse;
            }
            StoreResponse storeResponse = StoreResponse.NOT_STORED;
            return storeResponse;
        }
        finally {
            this.finishCacheWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreResponse append(MCElement element) {
        try {
            this.startCacheWrite();
            MCElement ret = this.get(element.keystring);
            if (ret == null || this.isBlocked(ret) || this.isExpired(ret)) {
                StoreResponse storeResponse = StoreResponse.NOT_FOUND;
                return storeResponse;
            }
            ret.data_length += element.data_length;
            ByteBuffer b = ByteBuffer.allocate((int)ret.data_length);
            b.put(ret.data);
            b.put(element.data);
            ret.data = new byte[ret.data_length];
            b.flip();
            b.get(ret.data);
            ++ret.cas_unique;
            this.cacheStorage.put(ret.keystring, ret, ret.data_length);
            StoreResponse storeResponse = StoreResponse.STORED;
            return storeResponse;
        }
        finally {
            this.finishCacheWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreResponse prepend(MCElement element) {
        try {
            this.startCacheWrite();
            MCElement ret = this.get(element.keystring);
            if (ret == null || this.isBlocked(ret) || this.isExpired(ret)) {
                StoreResponse storeResponse = StoreResponse.NOT_FOUND;
                return storeResponse;
            }
            ret.data_length += element.data_length;
            ByteBuffer b = ByteBuffer.allocate((int)ret.data_length);
            b.put(element.data);
            b.put(ret.data);
            ret.data = new byte[ret.data_length];
            b.flip();
            b.get(ret.data);
            ++ret.cas_unique;
            this.cacheStorage.put(ret.keystring, ret, ret.data_length);
            StoreResponse storeResponse = StoreResponse.STORED;
            return storeResponse;
        }
        finally {
            this.finishCacheWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreResponse set(MCElement e) {
        try {
            this.startCacheWrite();
            ++this.setCmds;
            e.cas_unique = this.casCounter++;
            this.cacheStorage.put(e.keystring, e, e.data_length);
            StoreResponse storeResponse = StoreResponse.STORED;
            return storeResponse;
        }
        finally {
            this.finishCacheWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreResponse cas(Long cas_key, MCElement e) {
        try {
            this.startCacheWrite();
            MCElement element = this.get(e.keystring);
            if (element == null || this.isBlocked(element)) {
                StoreResponse storeResponse = StoreResponse.NOT_FOUND;
                return storeResponse;
            }
            if (element.cas_unique == cas_key) {
                StoreResponse storeResponse = this.set(e);
                return storeResponse;
            }
            StoreResponse storeResponse = StoreResponse.EXISTS;
            return storeResponse;
        }
        finally {
            this.finishCacheWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer get_add(String key, int mod) {
        try {
            this.startCacheWrite();
            MCElement e = this.cacheStorage.get(key);
            if (e == null) {
                ++this.getMisses;
                Integer n = null;
                return n;
            }
            if (this.isExpired(e) || e.blocked) {
                ++this.getMisses;
                Integer n = null;
                return n;
            }
            int old_val = Integer.parseInt(new String(e.data)) + mod;
            if (old_val < 0) {
                old_val = 0;
            }
            e.data = String.valueOf(old_val).getBytes();
            e.data_length = e.data.length;
            e.cas_unique = this.casCounter++;
            this.cacheStorage.put(e.keystring, e, e.data_length);
            Integer n = old_val;
            return n;
        }
        finally {
            this.finishCacheWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isThere(String key) {
        try {
            this.startCacheRead();
            MCElement e = this.cacheStorage.get(key);
            boolean bl = e != null && !this.isExpired(e) && !this.isBlocked(e);
            return bl;
        }
        finally {
            this.finishCacheRead();
        }
    }

    protected boolean isBlocked(MCElement e) {
        return e.blocked && e.blocked_until > (long)this.Now();
    }

    protected boolean isExpired(MCElement e) {
        return e.expire != 0 && e.expire < this.Now();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MCElement get(String key) {
        ++this.getCmds;
        try {
            this.startCacheRead();
            MCElement e = this.cacheStorage.get(key);
            if (e == null) {
                ++this.getMisses;
                MCElement mCElement = null;
                return mCElement;
            }
            if (this.isExpired(e) || e.blocked) {
                ++this.getMisses;
                MCElement mCElement = null;
                return mCElement;
            }
            ++this.getHits;
            MCElement mCElement = e;
            return mCElement;
        }
        finally {
            this.finishCacheRead();
        }
    }

    public boolean flush_all() {
        return this.flush_all(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flush_all(int expire) {
        try {
            this.startCacheWrite();
            this.cacheStorage.clear();
        }
        finally {
            this.finishCacheWrite();
        }
        return true;
    }

    protected final int Now() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    protected void initStats() {
        this.currentItems = 0;
        this.totalItems = 0;
        this.getMisses = 0;
        this.getHits = 0;
        this.setCmds = 0;
        this.getCmds = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keys() {
        try {
            this.startCacheRead();
            Set<String> set = this.cacheStorage.keys();
            return set;
        }
        finally {
            this.finishCacheRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentItems() {
        try {
            this.startCacheRead();
            long l = this.cacheStorage.count();
            return l;
        }
        finally {
            this.finishCacheRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLimitMaxBytes() {
        try {
            this.startCacheRead();
            long l = this.cacheStorage.getMaximumSize();
            return l;
        }
        finally {
            this.finishCacheRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentBytes() {
        try {
            this.startCacheRead();
            long l = this.cacheStorage.getSize();
            return l;
        }
        finally {
            this.finishCacheRead();
        }
    }

    private void startCacheRead() {
        this.cacheReadWriteLock.readLock().lock();
    }

    private void finishCacheRead() {
        this.cacheReadWriteLock.readLock().unlock();
    }

    private void startCacheWrite() {
        this.cacheReadWriteLock.writeLock().lock();
    }

    private void finishCacheWrite() {
        this.cacheReadWriteLock.writeLock().unlock();
    }

    public int getTotalItems() {
        return this.totalItems;
    }

    public int getGetCmds() {
        return this.getCmds;
    }

    public int getSetCmds() {
        return this.setCmds;
    }

    public int getGetHits() {
        return this.getHits;
    }

    public int getGetMisses() {
        return this.getMisses;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    private class DelayedMCElement
    implements Delayed {
        private MCElement element;

        public DelayedMCElement(MCElement element) {
            this.element = element;
        }

        public long getDelay(TimeUnit timeUnit) {
            return timeUnit.convert(this.element.blocked_until - (long)Cache.this.Now(), TimeUnit.MILLISECONDS);
        }

        public int compareTo(Delayed delayed) {
            if (!(delayed instanceof DelayedMCElement)) {
                return -1;
            }
            return this.element.keystring.compareTo(((DelayedMCElement)delayed).element.keystring);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DeleteResponse {
        DELETED,
        NOT_FOUND;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StoreResponse {
        STORED,
        NOT_STORED,
        EXISTS,
        NOT_FOUND;

    }
}

