/*
 * Decompiled with CFR 0.152.
 */
package com.thimbleware.jmemcached;

import com.thimbleware.jmemcached.Cache;
import com.thimbleware.jmemcached.MemcachedProtocolCodecFactory;
import com.thimbleware.jmemcached.ServerSessionHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.mina.common.ExecutorThreadModel;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemCacheDaemon {
    final Logger logger = LoggerFactory.getLogger(MemCacheDaemon.class);
    public static String memcachedVersion = "0.3";
    private int receiveBufferSize = 1024000;
    private int sendBufferSize = 1024000;
    private boolean verbose;
    private int idleTime;
    private InetSocketAddress addr;
    private int port;
    private Cache cache;
    private SocketAcceptor acceptor;

    public void start() throws IOException {
        this.acceptor = new SocketAcceptor(16, (Executor)Executors.newCachedThreadPool());
        SocketAcceptorConfig defaultConfig = this.acceptor.getDefaultConfig();
        SocketSessionConfig sessionConfig = defaultConfig.getSessionConfig();
        sessionConfig.setSendBufferSize(this.sendBufferSize);
        sessionConfig.setReceiveBufferSize(this.receiveBufferSize);
        sessionConfig.setTcpNoDelay(true);
        defaultConfig.setThreadModel((ThreadModel)ExecutorThreadModel.getInstance((String)"jmemcached"));
        this.acceptor.bind((SocketAddress)this.addr, (IoHandler)new ServerSessionHandler(this.cache, memcachedVersion, this.verbose, this.idleTime));
        MemcachedProtocolCodecFactory codec = new MemcachedProtocolCodecFactory();
        this.acceptor.getFilterChain().addFirst("protocolFilter", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)codec));
        this.logger.info("Listening on " + String.valueOf(this.addr.getHostName()) + ":" + this.port);
    }

    public void stop() {
        if (this.acceptor != null) {
            this.logger.info("Stopping daemon");
            this.acceptor.unbindAll();
        }
    }

    public static void setMemcachedVersion(String memcachedVersion) {
        MemCacheDaemon.memcachedVersion = memcachedVersion;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setIdleTime(int idleTime) {
        this.idleTime = idleTime;
    }

    public void setAddr(InetSocketAddress addr) {
        this.addr = addr;
        this.port = addr.getPort();
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }
}

