/*
 * Decompiled with CFR 0.152.
 */
package er.excel;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableDictionary;
import er.excel.EGSimpleTableParser;
import er.extensions.foundation.ERXFileUtilities;
import er.extensions.foundation.ERXKeyValueCodingUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class EGSimpleTableCreator {
    protected final Logger log = Logger.getLogger(EGSimpleTableParser.class);
    private static NSDictionary _fontDef;
    private static NSDictionary _styleDef;
    private static NSDictionary _cellDef;
    private HSSFWorkbook _workbook;
    private StringBuffer _html;

    private static NSDictionary dictionaryFromClassConstants(Class clazz, NSArray constants) {
        NSMutableDictionary result = new NSMutableDictionary();
        Enumeration keys = constants.objectEnumerator();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object o = ERXKeyValueCodingUtilities.classValueForKey((Class)clazz, (String)key);
            if (o == null) continue;
            result.setObjectForKey((Object)key, o);
        }
        return result;
    }

    private static NSDictionary dictionaryFromClassConstantDefinition(Class clazz, NSDictionary definition) {
        NSMutableDictionary result = new NSMutableDictionary();
        Enumeration keys = definition.keyEnumerator();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            NSArray constants = (NSArray)definition.objectForKey((Object)key);
            NSDictionary parsedKeys = EGSimpleTableCreator.dictionaryFromClassConstants(clazz, constants);
            result.setObjectForKey((Object)parsedKeys, (Object)key);
        }
        return result;
    }

    public EGSimpleTableCreator(File file) throws IOException {
        POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(file));
        this._workbook = new HSSFWorkbook(fs);
    }

    public String html() {
        if (this._html == null) {
            this._html = new StringBuffer();
            this.appendWorkbook();
        }
        return this._html.toString();
    }

    private void appendAttribute(String attribute, Object value) {
        if (value != null) {
            this._html.append(' ').append(attribute).append("=\"").append(value).append('\"');
        }
    }

    private void appendValueForKey(Object object, String key) {
        if (object != null) {
            Object value = NSKeyValueCoding.Utility.valueForKey((Object)object, (String)key);
            this.appendAttribute(key, value);
        }
    }

    private void appendColorForKey(Object object, String key) {
        HSSFColor col;
        short idx;
        Object value;
        if (object != null && (value = NSKeyValueCoding.Utility.valueForKey((Object)object, (String)key)) instanceof Number && (idx = ((Number)value).shortValue()) > 0 && (col = this._workbook.getCustomPalette().getColor(idx)) != null) {
            String stringValue = "#" + col.getHexString();
            this.appendAttribute(key, stringValue);
        }
    }

    private void appendDataFormatForKey(Object object, String key) {
        String fmt;
        short idx;
        Object value;
        if (object != null && (value = NSKeyValueCoding.Utility.valueForKey((Object)object, (String)key)) instanceof Number && (idx = ((Number)value).shortValue()) > 0 && (fmt = this._workbook.createDataFormat().getFormat(idx)) != null) {
            this.appendAttribute(key, fmt);
        }
    }

    private void appendValueForKeyWithMapping(Object object, String key, NSDictionary mapping) {
        if (object != null) {
            Object candidate;
            Object value = NSKeyValueCoding.Utility.valueForKey((Object)object, (String)key);
            NSDictionary map = (NSDictionary)mapping.objectForKey((Object)key);
            if (map != null && (candidate = map.objectForKey(value)) != null) {
                value = candidate;
            }
            this.appendAttribute(key, value);
        }
    }

    private void appendWorkbook() {
        short i;
        this._html.append("<div>\n");
        for (i = 0; i < this._workbook.getNumberOfFonts(); i = (short)(i + 1)) {
            HSSFFont font = this._workbook.getFontAt(i);
            this.appendFont(font, i);
        }
        for (i = 0; i < this._workbook.getNumCellStyles(); i = (short)(i + 1)) {
            HSSFCellStyle cellStyle = this._workbook.getCellStyleAt(i);
            this.appendCellStyle(cellStyle, i);
        }
        for (i = 0; i < this._workbook.getNumberOfSheets(); i = (short)(i + 1)) {
            HSSFSheet sheet = this._workbook.getSheetAt((int)i);
            String name = this._workbook.getSheetName((int)i);
            this.appendSheet(sheet, name);
        }
        this._html.append("</div>");
    }

    private void appendSheet(HSSFSheet sheet, String name) {
        this._html.append("<table");
        this.appendAttribute("border", new Integer(1));
        this.appendAttribute("name", name);
        this.appendValueForKey(sheet, "defaultRowHeightInPoints");
        this.appendValueForKey(sheet, "defaultColumnWidth");
        this._html.append(">");
        for (int i = 0; i < sheet.getPhysicalNumberOfRows(); ++i) {
            HSSFRow row = sheet.getRow(i);
            this.appendRow(row);
        }
        this._html.append("</table>\n");
    }

    private void appendRow(HSSFRow row) {
        this._html.append("\t<tr");
        this.appendValueForKey(row, "heightInPoints");
        this._html.append(">\n");
        for (short i = 0; i < row.getPhysicalNumberOfCells(); i = (short)(i + 1)) {
            HSSFCell cell = row.getCell(i);
            this.appendCell(cell);
        }
        this._html.append("\t</tr>\n");
    }

    private void appendCell(HSSFCell cell) {
        this._html.append("\t\t<td");
        this.appendValueForKeyWithMapping(cell, "cellType", _cellDef);
        short idx = cell.getCellStyle().getIndex();
        if (idx >= 0) {
            this.appendAttribute("class", "egstyle" + idx);
        }
        this._html.append(">");
        int cellType = cell.getCellType();
        Object value = null;
        switch (cellType) {
            case 0: {
                value = new Double(cell.getNumericCellValue());
                break;
            }
            case 2: {
                value = cell.getCellFormula();
                break;
            }
            default: {
                value = cell.getStringCellValue();
            }
        }
        this._html.append(value);
        this._html.append("</td>\n");
    }

    private void appendFont(HSSFFont font, short i) {
        this._html.append("<egfont");
        this.appendAttribute("id", "egfont" + i);
        this.appendValueForKey(font, "fontName");
        this.appendValueForKey(font, "fontHeightInPoints");
        this.appendValueForKeyWithMapping(font, "boldweight", _fontDef);
        this.appendValueForKeyWithMapping(font, "underline", _fontDef);
        this.appendValueForKeyWithMapping(font, "typeOffset", _fontDef);
        this.appendColorForKey(font, "color");
        this.appendValueForKey(font, "italic");
        this.appendValueForKey(font, "strikeout");
        this._html.append("/>\n");
    }

    private void appendCellStyle(HSSFCellStyle cellStyle, short i) {
        this._html.append("<egstyle");
        this.appendAttribute("id", "egstyle" + i);
        this.appendValueForKey(cellStyle, "wrapText");
        this.appendValueForKeyWithMapping(cellStyle, "verticalAlignment", _styleDef);
        this.appendColorForKey(cellStyle, "topBorderColor");
        this.appendColorForKey(cellStyle, "leftBorderColor");
        this.appendColorForKey(cellStyle, "rightBorderColor");
        this.appendColorForKey(cellStyle, "bottomBorderColor");
        this.appendValueForKey(cellStyle, "locked");
        this.appendValueForKey(cellStyle, "rotation");
        this.appendValueForKey(cellStyle, "indention");
        this.appendValueForKey(cellStyle, "hidden");
        short idx = cellStyle.getFontIndex();
        this.appendAttribute("fontIndex", "egfont" + idx);
        this.appendValueForKeyWithMapping(cellStyle, "fillPattern", _styleDef);
        this.appendColorForKey(cellStyle, "fillForegroundColor");
        this.appendColorForKey(cellStyle, "fillBackgroundColor");
        this.appendDataFormatForKey(cellStyle, "dataFormat");
        this.appendValueForKeyWithMapping(cellStyle, "borderTop", _styleDef);
        this.appendValueForKeyWithMapping(cellStyle, "borderLeft", _styleDef);
        this.appendValueForKeyWithMapping(cellStyle, "borderRight", _styleDef);
        this.appendValueForKeyWithMapping(cellStyle, "borderBottom", _styleDef);
        this._html.append(" />\n");
    }

    static {
        NSDictionary codes = (NSDictionary)ERXFileUtilities.readPropertyListFromFileInFramework((String)"Codes.plist", (String)"ExcelGenerator");
        _fontDef = EGSimpleTableCreator.dictionaryFromClassConstantDefinition(HSSFFont.class, (NSDictionary)codes.objectForKey((Object)"font"));
        _styleDef = EGSimpleTableCreator.dictionaryFromClassConstantDefinition(HSSFCellStyle.class, (NSDictionary)codes.objectForKey((Object)"style"));
        _cellDef = EGSimpleTableCreator.dictionaryFromClassConstantDefinition(HSSFCell.class, (NSDictionary)codes.objectForKey((Object)"cell"));
    }
}

