/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb.callback;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import org.jabsorb.callback.CallbackData;
import org.jabsorb.callback.ErrorInvocationCallback;
import org.jabsorb.callback.InvocationCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackController
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger log = LoggerFactory.getLogger((Class)CallbackController.class);
    private HashSet callbackSet = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallback(InvocationCallback callback, Class contextInterface) {
        HashSet hashSet = this.callbackSet;
        synchronized (hashSet) {
            this.callbackSet.add(new CallbackData(callback, contextInterface));
        }
        if (log.isDebugEnabled()) {
            log.debug("registered callback " + callback.getClass().getName() + " with context interface " + contextInterface.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCallback(InvocationCallback callback, Class contextInterface) {
        HashSet hashSet = this.callbackSet;
        synchronized (hashSet) {
            this.callbackSet.remove(new CallbackData(callback, contextInterface));
        }
        if (log.isDebugEnabled()) {
            log.debug("unregistered callback " + callback.getClass().getName() + " with context " + contextInterface.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preInvokeCallback(Object context, Object instance, Method method, Object[] arguments) throws Exception {
        HashSet hashSet = this.callbackSet;
        synchronized (hashSet) {
            Iterator i = this.callbackSet.iterator();
            while (i.hasNext()) {
                CallbackData cbdata = (CallbackData)i.next();
                if (!cbdata.understands(context)) continue;
                cbdata.getCallback().preInvoke(context, instance, method, arguments);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInvokeCallback(Object context, Object instance, Method method, Object result) throws Exception {
        HashSet hashSet = this.callbackSet;
        synchronized (hashSet) {
            Iterator i = this.callbackSet.iterator();
            while (i.hasNext()) {
                CallbackData cbdata = (CallbackData)i.next();
                if (!cbdata.understands(context)) continue;
                cbdata.getCallback().postInvoke(context, instance, method, result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void errorCallback(Object context, Object instance, Method method, Throwable error) {
        HashSet hashSet = this.callbackSet;
        synchronized (hashSet) {
            Iterator i = this.callbackSet.iterator();
            while (i.hasNext()) {
                CallbackData cbdata = (CallbackData)i.next();
                if (!cbdata.understands(context) || !(cbdata.getCallback() instanceof ErrorInvocationCallback)) continue;
                ErrorInvocationCallback ecb = (ErrorInvocationCallback)cbdata.getCallback();
                try {
                    ecb.invocationError(context, instance, method, error);
                }
                catch (Throwable th) {}
            }
        }
    }
}

