/*
 * Decompiled with CFR 0.152.
 */
package er.bugtracker;

import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.jdbcadaptor.JDBCAdaptorException;
import er.attachment.ERAttachmentPrincipal;
import er.bugtracker.Priority;
import er.bugtracker.State;
import er.bugtracker.TestItemState;
import er.corebusinesslogic.ERCoreBusinessLogic;
import er.extensions.ERXExtensions;
import er.extensions.ERXFrameworkPrincipal;
import er.extensions.appserver.ERXApplication;
import er.extensions.appserver.ERXMainRunner;
import er.extensions.eof.ERXEC;
import er.prototypes.ERPrototypes;
import er.taggable.ERTaggableEntity;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class BTBusinessLogic
extends ERXFrameworkPrincipal {
    public static final Class[] REQUIRES = new Class[]{ERXExtensions.class, ERPrototypes.class, ERCoreBusinessLogic.class, ERAttachmentPrincipal.class};
    static BTBusinessLogic sharedInstance;
    private static boolean _sharedDataInitialized;

    public static BTBusinessLogic sharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = (BTBusinessLogic)ERXFrameworkPrincipal.sharedInstance(BTBusinessLogic.class);
        }
        return sharedInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishInitialization() {
        EOEditingContext ec = ERXEC.newEditingContext();
        ec.lock();
        try {
            String url;
            EOModel model = EOModelGroup.defaultGroup().modelNamed("BugTracker");
            EOEntity release = model.entityNamed("Release");
            if (model.connectionDictionary().toString().toLowerCase().indexOf(":mysql") >= 0) {
                release.setExternalName("`RELEASE`");
            } else if (model.connectionDictionary().toString().toLowerCase().indexOf(":derby") >= 0 && !(url = "" + model.connectionDictionary().objectForKey((Object)"URL")).contains(";create=true")) {
                Connection conn = null;
                try {
                    Class<?> foundDriver = Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
                    conn = DriverManager.getConnection(url + ";create=true");
                    Statement s = conn.createStatement();
                }
                catch (SQLException e) {
                }
                catch (ClassNotFoundException e) {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
                }
                finally {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            ERCoreBusinessLogic.sharedInstance().addPreferenceRelationshipToActorEntity("People", "id");
            ERTaggableEntity.registerTaggable((String)"Bug");
        }
        catch (JDBCAdaptorException ex) {
            if (!(ERXApplication.erxApplication() instanceof ERXMainRunner)) {
                throw ex;
            }
        }
        finally {
            ec.unlock();
        }
    }

    public static void initializeSharedData() {
        if (!_sharedDataInitialized) {
            _sharedDataInitialized = true;
            State.clazz.initializeSharedData();
            Priority.clazz.initializeSharedData();
            TestItemState.clazz.initializeSharedData();
            ERTaggableEntity.registerTaggable((String)"Bug");
        }
    }

    public void didFinishInitialization() {
        BTBusinessLogic.initializeSharedData();
    }

    static {
        BTBusinessLogic.setUpFrameworkPrincipalClass(BTBusinessLogic.class);
        _sharedDataInitialized = false;
    }
}

