/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects._ideservices;

import com.webobjects._ideservices._PBProject;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class _WOLipsProject
extends _PBProject {
    private File _bundleFolder;
    private File _contentsFolder;
    private File _versionFile;
    private long _lastModified;

    public _WOLipsProject(File bundleFolder) {
        this._bundleFolder = bundleFolder;
        this._contentsFolder = bundleFolder.getName().endsWith(".framework") ? this._bundleFolder : new File(this._bundleFolder, "Contents");
        this._versionFile = new File(this._bundleFolder.getParentFile(), ".version");
        this._dict = new NSMutableDictionary();
        this._lastModified = -1L;
    }

    public File contentsFolder() {
        return this._contentsFolder;
    }

    protected void refreshIfNecessary() {
        long lastModified;
        if ((this._lastModified == -1L || this._versionFile.exists()) && (lastModified = this._versionFile.lastModified()) != this._lastModified) {
            File webserverResourcesFolder;
            this._lastModified = lastModified;
            super.filesTable().removeAllObjects();
            super.mutableLocalFiles().removeAllObjects();
            File resourcesFolder = new File(this._contentsFolder, "Resources");
            if (resourcesFolder.exists()) {
                this.addResources(resourcesFolder, resourcesFolder.getAbsolutePath());
            }
            if ((webserverResourcesFolder = new File(this._contentsFolder, "WebServerResources")).exists()) {
                this.addWebserverResources(webserverResourcesFolder, webserverResourcesFolder.getAbsolutePath());
            }
        }
    }

    protected void addResources(File resourcesFolder, String basePath) {
        File[] files;
        boolean addChildren = true;
        String name = resourcesFolder.getName();
        if (name.endsWith(".wo")) {
            this._addRelativeFileKey(resourcesFolder.getAbsolutePath(), "WO_COMPONENTS", basePath);
            addChildren = false;
        } else if (name.endsWith(".eomodeld")) {
            this._addRelativeFileKey(resourcesFolder.getAbsolutePath(), "WOAPP_RESOURCES", basePath);
            addChildren = false;
        } else if (name.equals("Java")) {
            addChildren = false;
        }
        if (addChildren && (files = resourcesFolder.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.addResources(file, basePath);
                } else {
                    String fileName = file.getName();
                    if (!fileName.endsWith(".api")) {
                        this._addRelativeFileKey(file.getAbsolutePath(), "WOAPP_RESOURCES", basePath);
                    }
                }
                ++n2;
            }
        }
    }

    protected void addWebserverResources(File webresourcesFolder, String basePath) {
        File[] files = webresourcesFolder.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.addWebserverResources(file, basePath);
                } else {
                    this._addRelativeFileKey(file.getAbsolutePath(), "WEBSERVER_RESOURCES", basePath);
                }
                ++n2;
            }
        }
    }

    protected void _addRelativeFileKey(String absolutePath, String key, String basePath) {
        if (absolutePath.startsWith(basePath)) {
            String relativePath = absolutePath.substring(basePath.length() + 1);
            this.addFileKey(relativePath, key);
        } else {
            this.addFileKey(absolutePath, key);
        }
    }

    public NSDictionary<String, String> localFiles() {
        this.refreshIfNecessary();
        return super.localFiles();
    }

    @Override
    public NSMutableDictionary<String, NSMutableArray<String>> filesTable() {
        this.refreshIfNecessary();
        return super.filesTable();
    }
}

