/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects._ideservices;

import com.webobjects._ideservices._IDEProject;
import com.webobjects._ideservices._IDEProjectPB;
import com.webobjects._ideservices._IDEProjectPBX;
import com.webobjects._ideservices._IDEProjectWOLips;
import com.webobjects._ideservices._NSProjectBundleIDEProject;
import com.webobjects._ideservices._WOAntProject;
import com.webobjects.appserver._private.WODeployedBundle;
import com.webobjects.appserver._private.WOProjectBundle;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation.development.NSProjectBundle;
import java.io.File;

public class _WOProject {
    public static final String WBComponentExtension = "wo";
    public static final String WBArchiveExtension = "woo";
    public static final String WBAPIExtension = "api";
    public static final String WBDeclarationExtension = "wod";
    public static final String WBWebScriptExtension = "wos";
    public static final String WBJavaExtension = "java";
    public static final String WBObjCExtension = "h";
    public static final String WBObjCImplementationExtension = "m";
    public static final String WBHTMLExtension = "html";
    public static final String WBHTMExtension = "htm";
    public static final String WBEOModelExtension = "eomodeld";
    public static final String WBApplicationScriptName = "Application";
    public static final String WBSessionScriptName = "Session";
    public static final String EOCheckProjectsNotification = "EOCheckProjectsNotification";
    public static final String EOObjCPreindexExtension = "minx";
    public static final String EOJavaPreindexExtension = "jinx";
    public static final String WBLanguageProjectExtension = "lproj";
    static NSMutableDictionary _openProjects = new NSMutableDictionary();
    _IDEProject _ideProject;
    NSMutableArray _interfaceFilePaths;
    NSMutableArray _modelFilePaths;
    NSMutableArray _frameworkProjects;
    NSMutableArray _frameworkNames;
    NSMutableDictionary _frameworkResources;
    NSMutableArray _projectResources;
    NSMutableDictionary _resourceNameToPath;
    NSMutableArray _frameworkPaths;
    NSArray _allComponentNames;
    boolean _includeFrameworks;

    public static _IDEProject ideProjectAtPath(String path) {
        _IDEProject ideProject = null;
        for (NSBundle bundle : NSBundle._allBundlesReally()) {
            if (!(bundle instanceof NSProjectBundle) || !new File(bundle.bundlePath()).equals(new File(path))) continue;
            ideProject = new _NSProjectBundleIDEProject((NSProjectBundle)bundle);
            break;
        }
        if (ideProject == null && (ideProject = _IDEProjectPBX.pbxProjectAtPath(path)) != null && NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)32L)) {
            NSLog.debug.appendln((Object)("*****Found PBX project at " + path));
        }
        if (ideProject == null && (ideProject = _IDEProjectPB.pbProjectAtPath(path)) != null && NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)32L)) {
            NSLog.debug.appendln((Object)("*****Found PBWO project at " + path));
        }
        if (ideProject == null && (ideProject = _IDEProjectWOLips.wolipsProjectAtPath(path)) != null && NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)32L)) {
            NSLog.debug.appendln((Object)("*****Found WOLips project at " + path));
        }
        if (ideProject == null && (ideProject = _WOAntProject.antProjectAtPath(path)) != null && NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)32L)) {
            NSLog.debug.appendln((Object)("*****Found WO Ant project at " + ideProject.projectDir()));
        }
        return ideProject;
    }

    public static _WOProject loadedProjectAtPath(String path) {
        _IDEProject ideProject = _WOProject.ideProjectAtPath(path);
        _WOProject woProject = null;
        if (ideProject != null) {
            woProject = (_WOProject)_openProjects.objectForKey((Object)ideProject.projectDir());
        }
        return woProject;
    }

    public static _WOProject projectAtPath(String path) {
        return _WOProject.projectAtPath(path, false);
    }

    public static _WOProject projectAtPath(String path, boolean includeFrameworks) {
        _WOProject woProject = null;
        _IDEProject ideProject = _WOProject.ideProjectAtPath(path);
        if (ideProject != null && (woProject = (_WOProject)_openProjects.objectForKey((Object)ideProject.projectDir())) == null) {
            woProject = new _WOProject(ideProject, includeFrameworks);
            _openProjects.setObjectForKey((Object)woProject, (Object)ideProject.projectDir());
        }
        return woProject;
    }

    _WOProject(_IDEProject ideProject, boolean includeFrameworks) {
        this._ideProject = ideProject;
        this._includeFrameworks = includeFrameworks;
        this.updateFileList();
    }

    private void updateFileList() {
        this._interfaceFilePaths = new NSMutableArray();
        this._modelFilePaths = new NSMutableArray();
        this._resourceNameToPath = new NSMutableDictionary();
        this._frameworkProjects = new NSMutableArray();
        this._frameworkNames = new NSMutableArray();
        this._frameworkResources = new NSMutableDictionary();
        this._frameworkPaths = new NSMutableArray();
        this._projectResources = new NSMutableArray();
        this._ideProject.extractFilesIntoWOProject(this);
    }

    public void addInterfaceFilePath(String path) {
        this._interfaceFilePaths.addObject((Object)path);
    }

    public NSArray interfaceFilePaths() {
        return this._interfaceFilePaths;
    }

    public void addModelFilePath(String path) {
        this._modelFilePaths.addObject((Object)path);
    }

    public NSArray modelFilePaths() {
        return this._modelFilePaths;
    }

    public boolean includeFrameworks() {
        return this._includeFrameworks;
    }

    public static String frameworkPathForResource(String path) {
        if (path.length() < 1) {
            return null;
        }
        if (NSPathUtilities.pathExtension((String)path).equals("framework")) {
            return NSPathUtilities.stringByNormalizingExistingPath((String)path);
        }
        String containingDirectory = _NSStringUtilities.stringByDeletingLastComponent((String)path, (char)File.separatorChar);
        return _WOProject.frameworkPathForResource(containingDirectory);
    }

    String getPath() {
        return this._ideProject.projectDir();
    }

    public _IDEProject ideProject() {
        return this._ideProject;
    }

    public void addResourcePath(String resourcePath) {
        this.addResource(NSPathUtilities.lastPathComponent((String)resourcePath), resourcePath, _WOProject.languageFromResourcePath(resourcePath));
    }

    NSArray frameworkPaths() {
        return this._frameworkPaths;
    }

    public void addResource(String aResourceName, String aResourcePath, String aResourceLanguage) {
        String resourceName = NSPathUtilities._standardizedPath((String)aResourceName);
        String resourcePath = NSPathUtilities._standardizedPath((String)aResourcePath);
        String resourceLanguage = aResourceLanguage;
        NSMutableDictionary languageToPath = (NSMutableDictionary)this._resourceNameToPath.objectForKey((Object)resourceName);
        String resourcePathExtension = NSPathUtilities.pathExtension((String)resourceName);
        NSArray frameworkPaths = this.frameworkPaths();
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)32L)) {
            NSLog.debug.appendln((Object)("addResource " + resourceName + " : " + resourcePath + " : " + resourceLanguage));
        }
        resourcePath = NSPathUtilities.stringByNormalizingExistingPath((String)resourcePath);
        if (resourceLanguage == null) {
            resourceLanguage = "";
        }
        if (languageToPath != null) {
            languageToPath.takeValueForKey((Object)resourcePath, resourceLanguage);
        } else {
            languageToPath = new NSMutableDictionary();
            languageToPath.takeValueForKey((Object)resourcePath, resourceLanguage);
            this._resourceNameToPath.takeValueForKey((Object)languageToPath, resourceName);
        }
        if (frameworkPaths != null) {
            String frameworkPath = null;
            int i = 0;
            int c = frameworkPaths.count();
            while (i < c) {
                frameworkPath = (String)frameworkPaths.objectAtIndex(i);
                if (resourcePath.startsWith(frameworkPath)) break;
                ++i;
            }
            if (i < c && frameworkPath != null) {
                NSMutableArray resourceArray = (NSMutableArray)this._frameworkResources.objectForKey((Object)frameworkPath);
                if (!resourceArray.containsObject((Object)resourceName)) {
                    resourceArray.addObject((Object)resourceName);
                }
            } else if (!this._projectResources.containsObject((Object)resourceName)) {
                this._projectResources.addObject((Object)resourceName);
            }
        }
        if (resourcePathExtension.equals(WBComponentExtension)) {
            this._allComponentNames = null;
        } else {
            resourcePathExtension.equals(WBEOModelExtension);
        }
    }

    public String pathForResourceNamed(String resourceName, boolean refreshOnCacheMiss) {
        return this.pathForResourceNamed(resourceName, "", refreshOnCacheMiss);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pathForResourceNamed(String aResourceName, String aResourceLanguage, boolean refreshOnCacheMiss) {
        String resourcePath = null;
        NSMutableDictionary languageToPath = null;
        String resourceName = NSPathUtilities._standardizedPath((String)aResourceName);
        String resourceLanguage = aResourceLanguage;
        _WOProject _WOProject2 = this;
        synchronized (_WOProject2) {
            if (resourceLanguage == null) {
                resourceLanguage = this._ideProject.languageName();
            }
            if ((languageToPath = (NSMutableDictionary)this._resourceNameToPath.objectForKey((Object)resourceName)) != null) {
                if (languageToPath.count() == 1) {
                    resourcePath = (String)languageToPath.allValues().objectAtIndex(0);
                } else if (languageToPath.count() > 1) {
                    if (resourceLanguage != null) {
                        resourcePath = (String)languageToPath.objectForKey((Object)resourceLanguage);
                    }
                    if (resourcePath == null) {
                        resourcePath = (String)languageToPath.objectForKey((Object)"");
                    }
                    if (resourcePath == null && refreshOnCacheMiss) {
                        this._ideProject.refreshUnderlyingProjectCache();
                        this._ideProject.addFilenameExtensionToListOfKnowns(NSPathUtilities.pathExtension((String)resourceName));
                        this.updateFileList();
                        resourcePath = this.pathForResourceNamed(resourceName, resourceLanguage, false);
                    }
                }
            }
            if (resourcePath == null && refreshOnCacheMiss) {
                this._ideProject.refreshUnderlyingProjectCache();
                this._ideProject.addFilenameExtensionToListOfKnowns(NSPathUtilities.pathExtension((String)resourceName));
                this.updateFileList();
                resourcePath = this.pathForResourceNamed(resourceName, resourceLanguage, false);
            }
        }
        return resourcePath;
    }

    public String pathForComponentNamed(String componentName) {
        return this.pathForResourceNamed(NSPathUtilities.stringByAppendingPathExtension((String)componentName, (String)WBComponentExtension), true);
    }

    public void extractFrameworkAtPath(String filePath) {
    }

    public void extractFrameworkNamed(String frameworkName) {
        if (!this._frameworkNames.containsObject((Object)frameworkName)) {
            String frameworkPath = this._ideProject.pathForFrameworkNamed(frameworkName);
            this._frameworkNames.addObject((Object)frameworkName);
            if (frameworkPath != null && frameworkPath.length() > 0) {
                _IDEProject fwProj = _WOProject.ideProjectAtPath(frameworkPath);
                this._frameworkResources.takeValueForKey((Object)new NSMutableArray(), frameworkPath);
                if (fwProj != null) {
                    this._frameworkProjects.addObject((Object)fwProj);
                    fwProj.extractFilesIntoWOProject(this);
                } else {
                    this.extractFilesFromFramework(frameworkPath);
                }
            }
        }
    }

    private void extractFilesFromFramework(String frameworkPath) {
        NSMutableArray searchableBundles = new NSMutableArray();
        NSBundle bundle = NSBundle.mainBundle();
        if (bundle != null) {
            searchableBundles.addObject((Object)bundle);
        }
        if ((bundle = NSBundle.bundleForClass(this.getClass())) != null) {
            searchableBundles.addObject((Object)bundle);
        }
        if ((bundle = NSBundle.bundleWithPath((String)frameworkPath)) != null) {
            searchableBundles.addObject((Object)bundle);
        }
        int i = 0;
        int count = searchableBundles.count();
        while (i < count) {
            ++i;
        }
    }

    public void extractResourcesFromPath(String parentDir, String subdir) {
        String fullPath = String.valueOf(parentDir) + File.separator + subdir;
        File directory = new File(fullPath);
        if (directory.isDirectory()) {
            String[] subfiles = directory.list();
            int i = 0;
            int count = subfiles.length;
            while (i < count) {
                String resource = subfiles[i];
                String resourcePath = String.valueOf(parentDir) + File.separator + subdir;
                String resourcePathExtension = NSPathUtilities.pathExtension((String)resource);
                File theFile = new File(resourcePath);
                boolean isDirectory = theFile.isDirectory();
                if (theFile.exists() && !NSPathUtilities.pathIsEqualToString((String)resource, (String)"Documentation") && !NSPathUtilities.pathIsEqualToString((String)resource, (String)"Java")) {
                    if (isDirectory && resourcePathExtension.length() == 0) {
                        this.extractResourcesFromPath(parentDir, String.valueOf(subdir) + File.separator + resource);
                    } else if (isDirectory && resourcePathExtension.equals(WBLanguageProjectExtension) && subdir.length() == 0) {
                        this.extractResourcesFromPath(parentDir, String.valueOf(resource) + File.separator);
                    } else {
                        this.addResource(String.valueOf(subdir) + File.separator + resource, String.valueOf(resourcePath) + File.separator + resource, _WOProject.languageFromResourcePath(resourcePath));
                    }
                }
                ++i;
            }
        }
    }

    public static String resourcePathByAppendingLanguageFileName(String mySelf, String language, String file) {
        String self = mySelf;
        if (language.length() > 0) {
            self = NSPathUtilities.stringByAppendingPathComponent((String)self, (String)language);
            self = NSPathUtilities.stringByAppendingPathExtension((String)self, (String)WBLanguageProjectExtension);
        }
        self = NSPathUtilities.stringByAppendingPathComponent((String)self, (String)file);
        return self;
    }

    public static String languageFromResourcePath(String self) {
        int minLen = WBLanguageProjectExtension.length() + 1;
        String mySelf = self;
        while (mySelf.length() > minLen && !NSPathUtilities.pathExtension((String)mySelf).equals(WBLanguageProjectExtension)) {
            mySelf = NSPathUtilities.stringByDeletingLastPathComponent((String)mySelf);
        }
        if (mySelf.length() > minLen) {
            mySelf = NSPathUtilities.stringByDeletingPathExtension((String)mySelf);
            mySelf = NSPathUtilities.lastPathComponent((String)mySelf);
        } else {
            mySelf = "";
        }
        return mySelf;
    }

    public String _pathToSourceFileForClass(String fullClassName, String filename) {
        WODeployedBundle db;
        Class theClass = _NSUtilities._classWithFullySpecifiedName((String)fullClassName);
        NSBundle b = NSBundle.bundleForClass((Class)theClass);
        if (b != null && (db = WODeployedBundle.bundleWithNSBundle(b)) instanceof WOProjectBundle) {
            NSArray paths = ((WOProjectBundle)db)._woProject().interfaceFilePaths();
            int i = 0;
            int c = paths.count();
            while (i < c) {
                String path = (String)paths.objectAtIndex(i);
                if (NSPathUtilities.lastPathComponent((String)path).equals(filename)) {
                    return path;
                }
                ++i;
            }
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)36L)) {
            NSLog.debug.appendln((Object)("_WOProject: could not find path to source file for " + fullClassName + " " + filename));
        }
        return null;
    }

    public String toString() {
        return "<" + this.getClass().getName() + ": projectName='" + this._ideProject.projectName() + "'>";
    }

    public String bundlePath() {
        return this._ideProject.bundlePathURL() != null ? this._ideProject.bundlePathURL().getPath() : null;
    }
}

