/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver._private.WOProjectBundle;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSThreadsafeMutableDictionary;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WODeployedBundle {
    private final NSMutableDictionary _absolutePaths;
    private final NSMutableDictionary _pathURLs;
    protected final String _bundlePath;
    protected final boolean _isFramework;
    protected final String _projectName;
    private final _NSThreadsafeMutableDictionary _relativePaths;
    private boolean _resourcesHaveBeenPreloaded;
    private final NSMutableDictionary _URLs;
    protected final String _wrapperName;
    private final NSMutableSet _expectedLanguages;
    private boolean _isJar;
    private NSBundle _nsBundle;
    private static final NSMutableDictionary TheBundles = new NSMutableDictionary(NSBundle.frameworkBundles().count());
    private static final boolean _allowRapidTurnaround = NSPropertyListSerialization.booleanForString((String)NSProperties.getProperty((String)"WOAllowRapidTurnaround"));
    private static final String _webServerResources = "/WebServerResources";
    private static final String _resources = "/Resources";
    private static final String _cvs = "/CVS";
    private static final String _versions = "/Versions";
    private static final String _contentsWebServerResourcesPathKey = "Contents/WebServerResources/";
    private static final String _webServerResourcesPathKey = "WebServerResources/";

    public WODeployedBundle(NSBundle nsb) {
        this(null, nsb);
    }

    public WODeployedBundle(String projectPath, NSBundle nsb) {
        if (nsb == null) {
            throw new IllegalStateException("Cannot create WODeployedBundle without corresponding NSBundle!");
        }
        this._nsBundle = nsb;
        this._isJar = this._nsBundle.isJar();
        String aProjectPath = projectPath != null ? projectPath : this._nsBundle.bundlePathURL().getPath();
        this._bundlePath = this._initBundlePath(aProjectPath);
        this._wrapperName = NSBundle.mainBundle() == this._nsBundle || !this._nsBundle.isFramework() && !this._nsBundle.name().endsWith(".woa") ? String.valueOf(this._nsBundle.name()) + ".woa" : (this._nsBundle.isFramework() && !this._nsBundle.name().endsWith(".framework") ? String.valueOf(this._nsBundle.name()) + ".framework" : this._nsBundle.name());
        this._projectName = this._initProjectName(this._wrapperName);
        this._isFramework = NSBundle.mainBundle() == this._nsBundle ? false : this._nsBundle.isFramework();
        this._absolutePaths = new NSMutableDictionary(128);
        this._pathURLs = new NSMutableDictionary(128);
        this._relativePaths = new _NSThreadsafeMutableDictionary(new NSMutableDictionary(128));
        this._URLs = new NSMutableDictionary();
        this._expectedLanguages = new NSMutableSet(16);
        this._resourcesHaveBeenPreloaded = false;
    }

    public static WODeployedBundle deployedBundle() {
        return WODeployedBundle.bundleWithNSBundle(NSBundle.mainBundle());
    }

    private void _newAddToRelativePaths(File aFile, int pathIndex, int keyPathIndex) {
        String absolutePath = aFile.getAbsolutePath();
        String aFileName = NSPathUtilities._standardizedPath((String)absolutePath.substring(keyPathIndex));
        String aRelativePath = absolutePath.substring(pathIndex);
        Object localizedPathsTable = this._relativePaths.objectForKey((Object)aFileName);
        if (localizedPathsTable != null) {
            if (localizedPathsTable instanceof NSMutableDictionary && ((NSMutableDictionary)localizedPathsTable).objectForKey((Object)"Default") == null) {
                ((NSMutableDictionary)localizedPathsTable).setObjectForKey((Object)NSPathUtilities._standardizedPath((String)aRelativePath), (Object)"Default");
            }
        } else {
            this._relativePaths.setObjectForKey((Object)NSPathUtilities._standardizedPath((String)aRelativePath), (Object)aFileName);
        }
    }

    private void _jarAddToRelativePaths(String aFile) {
        String aRelativePath;
        int jarIndex = aFile.indexOf("!/");
        jarIndex = jarIndex != -1 ? (jarIndex += 2) : 0;
        String aFileName = aRelativePath = aFile.substring(jarIndex);
        aFileName = aRelativePath.startsWith("WebServerResources") ? aRelativePath.substring(19) : (aRelativePath.startsWith("Resources") ? aRelativePath.substring(10) : NSPathUtilities.lastPathComponent((String)aRelativePath));
        Object localizedPathsTable = this._relativePaths.objectForKey((Object)aFileName);
        if (localizedPathsTable != null) {
            if (localizedPathsTable instanceof NSMutableDictionary && ((NSMutableDictionary)localizedPathsTable).objectForKey((Object)"Default") == null) {
                ((NSMutableDictionary)localizedPathsTable).setObjectForKey((Object)aRelativePath, (Object)"Default");
            }
        } else {
            this._relativePaths.setObjectForKey((Object)aRelativePath, (Object)aFileName);
        }
    }

    private void _newPreloadAllResourcesInLanguageDirectory(File aDirectory, int pathIndex, int keyPathIndex) {
        String language = NSPathUtilities.lastPathComponent((String)NSPathUtilities.stringByDeletingPathExtension((String)aDirectory.getName()));
        int languagePathIndex = keyPathIndex + language.length() + 7;
        NSMutableArray resources = new NSMutableArray(64);
        this._newPreloadAllResourcesInSubDirectory(aDirectory, pathIndex, keyPathIndex, resources);
        int count = resources.count();
        int i = 0;
        while (i < count) {
            String aResourcePath = (String)resources.objectAtIndex(i);
            String aResourceKey = NSPathUtilities._standardizedPath((String)aResourcePath).substring(languagePathIndex);
            Object localizedPathsTable = this._relativePaths.objectForKey((Object)aResourceKey);
            if (localizedPathsTable != null) {
                if (localizedPathsTable instanceof String) {
                    Object defaultRelativePath = localizedPathsTable;
                    localizedPathsTable = new NSMutableDictionary();
                    ((NSMutableDictionary)localizedPathsTable).setObjectForKey(defaultRelativePath, (Object)"Default");
                    this._relativePaths.setObjectForKey(localizedPathsTable, (Object)aResourceKey);
                }
            } else {
                localizedPathsTable = new NSMutableDictionary();
                this._relativePaths.setObjectForKey(localizedPathsTable, (Object)aResourceKey);
            }
            if (((NSMutableDictionary)localizedPathsTable).objectForKey((Object)language) == null) {
                String relativePath = aResourcePath.substring(pathIndex);
                ((NSMutableDictionary)localizedPathsTable).setObjectForKey((Object)relativePath, (Object)language);
            }
            ++i;
        }
    }

    private void _jarPreloadAllResourcesInLanguageDirectory(String aDirectory) {
        String language = NSPathUtilities.lastPathComponent((String)NSPathUtilities.stringByDeletingPathExtension((String)aDirectory));
        NSMutableArray resources = new NSMutableArray(64);
        this._jarPreloadAllResourcesInSubDirectory(aDirectory, (NSMutableArray<String>)resources);
        int count = resources.count();
        int i = 0;
        while (i < count) {
            String aResourcePath = (String)resources.objectAtIndex(i);
            String aResourceKey = NSPathUtilities.lastPathComponent((String)aResourcePath);
            Object localizedPathsTable = this._relativePaths.objectForKey((Object)aResourceKey);
            if (localizedPathsTable != null) {
                if (localizedPathsTable instanceof String) {
                    Object defaultRelativePath = localizedPathsTable;
                    localizedPathsTable = new NSMutableDictionary();
                    ((NSMutableDictionary)localizedPathsTable).setObjectForKey(defaultRelativePath, (Object)"Default");
                    this._relativePaths.setObjectForKey(localizedPathsTable, (Object)aResourceKey);
                }
            } else {
                localizedPathsTable = new NSMutableDictionary();
                this._relativePaths.setObjectForKey(localizedPathsTable, (Object)aResourceKey);
            }
            if (((NSMutableDictionary)localizedPathsTable).objectForKey((Object)language) == null) {
                int jarIndex = aResourcePath.indexOf("!/");
                jarIndex = jarIndex != -1 ? (jarIndex += 2) : 0;
                String relativePath = aResourcePath.substring(jarIndex);
                ((NSMutableDictionary)localizedPathsTable).setObjectForKey((Object)relativePath, (Object)language);
            }
            ++i;
        }
    }

    protected void _newPreloadAllResourcesInSubDirectory(File aDir, int pathIndex, int keyPathIndex, NSMutableArray array) {
        String[] resources = aDir.list();
        File aFile = null;
        if (resources != null) {
            int length = resources.length;
            int i = 0;
            while (i < length) {
                String aFileName = resources[i];
                aFile = new File(aDir, aFileName);
                if (array == null) {
                    this._newAddToRelativePaths(aFile, pathIndex, keyPathIndex);
                } else {
                    array.addObject((Object)aFile.getAbsolutePath());
                }
                if (aFile.isDirectory() && !aFileName.endsWith(".wo") && !aFileName.equals("CVS")) {
                    this._newPreloadAllResourcesInSubDirectory(aFile, pathIndex, keyPathIndex, array);
                }
                ++i;
            }
        }
    }

    protected void _jarPreloadAllResourcesInSubDirectory(String aDirectory, NSMutableArray<String> array) {
        NSMutableArray dirNames = new NSMutableArray();
        NSMutableArray fileNames = new NSMutableArray();
        this._nsBundle._simplePathsInDirectoryInJar(aDirectory, "", dirNames, "", fileNames);
        Enumeration fileE = fileNames.objectEnumerator();
        while (fileE.hasMoreElements()) {
            String fileName = (String)fileE.nextElement();
            if (array == null) {
                this._jarAddToRelativePaths(_NSStringUtilities.concat((String)aDirectory, (String)"/", (String)fileName));
                continue;
            }
            array.addObject((Object)_NSStringUtilities.concat((String)aDirectory, (String)"/", (String)fileName));
        }
        Enumeration dirE = dirNames.objectEnumerator();
        while (dirE.hasMoreElements()) {
            String dirName = (String)dirE.nextElement();
            if (array == null) {
                this._jarAddToRelativePaths(_NSStringUtilities.concat((String)aDirectory, (String)"/", (String)dirName));
            } else {
                array.addObject((Object)_NSStringUtilities.concat((String)aDirectory, (String)"/", (String)dirName));
            }
            if (dirName.endsWith(".wo") || dirName.equals("CVS")) continue;
            this._jarPreloadAllResourcesInSubDirectory(_NSStringUtilities.concat((String)aDirectory, (String)"/", (String)dirName), array);
        }
    }

    private void _newPreloadAllResourcesInTopDirectory(String aDirectory) {
        File aDir = new File(this.bundlePath(), aDirectory);
        String[] resources = aDir.list();
        if (resources != null) {
            File aFile = null;
            int length = resources.length;
            int keyPathIndex = 0;
            int pathIndex = 0;
            keyPathIndex = aDir.getAbsolutePath().length() + 1;
            pathIndex = aDir.getAbsolutePath().lastIndexOf(aDirectory);
            if (aDirectory.equals(".")) {
                pathIndex += 2;
            }
            int i = 0;
            while (i < length) {
                String aFileName = resources[i];
                aFile = new File(aDir, aFileName);
                String aFilePath = aFile.getAbsolutePath();
                if (aFile.isDirectory()) {
                    if (!(aFilePath.endsWith(_webServerResources) || aFilePath.endsWith(_resources) || aFilePath.endsWith(".subproj") || aFilePath.endsWith(_versions) || aFilePath.endsWith(_cvs))) {
                        if (aFilePath.endsWith(".lproj")) {
                            String language = NSPathUtilities.lastPathComponent((String)aFilePath);
                            language = language.substring(0, language.length() - ".lproj".length());
                            this.addToExpectedLanguages(language);
                            this._newPreloadAllResourcesInLanguageDirectory(aFile, pathIndex, keyPathIndex);
                        } else {
                            if (aFilePath.endsWith(".wo") || aFilePath.endsWith(".eomodeld")) {
                                this._newAddToRelativePaths(aFile, pathIndex, keyPathIndex);
                            }
                            if (NSPathUtilities.pathExtension((String)aFilePath).length() > 0) {
                                this._newAddToRelativePaths(aFile, pathIndex, keyPathIndex);
                            }
                            this._newPreloadAllResourcesInSubDirectory(aFile, pathIndex, keyPathIndex, null);
                        }
                    }
                } else {
                    this._newAddToRelativePaths(aFile, pathIndex, keyPathIndex);
                }
                ++i;
            }
        }
    }

    private void _jarPreloadAllResourcesInTopDirectory(String aDirectory) {
        NSMutableArray dirNames = new NSMutableArray();
        NSMutableArray fileNames = new NSMutableArray();
        this._nsBundle._simplePathsInDirectoryInJar(aDirectory, "", dirNames, "", fileNames);
        String dirPrefix = aDirectory.equals(".") ? "" : aDirectory.concat("/");
        Enumeration fileE = fileNames.objectEnumerator();
        while (fileE.hasMoreElements()) {
            String fileName = (String)fileE.nextElement();
            this._jarAddToRelativePaths(dirPrefix.concat(fileName));
        }
        Enumeration dirE = dirNames.objectEnumerator();
        while (dirE.hasMoreElements()) {
            String dirName = (String)dirE.nextElement();
            String aFilePath = _NSStringUtilities.concat((String)aDirectory, (String)"/", (String)dirName);
            if (aFilePath.endsWith(_webServerResources) || aFilePath.endsWith(_resources) || aFilePath.endsWith(".subproj") || aFilePath.endsWith(_versions) || aFilePath.endsWith(_cvs) || aFilePath.endsWith("META-INF")) continue;
            if (aFilePath.endsWith(".lproj")) {
                String language = dirName;
                language = language.substring(0, language.length() - ".lproj".length());
                this.addToExpectedLanguages(language);
                this._jarPreloadAllResourcesInLanguageDirectory(dirPrefix.concat(dirName));
                continue;
            }
            if (aFilePath.endsWith(".eomodeld") || aFilePath.endsWith(".wo")) {
                this._jarAddToRelativePaths(dirPrefix.concat(dirName));
            }
            if (NSPathUtilities.pathExtension((String)dirName).length() > 0) {
                this._jarAddToRelativePaths(dirPrefix.concat(dirName));
            }
            this._jarPreloadAllResourcesInSubDirectory(dirPrefix.concat(dirName), null);
        }
    }

    private void addToExpectedLanguages(String aLanguage) {
        this._expectedLanguages.addObject((Object)aLanguage);
    }

    private NSArray expectedLanguages() {
        return this._expectedLanguages.allObjects();
    }

    private boolean isLocalized() {
        return this._expectedLanguages.count() > 0;
    }

    private synchronized void _preloadAllResourcesIfNecessary() {
        if (!this._resourcesHaveBeenPreloaded) {
            WOProjectBundle projectBundle = this.projectBundle();
            if (!(_allowRapidTurnaround && projectBundle != null && projectBundle._woProject() != null && projectBundle._woProject().ideProject() != null && !projectBundle._woProject().ideProject().shouldPreloadResources() || this.loadResourceIndex())) {
                if (this._isJar) {
                    this._jarPreloadAllResourcesInTopDirectory("WebServerResources");
                    this._jarPreloadAllResourcesInTopDirectory("Resources");
                    this._jarPreloadAllResourcesInTopDirectory(".");
                } else {
                    this._newPreloadAllResourcesInTopDirectory(_NSStringUtilities.concat((String)"Contents", (String)File.separator, (String)"WebServerResources"));
                    this._newPreloadAllResourcesInTopDirectory(_NSStringUtilities.concat((String)"Contents", (String)File.separator, (String)"Resources"));
                    this._newPreloadAllResourcesInTopDirectory("Contents");
                    this._newPreloadAllResourcesInTopDirectory("WebServerResources");
                    this._newPreloadAllResourcesInTopDirectory("Resources");
                    this._newPreloadAllResourcesInTopDirectory(".");
                }
            }
            if (this.isLocalized()) {
                WOApplication.application()._addToExpectedLanguages(this.expectedLanguages());
            }
            this._resourcesHaveBeenPreloaded = true;
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)32L)) {
                NSLog.debug.appendln((Object)(String.valueOf(this._wrapperName) + " " + this._relativePaths.delegate()));
            }
        }
    }

    private String resourceIndexPath() {
        return NSPathUtilities.stringByAppendingPathComponent((String)this.nsBundle().resourcePath(), (String)"WODeployedBundle-index.plist");
    }

    public void writeResourceIndex() {
        this._preloadAllResourcesIfNecessary();
        _NSThreadsafeMutableDictionary tempRelativePaths = this._relativePaths;
        tempRelativePaths.acquireReadLock();
        try {
            try {
                NSMutableDictionary dictToSave = new NSMutableDictionary(2);
                dictToSave.setObjectForKey((Object)tempRelativePaths.delegate(), (Object)"relativePaths");
                if (this.isLocalized()) {
                    dictToSave.setObjectForKey((Object)this.expectedLanguages(), (Object)"expectedLanguages");
                }
                String plist = NSPropertyListSerialization.stringFromPropertyList((Object)dictToSave);
                NSData data = new NSData(plist, "UTF-8");
                String outputPath = this.resourceIndexPath();
                BufferedOutputStream dataOutputStream = new BufferedOutputStream(new FileOutputStream(outputPath));
                try {
                    data.writeToStream((OutputStream)dataOutputStream);
                }
                finally {
                    ((OutputStream)dataOutputStream).close();
                }
                NSLog.debug.appendln((Object)("writeResourceIndex() wrote to path: " + outputPath));
            }
            catch (IOException e) {
                NSLog.err.appendln((Object)("writeResourceIndex() error writing index file for " + this._wrapperName + " to path: " + this.resourceIndexPath() + ": " + e));
                tempRelativePaths.releaseReadLock();
            }
        }
        finally {
            tempRelativePaths.releaseReadLock();
        }
    }

    private boolean loadResourceIndex() {
        block10: {
            boolean shouldReadIndex = Boolean.valueOf(System.getProperty("WODeployedBundleShouldReadIndexFile", "true"));
            if (!shouldReadIndex) {
                return false;
            }
            try {
                NSDictionary indexDict;
                NSData data;
                File file = new File(this.resourceIndexPath());
                if (!file.exists()) break block10;
                FileInputStream fis = new FileInputStream(file);
                try {
                    data = new NSData((InputStream)fis, -1);
                }
                finally {
                    fis.close();
                }
                if (data == null || data.length() <= 0 || (indexDict = (NSDictionary)NSPropertyListSerialization.propertyListFromData((NSData)data, (String)"UTF-8")) == null) break block10;
                NSDictionary relativePaths = (NSDictionary)indexDict.objectForKey((Object)"relativePaths");
                _NSThreadsafeMutableDictionary tempRelativePaths = this._relativePaths;
                tempRelativePaths.acquireReadLock();
                try {
                    tempRelativePaths.delegate().addEntriesFromDictionary(relativePaths);
                }
                finally {
                    tempRelativePaths.releaseReadLock();
                }
                NSArray expectedLanguages = (NSArray)indexDict.objectForKey((Object)"expectedLanguages");
                if (expectedLanguages != null) {
                    this._expectedLanguages.addObjectsFromArray(expectedLanguages);
                }
                return true;
            }
            catch (IOException e) {
                NSLog.err.appendln((Object)("loadResourceIndex(): " + e));
            }
        }
        return false;
    }

    public String relativePathForResource(String aResourceName, NSArray aLanguagesList) {
        Object aRelativePath = null;
        if (aResourceName != null) {
            this._preloadAllResourcesIfNecessary();
            aRelativePath = this._relativePaths.objectForKey((Object)aResourceName);
            if (aRelativePath != null) {
                if (aRelativePath instanceof NSDictionary) {
                    NSMutableDictionary localizedPathTable = (NSMutableDictionary)aRelativePath;
                    if (aLanguagesList != null) {
                        int count = aLanguagesList.count();
                        int i = 0;
                        while (i < count) {
                            aRelativePath = localizedPathTable.objectForKey(aLanguagesList.objectAtIndex(i));
                            if (aRelativePath != null) {
                                return (String)aRelativePath;
                            }
                            ++i;
                        }
                    }
                    aRelativePath = localizedPathTable.objectForKey((Object)"Default");
                }
            } else {
                String standardizedPath = NSPathUtilities._standardizedPath((String)aResourceName);
                if (!standardizedPath.equals(aResourceName) && (aRelativePath = this.relativePathForResource(standardizedPath, aLanguagesList)) != null && ((String)aRelativePath).length() > 0) {
                    this._relativePaths.setObjectForKey(this._relativePaths.objectForKey((Object)standardizedPath), (Object)aResourceName);
                }
            }
        }
        return (String)aRelativePath;
    }

    public String relativePathForResource(String aResourceName, String aLanguageString) {
        this._preloadAllResourcesIfNecessary();
        Object aRelativePath = this._relativePaths.objectForKey((Object)aResourceName);
        if (aRelativePath instanceof NSMutableDictionary) {
            NSMutableDictionary localizedPathTable = (NSMutableDictionary)aRelativePath;
            aRelativePath = aLanguageString != null ? localizedPathTable.objectForKey((Object)aLanguageString) : localizedPathTable.objectForKey((Object)"Default");
        }
        return (String)aRelativePath;
    }

    private String _cachedAbsolutePath(String aRelativePath) {
        String aPath = null;
        if (aRelativePath != null && (aPath = (String)this._absolutePaths.objectForKey((Object)aRelativePath)) == null) {
            if (this._isJar) {
                aPath = this._nsBundle._bundleURLPrefix().concat(aRelativePath);
            } else {
                aPath = NSPathUtilities.stringByAppendingPathComponent((String)this.bundlePath(), (String)aRelativePath);
                aPath = NSPathUtilities.stringByNormalizingExistingPath((String)aPath);
            }
            this._absolutePaths.setObjectForKey((Object)aPath, (Object)aRelativePath);
        }
        return aPath;
    }

    private URL _cachedPathURL(String aRelativePath) {
        URL anURL = null;
        if (aRelativePath != null && (anURL = (URL)this._pathURLs.objectForKey((Object)aRelativePath)) == null && (anURL = this._nsBundle._urlForRelativePath(aRelativePath)) != null) {
            this._pathURLs.setObjectForKey((Object)anURL, (Object)aRelativePath);
        }
        return anURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _absolutePathForRelativePath(String aRelativePath) {
        String anAbsolutePath = null;
        NSMutableDictionary nSMutableDictionary = this._absolutePaths;
        synchronized (nSMutableDictionary) {
            anAbsolutePath = this._cachedAbsolutePath(aRelativePath);
        }
        return anAbsolutePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL _pathURLForRelativePath(String aRelativePath) {
        URL anURL = null;
        NSMutableDictionary nSMutableDictionary = this._pathURLs;
        synchronized (nSMutableDictionary) {
            anURL = this._cachedPathURL(aRelativePath);
        }
        return anURL;
    }

    public String _absolutePathForResource(String aResourceName, NSArray aLanguagesList) {
        String aRelativePath = this.relativePathForResource(aResourceName, aLanguagesList);
        return this._absolutePathForRelativePath(aRelativePath);
    }

    public String _absolutePathForResource(String aResourceName, String aLanguage, boolean refresh) {
        return this._absolutePathForResource(aResourceName, aLanguage);
    }

    public String _absolutePathForResource(String aResourceName, String aLanguage) {
        String aRelativePath = this.relativePathForResource(aResourceName, aLanguage);
        return this._absolutePathForRelativePath(aRelativePath);
    }

    public InputStream inputStreamForResourceNamed(String aResourceName, NSArray aLanguagesList) {
        InputStream is = null;
        URL url = this.pathURLForResourceNamed(aResourceName, aLanguagesList);
        if (url != null) {
            try {
                is = url.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return is;
    }

    public InputStream inputStreamForResourceNamed(String aResourceName, String aLanguage) {
        InputStream is = null;
        URL url = this.pathURLForResourceNamed(aResourceName, aLanguage);
        if (url != null) {
            try {
                is = url.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return is;
    }

    public URL pathURLForResourceNamed(String aResourceName, String aLanguageString, boolean refreshProjectOnCacheMiss) {
        return this.pathURLForResourceNamed(aResourceName, aLanguageString);
    }

    public URL pathURLForResourceNamed(String aResourceName, String aLanguageString) {
        String aRelativePath = this.relativePathForResource(aResourceName, aLanguageString);
        return this._pathURLForRelativePath(aRelativePath);
    }

    public URL pathURLForResourceNamed(String aResourceName, NSArray aLanguagesList) {
        String aRelativePath = this.relativePathForResource(aResourceName, aLanguagesList);
        return this._pathURLForRelativePath(aRelativePath);
    }

    private String _cachedURL(String aRelativePath) {
        String aURL = null;
        if (aRelativePath != null && (aURL = (String)this._URLs.objectForKey((Object)aRelativePath)) == null) {
            String aBaseURL = null;
            aBaseURL = this.isFramework() ? WOApplication.application().frameworksBaseURL() : WOApplication.application().applicationBaseURL();
            String aWrapperName = this.wrapperName();
            if (aBaseURL != null && aWrapperName != null) {
                aURL = _NSStringUtilities.concat((String)aBaseURL, (String)File.separator, (String)aWrapperName, (String)File.separator, (String)aRelativePath);
                aURL = NSPathUtilities._standardizedPath((String)aURL);
                this._URLs.setObjectForKey((Object)aURL, (Object)aRelativePath);
            }
        }
        return aURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String urlForResource(String aResourceName, NSArray aLanguagesList) {
        String aRelativePath = this.relativePathForResource(aResourceName, aLanguagesList);
        String aURL = null;
        NSMutableDictionary nSMutableDictionary = this._URLs;
        synchronized (nSMutableDictionary) {
            aURL = this._cachedURL(aRelativePath);
        }
        return aURL;
    }

    public String bundlePath() {
        return this._bundlePath;
    }

    protected String _initBundlePath(String aPath) {
        if (!this._isJar) {
            return NSPathUtilities.stringByNormalizingExistingPath((String)aPath);
        }
        return aPath;
    }

    protected URL _initBundleURL(URL anURL) {
        return anURL;
    }

    protected String _initProjectName(String aProjectName) {
        return NSPathUtilities.stringByDeletingPathExtension((String)aProjectName);
    }

    public String projectName() {
        return this._projectName;
    }

    public String wrapperName() {
        return this._wrapperName;
    }

    public boolean isFramework() {
        return this._isFramework;
    }

    public boolean isAggregate() {
        return false;
    }

    public boolean isJar() {
        return this._isJar;
    }

    public NSBundle nsBundle() {
        return this._nsBundle;
    }

    public WOProjectBundle projectBundle() {
        WOProjectBundle aProjectBundle = null;
        if (_allowRapidTurnaround) {
            String aProjectName = this.projectName();
            boolean isFramework = this.isFramework();
            aProjectBundle = WOProjectBundle.projectBundleForProject(aProjectName, isFramework);
        }
        return aProjectBundle;
    }

    public static synchronized WODeployedBundle bundleWithPath(String aPath) {
        NSBundle bundle = NSBundle.bundleWithPath((String)aPath);
        if (bundle == null) {
            return null;
        }
        return WODeployedBundle.bundleWithNSBundle(bundle);
    }

    public static synchronized WODeployedBundle bundleWithNSBundle(NSBundle nsBundle) {
        Object aBundle = TheBundles.objectForKey((Object)nsBundle);
        if (aBundle == null) {
            block7: {
                WODeployedBundle deployedBundle = new WODeployedBundle(nsBundle);
                if (_allowRapidTurnaround) {
                    String bundlePath = nsBundle.bundlePathURL().getPath();
                    try {
                        if (WOProjectBundle._isProjectBundlePath(bundlePath)) {
                            aBundle = new WOProjectBundle(bundlePath, deployedBundle);
                            break block7;
                        }
                        aBundle = deployedBundle;
                    }
                    catch (Exception e) {
                        if (NSLog.debugLoggingAllowedForLevel((int)1)) {
                            NSLog.debug.appendln((Object)("<WOProjectBundle>: Warning - Unable to find project at path " + nsBundle.bundlePathURL().getPath() + " - Ignoring project."));
                            NSLog.debug.appendln((Throwable)e);
                        }
                        aBundle = deployedBundle;
                    }
                } else {
                    aBundle = deployedBundle;
                }
            }
            TheBundles.setObjectForKey(aBundle, (Object)nsBundle);
        }
        return (WODeployedBundle)aBundle;
    }

    private boolean _isWebServerResource(String resourceName) {
        this._preloadAllResourcesIfNecessary();
        Object localizedPathsTable = this._relativePaths.objectForKey((Object)resourceName);
        if (localizedPathsTable != null) {
            if (localizedPathsTable instanceof String) {
                if (this._isAnyWebServerResource((String)localizedPathsTable)) {
                    return true;
                }
            } else {
                NSArray localizedPaths = ((NSDictionary)localizedPathsTable).allValues();
                int count = localizedPaths.count();
                int i = 0;
                while (i < count) {
                    if (this._isAnyWebServerResource((String)localizedPaths.objectAtIndex(i))) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    private boolean _isAnyWebServerResource(String pathName) {
        return pathName.startsWith(_webServerResourcesPathKey) || pathName.startsWith(_contentsWebServerResourcesPathKey);
    }

    public NSArray<String> _allResourceNamesWithExtension(String extension, boolean webServerResourcesOnly) {
        if (extension == null) {
            throw new IllegalArgumentException("Extension needs to be specified in _allResourceNamesWithExtension");
        }
        this._preloadAllResourcesIfNecessary();
        NSMutableArray resourceNames = new NSMutableArray(16);
        NSArray allResourceNames = this._relativePaths.allKeys();
        int numberOfResourceNames = allResourceNames.count();
        int i = 0;
        while (i < numberOfResourceNames) {
            String resourceName = (String)allResourceNames.objectAtIndex(i);
            String resourceNameExtension = NSPathUtilities.pathExtension((String)resourceName);
            if (resourceNameExtension != null && extension.equals(resourceNameExtension) && (!webServerResourcesOnly || this._isWebServerResource(resourceName))) {
                resourceNames.addObject((Object)resourceName);
            }
            ++i;
        }
        return resourceNames;
    }

    public static synchronized WODeployedBundle deployedBundleForFrameworkNamed(String aFrameworkName) {
        WODeployedBundle aBundle = null;
        NSArray bundleArray = TheBundles.allValues();
        int baCount = TheBundles.count();
        NSBundle nsBundle = NSBundle.bundleForName((String)aFrameworkName);
        if (nsBundle == null) {
            nsBundle = NSBundle.bundleWithPath((String)aFrameworkName);
        }
        if (nsBundle != null) {
            int i = 0;
            while (i < baCount) {
                WODeployedBundle aFrameworkBundle = (WODeployedBundle)bundleArray.objectAtIndex(i);
                if (nsBundle.equals(aFrameworkBundle.nsBundle())) {
                    aBundle = aFrameworkBundle;
                    WOProjectBundle dBundle = aBundle.projectBundle();
                    if (dBundle == null) break;
                    aBundle = dBundle;
                    break;
                }
                ++i;
            }
        }
        return aBundle;
    }

    public String toString() {
        return "<" + this.getClass().getName() + ": bundlePath='" + this._bundlePath + "'>";
    }
}

