/*
 * Decompiled with CFR 0.152.
 */
package er.selenium;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXFileUtilities;
import er.selenium.SeleniumTestFilesFinder;
import er.selenium.io.SeleniumImporterExporterFactory;
import er.selenium.io.SeleniumTestImporter;
import java.io.File;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSeleniumTestFilesFinder
implements SeleniumTestFilesFinder {
    private static final Logger log = Logger.getLogger(DefaultSeleniumTestFilesFinder.class);

    @Override
    public NSArray<File> findTests(File rootDir) {
        NSMutableArray result = new NSMutableArray();
        log.debug((Object)("Inspecting contents of directory '" + rootDir.getAbsolutePath()));
        NSArray filesList = ERXFileUtilities.arrayByAddingFilesInDirectory((File)rootDir, (boolean)true);
        for (File file : filesList) {
            String fname = file.getName();
            if (!file.isFile()) {
                log.debug((Object)("Ignoring " + fname + " as it is not a regular file"));
                continue;
            }
            if (fname.startsWith("_")) {
                log.debug((Object)("Ignoring " + fname + " because of the starting _"));
                continue;
            }
            String extension = "." + ERXFileUtilities.fileExtension((String)fname);
            SeleniumTestImporter importer = SeleniumImporterExporterFactory.instance().findImporterByExtension(extension);
            if (importer != null) {
                result.add((Object)file);
                log.debug((Object)("Test file '" + file.getName() + "' of type '" + importer.name() + "'"));
                continue;
            }
            log.debug((Object)("Can't find importer for extension '" + extension + "' for file '" + file.getName() + "'"));
        }
        ERXArrayUtilities.sortArrayWithKey((NSMutableArray)result, (String)"absolutePath");
        return result;
    }
}

