/*
 * Decompiled with CFR 0.152.
 */
package er.selenium;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOCookie;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSTimestamp;
import er.extensions.appserver.ERXDirectAction;
import er.selenium.ERSelenium;
import java.util.Enumeration;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumAction
extends ERXDirectAction {
    private static final Logger log = Logger.getLogger(SeleniumAction.class);

    public SeleniumAction(WORequest request) {
        super(request);
    }

    protected String[] cookieKeys() {
        return new String[0];
    }

    protected void resetSession(WOResponse response) {
        if (!this.context().hasSession()) {
            // empty if block
        }
        this.session().terminate();
        String[] keys = this.cookieKeys();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            WOCookie dummyCookie = new WOCookie(key, "dummy");
            dummyCookie.setPath("/");
            dummyCookie.setDomain(null);
            dummyCookie.setExpires(new NSTimestamp().timestampByAddingGregorianUnits(0, -2, 0, 0, 0, 0));
            response.addCookie(dummyCookie);
        }
    }

    protected WOResponse dictionaryResponse(NSDictionary<?, ?> dict) {
        WOResponse response = new WOResponse();
        response.appendContentString("<html><body>");
        Enumeration e = dict.keyEnumerator();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = dict.objectForKey(key);
            response.appendContentString("<span id='" + key + "'>" + value + "</span>\n");
        }
        response.appendContentString("</body></html>");
        return response;
    }

    protected WOResponse stringResponse(String s) {
        WOResponse response = new WOResponse();
        response.appendContentString(s);
        return response;
    }

    protected WOResponse simpleResponse(String s) {
        return this.stringResponse(s);
    }

    protected WOResponse success() {
        return this.stringResponse("Action command succeeded.");
    }

    protected WOResponse fail() {
        return this.stringResponse("Action command failed.");
    }

    protected WOResponse fail(String s) {
        return this.stringResponse("Action command failed. " + s);
    }

    public WOActionResults performActionNamed(String anActionName) {
        log.debug((Object)("Selenium Action: " + anActionName));
        WOActionResults result = null;
        if (ERSelenium.testsEnabled()) {
            result = super.performActionNamed(anActionName);
        } else {
            log.error((Object)"Selenium tests support is disabled. You can turn them on using SeleniumTestsEnabled=true in Properties files");
            result = this.stringResponse("Selenium tests are disabled.");
        }
        WOResponse response = result.generateResponse();
        if (!this.session().isTerminating()) {
            result = response;
            this.session()._appendCookieToResponse(response);
        }
        log.debug((Object)("Out Session: " + this.session().sessionID() + response.cookies()));
        return result;
    }
}

