/*
 * Decompiled with CFR 0.152.
 */
package er.selenium;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WODirectAction;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSComparator;
import er.extensions.foundation.ERXFileUtilities;
import er.extensions.foundation.ERXProperties;
import er.selenium.ERSelenium;
import er.selenium.SeleniumAction;
import java.io.File;
import org.apache.log4j.Logger;

public class SeleniumTestResults
extends WODirectAction {
    private static final Logger log = Logger.getLogger(SeleniumAction.class);
    public static final String DEFAULT_REPORT_PATH = "./";
    protected String _report;

    public SeleniumTestResults(WORequest request) {
        super(request);
    }

    protected String buildReport() {
        StringBuilder result = new StringBuilder();
        NSArray keys = this.context().request().formValueKeys();
        try {
            keys = keys.sortedArrayUsingComparator(NSComparator.AscendingStringComparator);
        }
        catch (NSComparator.ComparisonException e) {
            log.debug((Object)"can't sort results' dictionary keys");
        }
        for (String key : keys) {
            result.append(key);
            result.append(": ");
            result.append(this.context().request().stringFormValueForKey(key));
            result.append("\n\n");
        }
        return result.toString();
    }

    public String report() {
        if (this._report == null) {
            this._report = this.buildReport();
        }
        return this._report;
    }

    protected WOActionResults processReport(String filename) {
        if (filename != null) {
            filename = ERXProperties.stringForKeyWithDefault((String)"SeleniumReportPath", (String)DEFAULT_REPORT_PATH) + "/" + filename;
            try {
                ERXFileUtilities.stringToFile((String)this.report(), (File)new File(filename), (String)"UTF-8");
            }
            catch (Exception e) {
                log.debug((Object)e.getMessage());
            }
        }
        WOResponse response = new WOResponse();
        response.appendContentString(this.report());
        return response;
    }

    public WOActionResults defaultAction() {
        return this.processReport(null);
    }

    public WOActionResults performActionNamed(String actionName) {
        if (!ERSelenium.testsEnabled()) {
            return new WOResponse();
        }
        if (actionName.equals("default")) {
            return this.defaultAction();
        }
        return this.processReport(actionName);
    }
}

