/*
 * Decompiled with CFR 0.152.
 */
package er.selenium;

import com.webobjects.appserver.WOContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.components.ERXStatelessComponent;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXUtilities;
import er.selenium.ERSelenium;
import er.selenium.SeleniumTest;
import er.selenium.SeleniumTestFileProcessor;
import er.selenium.filters.SeleniumCompositeTestFilter;
import er.selenium.filters.SeleniumIncludeTestFilter;
import er.selenium.filters.SeleniumOverrideOpenTestFilter;
import er.selenium.filters.SeleniumRepeatExpanderTestFilter;
import er.selenium.filters.SeleniumTestFilter;
import er.selenium.io.SeleniumImporterExporterFactory;
import er.selenium.io.SeleniumTestExporter;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumTestSuitePage
extends ERXStatelessComponent {
    private static final Logger log = Logger.getLogger(SeleniumTestSuitePage.class);
    private static final String DEFAULT_SELENIUM_TESTS_ROOT = ERXProperties.booleanForKeyWithDefault((String)"NSProjectBundleEnabled", (boolean)false) ? "./Resources/Selenium" : "./Contents/Resources/Selenium";
    private static final String DEFAULT_EXPORTER_NAME = "xhtml";
    private SeleniumCompositeTestFilter testFilter;
    private NSArray<File> testFiles;
    public File testFile;
    private File groupDir;
    private String testPath;

    public NSArray<File> testFiles() {
        if (this.testFiles == null) {
            this.testFiles = ERSelenium.testFilesFinder().findTests(this.groupDir != null ? this.groupDir : this.testsRoot());
        }
        return this.testFiles;
    }

    public void setTestPath(String testPath) {
        this.testPath = testPath;
        File fpath = new File(this.testsRoot().getAbsolutePath() + "/" + testPath);
        if (fpath.isDirectory()) {
            this.groupDir = fpath;
        } else {
            this.testFile = fpath;
        }
    }

    public String testPath() {
        return this.testPath;
    }

    protected File testsRoot() {
        return new File(ERXProperties.stringForKeyWithDefault((String)"SeleniumTestsRoot", (String)DEFAULT_SELENIUM_TESTS_ROOT));
    }

    protected File testDir() {
        return this.testFile.getParentFile();
    }

    public String testGroupName() {
        File parentFile = this.testFile.getParentFile();
        try {
            return parentFile.getCanonicalPath().equals(this.testsRoot().getCanonicalPath()) ? "" : parentFile.getName();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasTestGroup() {
        return this.testGroupName().length() > 0;
    }

    protected void checkTestPath() {
        try {
            String cnTestPath = this.testFile.getCanonicalPath();
            String cnTestsRoot = this.testsRoot().getCanonicalPath();
            if (!cnTestPath.startsWith(cnTestsRoot)) {
                throw new RuntimeException("Trying to reach file (" + cnTestPath + ") ouside of the tests root (" + cnTestsRoot + ")");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SeleniumTestFilter testFilter() {
        if (this.testFilter == null) {
            this.testFilter = new SeleniumCompositeTestFilter();
            Object[] searchPaths = new File[]{this.testDir().getAbsoluteFile(), this.testsRoot().getAbsoluteFile()};
            this.testFilter.addTestFilter(new SeleniumIncludeTestFilter((NSArray<File>)new NSArray(searchPaths)));
            this.testFilter.addTestFilter(new SeleniumRepeatExpanderTestFilter());
            if (!ERXProperties.booleanForKey((String)"er.selenium.filters.overrideopen.disable")) {
                this.testFilter.addTestFilter(new SeleniumOverrideOpenTestFilter(this.context().urlWithRequestHandlerKey(null, null, null)));
            }
        }
        return this.testFilter;
    }

    public SeleniumTestSuitePage(WOContext context) {
        super(context);
    }

    public String testLink() {
        NSMutableDictionary queryArgs = new NSMutableDictionary();
        String format = this.context().request().stringFormValueForKey("format");
        if (format != null) {
            queryArgs.setObjectForKey((Object)format, (Object)"format");
        }
        return this.context().directActionURLForActionNamed(String.format("SeleniumTestSuite/%s%s", this.hasTestGroup() ? this.testGroupName() + "|" : "", this.testFile.getName()), (NSDictionary)queryArgs);
    }

    public String testContents() {
        if (this.testPath != null && this.groupDir == null) {
            SeleniumTestExporter exporter = null;
            String format = this.context().request().stringFormValueForKey("format");
            if (format != null) {
                exporter = SeleniumImporterExporterFactory.instance().findExporterByName(format);
                if (exporter == null) {
                    throw new RuntimeException("Unsupported output format specified ('" + format + "')");
                }
            } else {
                exporter = SeleniumImporterExporterFactory.instance().findExporterByName(DEFAULT_EXPORTER_NAME);
                assert (exporter != null);
            }
            try {
                SeleniumTest test = new SeleniumTestFileProcessor(this.testFile, this.context().request().formValueForKey("noFilters") == null ? this.testFilter() : null).process();
                return exporter.process(test);
            }
            catch (Exception e) {
                log.debug((Object)ERXUtilities.stackTrace((Throwable)e));
                throw new RuntimeException("Test export failed", e);
            }
        }
        return null;
    }

    public void reset() {
        super.reset();
        this.testPath = null;
        this.groupDir = null;
    }
}

