/*
 * Decompiled with CFR 0.152.
 */
package er.selenium.io;

import com.webobjects.foundation.NSMutableDictionary;
import er.selenium.io.SeleniumTestExporter;
import er.selenium.io.SeleniumTestImporter;
import org.apache.log4j.Logger;

public class SeleniumImporterExporterFactory {
    private static final Logger log = Logger.getLogger(SeleniumImporterExporterFactory.class);
    private static SeleniumImporterExporterFactory _instance = null;
    protected static NSMutableDictionary _importersByExtensionMap = new NSMutableDictionary();
    protected static NSMutableDictionary _importersByNameMap = new NSMutableDictionary();
    protected static NSMutableDictionary _exportersByNameMap = new NSMutableDictionary();

    public static SeleniumImporterExporterFactory instance() {
        if (_instance == null) {
            _instance = new SeleniumImporterExporterFactory();
        }
        return _instance;
    }

    public void registerImporter(String extension, SeleniumTestImporter importer) {
        log.debug((Object)("Registering importer '" + importer.name() + "' for extension '" + extension + "'"));
        _importersByExtensionMap.setObjectForKey((Object)importer, (Object)extension);
        _importersByNameMap.setObjectForKey((Object)importer, (Object)importer.name());
    }

    public void registerExporter(SeleniumTestExporter exporter) {
        log.debug((Object)("Registering exporter '" + exporter.name() + "'"));
        _exportersByNameMap.setObjectForKey((Object)exporter, (Object)exporter.name());
    }

    public SeleniumTestImporter findImporterByExtension(String extension) {
        return (SeleniumTestImporter)_importersByExtensionMap.objectForKey((Object)extension);
    }

    public SeleniumTestImporter findImporterByName(String name) {
        return (SeleniumTestImporter)_importersByNameMap.objectForKey((Object)name);
    }

    public SeleniumTestExporter findExporterByName(String name) {
        return (SeleniumTestExporter)_exportersByNameMap.objectForKey((Object)name);
    }
}

