/*
 * Decompiled with CFR 0.152.
 */
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSMutableArray;
import er.ajax.AjaxDragResizeContainer;
import er.ajax.AjaxUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class DragResizeExample
extends WOComponent {
    public AjaxDragResizeContainer.ResizeReport report = null;
    public NSMutableArray<Annotation> annotations = new NSMutableArray((Object[])new Annotation[]{new Annotation(377, 96, 79, 68, "Nose", "Due to his big nose, our dog loves to snoop around"), new Annotation(312, 372, 112, 81, "Foot", "Athough the feet are quite big, the legs aren't, so he's not a big sprinter...")});
    public Annotation annotationItem;
    public boolean editingEnabled = true;

    public DragResizeExample(WOContext context) {
        super(context);
    }

    public void appendToResponse(WOResponse response, WOContext ctx) {
        super.appendToResponse(response, ctx);
        AjaxUtils.addScriptResourceInHead((WOContext)ctx, (WOResponse)response, (String)"app", (String)"overlib.js");
        AjaxUtils.addStylesheetResourceInHead((WOContext)ctx, (WOResponse)response, (String)"app", (String)"dragresize_example.css");
    }

    public void annotationChanged() {
        System.out.println("DragResizeExample.annotationChanged() " + this.report);
        if (this.report != null) {
            if (this.report.isBlur()) {
                this.report = null;
            } else if (this.report.isDragEnd() && this.report.object() != null) {
                Annotation annotation = (Annotation)this.report.object();
                annotation.x = this.report.x();
                annotation.y = this.report.y();
                annotation.w = this.report.width();
                annotation.h = this.report.height();
            }
        }
    }

    public void saveAction() {
        System.out.println("DragResizeExample.saveAction()");
    }

    public void toggleEditing() {
        System.out.println("DragResizeExample.toggleEditing()");
        this.editingEnabled = !this.editingEnabled;
    }

    public void addAnnotation() {
        System.out.println("DragResizeExample.addAnnotation()");
        this.annotations.addObject((Object)new Annotation(10, 10, 100, 100, "New Annotation", ""));
    }

    public void removeAnnotation() {
        System.out.println("DragResizeExample.removeAnnotation()");
        if (this.report != null && this.report.object() != null) {
            this.annotations.removeObject(this.report.object());
        }
    }

    public String overLibJsForAnnotationItem() {
        return this.editingEnabled ? "" : "return overlib(unescape('" + DragResizeExample.escapeStringForJS(this.annotationItem.content) + "'), CAPTION, '" + DragResizeExample.escapeStringForJS(this.annotationItem.title) + "');";
    }

    public static String escapeStringForJS(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8").replaceAll("\\+", " ");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    public class Annotation {
        public int x;
        public int y;
        public int w;
        public int h;
        public String title;
        public String content;

        public Annotation(int x, int y, int w, int h, String title, String content) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.title = title;
            this.content = content;
        }
    }
}

