/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.batching;

import com.webobjects.foundation.NSArray;
import er.extensions.batching.IBatchingList;
import java.util.AbstractList;

public abstract class AbstractBatchingList
extends AbstractList
implements IBatchingList {
    private int _pageIndex = 1;
    private int _pageSize = 10;
    private NSArray _sortOrderings;

    protected abstract boolean isPageLoaded();

    protected abstract void loadPage(int var1, int var2, NSArray var3);

    protected abstract void invalidatePage();

    protected abstract int getTotalCount();

    protected abstract Object getFromPage(int var1);

    protected void ensurePageLoaded(int index) {
        boolean withinPage;
        int startIndex = this._pageSize * (this._pageIndex - 1);
        int endIndex = startIndex + this._pageSize;
        int effectiveIndex = index == -1 ? startIndex : index;
        boolean bl = withinPage = effectiveIndex >= startIndex && effectiveIndex <= endIndex;
        if (!withinPage) {
            this.setPageIndex(index / this._pageSize + 1);
        }
        if (!withinPage || !this.isPageLoaded()) {
            this.loadPage(startIndex, this._pageSize, this._sortOrderings);
        }
    }

    public Object get(int index) {
        this.ensurePageLoaded(index);
        Object obj = this.getFromPage(index - this._pageSize * (this._pageIndex - 1));
        return obj;
    }

    public int size() {
        this.ensurePageLoaded(-1);
        int totalCount = this.getTotalCount();
        return totalCount;
    }

    public void setPageIndex(int pageIndex) {
        this._pageIndex = pageIndex;
        this.invalidatePage();
    }

    public void setPageSize(int pageSize) {
        this._pageSize = pageSize;
        this.invalidatePage();
    }

    public void setSortOrderings(NSArray sortOrderings) {
        this._sortOrderings = sortOrderings;
        this.invalidatePage();
    }
}

