/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.batching;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WODisplayGroup;
import com.webobjects.appserver.WOResponse;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSNotificationCenter;
import er.extensions.appserver.ERXDisplayGroup;
import er.extensions.components.ERXStatelessComponent;
import er.extensions.components._private.ERXWOForm;
import er.extensions.eof.ERXConstant;
import er.extensions.foundation.ERXThreadStorage;
import org.apache.log4j.Logger;

public class ERXBatchNavigationBar
extends ERXStatelessComponent {
    public static final Logger log = Logger.getLogger(ERXBatchNavigationBar.class);
    public static final String BatchSizeChanged = "BatchSizeChanged";
    public boolean wasInForm;
    private String _threadStorageKey;
    private WODisplayGroup _displayGroup;

    public ERXBatchNavigationBar(WOContext aContext) {
        super(aContext);
    }

    public void awake() {
        super.awake();
        this.wasInForm = this.context().isInForm();
        this._threadStorageKey = "ERXBatchNavigationBar_numberOfObjectsPerBatch_" + this.context().elementID();
    }

    public void reset() {
        super.reset();
        this._displayGroup = null;
        this._threadStorageKey = null;
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        Number newNumberOfObjectsPerBatch = (Number)ERXThreadStorage.valueForKey(this._threadStorageKey);
        if (newNumberOfObjectsPerBatch != null && newNumberOfObjectsPerBatch.intValue() != this.displayGroup().numberOfObjectsPerBatch()) {
            Object d2wcontext;
            if (this.displayGroup() != null) {
                NSArray selection = this.selection();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Setting db # of objects per batch to " + newNumberOfObjectsPerBatch));
                }
                this.displayGroup().setNumberOfObjectsPerBatch(newNumberOfObjectsPerBatch.intValue());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"The batch index is being set to : 1");
                }
                this.displayGroup().setCurrentBatchIndex(1);
                this.clearSelection(selection);
            }
            if ((d2wcontext = this.valueForBinding("d2wContext")) != null) {
                NSNotificationCenter.defaultCenter().postNotification(BatchSizeChanged, (Object)ERXConstant.integerForInt(newNumberOfObjectsPerBatch.intValue()), new NSDictionary<String, Object>(d2wcontext, "d2wContext"));
            }
            ERXThreadStorage.takeValueForKey(null, this._threadStorageKey);
        }
        if (this.displayGroup() != null && !this.displayGroup().hasMultipleBatches() && this.currentBatchIndex() != 0) {
            this.setCurrentBatchIndex(ERXConstant.ZeroInteger);
        }
        super.appendToResponse(response, context);
    }

    public WODisplayGroup displayGroup() {
        if (this._displayGroup == null) {
            this._displayGroup = (WODisplayGroup)this.valueForBinding("displayGroup");
        }
        return this._displayGroup;
    }

    public boolean hasObjectName() {
        return this.hasBinding("objectName");
    }

    public boolean hasSortKeyList() {
        return this.hasBinding("sortKeyList");
    }

    public int numberOfObjectsPerBatch() {
        return this.displayGroup() != null ? this.displayGroup().numberOfObjectsPerBatch() : 0;
    }

    public int currentBatchIndex() {
        return this.displayGroup() != null ? this.displayGroup().currentBatchIndex() : 0;
    }

    public void setCurrentBatchIndex(Number newValue) {
        if (newValue != null && this.displayGroup() != null) {
            this.displayGroup().setCurrentBatchIndex(newValue.intValue());
            if (log.isDebugEnabled()) {
                log.debug((Object)("The batch index is being set to :" + newValue.intValue()));
            }
        }
    }

    public void setNumberOfObjectsPerBatch(Number newValue) {
        ERXThreadStorage.takeValueForKey(newValue, this._threadStorageKey);
    }

    public int filteredObjectsCount() {
        WODisplayGroup dg = this.displayGroup();
        if (dg instanceof ERXDisplayGroup) {
            ERXDisplayGroup erxdg = (ERXDisplayGroup)dg;
            return erxdg.filteredObjects().count();
        }
        int result = 0;
        EOQualifier q = dg.qualifier();
        result = q != null ? EOQualifier.filteredArrayWithQualifier((NSArray)dg.allObjects(), (EOQualifier)q).count() : dg.allObjects().count();
        return result;
    }

    public int objectCount() {
        return this.displayGroup().allObjects().count();
    }

    public String imageFramework() {
        String imageFramework = !this.hasBinding("imageFramework") ? "JavaWOExtensions" : (String)this.valueForBinding("imageFramework");
        return imageFramework;
    }

    public String leftArrowImage() {
        String leftArrowImageName = !this.hasBinding("leftArrowImage") ? "lft-OSarw.gif" : (String)this.valueForBinding("leftArrowImage");
        return leftArrowImageName;
    }

    public String rightArrowImage() {
        String rightArrowImageName = !this.hasBinding("rightArrowImage") ? "rt-OSarw.gif" : (String)this.valueForBinding("rightArrowImage");
        return rightArrowImageName;
    }

    protected NSArray selection() {
        return this.displayGroup().selectedObjects();
    }

    protected void clearSelection(NSArray selection) {
        if (this.booleanValueForBinding("clearSelection", false)) {
            this.displayGroup().setSelectedObjects(NSArray.EmptyArray);
        }
    }

    public WOComponent displayNextBatch() {
        if (this.displayGroup() != null && this.displayGroup().numberOfObjectsPerBatch() != 0) {
            NSArray selection = this.selection();
            this.displayGroup().setCurrentBatchIndex(this.displayGroup().currentBatchIndex() + 1);
            this.clearSelection(selection);
        }
        return this.context().page();
    }

    public WOComponent displayPreviousBatch() {
        if (this.displayGroup() != null && this.displayGroup().numberOfObjectsPerBatch() != 0) {
            NSArray selection = this.selection();
            this.displayGroup().setCurrentBatchIndex(this.displayGroup().currentBatchIndex() - 1);
            this.clearSelection(selection);
        }
        return this.context().page();
    }

    public WOComponent displayFirstBatch() {
        if (this.displayGroup() != null && this.displayGroup().numberOfObjectsPerBatch() != 0) {
            NSArray selection = this.selection();
            this.displayGroup().setCurrentBatchIndex(1);
            this.clearSelection(selection);
        }
        return this.context().page();
    }

    public WOComponent displayLastBatch() {
        if (this.displayGroup() != null && this.displayGroup().numberOfObjectsPerBatch() != 0) {
            NSArray selection = this.selection();
            this.displayGroup().setCurrentBatchIndex(this.displayGroup().batchCount());
            this.clearSelection(selection);
        }
        return this.context().page();
    }

    public String formTarget() {
        if (this.wasInForm) {
            return ERXWOForm.formName(this.context(), "EditForm") + ".target='_self';";
        }
        return null;
    }
}

