/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.appserver.ERXResponseRewriter;
import er.extensions.components.ERXClickToOpenSupport;
import er.extensions.components.ERXComponentUtilities;
import er.extensions.foundation.ERXUtilities;
import er.extensions.foundation.ERXValueUtilities;
import er.extensions.localization.ERXLocalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ERXComponent
extends WOComponent {
    protected NSMutableDictionary _dynamicBindings = null;

    public ERXComponent(WOContext context) {
        super(context);
    }

    public <T extends WOComponent> T pageWithName(Class<T> componentClass) {
        return (T)super.pageWithName(componentClass.getName());
    }

    public void _awakeInContext(WOContext aArg0) {
        super._awakeInContext(aArg0);
        if (this.isStateless()) {
            this._dynamicBindings = null;
        }
    }

    protected void _checkAccess() throws SecurityException {
        if (!this.isPageAccessAllowed() && this._isPage()) {
            throw new SecurityException("You are not allowed to directly access the component '" + this.name() + "'.");
        }
        if (this._isPage()) {
            this.checkAccess();
        }
    }

    public void takeValuesFromRequest(WORequest request, WOContext context) {
        this._checkAccess();
        super.takeValuesFromRequest(request, context);
    }

    public WOActionResults invokeAction(WORequest request, WOContext context) {
        this._checkAccess();
        return super.invokeAction(request, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendToResponse(WOResponse response, WOContext context) {
        this._checkAccess();
        this.preAppendToResponse(response, context);
        boolean clickToOpenEnabled = this.clickToOpenEnabled(response, context);
        ERXClickToOpenSupport.preProcessResponse(response, context, clickToOpenEnabled);
        try {
            super.appendToResponse(response, context);
        }
        finally {
            ERXClickToOpenSupport.postProcessResponse(((Object)((Object)this)).getClass(), response, context, clickToOpenEnabled);
        }
        this.postAppendToResponse(response, context);
        this._includeCSSResources(response, context);
        this._includeJavascriptResources(response, context);
    }

    public boolean clickToOpenEnabled(WOResponse response, WOContext context) {
        return ERXClickToOpenSupport.isEnabled();
    }

    protected int intValueForBinding(String binding, int defaultValue) {
        return ERXValueUtilities.intValueWithDefault(this.valueForBinding(binding), defaultValue);
    }

    protected float floatValueForBinding(String binding, float defaultValue) {
        return ERXValueUtilities.floatValueWithDefault(this.valueForBinding(binding), defaultValue);
    }

    protected boolean booleanValueForBinding(String binding) {
        return this.booleanValueForBinding(binding, false);
    }

    protected boolean booleanValueForBinding(String binding, boolean defaultValue) {
        return ERXComponentUtilities.booleanValueForBinding(this, binding, defaultValue);
    }

    protected boolean booleanValueForBinding(String binding, ERXUtilities.BooleanOperation defaultValue) {
        if (this.hasBinding(binding)) {
            return this.booleanValueForBinding(binding, false);
        }
        return defaultValue.value();
    }

    protected Object objectValueForBinding(String binding) {
        return this.objectValueForBinding(binding, null);
    }

    protected Object objectValueForBinding(String binding, Object defaultValue) {
        Object o;
        Object result = null;
        result = this.hasBinding(binding) ? ((o = this.valueForBinding(binding)) == null ? defaultValue : o) : defaultValue;
        if (result instanceof ERXUtilities.Operation) {
            result = ((ERXUtilities.Operation)result).value();
        }
        return result;
    }

    protected String stringValueForBinding(String binding) {
        return this.stringValueForBinding(binding, null);
    }

    protected String stringValueForBinding(String binding, String defaultValue) {
        Object v = this.objectValueForBinding(binding, defaultValue);
        return v != null ? v.toString() : null;
    }

    public ERXLocalizer localizer() {
        return ERXLocalizer.currentLocalizer();
    }

    public NSMutableDictionary dynamicBindings() {
        if (this._dynamicBindings == null) {
            this._dynamicBindings = new NSMutableDictionary();
        }
        return this._dynamicBindings;
    }

    public void reset() {
        super.reset();
        if (this._dynamicBindings != null) {
            this._dynamicBindings.removeAllObjects();
        }
    }

    public String componentName() {
        int lastDotIndex;
        String componentName = this.name();
        if (componentName != null && (lastDotIndex = componentName.lastIndexOf(46)) != -1) {
            componentName = componentName.substring(lastDotIndex + 1);
        }
        return componentName;
    }

    protected void _includeCSSResources(WOResponse response, WOContext context) {
        NSArray<String> additionalCSSFiles;
        String primaryCSSFile = this.primaryCSSFile();
        if (primaryCSSFile == null && this.useDefaultComponentCSS()) {
            String componentName = this.componentName();
            primaryCSSFile = componentName + ".css";
        }
        if (primaryCSSFile != null) {
            String defaultCSSPath = this.defaultCSSPath();
            if (defaultCSSPath != null && defaultCSSPath.length() > 0 && !defaultCSSPath.endsWith("/")) {
                defaultCSSPath = defaultCSSPath + "/";
            }
            String frameworkName = this._frameworkName();
            ERXResponseRewriter.addStylesheetResourceInHead(response, context, frameworkName, defaultCSSPath + primaryCSSFile);
        }
        if ((additionalCSSFiles = this.additionalCSSFiles()) != null) {
            String defaultCSSPath = this.defaultCSSPath();
            if (defaultCSSPath != null && defaultCSSPath.length() > 0 && !defaultCSSPath.endsWith("/")) {
                defaultCSSPath = defaultCSSPath + "/";
            }
            String frameworkName = this._frameworkName();
            for (String additionalCSSFile : additionalCSSFiles) {
                ERXResponseRewriter.addStylesheetResourceInHead(response, context, frameworkName, defaultCSSPath + additionalCSSFile);
            }
        }
    }

    protected void _includeJavascriptResources(WOResponse response, WOContext context) {
        NSArray<String> additionalJavascriptFiles;
        String primaryJavascriptFile = this.primaryJavascriptFile();
        if (primaryJavascriptFile == null && this.useDefaultComponentJavascript()) {
            String componentName = this.componentName();
            primaryJavascriptFile = componentName + ".js";
        }
        if (primaryJavascriptFile != null) {
            String defaultJavascriptPath = this.defaultJavascriptPath();
            if (defaultJavascriptPath != null && defaultJavascriptPath.length() > 0 && !defaultJavascriptPath.endsWith("/")) {
                defaultJavascriptPath = defaultJavascriptPath + "/";
            }
            String frameworkName = this._frameworkName();
            ERXResponseRewriter.addScriptResourceInHead(response, context, frameworkName, defaultJavascriptPath + primaryJavascriptFile);
        }
        if ((additionalJavascriptFiles = this.additionalJavascriptFiles()) != null) {
            String defaultJavascriptPath = this.defaultJavascriptPath();
            if (defaultJavascriptPath != null && defaultJavascriptPath.length() > 0 && !defaultJavascriptPath.endsWith("/")) {
                defaultJavascriptPath = defaultJavascriptPath + "/";
            }
            String frameworkName = this._frameworkName();
            for (String additionalJavascriptFile : additionalJavascriptFiles) {
                ERXResponseRewriter.addScriptResourceInHead(response, context, frameworkName, defaultJavascriptPath + additionalJavascriptFile);
            }
        }
    }

    protected String _frameworkName() {
        String frameworkName = super.frameworkName();
        if (frameworkName == null) {
            frameworkName = "app";
        }
        return frameworkName;
    }

    protected boolean useDefaultComponentCSS() {
        return false;
    }

    protected String defaultCSSPath() {
        return "";
    }

    protected String primaryCSSFile() {
        return null;
    }

    protected NSArray<String> additionalCSSFiles() {
        return null;
    }

    protected boolean useDefaultComponentJavascript() {
        return false;
    }

    protected String defaultJavascriptPath() {
        return "";
    }

    protected String primaryJavascriptFile() {
        return null;
    }

    protected NSArray<String> additionalJavascriptFiles() {
        return null;
    }

    protected boolean isPageAccessAllowed() {
        return true;
    }

    protected void checkAccess() throws SecurityException {
    }

    protected void preAppendToResponse(WOResponse response, WOContext context) {
    }

    protected void postAppendToResponse(WOResponse response, WOContext context) {
    }
}

