/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components;

import com.webobjects.appserver.WOContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import er.extensions.components.ERXStatelessComponent;
import er.extensions.crypting.ERXCrypto;
import er.extensions.eof.ERXEOEncodingUtilities;
import er.extensions.foundation.ERXStringUtilities;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class ERXDirectActionHyperlink
extends ERXStatelessComponent {
    public static final String ADAPTOR_PREFIX_MARKER = "**ADAPTOR_PREFIX**";
    public static final String SUFFIX_MARKER = "**SUFFIX**";
    public static final Logger log = Logger.getLogger(ERXDirectActionHyperlink.class);
    private static String _applicationHostUrl;

    public ERXDirectActionHyperlink(WOContext aContext) {
        super(aContext);
    }

    public String entityNameSeparator() {
        String separator = (String)this.valueForBinding("entityNameSeparator");
        if (separator == null) {
            separator = ERXEOEncodingUtilities.entityNameSeparator();
        }
        return separator;
    }

    public boolean relative() {
        return this.booleanValueForBinding("relative", true);
    }

    public boolean shouldEncryptObjectFormValues() {
        return this.booleanValueForBinding("shouldEncryptObjectFormValues");
    }

    public NSArray objectsForFormValues() {
        return (NSArray)this.valueForBinding("objectsForFormValues");
    }

    public EOEnterpriseObject objectForFormValue() {
        return (EOEnterpriseObject)this.valueForBinding("objectForFormValue");
    }

    public NSArray allObjectsForFormValues() {
        NSMutableArray<EOEnterpriseObject> objects = null;
        if (this.hasBinding("objectsForFormValues") || this.hasBinding("objectForFormValue")) {
            objects = new NSMutableArray<EOEnterpriseObject>();
            if (this.objectsForFormValues() != null) {
                objects.addObjectsFromArray(this.objectsForFormValues());
            }
            if (this.objectForFormValue() != null) {
                objects.addObject(this.objectForFormValue());
            }
        }
        return objects != null ? objects : NSArray.EmptyArray;
    }

    public String href() {
        String directActionName = null;
        NSDictionary encryptedBindingDict = null;
        NSDictionary unencryptedBindingDict = null;
        NSArray formValuesObjects = null;
        if (this.hasBinding("actionClass")) {
            StringBuffer daBuffer = new StringBuffer();
            daBuffer.append(this.valueForBinding("actionClass"));
            daBuffer.append('/');
            daBuffer.append(this.valueForBinding("directActionName"));
            directActionName = daBuffer.toString();
        } else {
            directActionName = (String)this.valueForBinding("directActionName");
        }
        if (directActionName == null || directActionName.length() == 0) {
            throw new IllegalArgumentException("ERXDirectActionHyperlink: directActionName must be specified.");
        }
        if (this.hasBinding("bindingDictionary")) {
            encryptedBindingDict = (NSDictionary)this.valueForBinding("bindingDictionary");
        }
        if (this.hasBinding("unencryptedBindingDictionary")) {
            unencryptedBindingDict = (NSDictionary)this.valueForBinding("unencryptedBindingDictionary");
        }
        if (this.allObjectsForFormValues().count() > 0) {
            formValuesObjects = this.allObjectsForFormValues();
        }
        return ERXDirectActionHyperlink.directActionHyperlink(this.context(), this.shouldEncryptObjectFormValues(), formValuesObjects, this.entityNameSeparator(), encryptedBindingDict, unencryptedBindingDict, this.application().name(), directActionName, this.relative(), null);
    }

    public static String applicationHostUrl() {
        if (_applicationHostUrl == null && ((_applicationHostUrl = System.getProperty("ERApplicationHostURL")) == null || _applicationHostUrl.length() == 0)) {
            throw new RuntimeException("The ERApplicationHostURL default was empty -- please set it for the machine running the target application: it should look like http://mymachine.com");
        }
        return _applicationHostUrl;
    }

    public static String directActionHyperlink(WOContext context, boolean encryptEos, NSArray eos, String entityNameSeparator, NSDictionary encryptedDict, NSDictionary unencryptedDict, String appName, String daName, boolean relative, String suffix) {
        String value;
        String key;
        Enumeration e;
        NSArray allKeys;
        StringBuffer result = new StringBuffer(ADAPTOR_PREFIX_MARKER);
        result.append(".woa/wa/");
        result.append(daName);
        result.append('?');
        if (encryptedDict != null) {
            allKeys = encryptedDict.allKeys();
            e = allKeys.objectEnumerator();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                value = encryptedDict.objectForKey(key).toString();
                ERXStringUtilities.appendSeparatorIfLastNot('&', '?', result);
                result.append(key);
                result.append("=");
                result.append(ERXCrypto.blowfishEncode(value));
            }
        }
        if (unencryptedDict != null) {
            allKeys = unencryptedDict.allKeys();
            e = allKeys.objectEnumerator();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                value = unencryptedDict.objectForKey(key).toString();
                ERXStringUtilities.appendSeparatorIfLastNot('&', '?', result);
                result.append(key);
                result.append("=");
                result.append(value);
            }
        }
        if (eos != null && eos.count() > 0) {
            ERXStringUtilities.appendSeparatorIfLastNot('&', '?', result);
            result.append(ERXEOEncodingUtilities.encodeEnterpriseObjectsPrimaryKeyForUrl(eos, entityNameSeparator, encryptEos));
        }
        if (suffix != null) {
            result.append(SUFFIX_MARKER);
        }
        return ERXDirectActionHyperlink.completeURLFromString(result.toString(), context, appName, relative, suffix);
    }

    public static String completeURLFromString(String s, WOContext c, String applicationName, boolean relative, String suffix) {
        String postFix;
        NSArray<String> a;
        if (s != null && s.indexOf(ADAPTOR_PREFIX_MARKER) != -1) {
            if (applicationName == null || applicationName.length() == 0) {
                throw new RuntimeException("completeURLFromString: found ADAPTOR_PREFIX_MARKER and no application name to replace it - original text:" + s);
            }
            a = NSArray.componentsSeparatedByString(s, ADAPTOR_PREFIX_MARKER);
            postFix = c.request().adaptorPrefix() + "/" + applicationName;
            s = a.componentsJoinedByString(relative ? postFix : ERXDirectActionHyperlink.applicationHostUrl() + postFix);
        }
        if (s != null && s.indexOf(SUFFIX_MARKER) != -1) {
            a = NSArray.componentsSeparatedByString(s, SUFFIX_MARKER);
            postFix = suffix != null ? suffix : "";
            s = a.componentsJoinedByString(postFix);
        }
        return s;
    }
}

