/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components;

import com.webobjects.appserver.WOContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.components.ERXStatelessComponent;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.foundation.ERXValueUtilities;
import er.extensions.localization.ERXLocalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXLanguageMenu
extends ERXStatelessComponent {
    private static NSDictionary<String, String> displayStringForLanguages;
    private static final String localizeDisplayStringsKey = "localizeDisplayStrings";
    private String _languageOption;

    public ERXLanguageMenu(WOContext context) {
        super(context);
    }

    @Override
    public void reset() {
        super.reset();
        this._languageOption = null;
    }

    public NSArray availableLanguages() {
        return ERXLocalizer.availableLanguages();
    }

    public String languageOption() {
        return this._languageOption;
    }

    public void setLanguageOption(String languageOption) {
        this._languageOption = languageOption;
    }

    public String displayStringForLanguage() {
        if (ERXValueUtilities.booleanValueWithDefault(this.valueForBinding(localizeDisplayStringsKey), true)) {
            return this.displayStringForLanguages().get(this.languageOption());
        }
        return ERXLocalizer.currentLocalizer().localizedStringForKey(this.languageOption());
    }

    private NSDictionary<String, String> displayStringForLanguages() {
        if (displayStringForLanguages == null) {
            NSMutableDictionary<String, String> displayStrings = new NSMutableDictionary<String, String>();
            for (Object o : this.availableLanguages()) {
                String languageKey = (String)o;
                ERXLocalizer loc = ERXLocalizer.localizerForLanguage(languageKey);
                String displayString = loc.localizedStringForKey(languageKey);
                if (ERXStringUtilities.stringIsNullOrEmpty(displayString)) {
                    displayString = languageKey;
                }
                displayStrings.put(languageKey, displayString);
            }
            displayStringForLanguages = displayStrings.immutableClone();
        }
        return displayStringForLanguages;
    }
}

