/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components;

import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSRange;
import org.apache.log4j.Logger;

public class ERXMacBinarySwissArmyKnife {
    public static final Logger log = Logger.getLogger(ERXMacBinarySwissArmyKnife.class);
    public static final int ZERO_1_AT = 0;
    public static final int NAME_LEN_AT = 1;
    public static final int NAME_BYTES_AT = 2;
    public static final int FILE_TYPE_AT = 65;
    public static final int FILE_CREATOR_AT = 69;
    public static final int FINDER_FLAGS1_AT = 73;
    public static final int ZERO_2_AT = 74;
    public static final int FINDER_VERT_AT = 75;
    public static final int FINDER_HORZ_AT = 77;
    public static final int FINDER_WINDOW_AT = 79;
    public static final int FLAG_LOCKED_AT = 81;
    public static final int ZERO_3_AT = 82;
    public static final int LEN_DATA_FORK_AT = 83;
    public static final int LEN_RES_FORK_AT = 87;
    public static final int WHEN_CREATED_AT = 91;
    public static final int WHEN_MODIFIED_AT = 95;
    public static final int LEN_COMMENT_AT = 99;
    public static final int FINDER_FLAGS2_AT = 101;
    public static final int MB3_SIGNATURE_AT = 102;
    public static final int NAME_SCRIPT_AT = 106;
    public static final int FINDER_FLAGS3_AT = 107;
    public static final int LEN_SECONDARY_AT = 120;
    public static final int VERSION_TARGET_AT = 122;
    public static final int VERSION_MIN_AT = 123;
    public static final int CRC_AT = 124;
    public static final int VERSION_OBSOLETE_AT = 126;
    public static final int _AT = 0;
    public static final int MB1_VERSION = 128;
    public static final int MB2_VERSION = 129;
    public static final int MB3_VERSION = 130;
    public static final int MB3_SIGNATURE = 1833060686;
    protected static final int[] levelMasks = new int[]{0xFFFE7F, 64512, 64590, 64590};
    public static final int MACBINARY_HEADER_LEN = 128;
    public static final long LIMIT_DATAFORK = Integer.MAX_VALUE;
    public static final int LIMIT_RESFORK = 0xFFFFFF;
    public static final int LIMIT_NAME = 31;
    private byte[] myBytes;
    private static final byte[] noBytes = new byte[0];
    protected static boolean strict = false;
    private static String[] errorText = new String[]{"Zero-length name", "Invalid fork-lengths", "Non-zero byte at 74", "Non-zero bytes at 0 and/or 82"};
    private static final char[] crcTable = "\u0000\u1021\u2042\u3063\u4084\u50a5\u60c6\u70e7\u8108\u9129\ua14a\ub16b\uc18c\ud1ad\ue1ce\uf1ef\u1231\u0210\u3273\u2252\u52b5\u4294\u72f7\u62d6\u9339\u8318\ub37b\ua35a\ud3bd\uc39c\uf3ff\ue3de\u2462\u3443\u0420\u1401\u64e6\u74c7\u44a4\u5485\ua56a\ub54b\u8528\u9509\ue5ee\uf5cf\uc5ac\ud58d\u3653\u2672\u1611\u0630\u76d7\u66f6\u5695\u46b4\ub75b\ua77a\u9719\u8738\uf7df\ue7fe\ud79d\uc7bc\u48c4\u58e5\u6886\u78a7\u0840\u1861\u2802\u3823\uc9cc\ud9ed\ue98e\uf9af\u8948\u9969\ua90a\ub92b\u5af5\u4ad4\u7ab7\u6a96\u1a71\u0a50\u3a33\u2a12\udbfd\ucbdc\ufbbf\ueb9e\u9b79\u8b58\ubb3b\uab1a\u6ca6\u7c87\u4ce4\u5cc5\u2c22\u3c03\u0c60\u1c41\uedae\ufd8f\ucdec\uddcd\uad2a\ubd0b\u8d68\u9d49\u7e97\u6eb6\u5ed5\u4ef4\u3e13\u2e32\u1e51\u0e70\uff9f\uefbe\udfdd\ucffc\ubf1b\uaf3a\u9f59\u8f78\u9188\u81a9\ub1ca\ua1eb\ud10c\uc12d\uf14e\ue16f\u1080\u00a1\u30c2\u20e3\u5004\u4025\u7046\u6067\u83b9\u9398\ua3fb\ub3da\uc33d\ud31c\ue37f\uf35e\u02b1\u1290\u22f3\u32d2\u4235\u5214\u6277\u7256\ub5ea\ua5cb\u95a8\u8589\uf56e\ue54f\ud52c\uc50d\u34e2\u24c3\u14a0\u0481\u7466\u6447\u5424\u4405\ua7db\ub7fa\u8799\u97b8\ue75f\uf77e\uc71d\ud73c\u26d3\u36f2\u0691\u16b0\u6657\u7676\u4615\u5634\ud94c\uc96d\uf90e\ue92f\u99c8\u89e9\ub98a\ua9ab\u5844\u4865\u7806\u6827\u18c0\u08e1\u3882\u28a3\ucb7d\udb5c\ueb3f\ufb1e\u8bf9\u9bd8\uabbb\ubb9a\u4a75\u5a54\u6a37\u7a16\u0af1\u1ad0\u2ab3\u3a92\ufd2e\ued0f\udd6c\ucd4d\ubdaa\uad8b\u9de8\u8dc9\u7c26\u6c07\u5c64\u4c45\u3ca2\u2c83\u1ce0\u0cc1\uef1f\uff3e\ucf5d\udf7c\uaf9b\ubfba\u8fd9\u9ff8\u6e17\u7e36\u4e55\u5e74\u2e93\u3eb2\u0ed1\u1ef0".toCharArray();

    public ERXMacBinarySwissArmyKnife() {
    }

    public ERXMacBinarySwissArmyKnife(NSData fileData) {
        this();
        this.setByteArray(fileData.bytes(0, fileData.length()));
    }

    private static String formatExplained(int format) {
        if (format > 0) {
            return "MacBinary-" + format;
        }
        return errorText[-format];
    }

    public boolean isMacBinary(NSData fileData) {
        try {
            if (fileData.length() < 128) {
                return false;
            }
            int dataLength = 128;
            this.myBytes = fileData.bytes(0, dataLength);
            int fileFormat = this.checkFormat(strict);
            if (fileFormat <= 0) {
                return false;
            }
        }
        catch (Throwable why) {
            return false;
        }
        return true;
    }

    public NSData unwrapMacBinary(NSData fileContents) {
        int dataForkLength = this.getDataForkLength();
        return fileContents.subdataWithRange(new NSRange(128, dataForkLength));
    }

    public int checkFormat(boolean strictFormat) {
        int a = this.getUByteAt(0);
        int b = this.getUByteAt(82);
        if (a != 0 || b != 0) {
            return -3;
        }
        if (strictFormat && this.getUByteAt(74) != 0) {
            return -2;
        }
        a = this.getDataForkLength();
        b = this.getResourceForkLength();
        if (a < 0 || (long)a > Integer.MAX_VALUE || b < 0 || b > 0xFFFFFF) {
            return -1;
        }
        a = this.getUByteAt(1);
        if (a < 1 || a > 31) {
            return 0;
        }
        if (!this.isValidCRC() || this.getUByteAt(123) < 129) {
            return 1;
        }
        a = this.getIntAt(102);
        if (a != 1833060686) {
            return 2;
        }
        return 3;
    }

    public byte getByteAt(int offset) {
        return this.myBytes[offset];
    }

    public int getUByteAt(int offset) {
        return 0xFF & this.myBytes[offset];
    }

    public short getShortAt(int offset) {
        return (short)((this.myBytes[offset] << 8) + (0xFF & this.myBytes[offset + 1]));
    }

    public int getUShortAt(int offset) {
        return (0xFF00 & this.myBytes[offset] << 8) + (0xFF & this.myBytes[offset + 1]);
    }

    public int getIntAt(int offset) {
        int value = (0xFF & this.myBytes[offset]) << 24;
        value += (0xFF & this.myBytes[offset + 1]) << 16;
        return (value += (0xFF & this.myBytes[offset + 2]) << 8) + (0xFF & this.myBytes[offset + 3]);
    }

    public long getUIntAt(int offset) {
        long value = 0xFFFFFFFFL & (long)this.getIntAt(offset);
        return value;
    }

    public long getLongAt(int offset) {
        long value = this.getIntAt(offset);
        return (value << 32) + this.getUIntAt(offset + 4);
    }

    public void putByteAt(byte value, int offset) {
        this.myBytes[offset] = value;
    }

    public void putBytesAt(byte[] data, int offset) {
        System.arraycopy(data, 0, this.myBytes, offset, data.length);
    }

    public void putBytesAt(byte[] data, int offset, int count) {
        System.arraycopy(data, 0, this.myBytes, offset, count);
    }

    public void putShortAt(short value, int offset) {
        this.myBytes[offset] = (byte)(value >> 8);
        this.myBytes[offset + 1] = (byte)value;
    }

    public void putIntAt(int value, int offset) {
        this.myBytes[offset] = (byte)(value >> 24);
        this.myBytes[offset + 1] = (byte)(value >> 16);
        this.myBytes[offset + 2] = (byte)(value >> 8);
        this.myBytes[offset + 3] = (byte)value;
    }

    public void putLongAt(long value, int offset) {
        this.putIntAt((int)(value >> 32), offset);
        this.putIntAt((int)value, offset + 4);
    }

    public final byte[] getByteArray() {
        return this.myBytes;
    }

    public final void setByteArray(byte[] bytes) {
        this.myBytes = bytes;
    }

    public int getDataForkLength() {
        return this.getIntAt(83);
    }

    public int getResourceForkLength() {
        return this.getIntAt(87);
    }

    public static int calculateCRC(int seed, byte[] bytes, int offset, int count) {
        count += offset;
        while (offset < count) {
            seed ^= (0xFF & bytes[offset]) << 8;
            seed = seed << 8 ^ crcTable[0xFF & seed >> 8];
            ++offset;
        }
        return 0xFFFF & seed;
    }

    public void setCRC() {
        this.putShortAt((short)this.calcCRC(), 124);
    }

    public boolean isValidCRC() {
        return this.calcCRC() == this.getCRC();
    }

    public int calcCRC() {
        return ERXMacBinarySwissArmyKnife.calculateCRC(0, this.getByteArray(), 0, 124);
    }

    public int calcCRC2() {
        return ERXMacBinarySwissArmyKnife.calculateCRC(0, this.getByteArray(), 0, 126);
    }

    public int getCRC() {
        return this.getUShortAt(124);
    }
}

