/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOResourceManager;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSForwardException;
import er.extensions.components.ERXNonSynchronizingComponent;
import er.extensions.foundation.ERXFileUtilities;
import er.extensions.foundation.ERXSimpleTemplateParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ERXSLTWrapper
extends ERXNonSynchronizingComponent {
    private static final Logger log = Logger.getLogger(ERXSLTWrapper.class);
    private long start;
    private long current;
    private static Map cache = new HashMap();
    private static XMLReader xmlReader;
    private static TemplatePool pool;

    public ERXSLTWrapper(WOContext context) {
        super(context);
    }

    private boolean isEnabled() {
        return this.booleanValueForBinding("enabled", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transformer transformer() {
        try {
            Transformer transformer;
            Map map = cache;
            synchronized (map) {
                String stylesheet = (String)this.valueForBinding("stylesheet");
                String framework = (String)this.valueForBinding("framework");
                NSArray languages = this.session().languages();
                String key = stylesheet + "-" + framework;
                transformer = (Transformer)cache.get(key);
                if (transformer == null || this.booleanValueForBinding("nocache")) {
                    byte[] bytes = this.application().resourceManager().bytesForResourceNamed(stylesheet, framework, languages);
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setValidating(false);
                    documentBuilderFactory.setNamespaceAware(true);
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                    Document document = documentBuilder.parse(bis);
                    DOMSource xslt = new DOMSource(document);
                    xslt.setSystemId(key);
                    String transformerFactoryName = (String)this.valueForBinding("transformerFactory");
                    String oldTransformerFactoryName = System.getProperty("javax.xml.transform.TransformerFactory");
                    if (transformerFactoryName != null) {
                        System.setProperty("javax.xml.transform.TransformerFactory", transformerFactoryName);
                    } else {
                        System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
                    }
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    if (oldTransformerFactoryName != null) {
                        System.setProperty("javax.xml.transform.TransformerFactory", oldTransformerFactoryName);
                    }
                    transformer = transformerFactory.newTransformer(xslt);
                    cache.put(key, transformer);
                }
            }
            return transformer;
        }
        catch (Exception ex) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)ex);
        }
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        this.current = this.start = System.currentTimeMillis();
        if (this.isEnabled()) {
            WOResponse newResponse = new WOResponse();
            newResponse.setContentEncoding(response.contentEncoding());
            super.appendToResponse(newResponse, context);
            if (log.isDebugEnabled()) {
                String contentString = newResponse.contentString();
                log.debug((Object)("Converting content string:\n" + contentString));
            }
            try {
                NSData data = ERXSLTWrapper.transform(this.transformer(), newResponse.content());
                if (this.hasBinding("data") && this.canSetValueForBinding("data")) {
                    this.setValueForBinding(data, "data");
                }
                if (this.hasBinding("stream") && this.canSetValueForBinding("stream")) {
                    this.setValueForBinding(data.stream(), "stream");
                }
                response.appendContentData(data);
            }
            catch (TransformerException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
        } else {
            super.appendToResponse(response, context);
        }
        log.debug((Object)("Total: " + (System.currentTimeMillis() - this.start)));
        this.start = System.currentTimeMillis();
    }

    public static Transformer getTransformer(String framework, String filename) {
        return pool.getTransformer(framework, filename);
    }

    public static String transform(Transformer transformer, String xml) throws TransformerException {
        StringReader stringreader = new StringReader(xml);
        InputSource inputsource = new InputSource(stringreader);
        SAXSource s = new SAXSource(inputsource);
        StringWriter writer = new StringWriter();
        StreamResult r = new StreamResult(writer);
        transformer.transform(s, r);
        String result = writer.toString();
        return result;
    }

    public static NSData transform(Transformer transformer, NSData data) throws TransformerException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data.bytes());
        SAXSource saxSource = new SAXSource();
        saxSource.setXMLReader(xmlReader);
        saxSource.setInputSource(new InputSource(bis));
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        StreamResult r = new StreamResult(os);
        transformer.transform(saxSource, r);
        NSData result = new NSData(os.toByteArray());
        return result;
    }

    static {
        try {
            xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setFeature("http://xml.org/sax/features/validation", false);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        pool = new TemplatePool();
    }

    public static class TemplatePool {
        private final Map templates = new HashMap();
        private static final Logger log = Logger.getLogger(TemplatePool.class);
        private ERXSimpleTemplateParser templateParser = new ERXSimpleTemplateParser("?", false);

        private TemplatePool() {
        }

        public Map getTemplates() {
            return this.templates;
        }

        public synchronized Transformer getTransformer(String framework, String filename) {
            if (filename == null || filename.length() == 0) {
                throw new IllegalArgumentException("filename cannot be null or empty");
            }
            String key = framework + "-" + filename;
            Templates t = (Templates)pool.getTemplates().get(key);
            String s = null;
            if (t == null) {
                try {
                    WOApplication app = WOApplication.application();
                    WOResourceManager rm = app.resourceManager();
                    TransformerFactory fac = TransformerFactory.newInstance();
                    log.debug((Object)("creating template for file " + filename + " in framework " + framework));
                    InputStream is = rm.inputStreamForResourceNamed(filename, framework, null);
                    if (is == null) {
                        log.debug((Object)"trying with framework = null");
                        is = rm.inputStreamForResourceNamed(filename, null, null);
                        if (is == null) {
                            throw new IllegalArgumentException("inputStream is null");
                        }
                    }
                    if (is.available() == 0) {
                        throw new IllegalArgumentException("InputStream has 0 bytes available, cannot read xsl file!");
                    }
                    s = ERXFileUtilities.stringFromInputStream(is);
                    s = this.templateParser.parseTemplateWithObject(s, "@@", app);
                    t = fac.newTemplates(new StreamSource(new ByteArrayInputStream(s.getBytes())));
                    if (app.isCachingEnabled()) {
                        this.templates.put(key, t);
                    }
                }
                catch (IOException e1) {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)e1);
                }
                catch (TransformerConfigurationException tce) {
                    log.error((Object)("could not create template " + tce.getLocationAsString()), (Throwable)tce);
                    log.error((Object)"  cause", tce.getCause());
                    if (tce.getCause() != null && tce.getCause() instanceof SAXParseException) {
                        SAXParseException e = (SAXParseException)tce.getCause();
                        log.error((Object)("SAXParseException: line " + e.getLineNumber() + ", column " + e.getColumnNumber()));
                    }
                    log.error((Object)("this is the incorrect xsl:>>>" + s + "<<<"));
                    return null;
                }
            }
            try {
                return t.newTransformer();
            }
            catch (TransformerConfigurationException tce) {
                log.error((Object)("could not create template " + tce.getLocationAsString()), (Throwable)tce);
                log.error((Object)"  cause", tce.getCause());
                return null;
            }
        }
    }
}

