/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.concurrency;

import er.extensions.concurrency.ERXExecutionStateTransition;
import er.extensions.concurrency.ERXFutureTask;
import er.extensions.concurrency.ERXTaskThread;
import er.extensions.eof.ERXEC;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXTaskThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Logger log = Logger.getLogger(ERXTaskThreadPoolExecutor.class);

    public ERXTaskThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public ERXTaskThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public ERXTaskThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
    }

    public ERXTaskThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    @Override
    public Future<?> submit(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        ERXFutureTask<Object> ftask = new ERXFutureTask<Object>(task, null);
        this.execute(ftask);
        return ftask;
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        if (task == null) {
            throw new NullPointerException();
        }
        ERXFutureTask<T> ftask = new ERXFutureTask<T>(task, result);
        this.execute(ftask);
        return ftask;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        ERXFutureTask<T> ftask = new ERXFutureTask<T>(task);
        this.execute(ftask);
        return ftask;
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        if (t instanceof ERXTaskThread) {
            ((ERXTaskThread)t).setTask(r);
            ((ERXTaskThread)t).startStopWatch();
            if (log.isDebugEnabled()) {
                log.debug((Object)("About to execute " + (r == null ? "null" : r) + " in thread " + t));
            }
        }
        if (r instanceof ERXExecutionStateTransition) {
            ((ERXExecutionStateTransition)((Object)r)).beforeExecute();
        }
        super.beforeExecute(t, r);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (Thread.currentThread() instanceof ERXTaskThread) {
            ERXTaskThread thread = (ERXTaskThread)Thread.currentThread();
            thread.setTask(null);
            thread.stopStopWatch();
            String elapsedTime = thread.elapsedTime();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Finished executing " + (r == null ? "null" : r) + " after " + elapsedTime));
            }
        }
        if (r instanceof ERXExecutionStateTransition) {
            ((ERXExecutionStateTransition)((Object)r)).afterExecute();
        }
        ERXEC.unlockAllContextsForCurrentThread();
    }
}

