/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.crypting;

import com.webobjects.foundation.NSForwardException;
import er.extensions.crypting.ERXCrypterInterface;
import er.extensions.crypting.ERXCrypto;
import er.extensions.foundation.ERXStringUtilities;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import org.apache.log4j.Logger;

public abstract class ERXAbstractAESCrypter
implements ERXCrypterInterface {
    public static final Logger log = Logger.getLogger(ERXCrypto.class);
    private int _blockSize = 16;
    private ThreadLocalCipher _encryptCipher;
    private ThreadLocalCipher _decryptCipher;
    private Key _secretKey;

    public void setBlockSize(int blockSize) {
        this._blockSize = blockSize;
    }

    public int blockSize() {
        return this._blockSize;
    }

    protected abstract Key secretKey() throws Exception;

    private Key _secretKey() {
        if (this._secretKey == null) {
            try {
                this._secretKey = this.secretKey();
            }
            catch (Exception e) {
                throw new NSForwardException((Throwable)e);
            }
        }
        return this._secretKey;
    }

    protected Cipher createCipher(int mode) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            cipher.init(mode, this._secretKey());
            return cipher;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new NSForwardException((Throwable)ex, "Couldn't find the AES algorithm; perhaps you do not have the SunJCE security provider installed properly?");
        }
        catch (Exception e) {
            throw new NSForwardException((Throwable)e);
        }
    }

    protected Cipher encryptCipher() {
        if (this._encryptCipher == null) {
            this._encryptCipher = new ThreadLocalCipher(1);
        }
        return this._encryptCipher.get();
    }

    protected Cipher decryptCipher() {
        if (this._decryptCipher == null) {
            this._decryptCipher = new ThreadLocalCipher(2);
        }
        return this._decryptCipher.get();
    }

    public String decrypt(String cryptedText) {
        if (cryptedText == null) {
            return null;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] clearText = null;
        byte[] decodedBytes = null;
        try {
            decodedBytes = ERXCrypto.base64urlDecode(cryptedText);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
        int length = decodedBytes.length;
        for (int j = 0; j < length; j += this._blockSize) {
            byte[] encryptedBytes = new byte[this._blockSize];
            System.arraycopy(decodedBytes, j, encryptedBytes, 0, Math.min(length - j, this._blockSize));
            try {
                clearText = this.decryptCipher().doFinal(encryptedBytes);
            }
            catch (Exception e) {
                throw new NSForwardException((Throwable)e);
            }
            for (int k = 0; k < this._blockSize; ++k) {
                if (clearText[k] == 0) continue;
                result.write(clearText[k]);
            }
        }
        return ERXStringUtilities.fromUTF8Bytes(result.toByteArray());
    }

    public String encrypt(String clearText) {
        if (clearText == null) {
            return null;
        }
        byte[] clearTextBytes = ERXStringUtilities.toUTF8Bytes(clearText);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        int length = clearTextBytes.length;
        for (int pos = 0; pos < length; pos += this._blockSize) {
            byte[] bytesToEncrypt = new byte[this._blockSize];
            System.arraycopy(clearTextBytes, pos, bytesToEncrypt, 0, Math.min(length - pos, this._blockSize));
            try {
                byte[] encryptedBytes = this.encryptCipher().doFinal(bytesToEncrypt);
                result.write(encryptedBytes);
                continue;
            }
            catch (Exception e) {
                throw new NSForwardException((Throwable)e);
            }
        }
        return ERXCrypto.base64urlEncode(result.toByteArray());
    }

    class ThreadLocalCipher
    extends ThreadLocal {
        private final int _mode;

        public ThreadLocalCipher(int mode) {
            this._mode = mode;
        }

        protected Object initialValue() {
            return ERXAbstractAESCrypter.this.createCipher(this._mode);
        }

        public Cipher get() {
            return (Cipher)super.get();
        }
    }
}

