/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eoaccess.EOGeneralAdaptorException;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EOObjectStore;
import com.webobjects.eocontrol.EOSharedEditingContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation._NSDelegate;
import er.extensions.appserver.ERXApplication;
import er.extensions.eof.ERXDefaultEditingContextDelegate;
import er.extensions.eof.ERXECNoValidationDelegate;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.eof.ERXEnterpriseObject;
import er.extensions.eof.ERXFetchSpecification;
import er.extensions.eof.ERXGenericRecord;
import er.extensions.eof.ERXObjectStoreCoordinator;
import er.extensions.eof.ERXTolerantSaver;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXSelectorUtilities;
import er.extensions.foundation.ERXSignalHandler;
import er.extensions.foundation.ERXUtilities;
import er.extensions.foundation.ERXValueUtilities;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;
import sun.misc.Signal;
import sun.misc.SignalHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXEC
extends EOEditingContext {
    public static final Logger log = Logger.getLogger(ERXEC.class);
    public static final Logger lockLogger = Logger.getLogger((String)"er.extensions.ERXEC.LockLogger");
    public static final Logger lockTrace = Logger.getLogger((String)"er.extensions.ERXEC.LockTrace");
    public static final String EditingContextDidCreateNotification = "EOEditingContextDidCreate";
    public static final String EditingContextWillSaveChangesNotification = "EOEditingContextWillSaveChanges";
    public static final String EditingContextDidRevertChanges = "EOEditingContextDidRevertChanges";
    public static final String EditingContextFailedToSaveChanges = "EOEditingContextFailedToSaveChanges";
    private Exception creationTrace;
    NSMutableDictionary<Thread, NSMutableArray<Exception>> openLockTraces = new NSMutableDictionary();
    Thread lockingThread;
    String lockingThreadName;
    private Boolean useAutolock;
    private Boolean coalesceAutoLocks;
    private int autoLocked;
    private boolean isFinalizing;
    private static Boolean useUnlocker;
    private static Boolean traceOpenLocks;
    private static Boolean markOpenLocks;
    private static final String LockedContextsForCurrentThreadKey = "ERXEC.lockedContextsForCurrentThread";
    private static final NSSelector EditingContextWillRevertObjectsDelegateSelector;
    private static final NSSelector EditingContextDidRevertObjectsDelegateSelector;
    private static final NSSelector EditingContextDidFailSaveChangesDelegateSelector;
    private static ThreadLocal<List> locks;
    private static Exception defaultTrace;
    private ThreadLocal<Integer> lockAttempts = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    public static boolean _shouldLockOnLockObjectStore;
    private boolean _recoversFromException;
    private boolean _doesRetry;
    private boolean _mergesChanges;
    private boolean savingChanges;
    private NSMutableArray queuedNotifications = new NSMutableArray();
    protected static Map<ERXEC, String> activeEditingContexts;
    private _NSDelegate _denyDelegate;
    protected static Factory factory;

    public static boolean safeLocking() {
        return ERXProperties.booleanForKeyWithDefault("er.extensions.ERXEC.safeLocking", false);
    }

    public static boolean defaultAutomaticLockUnlock() {
        return ERXProperties.booleanForKey("er.extensions.ERXEC.defaultAutomaticLockUnlock") || ERXEC.safeLocking();
    }

    public static boolean defaultCoalesceAutoLocks() {
        return ERXProperties.booleanForKey("er.extensions.ERXEC.defaultCoalesceAutoLocks") || ERXEC.safeLocking();
    }

    public static boolean useUnlocker() {
        if (useUnlocker == null) {
            useUnlocker = ERXProperties.booleanForKey("er.extensions.ERXEC.useUnlocker") || ERXEC.safeLocking();
            log.debug((Object)("setting useUnlocker to " + useUnlocker));
        }
        return useUnlocker;
    }

    public static void setUseUnlocker(boolean value) {
        useUnlocker = value;
    }

    public static boolean traceOpenLocks() {
        if (traceOpenLocks == null) {
            traceOpenLocks = ERXProperties.booleanForKeyWithDefault("er.extensions.ERXEC.traceOpenLocks", false);
            log.debug((Object)("setting traceOpenLocks to " + traceOpenLocks));
        }
        return traceOpenLocks;
    }

    public static boolean markOpenLocks() {
        if (markOpenLocks == null) {
            markOpenLocks = ERXProperties.booleanForKeyWithDefault("er.extensions.ERXEC.markOpenLocks", false);
            log.debug((Object)("setting markOpenLocks to " + markOpenLocks));
        }
        return markOpenLocks != false || ERXEC.traceOpenLocks();
    }

    public static void setTraceOpenLocks(boolean value) {
        traceOpenLocks = value;
    }

    public static void setMarkOpenLocks(boolean value) {
        markOpenLocks = value;
    }

    public static void pushLockedContextForCurrentThread(EOEditingContext ec) {
        if (ERXEC.useUnlocker() && ec != null) {
            List ecs = locks.get();
            ecs.add(ec);
            if (log.isDebugEnabled()) {
                log.debug((Object)("After pushing: " + ecs));
            }
        }
    }

    public static void popLockedContextForCurrentThread(EOEditingContext ec) {
        if (ERXEC.useUnlocker() && ec != null) {
            List ecs = locks.get();
            if (ecs != null) {
                int index = ecs.lastIndexOf(ec);
                if (index >= 0) {
                    ecs.remove(index);
                } else {
                    log.error((Object)("Should pop, but ec not found in Vector! " + Thread.currentThread().getName() + ", ec: " + ec + ", ecs:" + ecs));
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("After popping: " + ecs));
            }
        }
    }

    public static void unlockAllContextsForCurrentThread() {
        List ecs = locks.get();
        if (ERXEC.useUnlocker() && ecs != null && ecs.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unlock remaining: " + ecs));
            }
            for (int i = ecs.size() - 1; i >= 0; --i) {
                boolean openAutoLocks;
                EOEditingContext ec = (EOEditingContext)ecs.get(i);
                boolean bl = openAutoLocks = ec instanceof ERXEC && ((ERXEC)ec).isAutoLocked();
                if (openAutoLocks) {
                    log.debug((Object)("Unlocking autolocked editing context: " + ec));
                    --((ERXEC)ec).autoLocked;
                } else {
                    log.warn((Object)("Unlocking context that wasn't unlocked in RR-Loop!: " + ec));
                }
                try {
                    ec.unlock();
                    continue;
                }
                catch (IllegalStateException ex) {
                    log.error((Object)("Could not unlock EC: " + ec), (Throwable)ex);
                }
            }
        }
    }

    public ERXEC() {
        this(ERXEC.defaultParentObjectStore());
    }

    public ERXEC(EOObjectStore os) {
        super(os);
        super._initWithParentObjectStore(os);
        ERXEnterpriseObject.Observer.install();
        if (ERXEC.markOpenLocks()) {
            this.creationTrace = new Exception("Creation");
            this.creationTrace.fillInStackTrace();
            activeEditingContexts.put(this, Thread.currentThread().getName());
        }
    }

    protected void _initWithParentObjectStore(EOObjectStore parent) {
    }

    public void deleteObjects(NSArray objects) {
        int i = objects.count();
        while (i-- > 0) {
            EOEnterpriseObject eo;
            Object o = objects.objectAtIndex(i);
            if (!(o instanceof EOEnterpriseObject) || (eo = (EOEnterpriseObject)o).editingContext() == null) continue;
            eo.editingContext().deleteObject(eo);
        }
    }

    public boolean useAutoLock() {
        if (this.useAutolock == null) {
            this.useAutolock = ERXEC.defaultAutomaticLockUnlock();
        }
        return this.useAutolock;
    }

    public void setUseAutoLock(boolean value) {
        this.useAutolock = value;
    }

    public boolean coalesceAutoLocks() {
        if (this.coalesceAutoLocks == null) {
            this.coalesceAutoLocks = ERXEC.defaultCoalesceAutoLocks();
            if (this.coalesceAutoLocks.booleanValue() && !ERXEC.useUnlocker()) {
                throw new IllegalStateException("You must enable the EC unlocker if you want to coalesce autolocks.");
            }
        }
        return this.coalesceAutoLocks != false && ERXApplication.isInRequest();
    }

    public void setCoalesceAutoLocks(boolean value) {
        this.coalesceAutoLocks = value;
    }

    public Exception creationTrace() {
        return this.creationTrace;
    }

    public NSDictionary<Thread, NSMutableArray<Exception>> openLockTraces() {
        return this.openLockTraces;
    }

    public void lock() {
        if (ERXEC.markOpenLocks()) {
            this.traceLock();
        }
        this.lockAttempts.set(this.lockAttempts.get() + 1);
        super.lock();
        ERXEC.pushLockedContextForCurrentThread(this);
        if (ERXEC.markOpenLocks()) {
            this.lockingThread = Thread.currentThread();
            this.lockingThreadName = this.lockingThread.getName();
        }
        if (!this.isAutoLocked() && lockLogger.isDebugEnabled()) {
            if (lockTrace.isDebugEnabled()) {
                lockLogger.debug((Object)("locked " + (Object)((Object)this)), (Throwable)new Exception());
            } else {
                lockLogger.debug((Object)("locked " + (Object)((Object)this)));
            }
        }
    }

    private synchronized void traceLock() {
        Thread currentThread;
        NSMutableArray<Exception> currentTraces;
        if (this.openLockTraces == null) {
            this.openLockTraces = new NSMutableDictionary();
        }
        Exception openLockTrace = defaultTrace;
        if (ERXEC.traceOpenLocks()) {
            openLockTrace = new Exception("Locked");
        }
        if ((currentTraces = (NSMutableArray<Exception>)this.openLockTraces.objectForKey(currentThread = Thread.currentThread())) == null) {
            currentTraces = new NSMutableArray<Exception>();
            this.openLockTraces.setObjectForKey(currentTraces, currentThread);
        }
        currentTraces.addObject(openLockTrace);
        if (!currentThread.equals(this.lockingThread)) {
            // empty if block
        }
    }

    private synchronized void traceUnlock() {
        if (this.openLockTraces != null) {
            NSMutableArray traces = (NSMutableArray)this.openLockTraces.objectForKey(this.lockingThread);
            if (traces != null) {
                traces.removeLastObject();
                if (traces.count() == 0) {
                    this.openLockTraces.removeObjectForKey(this.lockingThread);
                }
            } else {
                log.error((Object)("Missing lock: " + this.lockingThread));
            }
            if (this.openLockTraces.count() == 0) {
                this.openLockTraces = null;
            }
        }
        if (!this.isLockedInThread()) {
            this.lockingThread = null;
            this.lockingThreadName = null;
        }
    }

    public void unlock() {
        ERXEC.popLockedContextForCurrentThread(this);
        if (ERXEC.markOpenLocks()) {
            this.traceUnlock();
        }
        if (!this.isAutoLocked() && lockLogger.isDebugEnabled()) {
            if (lockTrace.isDebugEnabled()) {
                lockLogger.debug((Object)("unlocked " + (Object)((Object)this)), (Throwable)new Exception());
            } else {
                lockLogger.debug((Object)("unlocked " + (Object)((Object)this)));
            }
        }
        super.unlock();
        this.lockAttempts.set(this.lockAttempts.get() - 1);
    }

    private boolean isLockedInThread() {
        return locks.get().contains((Object)this);
    }

    protected boolean autoLock(String method) {
        if (!this.useAutoLock() || this.isFinalizing || this.isLockedInThread() || this.lockAttempts.get() > 0) {
            return false;
        }
        boolean wasAutoLocked = false;
        if (!this.isAutoLocked() || !this.coalesceAutoLocks()) {
            wasAutoLocked = true;
            this.lock();
            ++this.autoLocked;
            if (!this.isFinalizing && lockTrace.isDebugEnabled()) {
                lockTrace.debug((Object)("called method " + method + " without a lock, ec=" + (Object)((Object)this)), (Throwable)new Exception());
            }
        }
        return wasAutoLocked;
    }

    protected void autoUnlock(boolean wasAutoLocked) {
        if (wasAutoLocked && !this.coalesceAutoLocks()) {
            --this.autoLocked;
            this.unlock();
        }
    }

    public boolean isAutoLocked() {
        return this.autoLocked > 0;
    }

    protected void _checkOpenLockTraces() {
        NSMutableDictionary<Thread, NSMutableArray<Exception>> traces = this.openLockTraces;
        if (traces != null && traces.count() != 0) {
            String instance = ((Object)((Object)this)).getClass().getSimpleName() + "@" + System.identityHashCode((Object)this);
            log.error((Object)(instance + " Disposed with " + traces.count() + " locks (finalizing = " + this.isFinalizing + ")"));
            for (NSMutableArray<Exception> actual : traces.values()) {
                for (Exception existingOpenLockTrace : actual) {
                    log.error((Object)(instance + " Existing lock: "), (Throwable)existingOpenLockTrace);
                }
            }
            log.error((Object)(instance + " Created: "), (Throwable)this.creationTrace);
        }
    }

    public void dispose() {
        if (ERXEC.markOpenLocks()) {
            this._checkOpenLockTraces();
        }
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void finalize() throws Throwable {
        this.isFinalizing = true;
        try {
            block4: {
                try {
                    if (!ERXEC.markOpenLocks()) break block4;
                    this._checkOpenLockTraces();
                }
                catch (Throwable ex) {
                    log.error((Object)("Error finalizing: " + ex), ex);
                    Object var3_2 = null;
                    super.finalize();
                    return;
                }
            }
            Object var3_1 = null;
            super.finalize();
            return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            super.finalize();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockObjectStore() {
        if (!_shouldLockOnLockObjectStore || this.parentObjectStore() instanceof EOEditingContext) {
            super.lockObjectStore();
        } else {
            boolean wasAutoLocked = this.autoLock("lockObjectStore");
            try {
                super.lockObjectStore();
                Object var3_2 = null;
                this.autoUnlock(wasAutoLocked);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.autoUnlock(wasAutoLocked);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockObjectStore() {
        if (!_shouldLockOnLockObjectStore || this.parentObjectStore() instanceof EOEditingContext) {
            super.unlockObjectStore();
        } else {
            boolean wasAutoLocked = this.autoLock("unlockObjectStore");
            try {
                super.unlockObjectStore();
                Object var3_2 = null;
                this.autoUnlock(wasAutoLocked);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.autoUnlock(wasAutoLocked);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        boolean wasAutoLocked = this.autoLock("reset");
        try {
            super.reset();
            Object var3_2 = null;
            this.autoUnlock(wasAutoLocked);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordObject(EOEnterpriseObject eoenterpriseobject, EOGlobalID eoglobalid) {
        boolean wasAutoLocked = this.autoLock("recordObject");
        try {
            super.recordObject(eoenterpriseobject, eoglobalid);
            Object var5_4 = null;
            this.autoUnlock(wasAutoLocked);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forgetObject(EOEnterpriseObject eoenterpriseobject) {
        boolean wasAutoLocked = this.autoLock("forgetObject");
        try {
            super.forgetObject(eoenterpriseobject);
            Object var4_3 = null;
            this.autoUnlock(wasAutoLocked);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRecentChanges() {
        boolean wasAutoLocked = this.autoLock("processRecentChanges");
        try {
            super.processRecentChanges();
            Object var3_2 = null;
            this.autoUnlock(wasAutoLocked);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSArray updatedObjects() {
        boolean wasAutoLocked = this.autoLock("updatedObjects");
        try {
            NSArray nSArray = super.updatedObjects();
            Object var4_3 = null;
            this.autoUnlock(wasAutoLocked);
            return nSArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSArray registeredObjects() {
        boolean wasAutoLocked = this.autoLock("registeredObjects");
        try {
            NSArray nSArray = super.registeredObjects();
            Object var4_3 = null;
            this.autoUnlock(wasAutoLocked);
            return nSArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSArray insertedObjects() {
        boolean wasAutoLocked = this.autoLock("insertedObjects");
        try {
            NSArray nSArray = super.insertedObjects();
            Object var4_3 = null;
            this.autoUnlock(wasAutoLocked);
            return nSArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSArray deletedObjects() {
        boolean wasAutoLocked = this.autoLock("deletedObjects");
        try {
            NSArray nSArray = super.deletedObjects();
            Object var4_3 = null;
            this.autoUnlock(wasAutoLocked);
            return nSArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSharedEditingContext(EOSharedEditingContext eosharededitingcontext) {
        boolean wasAutoLocked = this.autoLock("setSharedEditingContext");
        try {
            super.setSharedEditingContext(eosharededitingcontext);
            Object var4_3 = null;
            this.autoUnlock(wasAutoLocked);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EOEnterpriseObject objectForGlobalID(EOGlobalID eoglobalid) {
        boolean wasAutoLocked = this.autoLock("objectForGlobalID");
        try {
            EOEnterpriseObject eOEnterpriseObject = super.objectForGlobalID(eoglobalid);
            Object var5_4 = null;
            this.autoUnlock(wasAutoLocked);
            return eOEnterpriseObject;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EOGlobalID globalIDForObject(EOEnterpriseObject eoenterpriseobject) {
        boolean wasAutoLocked = this.autoLock("globalIDForObject");
        try {
            EOGlobalID eOGlobalID = super.globalIDForObject(eoenterpriseobject);
            Object var5_4 = null;
            this.autoUnlock(wasAutoLocked);
            return eOGlobalID;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSDictionary committedSnapshotForObject(EOEnterpriseObject eoenterpriseobject) {
        boolean wasAutoLocked = this.autoLock("committedSnapshotForObject");
        try {
            NSDictionary nSDictionary = super.committedSnapshotForObject(eoenterpriseobject);
            Object var5_4 = null;
            this.autoUnlock(wasAutoLocked);
            return nSDictionary;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSDictionary currentEventSnapshotForObject(EOEnterpriseObject eoenterpriseobject) {
        boolean wasAutoLocked = this.autoLock("currentEventSnapshotForObject");
        try {
            NSDictionary nSDictionary = super.currentEventSnapshotForObject(eoenterpriseobject);
            Object var5_4 = null;
            this.autoUnlock(wasAutoLocked);
            return nSDictionary;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void objectWillChange(Object obj) {
        boolean wasAutoLocked = this.autoLock("objectWillChange");
        try {
            super.objectWillChange(obj);
            Object var4_3 = null;
            this.autoUnlock(wasAutoLocked);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertObjectWithGlobalID(EOEnterpriseObject eoenterpriseobject, EOGlobalID eoglobalid) {
        boolean wasAutoLocked = this.autoLock("insertObjectWithGlobalID");
        try {
            super.insertObjectWithGlobalID(eoenterpriseobject, eoglobalid);
            Object var5_4 = null;
            this.autoUnlock(wasAutoLocked);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertObject(EOEnterpriseObject eoenterpriseobject) {
        boolean wasAutoLocked = this.autoLock("insertObject");
        try {
            super.insertObject(eoenterpriseobject);
            Object var4_3 = null;
            this.autoUnlock(wasAutoLocked);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObject(EOEnterpriseObject eo) {
        boolean wasAutoLocked = this.autoLock("deleteObject");
        try {
            if (eo instanceof ERXEnterpriseObject) {
                ERXEnterpriseObject erxeo = (ERXEnterpriseObject)eo;
                erxeo.mightDelete();
            }
            super.deleteObject(eo);
            Object var5_4 = null;
            this.autoUnlock(wasAutoLocked);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChanges() {
        boolean wasAutoLocked = this.autoLock("hasChanges");
        try {
            boolean bl = super.hasChanges();
            Object var4_3 = null;
            this.autoUnlock(wasAutoLocked);
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    protected void willSaveChanges(NSArray insertedObjects, NSArray updatedObjects, NSArray deletedObjects) {
    }

    protected void didSaveChanges(NSArray insertedObjects, NSArray updatedObjects, NSArray deletedObjects) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveChanges() {
        boolean wasAutoLocked = this.autoLock("saveChanges");
        this._EOAssertSafeMultiThreadedAccess("saveChanges()");
        this.savingChanges = true;
        try {
            try {
                NSArray insertedObjects = this.insertedObjects().immutableClone();
                NSArray updatedObjects = this.updatedObjects().immutableClone();
                NSArray deletedObjects = this.deletedObjects().immutableClone();
                this.willSaveChanges(insertedObjects, updatedObjects, deletedObjects);
                NSNotificationCenter.defaultCenter().postNotification(EditingContextWillSaveChangesNotification, (Object)this);
                this._saveChanges();
                this.didSaveChanges(insertedObjects, updatedObjects, deletedObjects);
            }
            catch (EOGeneralAdaptorException e) {
                boolean delegateImplementsDidSaveFailed;
                NSNotificationCenter.defaultCenter().postNotification(EditingContextFailedToSaveChanges, (Object)this);
                Object delegate = this.delegate();
                boolean bl = delegateImplementsDidSaveFailed = delegate != null && EditingContextDidFailSaveChangesDelegateSelector.implementedByObject(delegate);
                if (delegateImplementsDidSaveFailed) {
                    Object[] parameters = new Object[]{this, e};
                    RuntimeException ex = (RuntimeException)ERXSelectorUtilities.invoke(EditingContextDidFailSaveChangesDelegateSelector, delegate, parameters);
                    if (ex != null) {
                        throw ex;
                    }
                } else {
                    throw e;
                }
                Object var8_9 = null;
                this.autoUnlock(wasAutoLocked);
                this.savingChanges = false;
            }
            Object var8_8 = null;
            this.autoUnlock(wasAutoLocked);
            this.savingChanges = false;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.autoUnlock(wasAutoLocked);
            this.savingChanges = false;
            throw throwable;
        }
        this.processQueuedNotifications();
    }

    public void saveChangesTolerantly(boolean doesRetry, boolean mergesChanges) {
        this._EOAssertSafeMultiThreadedAccess("saveChangesTolerantly()");
        boolean recover = this._recoversFromException;
        boolean retry = this._doesRetry;
        boolean merge = this._mergesChanges;
        this.setOptions(true, doesRetry, mergesChanges);
        this.saveChanges();
        this.setOptions(recover, retry, merge);
    }

    public void saveChangesTolerantly() {
        this.saveChangesTolerantly(true);
    }

    public void saveChangesTolerantly(boolean doesRetry) {
        this.saveChangesTolerantly(doesRetry, true);
    }

    public void setOptions(boolean recoversFromException, boolean doesRetry, boolean mergesChanges) {
        this._EOAssertSafeMultiThreadedAccess("setOptions()");
        this._recoversFromException = recoversFromException;
        this._doesRetry = doesRetry;
        this._mergesChanges = mergesChanges;
    }

    protected void _saveChanges() {
        block6: {
            boolean saved = true;
            try {
                super.saveChanges();
            }
            catch (EOGeneralAdaptorException e) {
                saved = false;
                if (this._recoversFromException) {
                    log.warn((Object)("_saveChangesTolerantly: Exception occurred: " + (Object)((Object)e)), (Throwable)e);
                    if (ERXEOAccessUtilities.isOptimisticLockingFailure(e)) {
                        EOEnterpriseObject eo = ERXEOAccessUtilities.refetchFailedObject(this, e);
                        if (this._mergesChanges) {
                            ERXEOAccessUtilities.reapplyChanges(eo, e);
                        }
                        if (this._doesRetry) {
                            this._saveChanges();
                            saved = true;
                        }
                    }
                }
                if (saved) break block6;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EOEnterpriseObject faultForGlobalID(EOGlobalID eoglobalid, EOEditingContext eoeditingcontext) {
        boolean wasAutoLocked = this.autoLock("faultForGlobalID");
        try {
            EOEnterpriseObject eOEnterpriseObject = super.faultForGlobalID(eoglobalid, eoeditingcontext);
            Object var6_5 = null;
            this.autoUnlock(wasAutoLocked);
            return eOEnterpriseObject;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSArray arrayFaultWithSourceGlobalID(EOGlobalID eoglobalid, String s, EOEditingContext eoeditingcontext) {
        boolean wasAutoLocked = this.autoLock("arrayFaultWithSourceGlobalID");
        try {
            NSArray nSArray = super.arrayFaultWithSourceGlobalID(eoglobalid, s, eoeditingcontext);
            Object var7_6 = null;
            this.autoUnlock(wasAutoLocked);
            return nSArray;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeObject(EOEnterpriseObject eoenterpriseobject, EOGlobalID eoglobalid, EOEditingContext eoeditingcontext) {
        boolean wasAutoLocked = this.autoLock("initializeObject");
        try {
            block5: {
                if (eoenterpriseobject instanceof ERXGenericRecord) {
                    ERXGenericRecord eo = (ERXGenericRecord)eoenterpriseobject;
                    boolean old = eo._setUpdateInverseRelationships(false);
                    try {
                        super.initializeObject(eoenterpriseobject, eoglobalid, eoeditingcontext);
                        Object var8_7 = null;
                        eo._setUpdateInverseRelationships(old);
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        eo._setUpdateInverseRelationships(old);
                        throw throwable;
                    }
                    {
                        break block5;
                    }
                }
                super.initializeObject(eoenterpriseobject, eoglobalid, eoeditingcontext);
            }
            Object var10_10 = null;
            this.autoUnlock(wasAutoLocked);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editingContextDidForgetObjectWithGlobalID(EOEditingContext eoeditingcontext, EOGlobalID eoglobalid) {
        boolean wasAutoLocked = this.autoLock("editingContextDidForgetObjectWithGlobalID");
        try {
            super.editingContextDidForgetObjectWithGlobalID(eoeditingcontext, eoglobalid);
            Object var5_4 = null;
            this.autoUnlock(wasAutoLocked);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSArray objectsForSourceGlobalID(EOGlobalID eoglobalid, String s, EOEditingContext eoeditingcontext) {
        boolean wasAutoLocked = this.autoLock("objectsForSourceGlobalID");
        try {
            NSArray nSArray = super.objectsForSourceGlobalID(eoglobalid, s, eoeditingcontext);
            Object var7_6 = null;
            this.autoUnlock(wasAutoLocked);
            return nSArray;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refaultObject(EOEnterpriseObject eoenterpriseobject) {
        boolean wasAutoLocked = this.autoLock("refaultObject");
        try {
            super.refaultObject(eoenterpriseobject);
            Object var4_3 = null;
            this.autoUnlock(wasAutoLocked);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refaultObject(EOEnterpriseObject eoenterpriseobject, EOGlobalID eoglobalid, EOEditingContext eoeditingcontext) {
        boolean wasAutoLocked = this.autoLock("refaultObject");
        try {
            ERXEnterpriseObject.FlushCachesProcessor.perform((EOEditingContext)this, eoenterpriseobject);
            super.refaultObject(eoenterpriseobject, eoglobalid, eoeditingcontext);
            Object var6_5 = null;
            this.autoUnlock(wasAutoLocked);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSArray objectsWithFetchSpecification(EOFetchSpecification fs, EOEditingContext eoeditingcontext) {
        boolean wasAutoLocked = this.autoLock("objectsWithFetchSpecification");
        try {
            NSArray objects = super.objectsWithFetchSpecification(fs, eoeditingcontext);
            if (fs instanceof ERXFetchSpecification && ((ERXFetchSpecification)fs).includeEditingContextChanges()) {
                objects = ERXEOControlUtilities.filteredObjectsWithQualifier(this, objects, fs.entityName(), fs.qualifier(), fs.sortOrderings(), fs.usesDistinct(), fs.isDeep(), true, true, true, true);
            }
            NSArray nSArray = objects;
            Object var7_6 = null;
            this.autoUnlock(wasAutoLocked);
            return nSArray;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveChangesInEditingContext(EOEditingContext eoeditingcontext) {
        boolean wasAutoLocked = this.autoLock("saveChangesInEditingContext");
        try {
            super.saveChangesInEditingContext(eoeditingcontext);
            NSArray childInsertedObjects = eoeditingcontext.insertedObjects();
            for (EOEnterpriseObject childInsertedObject : childInsertedObjects) {
                EOEnterpriseObject parentInsertedObject = this.objectForGlobalID(eoeditingcontext.globalIDForObject(childInsertedObject));
                if (!(parentInsertedObject instanceof ERXGenericRecord) || !(childInsertedObject instanceof ERXGenericRecord)) continue;
                ((ERXGenericRecord)parentInsertedObject).didCopyFromChildInEditingContext((ERXGenericRecord)childInsertedObject, eoeditingcontext);
            }
            Object var8_7 = null;
            this.autoUnlock(wasAutoLocked);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refaultAllObjects() {
        boolean wasAutoLocked = this.autoLock("refaultAllObjects");
        try {
            super.refaultAllObjects();
            Object var3_2 = null;
            this.autoUnlock(wasAutoLocked);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateObjectsWithGlobalIDs(NSArray nsarray) {
        boolean wasAutoLocked = this.autoLock("invalidateObjectsWithGlobalIDs");
        try {
            super.invalidateObjectsWithGlobalIDs(nsarray);
            Object var4_3 = null;
            this.autoUnlock(wasAutoLocked);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAllObjects() {
        boolean wasAutoLocked = this.autoLock("invalidateAllObjects");
        try {
            super.invalidateAllObjects();
            Object var3_2 = null;
            this.autoUnlock(wasAutoLocked);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockObject(EOEnterpriseObject eoenterpriseobject) {
        boolean wasAutoLocked = this.autoLock("lockObject");
        try {
            super.lockObject(eoenterpriseobject);
            Object var4_3 = null;
            this.autoUnlock(wasAutoLocked);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revert() {
        boolean wasAutoLocked = this.autoLock("revert");
        try {
            Object[] parameters;
            Object[] objectArray;
            boolean needToCallDelegate;
            NSArray insertedObjects = this.insertedObjects().immutableClone();
            NSArray updatedObjects = this.updatedObjects().immutableClone();
            NSArray deletedObjects = this.deletedObjects().immutableClone();
            ERXEnterpriseObject.WillRevertProcessor.perform((EOEditingContext)this, insertedObjects);
            ERXEnterpriseObject.WillRevertProcessor.perform((EOEditingContext)this, updatedObjects);
            ERXEnterpriseObject.WillRevertProcessor.perform((EOEditingContext)this, deletedObjects);
            Object delegate = this.delegate();
            boolean delegateImplementsWillRevert = delegate != null && EditingContextWillRevertObjectsDelegateSelector.implementedByObject(delegate);
            boolean delegateImplementsDidRevert = delegate != null && EditingContextDidRevertObjectsDelegateSelector.implementedByObject(delegate);
            boolean bl = needToCallDelegate = delegateImplementsWillRevert || delegateImplementsDidRevert;
            if (needToCallDelegate) {
                Object[] objectArray2 = new Object[4];
                objectArray2[0] = this;
                objectArray2[1] = insertedObjects;
                objectArray2[2] = updatedObjects;
                objectArray = objectArray2;
                objectArray2[3] = deletedObjects;
            } else {
                objectArray = parameters = null;
            }
            if (delegateImplementsWillRevert) {
                ERXSelectorUtilities.invoke(EditingContextWillRevertObjectsDelegateSelector, delegate, parameters);
            }
            super.revert();
            if (delegateImplementsDidRevert) {
                ERXSelectorUtilities.invoke(EditingContextDidRevertObjectsDelegateSelector, delegate, parameters);
            }
            ERXEnterpriseObject.DidRevertProcessor.perform((EOEditingContext)this, insertedObjects);
            ERXEnterpriseObject.DidRevertProcessor.perform((EOEditingContext)this, updatedObjects);
            ERXEnterpriseObject.DidRevertProcessor.perform((EOEditingContext)this, deletedObjects);
            NSNotificationCenter.defaultCenter().postNotification(EditingContextDidRevertChanges, (Object)this);
            Object var11_10 = null;
            this.autoUnlock(wasAutoLocked);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveChanges(Object obj) {
        boolean wasAutoLocked = this.autoLock("saveChanges");
        try {
            this.saveChanges();
            Object var4_3 = null;
            this.autoUnlock(wasAutoLocked);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshObject(EOEnterpriseObject eoenterpriseobject) {
        boolean wasAutoLocked = this.autoLock("refreshObject");
        try {
            super.refreshObject(eoenterpriseobject);
            Object var4_3 = null;
            this.autoUnlock(wasAutoLocked);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() {
        boolean wasAutoLocked = this.autoLock("undo");
        try {
            super.undo();
            Object var3_2 = null;
            this.autoUnlock(wasAutoLocked);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() {
        boolean wasAutoLocked = this.autoLock("redo");
        try {
            super.redo();
            Object var3_2 = null;
            this.autoUnlock(wasAutoLocked);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeRemoteMethod(EOEditingContext eoeditingcontext, EOGlobalID eoglobalid, String s, Class[] aclass, Object[] aobj) {
        boolean wasAutoLocked = this.autoLock("invokeRemoteMethod");
        try {
            Object object = super.invokeRemoteMethod(eoeditingcontext, eoglobalid, s, aclass, aobj);
            Object var9_8 = null;
            this.autoUnlock(wasAutoLocked);
            return object;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.autoUnlock(wasAutoLocked);
            throw throwable;
        }
    }

    public void _objectsChangedInStore(NSNotification nsnotification) {
        ERXEnterpriseObject.FlushCachesProcessor.perform((EOEditingContext)this, (NSArray)nsnotification.userInfo().objectForKey("objects"));
        if (this.savingChanges) {
            this.queuedNotifications.addObject(nsnotification);
        } else {
            super._objectsChangedInStore(nsnotification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _processObjectStoreChanges(NSDictionary info) {
        if (ERXProperties.booleanForKey("er.extensions.ERXEC.denyMerges")) {
            Object original = this.delegate();
            try {
                if (this._denyDelegate == null) {
                    this._denyDelegate = new _NSDelegate(_DenyMergeDelegate.class, (Object)new _DenyMergeDelegate(original));
                }
                this.setDelegate(this._denyDelegate);
                super._processObjectStoreChanges(info);
                Object var4_3 = null;
                this.setDelegate(original);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.setDelegate(original);
                throw throwable;
            }
        } else {
            super._processObjectStoreChanges(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueuedNotifications() {
        NSMutableArray nSMutableArray = this.queuedNotifications;
        synchronized (nSMutableArray) {
            Enumeration e = this.queuedNotifications.objectEnumerator();
            while (e.hasMoreElements()) {
                NSNotification n = (NSNotification)e.nextElement();
                this._objectsChangedInStore(n);
            }
            this.queuedNotifications.removeAllObjects();
        }
    }

    public void setDelegate(Object d) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setting delegate to " + d));
            log.debug((Object)ERXUtilities.stackTrace());
        }
        super.setDelegate(d);
    }

    public static Factory factory() {
        if (factory == null) {
            factory = new DefaultFactory();
        }
        return factory;
    }

    public static void setFactory(Factory aFactory) {
        factory = aFactory;
    }

    public static EOEditingContext newEditingContext() {
        return ERXEC.factory()._newEditingContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EOEditingContext newTolerantEditingContext(EOObjectStore parent, boolean retry, boolean merge) {
        ERXEC ec = (ERXEC)ERXEC.newEditingContext(parent);
        ec.lock();
        try {
            ec.setOptions(true, retry, merge);
            Object var5_4 = null;
            ec.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ec.unlock();
            throw throwable;
        }
        return ec;
    }

    public static EOEditingContext newTolerantEditingContext() {
        return ERXEC.newTolerantEditingContext(null, true, true);
    }

    public static EOEditingContext newTolerantEditingContext(EOObjectStore osc) {
        return ERXEC.newTolerantEditingContext(osc, true, true);
    }

    public static void saveChangesTolerantly(EOEditingContext ec, boolean doesRetry, boolean mergesChanges) {
        if (ec instanceof ERXEC) {
            ERXEC erxec = (ERXEC)ec;
            erxec.saveChangesTolerantly(doesRetry, mergesChanges);
        } else {
            ERXTolerantSaver.save(ec, doesRetry, mergesChanges);
        }
    }

    public static void saveChangesTolerantly(EOEditingContext ec) {
        ERXEC.saveChangesTolerantly(ec, true, true);
    }

    public static EOEditingContext newEditingContext(EOObjectStore parent, boolean validationEnabled) {
        return ERXEC.factory()._newEditingContext(parent, validationEnabled);
    }

    public static EOEditingContext newEditingContext(boolean validation) {
        return ERXEC.factory()._newEditingContext(validation);
    }

    public static EOEditingContext newEditingContext(EOObjectStore objectStore) {
        return ERXEC.factory()._newEditingContext(objectStore);
    }

    public static void registerOpenEditingContextLockSignalHandler() {
        try {
            ERXEC.registerOpenEditingContextLockSignalHandler("HUP");
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)"ERXEC's HUP signal handler was not registered, probably because your operating system does not support this signal.");
        }
    }

    public static void registerOpenEditingContextLockSignalHandler(String signalName) {
        ERXSignalHandler.register(signalName, new DumpLocksSignalHandler());
        ERXSignalHandler.register(signalName, new ERXObjectStoreCoordinator.DumpLocksSignalHandler());
    }

    public static String outstandingLockDescription() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        boolean hadLocks = false;
        pw.print("Currently " + activeEditingContexts.size() + " active ECs : " + activeEditingContexts + ")");
        for (ERXEC ec : activeEditingContexts.keySet()) {
            NSMutableDictionary<Thread, NSMutableArray<Exception>> traces = ec.openLockTraces;
            if (traces == null || traces.count() <= 0) continue;
            hadLocks = true;
            pw.println("\n------------------------");
            pw.println("Editing Context: " + (Object)((Object)ec) + " Locking thread: " + ec.lockingThreadName + "->" + ec.lockingThread);
            if (ec.creationTrace != null) {
                ec.creationTrace.printStackTrace(pw);
            }
            if (!ERXEC.traceOpenLocks()) {
                pw.println("Stack tracing is disabled");
                continue;
            }
            for (Thread thread : traces.keySet()) {
                pw.println("Outstanding at @" + thread);
                for (Exception ex : (NSMutableArray)traces.objectForKey(thread)) {
                    ex.printStackTrace(pw);
                }
            }
        }
        if (!hadLocks) {
            pw.print("No open editing contexts (of " + activeEditingContexts.size() + ")");
        }
        pw.close();
        return sw.toString();
    }

    static {
        EditingContextWillRevertObjectsDelegateSelector = new NSSelector("editingContextWillRevertObjects", new Class[]{EOEditingContext.class, NSArray.class, NSArray.class, NSArray.class});
        EditingContextDidRevertObjectsDelegateSelector = new NSSelector("editingContextDidRevertObjects", new Class[]{EOEditingContext.class, NSArray.class, NSArray.class, NSArray.class});
        EditingContextDidFailSaveChangesDelegateSelector = new NSSelector("editingContextDidFailSaveChanges", new Class[]{EOEditingContext.class, EOGeneralAdaptorException.class});
        locks = new ThreadLocal(){

            protected Object initialValue() {
                return new Vector();
            }
        };
        defaultTrace = new Exception("DefaultTrace");
        _shouldLockOnLockObjectStore = false;
        activeEditingContexts = Collections.synchronizedMap(new WeakHashMap());
    }

    public static class DumpLocksSignalHandler
    implements SignalHandler {
        public void handle(Signal signal) {
            log.info((Object)ERXEC.outstandingLockDescription());
        }
    }

    public static class DefaultFactory
    implements Factory {
        public static final Logger log = Logger.getLogger(DefaultFactory.class);
        protected Object defaultEditingContextDelegate = new ERXDefaultEditingContextDelegate();
        protected Object defaultNoValidationDelegate = new ERXECNoValidationDelegate();
        protected Boolean useSharedEditingContext = null;

        public Object defaultEditingContextDelegate() {
            return this.defaultEditingContextDelegate;
        }

        public void setDefaultEditingContextDelegate(Object delegate) {
            this.defaultEditingContextDelegate = delegate;
            if (log.isDebugEnabled()) {
                log.debug((Object)("setting defaultEditingContextDelegate to " + delegate));
            }
        }

        public Object defaultNoValidationDelegate() {
            return this.defaultNoValidationDelegate;
        }

        public void setDefaultNoValidationDelegate(Object delegate) {
            this.defaultNoValidationDelegate = delegate;
        }

        public void setDefaultDelegateOnEditingContext(EOEditingContext ec, boolean validation) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting default delegate on editing context: " + ec + " allows validation: " + validation));
            }
            if (ec != null) {
                if (validation) {
                    ec.setDelegate(this.defaultEditingContextDelegate());
                } else {
                    ec.setDelegate(this.defaultNoValidationDelegate());
                }
            } else {
                log.warn((Object)"Attempting to set a default delegate on a null ec!");
            }
        }

        public void setDefaultDelegateOnEditingContext(EOEditingContext ec) {
            this.setDefaultDelegateOnEditingContext(ec, true);
        }

        public EOEditingContext _newEditingContext() {
            return this._newEditingContext(EOEditingContext.defaultParentObjectStore(), true);
        }

        public EOEditingContext _newEditingContext(boolean validationEnabled) {
            return this._newEditingContext(EOEditingContext.defaultParentObjectStore(), validationEnabled);
        }

        public EOEditingContext _newEditingContext(EOObjectStore objectStore) {
            return this._newEditingContext(objectStore, true);
        }

        public EOEditingContext _newEditingContext(EOObjectStore objectStore, boolean validationEnabled) {
            EOEditingContext ec = this._createEditingContext(objectStore);
            int levelsOfUndo = ERXValueUtilities.intValueWithDefault(System.getProperty("WODefaultUndoStackLimit"), 10);
            if (levelsOfUndo == 0) {
                ec.setUndoManager(null);
            } else {
                ec.undoManager().setLevelsOfUndo(levelsOfUndo < 0 ? 10 : levelsOfUndo);
            }
            this.setDefaultDelegateOnEditingContext(ec, validationEnabled);
            if (!this.useSharedEditingContext()) {
                ec.lock();
                ec.setSharedEditingContext(null);
                ec.unlock();
            }
            NSNotificationCenter.defaultCenter().postNotification(ERXEC.EditingContextDidCreateNotification, (Object)ec);
            return ec;
        }

        protected EOEditingContext _createEditingContext(EOObjectStore parent) {
            return new ERXEC(parent == null ? EOEditingContext.defaultParentObjectStore() : parent);
        }

        public boolean useSharedEditingContext() {
            if (this.useSharedEditingContext == null) {
                this.useSharedEditingContext = ERXProperties.booleanForKeyWithDefault("er.extensions.ERXEC.useSharedEditingContext", true) ? Boolean.TRUE : Boolean.FALSE;
                log.debug((Object)("setting useSharedEditingContext to " + this.useSharedEditingContext));
            }
            return this.useSharedEditingContext;
        }

        public void setUseSharedEditingContext(boolean value) {
            this.useSharedEditingContext = value ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public static class _DenyMergeDelegate {
        private _NSDelegate delegate;

        public _DenyMergeDelegate(Object original) {
            if (original != null) {
                this.delegate = new _NSDelegate(original.getClass(), original);
            }
        }

        public boolean editingContextShouldMergeChangesForObject(EOEditingContext ec, EOEnterpriseObject eo) {
            if (this.delegate != null && this.delegate.respondsTo("editingContextShouldMergeChangesForObject")) {
                return this.delegate.booleanPerform("editingContextShouldMergeChangesForObject", (Object)ec, (Object)eo);
            }
            NSDictionary committedSnapshotForObject = ec.committedSnapshotForObject(eo);
            if (committedSnapshotForObject != null) {
                return eo.changesFromSnapshot(committedSnapshotForObject).count() == 0;
            }
            return true;
        }

        public void editingContextDidMergeChanges(EOEditingContext ec) {
            if (this.delegate != null && this.delegate.respondsTo("editingContextShouldMergeChangesForObject")) {
                this.delegate.perform("editingContextDidMergeChanges", (Object)ec);
            }
        }
    }

    public static interface Factory {
        public Object defaultEditingContextDelegate();

        public void setDefaultEditingContextDelegate(Object var1);

        public Object defaultNoValidationDelegate();

        public void setDefaultNoValidationDelegate(Object var1);

        public void setDefaultDelegateOnEditingContext(EOEditingContext var1);

        public void setDefaultDelegateOnEditingContext(EOEditingContext var1, boolean var2);

        public boolean useSharedEditingContext();

        public void setUseSharedEditingContext(boolean var1);

        public EOEditingContext _newEditingContext();

        public EOEditingContext _newEditingContext(boolean var1);

        public EOEditingContext _newEditingContext(EOObjectStore var1);

        public EOEditingContext _newEditingContext(EOObjectStore var1, boolean var2);
    }

    public static interface Delegate
    extends EOEditingContext.Delegate {
        public void editingContextDidFailSaveChanges(EOEditingContext var1, EOGeneralAdaptorException var2);

        public void editingContextWillRevertObjects(EOEditingContext var1, NSArray var2, NSArray var3, NSArray var4);

        public void editingContextDidRevertObjects(EOEditingContext var1, NSArray var2, NSArray var3, NSArray var4);
    }
}

