/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EOObjectStoreCoordinator;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOTemporaryGlobalID;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.eof.ERXEOGlobalIDUtilities;
import er.extensions.eof.ERXFetchSpecification;
import er.extensions.eof.ERXQ;
import er.extensions.foundation.ERXExpiringCache;
import er.extensions.foundation.ERXSelectorUtilities;
import er.extensions.qualifiers.IERXChainableQualifier;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXEnterpriseObjectCache<T extends EOEnterpriseObject> {
    public static String ClearCachesNotification = "ERXEnterpriseObjectCache.ClearCaches";
    protected static final EOGlobalID NO_GID_MARKER = new EOTemporaryGlobalID();
    private String _entityName;
    private String _keyPath;
    private EOQualifier _qualifier;
    private ERXExpiringCache<Object, EORecord<T>> _cache;
    private long _timeout;
    private long _fetchTime;
    private boolean _fetchInitialValues;
    private boolean _reuseEditingContext;
    private ERXEC _editingContext;
    private boolean _retainObjects;
    private boolean _resetOnChange;
    private boolean _returnUnsavedObjects;

    public ERXEnterpriseObjectCache(String entityName, String keyPath) {
        this(entityName, keyPath, 0L);
    }

    public ERXEnterpriseObjectCache(Class c, String keyPath) {
        this(ERXEnterpriseObjectCache.entityNameForClass(c), keyPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String entityNameForClass(Class c) {
        ERXEC ec;
        block3: {
            ec = (ERXEC)ERXEC.newEditingContext();
            ec.setCoalesceAutoLocks(false);
            ec.lock();
            try {
                EOEntity entity = EOUtilities.entityForClass((EOEditingContext)ec, (Class)c);
                if (entity == null) break block3;
                String string = entity.name();
                Object var5_5 = null;
                ec.unlock();
                ec.dispose();
                return string;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                ec.unlock();
                ec.dispose();
                throw throwable;
            }
        }
        String string = null;
        Object var5_6 = null;
        ec.unlock();
        ec.dispose();
        return string;
    }

    public ERXEnterpriseObjectCache(String entityName, String keyPath, long timeout) {
        this(entityName, keyPath, null, timeout);
    }

    public ERXEnterpriseObjectCache(String entityName, String keyPath, EOQualifier qualifier, long timeout) {
        this._entityName = entityName;
        this._keyPath = keyPath;
        this._timeout = timeout;
        this._qualifier = qualifier;
        this._resetOnChange = true;
        this._fetchInitialValues = true;
        this.start();
    }

    public ERXEnterpriseObjectCache(String entityName, String keyPath, EOQualifier qualifier, long timeout, boolean shouldRetainObjects, boolean shouldFetchInitialValues) {
        this(entityName, keyPath, qualifier, timeout, shouldRetainObjects, shouldFetchInitialValues, false);
    }

    public ERXEnterpriseObjectCache(String entityName, String keyPath, EOQualifier qualifier, long timeout, boolean shouldRetainObjects, boolean shouldFetchInitialValues, boolean shouldReturnUnsavedObjects) {
        this._entityName = entityName;
        this._keyPath = keyPath;
        this._timeout = timeout;
        this._qualifier = qualifier;
        this._returnUnsavedObjects = shouldReturnUnsavedObjects;
        this.setRetainObjects(shouldRetainObjects);
        this.setResetOnChange(false);
        this.setFetchInitialValues(shouldFetchInitialValues);
        this.start();
    }

    public void start() {
        NSSelector selector = ERXSelectorUtilities.notificationSelector("editingContextDidSaveChanges");
        NSNotificationCenter.defaultCenter().addObserver((Object)this, selector, "EOEditingContextDidSaveChangesNotification", null);
        selector = ERXSelectorUtilities.notificationSelector("clearCaches");
        NSNotificationCenter.defaultCenter().addObserver((Object)this, selector, ClearCachesNotification, null);
        if (this._timeout > 0L && this._cache != null) {
            this._cache.startBackgroundExpiration();
        }
    }

    public void stop() {
        NSNotificationCenter.defaultCenter().removeObserver((Object)this, "EOEditingContextDidSaveChangesNotification", null);
        NSNotificationCenter.defaultCenter().removeObserver((Object)this, ClearCachesNotification, null);
        this._cache.stopBackgroundExpiration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ERXEC editingContext() {
        ERXEC editingContext;
        if (this._reuseEditingContext) {
            ERXEnterpriseObjectCache eRXEnterpriseObjectCache = this;
            synchronized (eRXEnterpriseObjectCache) {
                if (this._editingContext == null) {
                    this._editingContext = (ERXEC)ERXEC.newEditingContext();
                    this._editingContext.setCoalesceAutoLocks(false);
                }
            }
            editingContext = this._editingContext;
        } else {
            editingContext = (ERXEC)ERXEC.newEditingContext();
            editingContext.setCoalesceAutoLocks(false);
        }
        return editingContext;
    }

    private NSArray<T> relevantChanges(NSDictionary dict, String key) {
        NSMutableArray<EOEnterpriseObject> releventEOs = null;
        NSArray eos = (NSArray)dict.objectForKey(key);
        Enumeration enumeration = eos.objectEnumerator();
        while (enumeration.hasMoreElements()) {
            EOEnterpriseObject eo = (EOEnterpriseObject)enumeration.nextElement();
            if (!eo.entityName().equals(this.entityName())) continue;
            if (releventEOs == null) {
                releventEOs = new NSMutableArray<EOEnterpriseObject>();
            }
            releventEOs.addObject(eo);
        }
        return releventEOs != null ? releventEOs : NSArray.EmptyArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editingContextDidSaveChanges(NSNotification n) {
        EOEditingContext ec = (EOEditingContext)n.object();
        if (ec.parentObjectStore() instanceof EOObjectStoreCoordinator) {
            NSArray<T> releventsInsertedEOs = this.relevantChanges(n.userInfo(), "inserted");
            NSArray<T> releventsUpdatedEOs = this.relevantChanges(n.userInfo(), "updated");
            NSArray<T> releventsDeletedEOs = this.relevantChanges(n.userInfo(), "deleted");
            if (this._resetOnChange) {
                if (releventsInsertedEOs.count() > 0 || releventsUpdatedEOs.count() > 0 || releventsDeletedEOs.count() > 0) {
                    this.reset();
                }
            } else {
                ERXExpiringCache<Object, EORecord<T>> cache;
                ERXExpiringCache<Object, EORecord<T>> eRXExpiringCache = cache = this.cache();
                synchronized (eRXExpiringCache) {
                    for (EOEnterpriseObject eo : releventsInsertedEOs) {
                        this.addObject(eo);
                    }
                    for (EOEnterpriseObject eo : releventsUpdatedEOs) {
                        this.updateObject(eo);
                    }
                    for (EOEnterpriseObject eo : releventsDeletedEOs) {
                        this.removeObject(eo);
                    }
                }
            }
        }
    }

    public void clearCaches(NSNotification n) {
        if (n.object() == null || this.entityName().equals(n.object())) {
            this.reset();
        }
    }

    protected String entityName() {
        return this._entityName;
    }

    protected String keyPath() {
        return this._keyPath;
    }

    protected synchronized ERXExpiringCache<Object, EORecord<T>> cache() {
        if (this._cache == null) {
            if (this._fetchInitialValues) {
                this._cache = new ERXExpiringCache(0L);
            } else {
                this._cache = new ERXExpiringCache(this._timeout);
                if (this._timeout > 0L) {
                    this._cache.startBackgroundExpiration();
                }
            }
            this.preLoadCacheIfNeeded();
        }
        long now = System.currentTimeMillis();
        if (this._fetchInitialValues && this._timeout > 0L && now - this._timeout > this._fetchTime) {
            this.reset();
        }
        return this._cache;
    }

    protected EORecord<T> createRecord(EOGlobalID gid, T eo) {
        EORecord<Object> record;
        if (this._retainObjects) {
            ERXEC editingContext = this.editingContext();
            T localEO = ERXEOControlUtilities.localInstanceOfObject(editingContext, eo);
            if (localEO != null && localEO.isFault()) {
                localEO.willRead();
            }
            record = new EORecord<T>(gid, localEO);
        } else {
            record = new EORecord<Object>(gid, null);
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preLoadCacheIfNeeded() {
        if (this._fetchInitialValues) {
            this._fetchTime = System.currentTimeMillis();
            ERXEC ec = this.editingContext();
            ec.setCoalesceAutoLocks(false);
            ERXExpiringCache<Object, EORecord<T>> eRXExpiringCache = this.cache();
            synchronized (eRXExpiringCache) {
                ec.lock();
                try {
                    ERXFetchSpecification fetchSpec = new ERXFetchSpecification(this.entityName(), this.qualifier(), null);
                    fetchSpec.setRefreshesRefetchedObjects(true);
                    fetchSpec.setIsDeep(true);
                    NSArray objects = ec.objectsWithFetchSpecification(fetchSpec);
                    Enumeration enumeration = objects.objectEnumerator();
                    while (enumeration.hasMoreElements()) {
                        EOEnterpriseObject eo = (EOEnterpriseObject)enumeration.nextElement();
                        this.addObject(eo);
                    }
                    Object var8_7 = null;
                    ec.unlock();
                    if (!this._reuseEditingContext) {
                        ec.dispose();
                    }
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    ec.unlock();
                    if (!this._reuseEditingContext) {
                        ec.dispose();
                    }
                    throw throwable;
                }
            }
        }
    }

    public void addObject(T eo) {
        Object key = eo.valueForKeyPath(this.keyPath());
        if (key == null) {
            key = NSKeyValueCoding.NullValue;
        }
        this.addObjectForKey(eo, key);
    }

    public void addObjectForKey(T eo, Object key) {
        if (this.qualifier() == null || this.qualifier().evaluateWithObject(eo)) {
            EOGlobalID gid = NO_GID_MARKER;
            if (eo != null) {
                gid = eo.editingContext().globalIDForObject(eo);
            }
            this.cache().setObjectForKey(this.createRecord(gid, eo), key);
        }
    }

    public void removeObject(T eo) {
        Object key = eo.valueForKeyPath(this.keyPath());
        if (key == null) {
            key = NSKeyValueCoding.NullValue;
        }
        this.removeObjectForKey(eo, key);
    }

    public void removeObjectForKey(T eo, Object key) {
        this.cache().setObjectForKey(this.createRecord(NO_GID_MARKER, null), key);
    }

    public void updateObject(T eo) {
        Object key = eo.valueForKeyPath(this.keyPath());
        if (key == null) {
            key = NSKeyValueCoding.NullValue;
        }
        this.updateObjectForKey(eo, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObjectForKey(T eo, Object key) {
        ERXExpiringCache<Object, EORecord<T>> cache;
        EOGlobalID gid = NO_GID_MARKER;
        if (eo != null) {
            gid = eo.editingContext().globalIDForObject(eo);
        }
        ERXExpiringCache<Object, EORecord<T>> eRXExpiringCache = cache = this.cache();
        synchronized (eRXExpiringCache) {
            Object previousKey = key;
            T previousObject = this.objectForKey(this.editingContext(), key, false);
            if (previousObject == null || !previousObject.editingContext().globalIDForObject(previousObject).equals((Object)gid)) {
                previousKey = null;
                for (Object entryKey : cache.allKeys()) {
                    EORecord<T> entryValue = cache.objectForKey(entryKey);
                    if (entryValue == null || !entryValue.gid.equals((Object)gid)) continue;
                    previousKey = entryKey;
                    break;
                }
            }
            if (previousKey != null) {
                if (!previousKey.equals(key)) {
                    this.removeObjectForKey(eo, previousKey);
                    this.addObjectForKey(eo, key);
                } else if (this.qualifier() != null && !this.qualifier().evaluateWithObject(eo)) {
                    this.removeObjectForKey(eo, previousKey);
                }
            } else {
                this.addObjectForKey(eo, key);
            }
        }
    }

    public T objectForKey(EOEditingContext ec, Object key) {
        return this.objectForKey(ec, key, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public T objectForKey(EOEditingContext ec, Object key, boolean handleUnsuccessfulQueryForKey) {
        EOEnterpriseObject eo;
        ERXExpiringCache<Object, EORecord<T>> cache = this.cache();
        EORecord<T> record = cache.objectForKey(key);
        if (record == null) {
            T unsavedMatchingObject;
            if (!handleUnsuccessfulQueryForKey) return null;
            if (this._returnUnsavedObjects && (unsavedMatchingObject = this.unsavedMatchingObject(ec, key)) != null) {
                return unsavedMatchingObject;
            }
            this.handleUnsuccessfullQueryForKey(key);
            record = cache.objectForKey(key);
            if (record == null) {
                return null;
            }
            if (record.gid == NO_GID_MARKER) {
                return null;
            }
        } else if (record.gid == NO_GID_MARKER) {
            return null;
        }
        eo = (eo = (EOEnterpriseObject)record.eo) == null ? ERXEOGlobalIDUtilities.fetchObjectWithGlobalID(ec, record.gid) : ERXEOControlUtilities.localInstanceOfObject(ec, eo);
        return (T)eo;
    }

    public T unsavedMatchingObject(EOEditingContext ec, Object key) {
        NSArray matchingObjects = EOQualifier.filteredArrayWithQualifier((NSArray)ec.insertedObjects(), (EOQualifier)ERXQ.equals("entityName", this._entityName));
        if ((matchingObjects = EOQualifier.filteredArrayWithQualifier((NSArray)matchingObjects, (EOQualifier)this.fetchObjectsQualifier(key))).count() > 1) {
            throw new EOUtilities.MoreThanOneException("There was more than one " + this._entityName + " with the key '" + key + "'.");
        }
        return (T)(matchingObjects.count() == 1 ? (EOEnterpriseObject)matchingObjects.lastObject() : null);
    }

    public NSArray<T> allObjects(EOEditingContext ec) {
        return this.allObjects(ec, null);
    }

    public NSArray<T> allObjects(EOEditingContext ec, EOQualifier additionalQualifier) {
        ERXExpiringCache<Object, EORecord<T>> cache = this.cache();
        NSArray<Object> allKeys = cache.allKeys();
        NSMutableArray<int> allObjects = new NSMutableArray<int>(allKeys.count());
        for (Object entryKey : allKeys) {
            T object = this.objectForKey(ec, entryKey, false);
            if (object == null || additionalQualifier != null && !additionalQualifier.evaluateWithObject(object)) continue;
            allObjects.addObject((int)object);
        }
        return allObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleUnsuccessfullQueryForKey(Object key) {
        if (!this._fetchInitialValues) {
            ERXExpiringCache<Object, EORecord<T>> cache;
            ERXExpiringCache<Object, EORecord<T>> eRXExpiringCache = cache = this.cache();
            synchronized (eRXExpiringCache) {
                ERXEC editingContext = this.editingContext();
                editingContext.lock();
                try {
                    NSArray<T> objects = this.fetchObjectsForKey(editingContext, key);
                    if (objects.count() == 0) {
                        cache.setObjectForKey(this.createRecord(NO_GID_MARKER, null), key);
                    } else if (objects.count() == 1) {
                        EOEnterpriseObject eo = (EOEnterpriseObject)objects.objectAtIndex(0);
                        this.addObject(eo);
                    } else {
                        throw new EOUtilities.MoreThanOneException("There was more than one " + this._entityName + " with the key '" + key + "'.");
                    }
                    Object var8_7 = null;
                    editingContext.unlock();
                    if (!this._reuseEditingContext) {
                        editingContext.dispose();
                    }
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    editingContext.unlock();
                    if (!this._reuseEditingContext) {
                        editingContext.dispose();
                    }
                    throw throwable;
                }
            }
        }
        this.cache().setObjectForKey(this.createRecord(NO_GID_MARKER, null), key);
    }

    protected NSArray<T> fetchObjectsForKey(EOEditingContext editingContext, Object key) {
        EOQualifier qualifier = this.fetchObjectsQualifier(key);
        ERXFetchSpecification fetchSpec = new ERXFetchSpecification(this._entityName, qualifier, null);
        fetchSpec.setRefreshesRefetchedObjects(true);
        fetchSpec.setIsDeep(true);
        NSArray objects = editingContext.objectsWithFetchSpecification(fetchSpec);
        return objects;
    }

    public EOQualifier qualifier() {
        return this._qualifier;
    }

    protected EOQualifier fetchObjectsQualifier(Object key) {
        IERXChainableQualifier qualifier = this.qualifier() == null ? ERXQ.is(this._keyPath, key) : ERXQ.is(this._keyPath, key).and(this.qualifier());
        return qualifier;
    }

    public synchronized void reset() {
        if (this._cache != null) {
            this._cache.removeAllObjects();
            this.preLoadCacheIfNeeded();
        }
    }

    public void setFetchInitialValues(boolean fetchInitialValues) {
        this._fetchInitialValues = fetchInitialValues;
        if (!fetchInitialValues) {
            this.setResetOnChange(false);
        }
    }

    public void setReuseEditingContext(boolean reuseEditingContext) {
        if (this._retainObjects && !reuseEditingContext) {
            throw new IllegalArgumentException("If retainObjects is true, reuseEditingContext cannot be false.");
        }
        this._reuseEditingContext = reuseEditingContext;
    }

    public void setRetainObjects(boolean retainObjects) {
        if (retainObjects && !ERXEC.defaultAutomaticLockUnlock()) {
            throw new RuntimeException("ERXEnterpriseObjectCache requires automatic locking when objects are retained. Set er.extensions.ERXEC.defaultAutomaticLockUnlock or er.extensions.ERXEC.safeLocking in your Properties file");
        }
        this._retainObjects = retainObjects;
        this.setReuseEditingContext(retainObjects);
    }

    public void setResetOnChange(boolean resetOnChange) {
        this._resetOnChange = resetOnChange;
        if (this._resetOnChange) {
            this.setFetchInitialValues(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EORecord<T> {
        public EOGlobalID gid;
        public T eo;

        public EORecord(EOGlobalID gid, T eo) {
            this.gid = gid;
            this.eo = eo;
        }
    }
}

