/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOKeyComparisonQualifier;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOQualifierEvaluation;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPropertyListSerialization;
import er.extensions.crypting.ERXCrypto;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.qualifiers.ERXQualifierTraversal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXFetchSpecification<T extends EOEnterpriseObject>
extends EOFetchSpecification {
    private NSMutableDictionary _userInfo;
    private boolean _includeEditingContextChanges;

    public ERXFetchSpecification(String entityName, EOQualifier qualifier, NSArray sortOrderings, boolean usesDistinct, boolean isDeep, NSDictionary hints) {
        super(entityName, qualifier, sortOrderings, usesDistinct, isDeep, hints);
    }

    public ERXFetchSpecification(String entityName, EOQualifier qualifier, NSArray sortOrderings) {
        super(entityName, qualifier, sortOrderings);
    }

    public ERXFetchSpecification(EOFetchSpecification spec) {
        super(spec.entityName(), spec.qualifier(), spec.sortOrderings(), spec.usesDistinct(), spec.isDeep(), spec.hints());
        this.setFetchesRawRows(spec.fetchesRawRows());
        this.setFetchLimit(spec.fetchLimit());
        this.setLocksObjects(spec.locksObjects());
        this.setRawRowKeyPaths(spec.rawRowKeyPaths());
        this.setPromptsAfterFetchLimit(spec.promptsAfterFetchLimit());
        this.setRefreshesRefetchedObjects(spec.refreshesRefetchedObjects());
        this.setPrefetchingRelationshipKeyPaths(spec.prefetchingRelationshipKeyPaths());
    }

    public ERXFetchSpecification(ERXFetchSpecification<T> spec) {
        this((EOFetchSpecification)spec);
        this._userInfo = spec.userInfo().count() > 0 ? null : spec.userInfo().mutableClone();
    }

    public void setIncludeEditingContextChanges(boolean includeEditingContextChanges) {
        this._includeEditingContextChanges = includeEditingContextChanges;
    }

    public boolean includeEditingContextChanges() {
        return this._includeEditingContextChanges;
    }

    public void setObjectForKey(Object value, String key) {
        this._userInfo = this._userInfo == null ? new NSMutableDictionary() : this._userInfo;
        this._userInfo.takeValueForKey(value, key);
    }

    public Object objectForKey(String key) {
        return this._userInfo != null ? this._userInfo.valueForKey(key) : null;
    }

    public NSDictionary userInfo() {
        return this._userInfo == null ? NSDictionary.EmptyDictionary : this._userInfo.immutableClone();
    }

    public NSArray<T> fetchObjects(EOEditingContext ec) {
        return ec.objectsWithFetchSpecification((EOFetchSpecification)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSArray<NSDictionary<String, Object>> fetchRawRows(EOEditingContext ec) {
        NSArray nSArray;
        block3: {
            boolean old = this.fetchesRawRows();
            if (!old) {
                this.setFetchesRawRows(true);
            }
            try {
                nSArray = ec.objectsWithFetchSpecification((EOFetchSpecification)this);
                Object var5_4 = null;
                if (old) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var5_5 = null;
                    if (old) break block4;
                    this.setFetchesRawRows(old);
                }
                throw throwable;
            }
            this.setFetchesRawRows(old);
        }
        return nSArray;
    }

    public String identifier() {
        return ERXFetchSpecification.identifierForFetchSpec(this);
    }

    protected String additionalIdentifierInfo() {
        return "";
    }

    public Object clone() {
        return ERXFetchSpecification.fetchSpec((EOFetchSpecification)super.clone());
    }

    public static <T extends EOEnterpriseObject> ERXFetchSpecification<T> fetchSpec(EOFetchSpecification fs, Class<T> clazz) {
        if (fs instanceof ERXFetchSpecification) {
            return (ERXFetchSpecification)fs;
        }
        return new ERXFetchSpecification<T>(fs);
    }

    public static <T extends EOEnterpriseObject> ERXFetchSpecification<T> fetchSpec(EOFetchSpecification fs) {
        if (fs instanceof ERXFetchSpecification) {
            return (ERXFetchSpecification)fs;
        }
        return new ERXFetchSpecification<T>(fs);
    }

    protected static String identifierForQualifier(EOQualifier q) {
        final StringBuilder sb = new StringBuilder();
        if (q != null) {
            ERXQualifierTraversal traversal = new ERXQualifierTraversal(){

                protected void visit(EOQualifierEvaluation q) {
                    sb.append(q.getClass().getName());
                }

                protected boolean traverseKeyComparisonQualifier(EOKeyComparisonQualifier q) {
                    sb.append(q.leftKey()).append(q.selector().name()).append(q.rightKey());
                    return super.traverseKeyComparisonQualifier(q);
                }

                protected boolean traverseKeyValueQualifier(EOKeyValueQualifier q) {
                    Object value = q.value();
                    if (value instanceof EOEnterpriseObject) {
                        EOEnterpriseObject eo = (EOEnterpriseObject)value;
                        value = ERXEOControlUtilities.primaryKeyStringForObject(eo);
                    } else if (value instanceof NSArray) {
                        NSArray arr = (NSArray)value;
                        String s = "";
                        for (Object object : arr) {
                            if (object instanceof EOEnterpriseObject) {
                                EOEnterpriseObject eo = (EOEnterpriseObject)object;
                                s = s + ERXEOControlUtilities.primaryKeyStringForObject(eo);
                                continue;
                            }
                            s = s + NSPropertyListSerialization.stringFromPropertyList(object);
                        }
                        value = s;
                    }
                    sb.append(q.key()).append(q.selector().name()).append(value);
                    return super.traverseKeyValueQualifier(q);
                }
            };
            traversal.traverse((EOQualifierEvaluation)q);
        }
        return sb.toString();
    }

    public static String identifierForFetchSpec(EOFetchSpecification fs) {
        StringBuilder sb = new StringBuilder(ERXFetchSpecification.identifierForQualifier(fs.qualifier()));
        for (EOSortOrdering so : fs.sortOrderings()) {
            sb.append(so.key()).append(so.selector().name());
        }
        sb.append(fs.fetchesRawRows()).append(fs.fetchLimit()).append(fs.locksObjects()).append(fs.isDeep());
        sb.append(fs.entityName());
        sb.append(fs.hints());
        if (fs instanceof ERXFetchSpecification) {
            sb.append(((ERXFetchSpecification)fs).additionalIdentifierInfo());
        }
        String result = sb.toString();
        result = ERXCrypto.base64HashedString(result);
        return result;
    }
}

