/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.appserver.WOSession;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOObjectStore;
import com.webobjects.eocontrol.EOObjectStoreCoordinator;
import com.webobjects.eocontrol.EOSharedEditingContext;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import er.extensions.appserver.ERXSession;
import er.extensions.eof.ERXConstant;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXObjectStoreCoordinator;
import er.extensions.eof.ERXObjectStoreCoordinatorSynchronizer;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXThreadStorage;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Observer;
import org.apache.log4j.Logger;

public class ERXObjectStoreCoordinatorPool {
    private static final Logger log = Logger.getLogger(ERXObjectStoreCoordinatorPool.class);
    private static final String THREAD_OSC_KEY = "er.extensions.ERXObjectStoreCoordinatorPool.threadOSC";
    private Hashtable _oscForSession;
    private int _maxOS;
    private int _currentObjectStoreIndex;
    private List _objectStores;
    private List _sharedEditingContexts;
    private Observer _observer;
    private Object _lock = new Object();
    protected static ERXObjectStoreCoordinatorPool _pool;

    public static ERXObjectStoreCoordinatorPool _pool() {
        return _pool;
    }

    public static void initializeIfNecessary() {
        if (ERXProperties.stringForKey("er.extensions.ERXObjectStoreCoordinatorPool.maxCoordinators") != null) {
            ERXObjectStoreCoordinatorPool.initialize();
        }
    }

    public static void initialize() {
        if (_pool == null) {
            ERXObjectStoreCoordinatorSynchronizer.initialize();
            _pool = new ERXObjectStoreCoordinatorPool();
            log.info((Object)"setting ERXEC.factory to MultiOSCFactory");
            ERXEC.setFactory(new MultiOSCFactory());
        }
    }

    private ERXObjectStoreCoordinatorPool() {
        this._maxOS = ERXProperties.intForKey("er.extensions.ERXObjectStoreCoordinatorPool.maxCoordinators");
        if (this._maxOS == 0) {
            log.warn((Object)"Registering the pool with only one coordinator doesn't make a lot of sense.");
            this._maxOS = 1;
        }
        this._oscForSession = new Hashtable();
        NSSelector sel = new NSSelector("sessionDidCreate", ERXConstant.NotificationClassArray);
        NSNotificationCenter.defaultCenter().addObserver((Object)this, sel, "SessionDidCreateNotification", null);
        sel = new NSSelector("sessionDidTimeout", ERXConstant.NotificationClassArray);
        NSNotificationCenter.defaultCenter().addObserver((Object)this, sel, "SessionDidTimeOutNotification", null);
    }

    public void sessionDidCreate(NSNotification n) {
        WOSession s = (WOSession)n.object();
        if (this._oscForSession.get(s.sessionID()) == null) {
            this._oscForSession.put(s.sessionID(), this.currentThreadObjectStore());
        }
    }

    public void sessionDidTimeout(NSNotification n) {
        String sessionID = (String)n.object();
        this._oscForSession.remove(sessionID);
    }

    protected String sessionID() {
        return ERXSession.currentSessionID();
    }

    public EOObjectStore currentRootObjectStore() {
        String sessionID = this.sessionID();
        EOObjectStore os = null;
        if (sessionID != null) {
            os = (EOObjectStore)this._oscForSession.get(sessionID);
            if (os == null) {
                os = this.currentThreadObjectStore();
                this._oscForSession.put(sessionID, os);
            }
        } else {
            os = this.currentThreadObjectStore();
        }
        return os;
    }

    protected EOObjectStore currentThreadObjectStore() {
        EOObjectStore os = (EOObjectStore)ERXThreadStorage.valueForKey(THREAD_OSC_KEY);
        if (os == null && (os = this.nextObjectStore()) != null) {
            ERXThreadStorage.takeValueForKey(os, THREAD_OSC_KEY);
        }
        return os;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EOObjectStore nextObjectStore() {
        Object object = this._lock;
        synchronized (object) {
            if (this._objectStores == null) {
                this._initObjectStores();
            }
            if (this._currentObjectStoreIndex == this._maxOS) {
                this._currentObjectStoreIndex = 0;
            }
            EOObjectStore os = (EOObjectStore)this._objectStores.get(this._currentObjectStoreIndex++);
            return os;
        }
    }

    public EOSharedEditingContext sharedEditingContextForObjectStore(EOObjectStore os) {
        int index = this._objectStores.indexOf(os);
        EOSharedEditingContext ec = null;
        if (index >= 0) {
            ec = (EOSharedEditingContext)this._sharedEditingContexts.get(index);
        }
        return ec;
    }

    private void _initObjectStores() {
        log.info((Object)"initializing Pool...");
        this._objectStores = new ArrayList(this._maxOS);
        this._sharedEditingContexts = new ArrayList(this._maxOS);
        for (int i = 0; i < this._maxOS; ++i) {
            EOObjectStoreCoordinator os = ERXObjectStoreCoordinator.create();
            this._objectStores.add(os);
            this._sharedEditingContexts.add(new EOSharedEditingContext((EOObjectStore)os));
        }
        if (this._maxOS > 0) {
            EOObjectStoreCoordinator.setDefaultCoordinator((EOObjectStoreCoordinator)((EOObjectStoreCoordinator)this._objectStores.get(0)));
        }
        log.info((Object)"initializing Pool finished");
    }

    public static class MultiOSCFactory
    extends ERXEC.DefaultFactory {
        public EOEditingContext _newEditingContext() {
            return this._newEditingContext(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EOEditingContext _newEditingContext(boolean validationEnabled) {
            EOObjectStore os = _pool.currentRootObjectStore();
            EOEditingContext ec = this._newEditingContext(os, validationEnabled);
            ec.lock();
            try {
                EOSharedEditingContext sec = this.useSharedEditingContext() ? _pool.sharedEditingContextForObjectStore(os) : null;
                ec.setSharedEditingContext(sec);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                ec.unlock();
                throw throwable;
            }
            ec.unlock();
            return ec;
        }
    }
}

