/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eoaccess.EOGeneralAdaptorException;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSValidation;
import er.extensions.eof.ERXEOAccessUtilities;
import org.apache.log4j.Logger;

public class ERXTolerantSaver {
    public static final Logger log = Logger.getLogger(ERXTolerantSaver.class);

    public static String save(EOEditingContext ec, boolean writeAnyWay) {
        return ERXTolerantSaver.save(ec, writeAnyWay, true);
    }

    private static String _save(EOEditingContext ec, boolean writeAnyWay, boolean merge) {
        String result = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"TolerantSaver: save...");
        }
        try {
            ec.saveChanges();
        }
        catch (NSValidation.ValidationException eov) {
            log.info((Object)("TolerantSaver: Caught EOValidationException: " + eov.getMessage()));
            throw eov;
        }
        catch (EOGeneralAdaptorException e) {
            if (ERXEOAccessUtilities.isOptimisticLockingFailure(e)) {
                EOEnterpriseObject failedEO = ERXEOAccessUtilities.refetchFailedObject(ec, e);
                if (merge) {
                    ERXEOAccessUtilities.reapplyChanges(failedEO, e);
                }
                if (writeAnyWay) {
                    ERXTolerantSaver._save(ec, writeAnyWay, merge);
                }
                result = "EOAdaptorOptimisticLockingFailure";
            }
            result = "Error: No EOAdaptorFailureKey, reason ";
            result = result + ERXTolerantSaver.errorFromException((Exception)((Object)e));
        }
        return result;
    }

    public static String save(EOEditingContext ec, boolean writeAnyWay, boolean merge) {
        int tries = 0;
        String re = "";
        while (tries++ < 20 && (re = ERXTolerantSaver._save(ec, writeAnyWay, merge)) != null && re.indexOf("deadlock") != -1) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            log.error((Object)"got deadlock, trying to save again");
        }
        return re;
    }

    private static String errorFromException(Exception e) {
        String stackTrace = NSLog.throwableAsString((Throwable)e);
        if (stackTrace.indexOf("multiple transaction conflict detected") != -1) {
            return "deadlock";
        }
        return "";
    }
}

