/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import java.text.ParseException;
import java.text.StringCharacterIterator;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class ERXCommandLineTokenizer
implements Enumeration {
    private StringCharacterIterator _iterator;
    private TokenizerState _state;
    private boolean _wasQuoted;

    public ERXCommandLineTokenizer(String line) {
        this._iterator = new StringCharacterIterator(line);
        this.reset();
    }

    protected void reset() {
        this._state = TokenizerState.Whitespace;
        this._iterator.first();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public boolean hasMoreTokens() {
        return this._iterator.current() != '\uffff';
    }

    public String nextElement() {
        String token;
        try {
            token = this.nextToken();
        }
        catch (ParseException e) {
            e.printStackTrace();
            token = null;
        }
        return token;
    }

    public String nextToken() throws ParseException {
        boolean escapeNext = false;
        boolean wasQuoted = this._wasQuoted;
        StringBuffer token = new StringBuffer();
        char c = this._iterator.current();
        boolean done = false;
        while (!done && c != '\uffff') {
            if (escapeNext) {
                switch (c) {
                    case '\n': {
                        throw new ParseException("Unexception escape '\\' at end of string.", this._iterator.getIndex());
                    }
                }
                token.append(c);
                c = this._iterator.next();
                escapeNext = false;
                continue;
            }
            block3 : switch (this._state) {
                case Whitespace: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case ' ': {
                            c = this._iterator.next();
                            break block3;
                        }
                        case '\"': {
                            this._state = TokenizerState.DoubleQuoted;
                            c = this._iterator.next();
                            if (token.length() > 0 || this._wasQuoted) {
                                done = true;
                                this._wasQuoted = false;
                            }
                            this._wasQuoted = true;
                            break block3;
                        }
                        case '\'': {
                            this._state = TokenizerState.SingleQuoted;
                            c = this._iterator.next();
                            if (token.length() > 0 || this._wasQuoted) {
                                done = true;
                                this._wasQuoted = false;
                            }
                            this._wasQuoted = true;
                            break block3;
                        }
                        case '\\': {
                            escapeNext = true;
                            c = this._iterator.next();
                            break block3;
                        }
                    }
                    this._state = TokenizerState.Text;
                    if (token.length() <= 0 && !this._wasQuoted) break;
                    done = true;
                    this._wasQuoted = false;
                    break;
                }
                case Text: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case ' ': {
                            this._state = TokenizerState.Whitespace;
                            break block3;
                        }
                        case '\\': {
                            escapeNext = true;
                            c = this._iterator.next();
                            break block3;
                        }
                    }
                    token.append(c);
                    c = this._iterator.next();
                    break;
                }
                case DoubleQuoted: {
                    switch (c) {
                        case '\"': {
                            this._state = TokenizerState.Whitespace;
                            c = this._iterator.next();
                            break block3;
                        }
                        case '\\': {
                            escapeNext = true;
                            c = this._iterator.next();
                            break block3;
                        }
                    }
                    token.append(c);
                    c = this._iterator.next();
                    break;
                }
                case SingleQuoted: {
                    switch (c) {
                        case '\'': {
                            this._state = TokenizerState.Whitespace;
                            c = this._iterator.next();
                            break block3;
                        }
                        case '\\': {
                            escapeNext = true;
                            c = this._iterator.next();
                            break block3;
                        }
                    }
                    token.append(c);
                    c = this._iterator.next();
                }
            }
        }
        if (token.length() <= 0 && !wasQuoted) {
            throw new NoSuchElementException("There are no more tokens on this line.");
        }
        return token.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TokenizerState {
        Whitespace,
        Text,
        DoubleQuoted,
        SingleQuoted;

    }
}

