/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import com.webobjects.appserver.WOApplication;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSSelector;
import er.extensions.eof.ERXConstant;
import er.extensions.foundation.ERXDictionaryUtilities;
import er.extensions.foundation.ERXFileNotificationCenter;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXSystem;
import er.extensions.logging.ERXLogger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ERXConfigurationManager {
    public static final Logger log = Logger.getLogger(ERXConfigurationManager.class);
    public static final String ConfigurationDidChangeNotification = "ConfigurationDidChangeNotification";
    static ERXConfigurationManager defaultManager = null;
    private String[] _commandLineArguments;
    private NSArray _monitoredProperties;
    private Properties _defaultProperties;
    private Properties _commandLineArgumentProperties;
    private boolean _isInitialized = false;
    private boolean _isRapidTurnAroundInitialized = false;
    public static final int WindowsOperatingSystem = 1;
    public static final int MacOSXOperatingSystem = 2;
    public static final int SolarisOperatingSystem = 3;
    public static final int UnknownOperatingSystem = 3;
    private int _operatingSystem = 0;
    protected String documentRoot;
    protected String _hostName;

    private ERXConfigurationManager() {
    }

    private static String propertiesTouchFile() {
        return ERXProperties.stringForKey("er.extensions.ERXConfigurationManager.PropertiesTouchFile");
    }

    public static ERXConfigurationManager defaultManager() {
        if (defaultManager == null) {
            defaultManager = new ERXConfigurationManager();
        }
        return defaultManager;
    }

    public String[] commandLineArguments() {
        return this._commandLineArguments;
    }

    public Properties commandLineArgumentProperties() {
        return (Properties)this._commandLineArgumentProperties.clone();
    }

    public Properties defaultProperties() {
        return (Properties)this._defaultProperties.clone();
    }

    public void setCommandLineArguments(String[] newCommandLineArguments) {
        this._commandLineArguments = newCommandLineArguments;
        this._defaultProperties = (Properties)NSProperties._getProperties().clone();
        this._commandLineArgumentProperties = ERXProperties.propertiesFromArgv(this._commandLineArguments);
    }

    public void initialize() {
        if (!this._isInitialized) {
            this._isInitialized = true;
            this.loadConfiguration();
        }
    }

    private NSArray monitoredProperties() {
        if (this._monitoredProperties == null) {
            this._monitoredProperties = ERXProperties.pathsForUserAndBundleProperties();
        }
        return this._monitoredProperties;
    }

    public void configureRapidTurnAround() {
        if (this._isRapidTurnAroundInitialized) {
            return;
        }
        this._isRapidTurnAroundInitialized = true;
        if (WOApplication.application() != null && WOApplication.application().isCachingEnabled()) {
            log.info((Object)"WOCachingEnabled is true. Disabling the rapid turnaround for Properties files");
            this.registerPropertiesTouchFiles();
            return;
        }
        Enumeration e = this.monitoredProperties().objectEnumerator();
        while (e.hasMoreElements()) {
            String path = (String)e.nextElement();
            this.registerForFileNotification(path, "updateSystemProperties");
        }
    }

    private void registerPropertiesTouchFiles() {
        String propertiesTouchFile = ERXConfigurationManager.propertiesTouchFile();
        if (propertiesTouchFile != null) {
            String appNamePlaceHolder = "/{AppName}/";
            int appNamePlaceHolderIndex = propertiesTouchFile.lastIndexOf(appNamePlaceHolder);
            if (appNamePlaceHolderIndex == -1) {
                this.registerForFileNotification(propertiesTouchFile, "updateAllSystemProperties");
            } else {
                if (WOApplication.application() != null) {
                    StringBuffer appSpecificTouchFile = new StringBuffer();
                    appSpecificTouchFile.append(propertiesTouchFile.substring(0, appNamePlaceHolderIndex + 1));
                    appSpecificTouchFile.append(WOApplication.application().name());
                    appSpecificTouchFile.append(propertiesTouchFile.substring(appNamePlaceHolderIndex + appNamePlaceHolder.length() - 1));
                    this.registerForFileNotification(appSpecificTouchFile.toString(), "updateAllSystemProperties");
                }
                StringBuffer globalTouchFile = new StringBuffer();
                globalTouchFile.append(propertiesTouchFile.substring(0, appNamePlaceHolderIndex + 1));
                globalTouchFile.append(propertiesTouchFile.substring(appNamePlaceHolderIndex + appNamePlaceHolder.length()));
                this.registerForFileNotification(globalTouchFile.toString(), "updateAllSystemProperties");
            }
        }
    }

    private void registerForFileNotification(String path, String callbackMethod) {
        try {
            ERXFileNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector(callbackMethod, ERXConstant.NotificationClassArray), path);
            log.debug((Object)("Registered: " + path));
        }
        catch (Exception ex) {
            log.error((Object)("An exception occured while registering the observer for the logging configuration file: " + ex.getClass().getName() + " " + ex.getMessage()));
        }
    }

    public void loadConfiguration() {
        Properties systemProperties = System.getProperties();
        systemProperties = this.applyConfiguration(systemProperties);
        ERXProperties.transferPropertiesFromSourceToDest(systemProperties, System.getProperties());
        ERXSystem.updateProperties();
        ERXLogger.configureLoggingWithSystemProperties();
    }

    public Properties applyConfiguration(Properties systemProperties) {
        return ERXProperties.applyConfiguration(systemProperties, this.commandLineArgumentProperties());
    }

    public synchronized void updateSystemProperties(NSNotification n) {
        this.loadConfiguration();
    }

    public synchronized void updateAllSystemProperties(NSNotification notification) {
        this.loadConfiguration();
    }

    public int operatingSystem() {
        if (this._operatingSystem == 0) {
            String osName = ERXSystem.getProperty("os.name").toLowerCase();
            this._operatingSystem = osName.indexOf("windows") != -1 ? 1 : (osName.indexOf("solaris") != -1 ? 3 : (osName.indexOf("macos") != -1 || osName.indexOf("mac os") != -1 ? 2 : 3));
        }
        return this._operatingSystem;
    }

    public String documentRoot() {
        if (this.documentRoot == null) {
            this.documentRoot = ERXProperties.stringForKey(WOApplication.application().name() + "DocumentRoot");
            if (this.documentRoot == null) {
                NSDictionary dict;
                this.documentRoot = ERXProperties.stringForKey("ERXDocumentRoot");
                if (this.documentRoot == null && (dict = ERXDictionaryUtilities.dictionaryFromPropertyList("WebServerConfig", NSBundle.bundleForName((String)"JavaWebObjects"))) != null) {
                    this.documentRoot = (String)dict.objectForKey("DocumentRoot");
                }
            }
        }
        return this.documentRoot;
    }

    public String hostName() {
        if (this._hostName == null) {
            try {
                this._hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ehe) {
                log.warn((Object)("Caught unknown host exception: " + ehe.getMessage()));
                this._hostName = "UnknownHost";
            }
        }
        return this._hostName;
    }

    public boolean isDeployedAsServlet() {
        NSArray frameworkNames = (NSArray)NSBundle.frameworkBundles().valueForKey("name");
        return frameworkNames.containsObject("JavaWOJSPServlet");
    }
}

