/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import java.io.File;

public class ERXFileContext {
    private File _file;
    private String _path;
    private String _clientFileName;
    private String _mimeType;

    public ERXFileContext() {
    }

    public ERXFileContext(File file) {
        this._file = file;
    }

    public ERXFileContext(File file, String clientFileName, String mimeType) {
        this._file = file;
        this._clientFileName = clientFileName;
        this._mimeType = mimeType;
    }

    public ERXFileContext(String path) {
        this._file = new File(path);
    }

    public void reset() {
        this._file = null;
        this._clientFileName = null;
        this._mimeType = null;
    }

    public File file() {
        return this._file;
    }

    public void setFile(File file) {
        this._file = file;
    }

    public String path() {
        if (this._file == null) {
            return null;
        }
        return this._file.getAbsolutePath();
    }

    public void setPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("cannot set a 'null' path");
        }
        this._file = new File(path);
    }

    public String clientFileName() {
        if (this._clientFileName == null) {
            if (this._file == null) {
                return null;
            }
            return this._file.getName();
        }
        return this._clientFileName;
    }

    public void setClientFileName(String clientFileName) {
        this._clientFileName = clientFileName;
    }

    public String mimeType() {
        return this._mimeType;
    }

    public void setMimeType(String mimeType) {
        this._mimeType = mimeType;
    }

    public String extension() {
        String extension = null;
        if (this._clientFileName != null) {
            extension = this.extensionForFileName(this._clientFileName);
        }
        if (extension == null && this._file != null) {
            extension = this.extensionForFileName(this.path());
        }
        return extension;
    }

    private String extensionForFileName(String fileName) {
        int dotIndex;
        String extension = null;
        if (fileName != null && (dotIndex = fileName.lastIndexOf(46)) != -1) {
            extension = fileName.substring(dotIndex + 1);
        }
        return extension;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(super.toString());
        b.append(";file = " + this._file);
        b.append(";clientFileName = " + this._clientFileName);
        b.append(";mimeType =" + this._mimeType);
        return b.toString();
    }
}

