/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.jdbc;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOAdaptorChannel;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EODatabase;
import com.webobjects.eoaccess.EODatabaseChannel;
import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOQualifierSQLGeneration;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOSQLExpressionFactory;
import com.webobjects.eoaccess.EOSynchronizationFactory;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOCooperatingObjectStore;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOObjectStoreCoordinator;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.jdbcadaptor.JDBCAdaptor;
import com.webobjects.jdbcadaptor.JDBCPlugIn;
import er.extensions.eof.ERXConstant;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.eof.ERXModelGroup;
import er.extensions.eof.qualifiers.ERXFullTextQualifier;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.jdbc.ERXJDBCUtilities;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXSQLHelper {
    public static final Logger log = Logger.getLogger(ERXSQLHelper.class);
    private static Map<String, ERXSQLHelper> _sqlHelperMap = new HashMap<String, ERXSQLHelper>();

    public void prepareConnectionForSchemaChange(EOEditingContext ec, EOModel model) {
    }

    public void restoreConnectionSettingsAfterSchemaChange(EOEditingContext ec, EOModel model) {
    }

    public boolean shouldExecute(String sql) {
        return true;
    }

    public String createSchemaSQLForEntitiesInModelWithNameAndOptions(NSArray<EOEntity> entities, String modelName, NSDictionary optionsCreate) {
        EOModel m = ERXEOAccessUtilities.modelGroup(null).modelNamed(modelName);
        return this.createSchemaSQLForEntitiesInModelAndOptions(entities, m, optionsCreate);
    }

    private EODatabaseContext databaseContextForModel(EOModel model, EOObjectStoreCoordinator coordinator) {
        EODatabaseContext dbc = null;
        NSArray objectStores = coordinator.cooperatingObjectStores();
        int c = objectStores.count();
        for (int i = 0; i < c; ++i) {
            Object objectStore = objectStores.objectAtIndex(i);
            if (!(objectStore instanceof EODatabaseContext) || !((EODatabaseContext)objectStore).database().addModelIfCompatible(model)) continue;
            dbc = (EODatabaseContext)objectStore;
        }
        if (dbc == null) {
            dbc = (EODatabaseContext)_NSUtilities.instantiateObject((Class)EODatabaseContext.contextClassToRegister(), (Class[])new Class[]{EODatabase.class}, (Object[])new Object[]{new EODatabase(model)}, (boolean)true, (boolean)false);
            coordinator.addCooperatingObjectStore((EOCooperatingObjectStore)dbc);
        }
        return dbc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createSchemaSQLForEntitiesInModelAndOptions(NSArray<EOEntity> entities, EOModel model, NSDictionary optionsCreate) {
        String string;
        EOEditingContext ec = ERXEC.newEditingContext();
        ec.lock();
        try {
            String result;
            EODatabaseContext databaseContext = this.databaseContextForModel(model, (EOObjectStoreCoordinator)ec.rootObjectStore());
            if (entities == null) {
                Enumeration e = model.entities().objectEnumerator();
                NSMutableArray<EOEntity> ar = new NSMutableArray<EOEntity>();
                while (e.hasMoreElements()) {
                    EOEntity currentEntity = (EOEntity)e.nextElement();
                    if (ERXModelGroup.isPrototypeEntity(currentEntity) || !ERXEOAccessUtilities.entityUsesSeparateTable(currentEntity)) continue;
                    ar.addObject(currentEntity);
                }
                entities = ar;
            }
            string = result = this.createSchemaSQLForEntitiesWithOptions(entities, databaseContext, (NSDictionary<String, String>)optionsCreate);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            ec.unlock();
            throw throwable;
        }
        ec.unlock();
        return string;
    }

    public String createSchemaSQLForEntitiesWithOptions(NSArray<EOEntity> entities, EODatabaseContext databaseContext, NSDictionary<String, String> optionsCreate) {
        return this.createSchemaSQLForEntitiesWithOptions(entities, databaseContext.adaptorContext().adaptor(), optionsCreate);
    }

    public String createDependentSchemaSQLForEntities(NSArray<EOEntity> entities, EOAdaptor adaptor) {
        NSMutableDictionary<String, String> optionsCreateTables = new NSMutableDictionary<String, String>();
        optionsCreateTables.setObjectForKey("NO", "dropTables");
        optionsCreateTables.setObjectForKey("NO", "dropPrimaryKeySupport");
        optionsCreateTables.setObjectForKey("YES", "createTables");
        optionsCreateTables.setObjectForKey("YES", "createPrimaryKeySupport");
        optionsCreateTables.setObjectForKey("YES", "primaryKeyConstraints");
        optionsCreateTables.setObjectForKey("NO", "foreignKeyConstraints");
        optionsCreateTables.setObjectForKey("NO", "createDatabase");
        optionsCreateTables.setObjectForKey("NO", "dropDatabase");
        StringBuffer sqlBuffer = new StringBuffer();
        EOSynchronizationFactory sf = ((JDBCAdaptor)adaptor).plugIn().synchronizationFactory();
        String creationScript = sf.schemaCreationScriptForEntities(entities, optionsCreateTables);
        sqlBuffer.append(creationScript);
        NSMutableArray<EOEntity> foreignKeyEntities = entities.mutableClone();
        for (EOEntity entity : entities) {
            for (EORelationship relationship : entity.relationships()) {
                EOEntity destinationEntity;
                if (relationship.isToMany() || (destinationEntity = relationship.destinationEntity()).model() == entity.model()) continue;
                foreignKeyEntities.addObject(destinationEntity);
            }
        }
        NSMutableDictionary<String, String> optionsCreateForeignKeys = new NSMutableDictionary<String, String>();
        optionsCreateForeignKeys.setObjectForKey("NO", "dropTables");
        optionsCreateForeignKeys.setObjectForKey("NO", "dropPrimaryKeySupport");
        optionsCreateForeignKeys.setObjectForKey("NO", "createTables");
        optionsCreateForeignKeys.setObjectForKey("NO", "createPrimaryKeySupport");
        optionsCreateForeignKeys.setObjectForKey("NO", "primaryKeyConstraints");
        optionsCreateForeignKeys.setObjectForKey("YES", "foreignKeyConstraints");
        optionsCreateForeignKeys.setObjectForKey("NO", "createDatabase");
        optionsCreateForeignKeys.setObjectForKey("NO", "dropDatabase");
        String foreignKeyScript = sf.schemaCreationScriptForEntities(foreignKeyEntities, optionsCreateForeignKeys);
        sqlBuffer.append(foreignKeyScript);
        return sqlBuffer.toString();
    }

    public String createSchemaSQLForEntitiesWithOptions(NSArray<EOEntity> entities, EOAdaptor adaptor, NSDictionary<String, String> optionsDictionary) {
        EOSynchronizationFactory sf = ((JDBCAdaptor)adaptor).plugIn().synchronizationFactory();
        String creationScript = sf.schemaCreationScriptForEntities(entities, optionsDictionary);
        return creationScript;
    }

    public String createSchemaSQLForEntitiesInModelWithName(NSArray<EOEntity> entities, String modelName) {
        EOModel model = ERXEOAccessUtilities.modelGroup(null).modelNamed(modelName);
        return this.createSchemaSQLForEntitiesInModel(entities, model);
    }

    public String createSchemaSQLForEntitiesInModel(NSArray<EOEntity> entities, EOModel model) {
        return this.createSchemaSQLForEntitiesInModelAndOptions(entities, model, this.defaultOptionDictionary(true, true));
    }

    public NSMutableDictionary<String, String> defaultOptionDictionary(boolean create, boolean drop) {
        NSMutableDictionary<String, String> optionsCreate = new NSMutableDictionary<String, String>();
        optionsCreate.setObjectForKey(drop ? "YES" : "NO", "dropTables");
        optionsCreate.setObjectForKey(drop ? "YES" : "NO", "dropPrimaryKeySupport");
        optionsCreate.setObjectForKey(create ? "YES" : "NO", "createTables");
        optionsCreate.setObjectForKey(create ? "YES" : "NO", "createPrimaryKeySupport");
        optionsCreate.setObjectForKey(create ? "YES" : "NO", "primaryKeyConstraints");
        optionsCreate.setObjectForKey(create ? "YES" : "NO", "foreignKeyConstraints");
        optionsCreate.setObjectForKey("NO", "createDatabase");
        optionsCreate.setObjectForKey("NO", "dropDatabase");
        return optionsCreate;
    }

    public String createSchemaSQLForEntitiesInDatabaseContext(NSArray<EOEntity> entities, EODatabaseContext databaseContext, boolean create, boolean drop) {
        return this.createSchemaSQLForEntitiesWithOptions(entities, databaseContext, this.defaultOptionDictionary(create, drop));
    }

    public String createIndexSQLForEntities(NSArray<EOEntity> entities) {
        return this.createIndexSQLForEntities(entities, null);
    }

    public String createIndexSQLForEntities(NSArray<EOEntity> entities, NSArray<String> externalTypesToIgnore) {
        if (externalTypesToIgnore == null) {
            externalTypesToIgnore = NSArray.EmptyArray;
        }
        if (entities == null || entities.count() == 0) {
            return "";
        }
        int i = 0;
        String oldIndexName = null;
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        String commandSeparator = this.commandSeparatorString();
        Enumeration<EOEntity> entitiesEnum = entities.objectEnumerator();
        while (entitiesEnum.hasMoreElements()) {
            EOEntity entity = entitiesEnum.nextElement();
            if (!ERXEOAccessUtilities.entityUsesSeparateTable(entity)) continue;
            NSDictionary d = entity.userInfo();
            NSMutableArray<String> usedColumns = new NSMutableArray<String>();
            Enumeration keys = d.keyEnumerator();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (key.startsWith("index")) {
                    String newIndexName;
                    String attributeNames;
                    String numbers = key.substring("index".length());
                    if (!ERXStringUtilities.isDigitsOnly(numbers) || ERXStringUtilities.stringIsNullOrEmpty(attributeNames = (String)d.objectForKey(key))) continue;
                    String indexName = "c" + System.currentTimeMillis() + new NSTimestamp().getNanos();
                    String string = newIndexName = i == 0 ? indexName : indexName + "_" + i;
                    if (oldIndexName == null) {
                        oldIndexName = indexName;
                    } else if (oldIndexName.equals(newIndexName)) {
                        indexName = indexName + "_" + ++i;
                    } else {
                        i = 0;
                    }
                    oldIndexName = indexName;
                    StringBuffer localBuf = new StringBuffer();
                    StringBuffer columnBuf = new StringBuffer();
                    boolean validIndex = false;
                    localBuf.append("create index " + indexName + " on " + entity.externalName() + "(");
                    Enumeration<String> attributes = NSArray.componentsSeparatedByString(attributeNames, ",").objectEnumerator();
                    while (attributes.hasMoreElements()) {
                        String attributeName = attributes.nextElement();
                        EOAttribute attribute = entity.attributeNamed(attributeName = attributeName.trim());
                        if (attribute == null) {
                            attribute = ERXEOAccessUtilities.attributeWithColumnNameFromEntity(attributeName, entity);
                        }
                        if (attribute != null && externalTypesToIgnore.indexOfObject(attribute.externalType()) != -1) continue;
                        validIndex = true;
                        String columnName = attribute == null ? attributeName : attribute.columnName();
                        columnBuf.append(columnName);
                        if (!attributes.hasMoreElements()) continue;
                        columnBuf.append(", ");
                    }
                    if (!validIndex) continue;
                    String l = columnBuf.toString();
                    if (l.endsWith(", ")) {
                        l = l.substring(0, l.length() - 2);
                    }
                    if (usedColumns.indexOfObject(l) != -1) continue;
                    buf.append(localBuf).append(l);
                    usedColumns.addObject(l);
                    buf.append(")").append(commandSeparator).append(lineSeparator);
                    continue;
                }
                if (!key.equals("additionalIndexes")) continue;
                String value = (String)d.objectForKey(key);
                Enumeration<String> indexes = NSArray.componentsSeparatedByString(value, " ").objectEnumerator();
                while (indexes.hasMoreElements()) {
                    String newIndexName;
                    String indexValues = indexes.nextElement();
                    if (ERXStringUtilities.stringIsNullOrEmpty(indexValues)) continue;
                    String indexName = "c" + System.currentTimeMillis() + new NSTimestamp().getNanos();
                    String string = newIndexName = i == 0 ? indexName : indexName + "_" + i;
                    if (oldIndexName == null) {
                        oldIndexName = indexName;
                    } else if (oldIndexName.equals(newIndexName)) {
                        indexName = indexName + "_" + ++i;
                    } else {
                        i = 0;
                    }
                    oldIndexName = indexName;
                    StringBuffer localBuf = new StringBuffer();
                    StringBuffer columnBuf = new StringBuffer();
                    boolean validIndex = false;
                    localBuf.append("create index " + indexName + " on " + entity.externalName() + "(");
                    Enumeration<String> e = NSArray.componentsSeparatedByString(indexValues, ",").objectEnumerator();
                    while (e.hasMoreElements()) {
                        String attributeName = e.nextElement();
                        EOAttribute attribute = entity.attributeNamed(attributeName = attributeName.trim());
                        if (attribute == null) {
                            attribute = ERXEOAccessUtilities.attributeWithColumnNameFromEntity(attributeName, entity);
                        }
                        if (attribute != null && externalTypesToIgnore.indexOfObject(attribute.externalType()) != -1) continue;
                        validIndex = true;
                        String columnName = attribute == null ? attributeName : attribute.columnName();
                        columnBuf.append(columnName);
                        if (!e.hasMoreElements()) continue;
                        columnBuf.append(", ");
                    }
                    if (!validIndex) continue;
                    String l = columnBuf.toString();
                    if (l.endsWith(", ")) {
                        l = l.substring(0, l.length() - 2);
                    }
                    if (usedColumns.indexOfObject(l) != -1) continue;
                    buf.append(localBuf).append(l);
                    usedColumns.addObject(l);
                    buf.append(")").append(commandSeparator).append(lineSeparator);
                }
            }
        }
        return buf.toString();
    }

    public NSArray<EOAttribute> attributesToFetchForEntity(EOFetchSpecification fetchSpec, EOEntity entity) {
        NSArray attributes;
        if (!fetchSpec.fetchesRawRows()) {
            attributes = entity.attributesToFetch();
        } else {
            NSMutableArray<EOAttribute> rawRowAttributes = new NSMutableArray<EOAttribute>();
            for (String rawRowKeyPath : fetchSpec.rawRowKeyPaths()) {
                rawRowAttributes.addObject(entity.anyAttributeNamed(rawRowKeyPath));
            }
            attributes = rawRowAttributes.immutableClone();
        }
        return attributes;
    }

    public EOSQLExpression sqlExpressionForFetchSpecification(EOEditingContext ec, EOFetchSpecification spec, long start, long end) {
        return this.sqlExpressionForFetchSpecification(ec, spec, start, end, null);
    }

    public String customQueryExpressionHintAsString(Object hint) {
        String sql;
        if (hint instanceof String) {
            sql = (String)hint;
        } else if (hint instanceof EOSQLExpression) {
            sql = ((EOSQLExpression)hint).statement();
            if (sql == null) {
                throw new IllegalArgumentException("This EOSQLExpression's statement was null (" + hint + ").");
            }
        } else {
            sql = null;
        }
        return sql;
    }

    public EOSQLExpression sqlExpressionForFetchSpecification(EOEditingContext ec, EOFetchSpecification spec, long start, long end, NSArray<EOAttribute> attributes) {
        EOEntity entity = ERXEOAccessUtilities.entityNamed(ec, spec.entityName());
        EOModel model = entity.model();
        EODatabaseContext dbc = EOUtilities.databaseContextForModelNamed((EOEditingContext)ec, (String)model.name());
        EOAdaptor adaptor = dbc.adaptorContext().adaptor();
        EOSQLExpressionFactory sqlFactory = adaptor.expressionFactory();
        EOQualifier qualifier = (spec = (EOFetchSpecification)spec.clone()).qualifier();
        if (qualifier != null) {
            qualifier = EOQualifierSQLGeneration.Support._schemaBasedQualifierWithRootEntity((EOQualifier)qualifier, (EOEntity)entity);
        }
        if (qualifier != spec.qualifier()) {
            spec.setQualifier(qualifier);
        }
        if (spec.fetchLimit() > 0) {
            spec.setFetchLimit(0);
            spec.setPromptsAfterFetchLimit(false);
        }
        spec = ERXEOAccessUtilities.localizeFetchSpecification(ec, spec);
        if (attributes == null) {
            attributes = this.attributesToFetchForEntity(spec, entity);
        }
        EOSQLExpression sqlExpr = sqlFactory.selectStatementForAttributes(attributes, false, spec, entity);
        String sql = sqlExpr.statement();
        if (spec.hints() != null && !spec.hints().isEmpty() && spec.hints().valueForKey("EOCustomQueryExpressionHintKey") != null) {
            Object hint = spec.hints().valueForKey("EOCustomQueryExpressionHintKey");
            sql = this.customQueryExpressionHintAsString(hint);
        }
        if (end >= 0L) {
            sql = this.limitExpressionForSQL(sqlExpr, spec, sql, start, end);
            sqlExpr.setStatement(sql);
        }
        return sqlExpr;
    }

    public String limitExpressionForSQL(EOSQLExpression expression, EOFetchSpecification fetchSpecification, String sql, long start, long end) {
        throw new UnsupportedOperationException("There is no " + this.getClass().getSimpleName() + " implementation for generating limit expressions.");
    }

    public void removeSelectFromExpression(EOAttribute attribute, EOSQLExpression sqlExpression) {
        String sql = sqlExpression.statement();
        String attributeSql = sqlExpression.sqlStringForAttribute(attribute);
        String replaceSql = sql.replaceFirst(", " + attributeSql, "");
        if (replaceSql.length() == sql.length()) {
            replaceSql = sql.replaceFirst(attributeSql + ", ", "");
        }
        sqlExpression.setStatement(replaceSql);
    }

    public String readFormatForAggregateFunction(String functionName, String columnName, String aggregateName) {
        StringBuffer sb = new StringBuffer();
        sb.append(functionName);
        sb.append("(");
        sb.append(columnName);
        sb.append(")");
        if (aggregateName != null) {
            sb.append(" AS ");
            sb.append(aggregateName);
        }
        return sb.toString();
    }

    public void appendItemToListString(String itemString, StringBuffer listString) {
        if (listString.length() > 0) {
            listString.append(", ");
        }
        listString.append(itemString);
    }

    public void addGroupByClauseToExpression(EOEditingContext editingContext, EOFetchSpecification fetchSpec, EOSQLExpression expression) {
        EOEntity entity = ERXEOAccessUtilities.entityNamed(editingContext, fetchSpec.entityName());
        this.addGroupByClauseToExpression(this.attributesToFetchForEntity(fetchSpec, entity), expression);
    }

    public int _orderByIndex(EOSQLExpression expression) {
        String sql = expression.statement();
        int orderByInsertIndex = sql.lastIndexOf(" LIMIT ");
        if (orderByInsertIndex == -1) {
            orderByInsertIndex = sql.length();
        }
        return orderByInsertIndex;
    }

    public int _groupByOrHavingIndex(EOSQLExpression expression) {
        String sql = expression.statement();
        int groupByInsertIndex = sql.lastIndexOf(" ORDER BY ");
        if (groupByInsertIndex == -1 && (groupByInsertIndex = sql.lastIndexOf(" LIMIT ")) == -1) {
            groupByInsertIndex = sql.length();
        }
        return groupByInsertIndex;
    }

    public void addGroupByClauseToExpression(NSArray<EOAttribute> attributes, EOSQLExpression expression) {
        StringBuffer groupByBuffer = new StringBuffer();
        for (EOAttribute attribute : attributes) {
            String attributeSqlString = expression.sqlStringForAttribute(attribute);
            attributeSqlString = expression.formatSQLString(attributeSqlString, attribute.readFormat());
            this.appendItemToListString(attributeSqlString, groupByBuffer);
        }
        groupByBuffer.insert(0, " GROUP BY ");
        StringBuffer sqlBuffer = new StringBuffer(expression.statement());
        sqlBuffer.insert(this._groupByOrHavingIndex(expression), groupByBuffer);
        expression.setStatement(sqlBuffer.toString());
    }

    public void addHavingCountClauseToExpression(NSSelector selector, int value, EOSQLExpression expression) {
        Integer integerValue = value;
        String operatorString = expression.sqlStringForSelector(selector, (Object)integerValue);
        StringBuffer havingBuffer = new StringBuffer();
        havingBuffer.append(" HAVING COUNT(*) ");
        havingBuffer.append(operatorString);
        havingBuffer.append(" ");
        havingBuffer.append(integerValue);
        StringBuffer sqlBuffer = new StringBuffer(expression.statement());
        sqlBuffer.insert(this._groupByOrHavingIndex(expression), havingBuffer);
        expression.setStatement(sqlBuffer.toString());
    }

    public String sqlForRegularExpressionQuery(String key, String value) {
        throw new UnsupportedOperationException("There is no " + this.getClass().getSimpleName() + " implementation for generating regex expressions.");
    }

    public String sqlForFullTextQuery(ERXFullTextQualifier qualifier, EOSQLExpression expression) {
        throw new UnsupportedOperationException("There is no " + this.getClass().getSimpleName() + " implementation for generating full text expressions.");
    }

    public String sqlForCreateUniqueIndex(String indexName, String tableName, String ... columnNames) {
        return this.sqlForCreateUniqueIndex(indexName, tableName, this.columnIndexesFromColumnNames(columnNames));
    }

    public String sqlForCreateUniqueIndex(String indexName, String tableName, ColumnIndex ... columnIndexes) {
        NSMutableArray<String> columnNames = this.columnNamesFromColumnIndexes(columnIndexes);
        return "ALTER TABLE \"" + tableName + "\" ADD CONSTRAINT \"" + indexName + "\" UNIQUE(\"" + new NSArray<String>((NSArray<String>)columnNames).componentsJoinedByString("\", \"") + "\")";
    }

    public String sqlForCreateIndex(String indexName, String tableName, String ... columnNames) {
        return this.sqlForCreateIndex(indexName, tableName, this.columnIndexesFromColumnNames(columnNames));
    }

    protected ColumnIndex[] columnIndexesFromColumnNames(String ... columnNames) {
        NSMutableArray<ColumnIndex> columnIndexes = new NSMutableArray<ColumnIndex>();
        for (String columnName : columnNames) {
            columnIndexes.addObject(new ColumnIndex(columnName));
        }
        return columnIndexes.toArray(new ColumnIndex[columnIndexes.count()]);
    }

    public String sqlForCreateIndex(String indexName, String tableName, ColumnIndex ... columnIndexes) {
        throw new UnsupportedOperationException("There is no " + this.getClass().getSimpleName() + " implementation for generating index expressions.");
    }

    public int varcharLargeJDBCType() {
        return 12;
    }

    public int varcharLargeColumnWidth() {
        return 10000000;
    }

    public String migrationTableName() {
        return "_dbupdater";
    }

    public int jdbcTypeForCustomType(int jdbcType) {
        int result = jdbcType;
        if (jdbcType == 9001) {
            result = 12;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String externalTypeForJDBCType(JDBCAdaptor adaptor, int jdbcType) {
        String externalType = null;
        NSArray defaultJDBCTypes = null;
        jdbcType = this.jdbcTypeForCustomType(jdbcType);
        try {
            Method typeInfoMethod = adaptor.getClass().getDeclaredMethod("typeInfo", new Class[0]);
            boolean oldAccessible = typeInfoMethod.isAccessible();
            typeInfoMethod.setAccessible(true);
            try {
                NSDictionary typeInfo = (NSDictionary)typeInfoMethod.invoke((Object)adaptor, new Object[0]);
                if (typeInfo != null) {
                    NSDictionary typeDescription;
                    String jdbcStringRep;
                    String typeInfoStringRep = jdbcStringRep = JDBCAdaptor.stringRepresentationForJDBCType((int)jdbcType);
                    for (String possibleTypeInfoStringRep : typeInfo.allKeys()) {
                        if (!typeInfoStringRep.equalsIgnoreCase(possibleTypeInfoStringRep)) continue;
                        typeInfoStringRep = possibleTypeInfoStringRep;
                        break;
                    }
                    if ((typeDescription = (NSDictionary)typeInfo.objectForKey(typeInfoStringRep)) != null && (defaultJDBCTypes = (NSArray)typeDescription.objectForKey("defaultJDBCType")) != null && defaultJDBCTypes.containsObject(jdbcStringRep)) {
                        externalType = typeInfoStringRep;
                    }
                    if (externalType == null) {
                        externalType = adaptor.externalTypeForJDBCType(jdbcType);
                    }
                }
                Object var13_14 = null;
                typeInfoMethod.setAccessible(oldAccessible);
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                typeInfoMethod.setAccessible(oldAccessible);
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to sneakily execute adaptor.typeInfo().", (Throwable)e);
        }
        if (externalType == null) {
            externalType = adaptor.externalTypeForJDBCType(jdbcType);
        }
        if (externalType == null && defaultJDBCTypes != null) {
            int defaultJDBCTypesCount = defaultJDBCTypes.count();
            if (defaultJDBCTypesCount == 1) {
                externalType = (String)defaultJDBCTypes.objectAtIndex(0);
            } else {
                if (defaultJDBCTypesCount == 0) {
                    throw new IllegalArgumentException("There is no type that could be found in your database that maps to JDBC Type #" + jdbcType + ".");
                }
                externalType = (String)defaultJDBCTypes.objectAtIndex(0);
                log.warn((Object)("There was more than one type that in your database that maps to JDBC Type #" + jdbcType + ": " + defaultJDBCTypes + ". We guessed '" + externalType + "'. Cross your fingers."));
            }
        }
        return externalType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int rowCountForFetchSpecification(EOEditingContext ec, EOFetchSpecification spec) {
        String sql;
        int rowCount = -1;
        EOEntity entity = ERXEOAccessUtilities.entityNamed(ec, spec.entityName());
        EOModel model = entity.model();
        NSArray<NSDictionary> result = null;
        if (spec.hints() == null || spec.hints().isEmpty() || spec.hints().valueForKey("EOCustomQueryExpressionHintKey") == null) {
            String countExpression;
            if (spec.fetchLimit() > 0 || spec.sortOrderings() != null) {
                boolean usesDistinct = spec.usesDistinct();
                spec = new EOFetchSpecification(spec.entityName(), spec.qualifier(), null);
                spec.setUsesDistinct(usesDistinct);
            }
            EOSQLExpression sqlExpression = this.sqlExpressionForFetchSpecification(ec, spec, 0L, -1L);
            String statement = sqlExpression.statement();
            int index = statement.toLowerCase().indexOf(" from ");
            if (spec.usesDistinct()) {
                NSArray primaryKeyAttributeNames = entity.primaryKeyAttributeNames();
                if (primaryKeyAttributeNames.count() > 1) {
                    log.warn((Object)"Composite primary keys are currently unsupported in rowCountForFetchSpecification, when the spec uses distinct");
                }
                String pkAttributeName = (String)primaryKeyAttributeNames.lastObject();
                String pkColumnName = entity.attributeNamed(pkAttributeName).columnName();
                countExpression = "count(distinct " + this.quoteColumnName("t0." + pkColumnName) + ") ";
            } else {
                countExpression = "count(*) ";
            }
            statement = "select " + countExpression + statement.substring(index, statement.length());
            sqlExpression.setStatement(statement);
            sql = statement;
            result = ERXEOAccessUtilities.rawRowsForSQLExpression(ec, model.name(), sqlExpression);
        } else {
            Object hint = spec.hints().valueForKey("EOCustomQueryExpressionHintKey");
            sql = ERXSQLHelper.newSQLHelper(model).customQueryExpressionHintAsString(hint);
            if (sql.endsWith(";")) {
                sql = sql.substring(0, sql.length() - 1);
            }
            sql = "select count(*) from " + this.sqlForSubquery(sql, "result_count_temp_table");
            result = EOUtilities.rawRowsForSQL((EOEditingContext)ec, (String)model.name(), (String)sql, null);
        }
        if (result.count() <= 0) throw new IllegalStateException("sql " + sql + " returned no result!");
        NSDictionary dict = (NSDictionary)result.objectAtIndex(0);
        NSArray values = dict.allValues();
        if (values.count() <= 0) throw new IllegalStateException("sql " + sql + " returned no result!");
        Object value = values.objectAtIndex(0);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        try {
            int c = Integer.parseInt(value.toString());
            return c;
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("sql " + sql + " returned a wrong result, could not convert " + value + " into an int!");
        }
    }

    protected String sqlForSubquery(String subquery, String alias) {
        return "(" + subquery + ") as " + alias;
    }

    protected String sqlForGetNextValFromSequencedNamed(String sequenceName) {
        throw new UnsupportedOperationException("There is no " + this.getClass().getSimpleName() + " implementation for sequences.");
    }

    public Number getNextValFromSequenceNamed(EOEditingContext ec, String modelName, String sequenceName) {
        NSArray array = EOUtilities.rawRowsForSQL((EOEditingContext)ec, (String)modelName, (String)this.sqlForGetNextValFromSequencedNamed(sequenceName), null);
        if (array.count() == 0) {
            throw new RuntimeException("Unable to generate value from sequence named: " + sequenceName + " in model: " + modelName);
        }
        NSDictionary dictionary = (NSDictionary)array.objectAtIndex(0);
        NSArray valuesArray = dictionary.allValues();
        return (Number)valuesArray.objectAtIndex(0);
    }

    public String sqlWhereClauseStringForKey(EOSQLExpression e, String key, NSArray valueArray) {
        if (valueArray.count() == 0) {
            return "0=1";
        }
        StringBuffer sb = new StringBuffer();
        NSArray attributePath = ERXEOAccessUtilities.attributePathForKeyPath(e.entity(), key);
        EOAttribute attribute = (EOAttribute)attributePath.lastObject();
        String sqlName = attributePath.count() > 1 ? e.sqlStringForAttributePath(attributePath) : e.sqlStringForAttribute(attribute);
        int maxPerQuery = this.maximumElementPerInClause(e.entity());
        if (valueArray.count() > maxPerQuery) {
            sb.append(" ( ");
        }
        for (int j = 0; j < valueArray.count(); j += maxPerQuery) {
            int currentSize = j + (maxPerQuery - 1) < valueArray.count() ? maxPerQuery : valueArray.count() % maxPerQuery;
            sb.append(sqlName);
            sb.append(" IN ");
            sb.append("(");
            for (int i = j; i < j + currentSize; ++i) {
                Object value;
                if (i > j) {
                    sb.append(", ");
                }
                value = (value = valueArray.objectAtIndex(i)) instanceof ERXConstant.NumberConstant ? new Long(((Number)value).longValue()) : this.formatValueForAttribute(e, value, attribute, key);
                sb.append(value);
            }
            sb.append(")");
            if (j >= valueArray.count() - maxPerQuery) continue;
            sb.append(" OR ");
        }
        if (valueArray.count() > maxPerQuery) {
            sb.append(" ) ");
        }
        return sb.toString();
    }

    protected int maximumElementPerInClause(EOEntity entity) {
        return 256;
    }

    protected String formatValueForAttribute(EOSQLExpression expression, Object value, EOAttribute attribute, String key) {
        return expression.sqlStringForValue(value, key);
    }

    public NSArray<String> splitSQLStatements(String sql) {
        NSMutableArray<String> statements = new NSMutableArray<String>();
        if (sql != null) {
            char commandSeparatorChar = this.commandSeparatorChar();
            Pattern commentPattern = this.commentPattern();
            StringBuffer statementBuffer = new StringBuffer();
            BufferedReader reader = new BufferedReader(new StringReader(sql));
            boolean inQuotes = false;
            try {
                String nextLine = reader.readLine();
                while (nextLine != null) {
                    if ((nextLine = nextLine.trim()).length() == 0 || statementBuffer.length() == 0 && commentPattern.matcher(nextLine).find()) {
                        nextLine = reader.readLine();
                        continue;
                    }
                    int length = nextLine.length();
                    char ch = '\u0000';
                    for (int i = 0; i < length; ++i) {
                        ch = nextLine.charAt(i);
                        if (inQuotes && ch == '\\') {
                            ++i;
                        } else if (ch == '\'') {
                            boolean bl = inQuotes = !inQuotes;
                        }
                        if (!inQuotes && ch == commandSeparatorChar) continue;
                        statementBuffer.append(ch);
                    }
                    if (!inQuotes) {
                        if (ch == commandSeparatorChar) {
                            statements.addObject(statementBuffer.toString().trim());
                            statementBuffer.setLength(0);
                        } else {
                            statementBuffer.append(' ');
                        }
                    }
                    nextLine = reader.readLine();
                }
                String finalStatement = statementBuffer.toString().trim();
                if (finalStatement.length() > 0) {
                    statements.addObject(finalStatement);
                }
            }
            catch (IOException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
        }
        return statements;
    }

    public NSArray<String> splitSQLStatementsFromInputStream(InputStream is) throws IOException {
        return this.splitSQLStatements(ERXStringUtilities.stringFromInputStream(is));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSArray<String> splitSQLStatementsFromFile(File f) throws IOException {
        NSArray<String> nSArray;
        FileInputStream fis = new FileInputStream(f);
        try {
            BufferedInputStream bis = new BufferedInputStream(fis);
            nSArray = this.splitSQLStatementsFromInputStream(bis);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            fis.close();
            throw throwable;
        }
        fis.close();
        return nSArray;
    }

    protected char commandSeparatorChar() {
        return ';';
    }

    protected String commandSeparatorString() {
        String lineSeparator = System.getProperty("line.separator");
        return ";" + lineSeparator;
    }

    protected Pattern commentPattern() {
        return Pattern.compile("^$");
    }

    public NSMutableArray<String> columnNamesFromColumnIndexes(ColumnIndex ... columnIndexes) {
        NSMutableArray<String> columnNames = new NSMutableArray<String>();
        for (ColumnIndex columnIndex : columnIndexes) {
            columnNames.addObject(columnIndex.columnName());
        }
        return columnNames;
    }

    public boolean reassignExternalTypeForValueTypeOverride(EOAttribute attribute) {
        return true;
    }

    public String quoteColumnName(String columnName) {
        return columnName;
    }

    protected boolean canReliablyPerformDistinctWithSortOrderings() {
        return true;
    }

    public boolean shouldPerformDistinctInMemory(EOFetchSpecification fetchSpecification) {
        boolean shouldPerformDistinctInMemory = false;
        if (!this.canReliablyPerformDistinctWithSortOrderings()) {
            NSArray sortOrderings = fetchSpecification.sortOrderings();
            if (fetchSpecification.usesDistinct() && sortOrderings != null && sortOrderings.count() > 0) {
                shouldPerformDistinctInMemory = true;
            }
        }
        return shouldPerformDistinctInMemory;
    }

    public boolean handleDatabaseException(EODatabaseContext databaseContext, Throwable throwable) {
        return false;
    }

    public static ERXSQLHelper newSQLHelper(EOSQLExpression expression) {
        int expressionIndex;
        String className = expression.getClass().getName();
        int dotIndex = className.lastIndexOf(36);
        if (dotIndex == -1) {
            dotIndex = className.lastIndexOf(46);
        }
        if ((expressionIndex = className.lastIndexOf("Expression")) == -1) {
            throw new RuntimeException("Failed to create sql helper for expression " + expression + ".");
        }
        String databaseProductName = className.substring(dotIndex + 1, expressionIndex);
        return ERXSQLHelper.newSQLHelper(databaseProductName);
    }

    public static ERXSQLHelper newSQLHelper(EOEditingContext ec, String modelName) {
        return ERXSQLHelper.newSQLHelper(EOUtilities.databaseContextForModelNamed((EOEditingContext)ec, (String)modelName));
    }

    public static ERXSQLHelper newSQLHelper(EOEditingContext ec, EOEntity entity) {
        return ERXSQLHelper.newSQLHelper(EODatabaseContext.registeredDatabaseContextForModel((EOModel)entity.model(), (EOEditingContext)ec));
    }

    public static ERXSQLHelper newSQLHelper(EOEditingContext ec, EOModel model) {
        return ERXSQLHelper.newSQLHelper(EODatabaseContext.registeredDatabaseContextForModel((EOModel)model, (EOEditingContext)ec));
    }

    public static ERXSQLHelper newSQLHelper(EODatabaseContext databaseContext) {
        EOAdaptor adaptor = databaseContext.database().adaptor();
        return ERXSQLHelper.newSQLHelper(adaptor);
    }

    public static ERXSQLHelper newSQLHelper(EODatabaseChannel databaseChannel) {
        EOAdaptor adaptor = databaseChannel.adaptorChannel().adaptorContext().adaptor();
        return ERXSQLHelper.newSQLHelper(adaptor);
    }

    public static ERXSQLHelper newSQLHelper(EOAdaptor adaptor) {
        if (adaptor instanceof JDBCAdaptor) {
            return ERXSQLHelper.newSQLHelper((JDBCAdaptor)adaptor);
        }
        return new NoSQLHelper();
    }

    public static ERXSQLHelper newSQLHelper(EOAdaptorChannel adaptorChannel) {
        EOAdaptor adaptor = adaptorChannel.adaptorContext().adaptor();
        return ERXSQLHelper.newSQLHelper(adaptor);
    }

    public static ERXSQLHelper newSQLHelper(JDBCAdaptor adaptor) {
        JDBCPlugIn plugin = adaptor.plugIn();
        return ERXSQLHelper.newSQLHelper(plugin);
    }

    public static ERXSQLHelper newSQLHelper(JDBCPlugIn plugin) {
        String databaseProductName = plugin.databaseProductName();
        return ERXSQLHelper.newSQLHelper(databaseProductName);
    }

    public static ERXSQLHelper newSQLHelper(EOEntity entity) {
        return ERXSQLHelper.newSQLHelper(entity.model());
    }

    public static ERXSQLHelper newSQLHelper(EOModel model) {
        EOAdaptor adaptor = EOAdaptor.adaptorWithModel((EOModel)model);
        return ERXSQLHelper.newSQLHelper(adaptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ERXSQLHelper newSQLHelper(String databaseProductName) {
        Map<String, ERXSQLHelper> map = _sqlHelperMap;
        synchronized (map) {
            ERXSQLHelper sqlHelper = _sqlHelperMap.get(databaseProductName);
            if (sqlHelper == null) {
                try {
                    String sqlHelperClassName = ERXProperties.stringForKey(databaseProductName + ".SQLHelper");
                    if (sqlHelperClassName == null) {
                        if (databaseProductName == null) {
                            sqlHelper = new ERXSQLHelper();
                        } else if (databaseProductName.equalsIgnoreCase("frontbase")) {
                            sqlHelper = new FrontBaseSQLHelper();
                        } else if (databaseProductName.equalsIgnoreCase("mysql")) {
                            sqlHelper = new MySQLSQLHelper();
                        } else if (databaseProductName.equalsIgnoreCase("oracle")) {
                            sqlHelper = new OracleSQLHelper();
                        } else if (databaseProductName.equalsIgnoreCase("postgresql")) {
                            sqlHelper = new PostgresqlSQLHelper();
                        } else if (databaseProductName.equalsIgnoreCase("openbase")) {
                            sqlHelper = new OpenBaseSQLHelper();
                        } else if (databaseProductName.equalsIgnoreCase("derby")) {
                            sqlHelper = new DerbySQLHelper();
                        } else if (databaseProductName.equalsIgnoreCase("microsoft")) {
                            sqlHelper = new MicrosoftSQLHelper();
                        } else if (databaseProductName.equalsIgnoreCase("h2")) {
                            log.warn((Object)"H2Helper");
                            sqlHelper = new H2SQLHelper();
                        } else {
                            try {
                                sqlHelper = (ERXSQLHelper)Class.forName(ERXSQLHelper.class.getName() + "$" + databaseProductName + "SQLHelper").newInstance();
                            }
                            catch (ClassNotFoundException e) {
                                sqlHelper = new ERXSQLHelper();
                            }
                        }
                    } else {
                        sqlHelper = (ERXSQLHelper)Class.forName(sqlHelperClassName).newInstance();
                    }
                    _sqlHelperMap.put(databaseProductName, sqlHelper);
                }
                catch (Exception e) {
                    throw new NSForwardException((Throwable)e, "Failed to create sql helper for the database with the product name '" + databaseProductName + "'.");
                }
            }
            return sqlHelper;
        }
    }

    public static class NoSQLHelper
    extends ERXSQLHelper {
        public String sqlForCreateIndex(String indexName, String tableName, ColumnIndex ... columnIndexes) {
            return null;
        }
    }

    public static class MicrosoftSQLHelper
    extends ERXSQLHelper {
        protected Pattern commentPattern() {
            return Pattern.compile("^--");
        }

        public String externalTypeForJDBCType(JDBCAdaptor adaptor, int type) {
            if (type == 2004) {
                return "binary";
            }
            return super.externalTypeForJDBCType(adaptor, type);
        }

        public String limitExpressionForSQL(EOSQLExpression expression, EOFetchSpecification fetchSpecification, String sql, long start, long end) {
            String orderBy;
            if (sql == null || "".equals(sql)) {
                return sql;
            }
            String originalSql = sql.toLowerCase();
            int indexOfOrderByClause = originalSql.indexOf(" order by ");
            if (indexOfOrderByClause > 0) {
                orderBy = originalSql.substring(indexOfOrderByClause + 1, originalSql.length());
                originalSql = originalSql.substring(0, indexOfOrderByClause);
            } else {
                String columns = originalSql.substring(originalSql.indexOf("select ") + 7, originalSql.indexOf(" from "));
                orderBy = "order by " + columns.split(",")[0];
            }
            StringBuilder limitSqlBuilder = new StringBuilder(originalSql);
            limitSqlBuilder.insert(0, "select * from (");
            String rowNumberClause = ", row_number() over (" + orderBy + ") eo_rownum";
            limitSqlBuilder.insert(limitSqlBuilder.lastIndexOf(" from "), rowNumberClause);
            limitSqlBuilder.append(") as temp_row_number where eo_rownum >= ");
            limitSqlBuilder.append(start + 1L);
            limitSqlBuilder.append(" and eo_rownum < ");
            limitSqlBuilder.append(end + 1L);
            limitSqlBuilder.append(" order by eo_rownum");
            return limitSqlBuilder.toString();
        }
    }

    public static class PostgresqlSQLHelper
    extends ERXSQLHelper {
        protected String sqlForGetNextValFromSequencedNamed(String sequenceName) {
            return "select NEXTVAL('" + sequenceName + "') as key";
        }

        protected String formatValueForAttribute(EOSQLExpression expression, Object value, EOAttribute attribute, String key) {
            return expression.formatValueForAttribute(value, attribute);
        }

        public String limitExpressionForSQL(EOSQLExpression expression, EOFetchSpecification fetchSpecification, String sql, long start, long end) {
            return sql + " LIMIT " + (end - start) + " OFFSET " + start;
        }

        public String sqlForRegularExpressionQuery(String key, String value) {
            return key + " ~* " + value + "";
        }

        public String externalTypeForJDBCType(JDBCAdaptor adaptor, int jdbcType) {
            String externalType = jdbcType == 4 ? "int4" : (jdbcType == -5 ? "int8" : (jdbcType == 2004 ? "bytea" : (jdbcType == 16 ? "bool" : (jdbcType == 3 ? "numeric" : (jdbcType == 9001 ? "inet" : (jdbcType == -1 || jdbcType == 2005 ? "text" : super.externalTypeForJDBCType(adaptor, jdbcType)))))));
            return externalType;
        }

        public String sqlForCreateUniqueIndex(String indexName, String tableName, ColumnIndex ... columnIndexes) {
            NSMutableArray<String> columnNames = new NSMutableArray<String>();
            for (ColumnIndex columnIndex : columnIndexes) {
                columnNames.addObject(columnIndex.columnName());
            }
            return "CREATE UNIQUE INDEX " + indexName + " ON " + tableName + "(" + columnNames.componentsJoinedByString(",") + ")";
        }

        public String sqlForCreateIndex(String indexName, String tableName, ColumnIndex ... columnIndexes) {
            NSMutableArray<String> columnNames = new NSMutableArray<String>();
            for (ColumnIndex columnIndex : columnIndexes) {
                columnNames.addObject(columnIndex.columnName());
            }
            return "CREATE INDEX " + indexName + " ON " + tableName + "(" + columnNames.componentsJoinedByString(",") + ")";
        }

        public int varcharLargeJDBCType() {
            return -1;
        }

        public int varcharLargeColumnWidth() {
            return -1;
        }
    }

    public static class MySQLSQLHelper
    extends ERXSQLHelper {
        protected Pattern commentPattern() {
            return Pattern.compile("^--");
        }

        public String externalTypeForJDBCType(JDBCAdaptor adaptor, int jdbcType) {
            String externalType = jdbcType == -1 || jdbcType == 2005 ? "longtext" : super.externalTypeForJDBCType(adaptor, jdbcType);
            return externalType;
        }

        public String limitExpressionForSQL(EOSQLExpression expression, EOFetchSpecification fetchSpecification, String sql, long start, long end) {
            return sql + " LIMIT " + start + ", " + (end - start);
        }

        public String sqlForRegularExpressionQuery(String key, String value) {
            return key + " REGEXP " + value + "";
        }

        public String sqlForCreateUniqueIndex(String indexName, String tableName, ColumnIndex ... columnIndexes) {
            StringBuffer sql = new StringBuffer();
            sql.append("ALTER TABLE `" + tableName + "` ADD UNIQUE `" + indexName + "` (");
            this._appendIndexColNames(sql, columnIndexes);
            sql.append(")");
            return sql.toString();
        }

        public String sqlForCreateIndex(String indexName, String tableName, ColumnIndex ... columnIndexes) {
            StringBuffer sql = new StringBuffer();
            sql.append("CREATE INDEX `" + indexName + "` ON `" + tableName + "` (");
            this._appendIndexColNames(sql, columnIndexes);
            sql.append(")");
            return sql.toString();
        }

        private void _appendIndexColNames(StringBuffer sql, ColumnIndex ... columnIndexes) {
            for (int columnIndexNum = 0; columnIndexNum < columnIndexes.length; ++columnIndexNum) {
                ColumnIndex columnIndex = columnIndexes[columnIndexNum];
                sql.append("`" + columnIndex.columnName() + "`");
                if (columnIndex.hasLength()) {
                    int length = Math.min(columnIndex.length(), 255);
                    sql.append("(" + length + ")");
                }
                if (columnIndexNum >= columnIndexes.length - 1) continue;
                sql.append(", ");
            }
        }

        public int varcharLargeJDBCType() {
            return -1;
        }

        public int varcharLargeColumnWidth() {
            return -1;
        }
    }

    public static class FrontBaseSQLHelper
    extends ERXSQLHelper {
        private static final String PREFIX_ISOLATION_LEVEL = "isolation=";
        private static final String PREFIX_LOCKING = "locking=";

        public boolean reassignExternalTypeForValueTypeOverride(EOAttribute attribute) {
            boolean reassignExternalTypeForValueTypeOverride = super.reassignExternalTypeForValueTypeOverride(attribute);
            if ("DATE".equalsIgnoreCase(attribute.externalType()) && attribute.valueType() == null) {
                reassignExternalTypeForValueTypeOverride = false;
            }
            return reassignExternalTypeForValueTypeOverride;
        }

        protected String sqlForGetNextValFromSequencedNamed(String sequenceName) {
            return "select unique from " + sequenceName;
        }

        public boolean shouldExecute(String sql) {
            boolean shouldExecute = true;
            if (sql.startsWith("SET TRANSACTION ISOLATION LEVEL")) {
                shouldExecute = false;
            } else if (sql.startsWith("COMMIT")) {
                // empty if block
            }
            return shouldExecute;
        }

        public String limitExpressionForSQL(EOSQLExpression expression, EOFetchSpecification fetchSpecification, String sql, long start, long end) {
            int index = sql.indexOf("select");
            if (index == -1) {
                index = sql.indexOf("SELECT");
            }
            String limitSQL = sql.substring(0, index += 6) + " TOP(" + start + ", " + (end - start) + ") " + sql.substring(index + 1, sql.length());
            return limitSQL;
        }

        public String sqlForFullTextQuery(ERXFullTextQualifier qualifier, EOSQLExpression expression) {
            StringBuffer sb = new StringBuffer();
            sb.append("satisfies(");
            sb.append(qualifier.indexName());
            sb.append(", '");
            ERXFullTextQualifier.MatchType matchType = qualifier.matchType();
            NSArray<String> terms = qualifier.terms();
            for (String term : terms) {
                String[] termWords;
                for (String termWord : termWords = term.split(" ")) {
                    sb.append(termWord);
                    if (matchType == ERXFullTextQualifier.MatchType.ALL) {
                        sb.append('&');
                        continue;
                    }
                    if (matchType != ERXFullTextQualifier.MatchType.ANY) continue;
                    sb.append('|');
                }
            }
            if (terms.count() > 0) {
                sb.setLength(sb.length() - 1);
            }
            sb.append("')");
            return sb.toString();
        }

        public String sqlForCreateUniqueIndex(String indexName, String tableName, ColumnIndex ... columnIndexes) {
            NSMutableArray<String> columnNames = this.columnNamesFromColumnIndexes(columnIndexes);
            return "ALTER TABLE \"" + tableName + "\" ADD CONSTRAINT \"" + indexName + "\" UNIQUE(\"" + new NSArray<String>((NSArray<String>)columnNames).componentsJoinedByString("\", \"") + "\") DEFERRABLE INITIALLY DEFERRED";
        }

        public String sqlForCreateIndex(String indexName, String tableName, ColumnIndex ... columnIndexes) {
            NSMutableArray<String> columnNames = this.columnNamesFromColumnIndexes(columnIndexes);
            return "CREATE INDEX \"" + indexName + "\" ON \"" + tableName + "\" (\"" + new NSArray<String>((NSArray<String>)columnNames).componentsJoinedByString("\", \"") + "\")";
        }

        public void prepareConnectionForSchemaChange(EOEditingContext ec, EOModel model) {
            ERXEOAccessUtilities.ChannelAction action = new ERXEOAccessUtilities.ChannelAction(){

                protected int doPerform(EOAdaptorChannel channel) {
                    try {
                        ERXJDBCUtilities.executeUpdate(channel, "SET TRANSACTION ISOLATION LEVEL SERIALIZABLE, LOCKING PESSIMISTIC");
                    }
                    catch (SQLException e) {
                        throw new NSForwardException((Throwable)e);
                    }
                    return 0;
                }
            };
            action.perform(ec, model.name());
        }

        public void restoreConnectionSettingsAfterSchemaChange(EOEditingContext ec, EOModel model) {
            String transactionIsolationLevel = "SERIALIZABLE";
            String lockingDiscipline = "PESSIMISTIC";
            String url = (String)model.connectionDictionary().valueForKey("URL");
            NSArray<String> urlComponents = NSArray.componentsSeparatedByString(url, "/");
            for (String urlComponent : urlComponents) {
                if (urlComponent.toLowerCase().startsWith(PREFIX_LOCKING)) {
                    lockingDiscipline = urlComponent.substring(PREFIX_LOCKING.length()).toUpperCase();
                    continue;
                }
                if (!urlComponent.toLowerCase().startsWith(PREFIX_ISOLATION_LEVEL)) continue;
                transactionIsolationLevel = urlComponent.substring(PREFIX_ISOLATION_LEVEL.length()).toUpperCase().replaceAll("_", " ");
            }
            final String sql = "SET TRANSACTION ISOLATION LEVEL " + transactionIsolationLevel + ", LOCKING " + lockingDiscipline;
            ERXEOAccessUtilities.ChannelAction action = new ERXEOAccessUtilities.ChannelAction(){

                protected int doPerform(EOAdaptorChannel channel) {
                    try {
                        ERXJDBCUtilities.executeUpdate(channel, sql);
                    }
                    catch (SQLException e) {
                        throw new NSForwardException((Throwable)e);
                    }
                    return 0;
                }
            };
            action.perform(ec, model.name());
        }

        protected Pattern commentPattern() {
            return Pattern.compile("^--");
        }

        public String quoteColumnName(String columnName) {
            if (columnName == null) {
                return null;
            }
            int i = columnName.lastIndexOf(46);
            if (i == -1) {
                return "\"" + columnName + "\"";
            }
            return "\"" + columnName.substring(0, i) + "\".\"" + columnName.substring(i + 1, columnName.length()) + "\"";
        }

        protected int maximumElementPerInClause(EOEntity entity) {
            return 15000;
        }
    }

    public static class DerbySQLHelper
    extends ERXSQLHelper {
        public boolean shouldExecute(String sql) {
            return sql != null && !sql.startsWith("--");
        }

        public int varcharLargeJDBCType() {
            return 2005;
        }

        public int varcharLargeColumnWidth() {
            return 0;
        }

        public String sqlForCreateUniqueIndex(String indexName, String tableName, ColumnIndex ... columnIndexes) {
            NSMutableArray<String> columnNames = new NSMutableArray<String>();
            for (ColumnIndex columnIndex : columnIndexes) {
                columnNames.addObject(columnIndex.columnName());
            }
            return "CREATE UNIQUE INDEX " + indexName + " ON " + tableName + "(" + columnNames.componentsJoinedByString(",") + ")";
        }

        public String migrationTableName() {
            return "dbupdater";
        }

        public String externalTypeForJDBCType(JDBCAdaptor adaptor, int jdbcType) {
            String externalType = jdbcType == 93 ? "DATE" : super.externalTypeForJDBCType(adaptor, jdbcType);
            return externalType;
        }
    }

    public static class H2SQLHelper
    extends ERXSQLHelper {
        public String limitExpressionForSQL(EOSQLExpression expression, EOFetchSpecification fetchSpecification, String sql, long start, long end) {
            return sql + " LIMIT " + (end - start) + " OFFSET " + start;
        }

        public String sqlForCreateUniqueIndex(String indexName, String tableName, ColumnIndex ... columnIndexes) {
            NSMutableArray<String> columnNames = this.columnNamesFromColumnIndexes(columnIndexes);
            return "ALTER TABLE " + tableName + " ADD CONSTRAINT \"" + indexName + "\" UNIQUE(" + new NSArray<String>((NSArray<String>)columnNames).componentsJoinedByString(", ") + ")";
        }

        public String sqlForCreateIndex(String indexName, String tableName, ColumnIndex ... columnIndexes) {
            NSMutableArray<String> columnNames = this.columnNamesFromColumnIndexes(columnIndexes);
            return "CREATE INDEX \"" + indexName + "\" ON " + tableName + " (" + new NSArray<String>((NSArray<String>)columnNames).componentsJoinedByString(", ") + ")";
        }

        protected String sqlForGetNextValFromSequencedNamed(String sequenceName) {
            return "select NEXTVAL('" + sequenceName + "') as key";
        }

        public String sqlForRegularExpressionQuery(String key, String value) {
            return key + " REGEXP " + value + "";
        }

        public int varcharLargeJDBCType() {
            return -1;
        }

        public int varcharLargeColumnWidth() {
            return -1;
        }
    }

    public static class OpenBaseSQLHelper
    extends ERXSQLHelper {
        public String limitExpressionForSQL(EOSQLExpression expression, EOFetchSpecification fetchSpecification, String sql, long start, long end) {
            return sql + " return results " + start + " to " + end;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OracleSQLHelper
    extends ERXSQLHelper {
        @Override
        protected String sqlForSubquery(String subquery, String alias) {
            return "(" + subquery + ") " + alias;
        }

        @Override
        protected String sqlForGetNextValFromSequencedNamed(String sequenceName) {
            String sqlString = "select " + sequenceName + ".nextVal from dual";
            return sqlString;
        }

        @Override
        public String createSchemaSQLForEntitiesInModelWithNameAndOptions(NSArray<EOEntity> entities, String modelName, NSDictionary optionsCreate) {
            String oldConstraintName = null;
            int i = 0;
            String s = super.createSchemaSQLForEntitiesInModelWithNameAndOptions(entities, modelName, optionsCreate);
            NSArray<String> a = NSArray.componentsSeparatedByString(s, "/");
            StringBuffer buf = new StringBuffer(s.length());
            Pattern pattern = Pattern.compile(".*ALTER TABLE .* ADD CONSTRAINT (.*) FOREIGN KEY .* REFERENCES .* \\(.*\\) DEFERRABLE INITIALLY DEFERRED.*");
            Pattern pattern2 = Pattern.compile("(.*ALTER TABLE .* ADD CONSTRAINT ).*( FOREIGN KEY .* REFERENCES .* \\(.*\\) DEFERRABLE INITIALLY DEFERRED.*)");
            String lineSeparator = System.getProperty("line.separator");
            Enumeration<String> e = a.objectEnumerator();
            while (e.hasMoreElements()) {
                String statementLine = e.nextElement();
                NSArray<String> b = NSArray.componentsSeparatedByString(statementLine, lineSeparator);
                Enumeration<String> e1 = b.objectEnumerator();
                while (e1.hasMoreElements()) {
                    String newConstraintName;
                    String statement = e1.nextElement();
                    if (!pattern.matcher(statement).matches()) {
                        buf.append(statement);
                        buf.append(lineSeparator);
                        continue;
                    }
                    String constraintName = pattern.matcher(statement).replaceAll("$1");
                    if (constraintName.length() <= 30) {
                        buf.append(statement);
                        buf.append(lineSeparator);
                        continue;
                    }
                    constraintName = "fk" + System.currentTimeMillis() + new NSTimestamp().getNanos();
                    String string = newConstraintName = i == 0 ? constraintName : constraintName + "_" + i;
                    if (oldConstraintName == null) {
                        oldConstraintName = constraintName;
                    } else if (oldConstraintName.equals(newConstraintName)) {
                        constraintName = constraintName + "_" + ++i;
                    } else {
                        i = 0;
                    }
                    oldConstraintName = constraintName;
                    String newConstraint = pattern2.matcher(statement).replaceAll("$1" + constraintName + "$2");
                    buf.append(newConstraint);
                    buf.append(lineSeparator);
                }
                if (!e.hasMoreElements()) continue;
                buf.append("/");
            }
            return buf.toString();
        }

        @Override
        public String limitExpressionForSQL(EOSQLExpression expression, EOFetchSpecification fetchSpecification, String sql, long start, long end) {
            int debug = ERXProperties.intForKeyWithDefault("OracleBatchMode", 3);
            String limitSQL = debug == 1 ? "select * from (" + sql + ") where rownum between " + (start + 1L) + " and " + end : (debug == 2 ? "select * from (select " + expression.listString() + ", row_number() over (" + expression.orderByString() + ") as eo_rownum from (" + sql + ")) where eo_rownum between " + (start + 1L) + " and " + end : (debug == 3 ? (expression != null ? "select * from (select " + expression.listString().replaceAll("[Tt]\\d\\.", "") + ", rownum eo_rownum from (" + sql + ")) where eo_rownum between " + (start + 1L) + " and " + end : "select * from (select a.*, rownum eo_rownum from (" + sql + ") a where rownum <= " + end + ") where eo_rownum >= " + (start + 1L)) : "select * from (select " + (fetchSpecification.usesDistinct() ? " distinct " : "") + expression.listString() + ", row_number() over (" + expression.orderByString() + ") eo_rownum" + " from " + expression.joinClauseString() + " where " + expression.whereClauseString() + ") where eo_rownum between " + (start + 1L) + " and " + end));
            return limitSQL;
        }

        @Override
        protected char commandSeparatorChar() {
            return '/';
        }

        @Override
        protected String commandSeparatorString() {
            String lineSeparator = System.getProperty("line.separator");
            String commandSeparator = lineSeparator + "/" + lineSeparator;
            return commandSeparator;
        }

        @Override
        public String createIndexSQLForEntities(NSArray<EOEntity> entities, NSArray<String> externalTypesToIgnore) {
            NSMutableArray<String> oracleExternalTypesToIgnore = new NSMutableArray<String>();
            if (externalTypesToIgnore != null) {
                oracleExternalTypesToIgnore.addObjectsFromArray(externalTypesToIgnore);
            }
            oracleExternalTypesToIgnore.addObject("BLOB");
            oracleExternalTypesToIgnore.addObject("CLOB");
            return super.createIndexSQLForEntities(entities, oracleExternalTypesToIgnore);
        }

        @Override
        public String sqlForCreateUniqueIndex(String indexName, String tableName, ColumnIndex ... columnIndexes) {
            NSMutableArray<String> columnNames = new NSMutableArray<String>();
            for (ColumnIndex columnIndex : columnIndexes) {
                columnNames.addObject(columnIndex.columnName());
            }
            return "CREATE UNIQUE INDEX " + indexName + " ON " + tableName + "(" + columnNames.componentsJoinedByString(",") + ")";
        }

        @Override
        public String sqlForCreateIndex(String indexName, String tableName, ColumnIndex ... columnIndexes) {
            NSMutableArray<String> columnNames = new NSMutableArray<String>();
            for (ColumnIndex columnIndex : columnIndexes) {
                columnNames.addObject(columnIndex.columnName());
            }
            return "CREATE INDEX " + indexName + " ON " + tableName + "(" + columnNames.componentsJoinedByString(",") + ")";
        }

        @Override
        public String sqlForRegularExpressionQuery(String key, String value) {
            return "REGEXP_LIKE(" + key + ", " + value + ")";
        }

        @Override
        public String migrationTableName() {
            return "dbupdater";
        }

        @Override
        public String externalTypeForJDBCType(JDBCAdaptor adaptor, int jdbcType) {
            String externalType = jdbcType == 93 ? "DATE" : super.externalTypeForJDBCType(adaptor, jdbcType);
            return externalType;
        }

        @Override
        public boolean reassignExternalTypeForValueTypeOverride(EOAttribute attribute) {
            return false;
        }

        @Override
        protected boolean canReliablyPerformDistinctWithSortOrderings() {
            return false;
        }

        @Override
        public int varcharLargeJDBCType() {
            return 2005;
        }

        @Override
        public int varcharLargeColumnWidth() {
            return -1;
        }
    }

    public static class EROracleSQLHelper
    extends OracleSQLHelper {
    }

    public static class ColumnIndex {
        private String _columnName;
        private int _length;

        public ColumnIndex(String columnName) {
            this(columnName, 0);
        }

        public ColumnIndex(String columnName, int length) {
            this._columnName = columnName;
            this._length = length;
        }

        public String columnName() {
            return this._columnName;
        }

        public int length() {
            return this._length;
        }

        public boolean hasLength() {
            return this._length > 0;
        }

        public String toString() {
            return "[ColumnIndex: columnName = " + this._columnName + "; length = " + this._length + "]";
        }
    }

    public static interface CustomTypes {
        public static final int INET = 9001;
    }
}

