/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.localization;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSTimestampFormatter;
import er.extensions.ERXExtensions;
import er.extensions.appserver.ERXWOContext;
import er.extensions.eof.ERXConstant;
import er.extensions.formatters.ERXNumberFormatter;
import er.extensions.foundation.ERXDictionaryUtilities;
import er.extensions.foundation.ERXFileNotificationCenter;
import er.extensions.foundation.ERXFileUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXSimpleTemplateParser;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.foundation.ERXThreadStorage;
import er.extensions.localization.ERXNonPluralFormLocalizer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.DateFormatSymbols;
import java.text.Format;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXLocalizer
implements NSKeyValueCoding,
NSKeyValueCodingAdditions {
    public static final String KEY_LOCALIZER_EXCEPTIONS = "localizerExceptions";
    protected static final Logger log = Logger.getLogger(ERXLocalizer.class);
    protected static final Logger createdKeysLog = Logger.getLogger((String)(ERXLocalizer.class.getName() + ".createdKeys"));
    private static boolean isLocalizationEnabled = true;
    private static boolean isInitialized = false;
    private static Boolean _useLocalizedFormatters;
    private static Boolean _fallbackToDefaultLanguage;
    public static final String LocalizationDidResetNotification = "LocalizationDidReset";
    private static Observer observer;
    private static NSMutableArray monitoredFiles;
    private static final char _localizerMethodIndicatorCharacter = '@';
    static NSArray<String> fileNamesToWatch;
    static NSArray<String> frameworkSearchPath;
    static NSArray<String> availableLanguages;
    static String defaultLanguage;
    static NSMutableDictionary localizers;
    private static NSArray _languagesWithoutPluralForm;
    protected NSMutableDictionary cache;
    private NSMutableDictionary createdKeys;
    private String NOT_FOUND = "**NOT_FOUND**";
    protected Hashtable _dateFormatters = new Hashtable();
    protected Hashtable _numberFormatters = new Hashtable();
    protected String language;
    protected Locale locale;
    private Map _plurifyRules = new HashMap();
    private Map _singularifyRules = new HashMap();

    public static void initialize() {
        if (!isInitialized) {
            isLocalizationEnabled = ERXProperties.booleanForKeyWithDefault("er.extensions.ERXLocalizer.isLocalizationEnabled", true);
            isInitialized = true;
        }
    }

    public static boolean isLocalizationEnabled() {
        return isLocalizationEnabled;
    }

    public static void setIsLocalizationEnabled(boolean value) {
        isLocalizationEnabled = value;
    }

    public static ERXLocalizer currentLocalizer() {
        ERXLocalizer current = (ERXLocalizer)ERXThreadStorage.valueForKey("localizer");
        if (current == null) {
            WOContext context;
            if (!isInitialized) {
                ERXLocalizer.initialize();
            }
            if ((context = ERXWOContext.currentContext()) != null && context.request() != null && context.request().browserLanguages() != null) {
                current = ERXLocalizer.localizerForLanguages(context.request().browserLanguages());
                ERXLocalizer.setCurrentLocalizer(current);
            } else {
                current = ERXLocalizer.defaultLocalizer();
            }
        }
        return current;
    }

    public static void setCurrentLocalizer(ERXLocalizer currentLocalizer) {
        ERXThreadStorage.takeValueForKey(currentLocalizer, "localizer");
    }

    public static ERXLocalizer defaultLocalizer() {
        return ERXLocalizer.localizerForLanguage(ERXLocalizer.defaultLanguage());
    }

    public static ERXLocalizer englishLocalizer() {
        return ERXLocalizer.localizerForLanguage("English");
    }

    public static ERXLocalizer localizerForRequest(WORequest request) {
        return ERXLocalizer.localizerForLanguages(request.browserLanguages());
    }

    public static void resetCache() {
        ERXLocalizer.initialize();
        if (WOApplication.application().isCachingEnabled()) {
            Enumeration e = localizers.objectEnumerator();
            while (e.hasMoreElements()) {
                ((ERXLocalizer)e.nextElement()).load();
            }
        } else {
            localizers = new NSMutableDictionary();
        }
    }

    protected void addToCreatedKeys(Object value, String key) {
        if (key != null && value != null) {
            this.createdKeys.takeValueForKey(value, key);
            if (key.indexOf(" ") > 0) {
                log.info((Object)("Value added: " + key + "->" + value + " in " + NSPropertyListSerialization.stringFromPropertyList(ERXWOContext.componentPath(ERXWOContext.currentContext()))));
            }
        }
    }

    public static ERXLocalizer localizerForLanguages(NSArray languages) {
        if (!isLocalizationEnabled) {
            return ERXLocalizer.createLocalizerForLanguage("Nonlocalized", false);
        }
        if (languages == null || languages.count() == 0) {
            return ERXLocalizer.localizerForLanguage(ERXLocalizer.defaultLanguage());
        }
        ERXLocalizer l = null;
        Enumeration e = languages.objectEnumerator();
        while (e.hasMoreElements()) {
            String language = (String)e.nextElement();
            l = (ERXLocalizer)localizers.objectForKey(language);
            if (l != null) {
                return l;
            }
            if (ERXLocalizer.availableLanguages().containsObject(language)) {
                return ERXLocalizer.localizerForLanguage(language);
            }
            int index = language.indexOf(95);
            if (index <= 0) continue;
            language = language.substring(0, index);
            if (!ERXLocalizer.availableLanguages().containsObject(language)) continue;
            return ERXLocalizer.localizerForLanguage(language);
        }
        return ERXLocalizer.localizerForLanguage((String)languages.objectAtIndex(0));
    }

    public static ERXLocalizer localizerForLanguage(String language) {
        if (!isLocalizationEnabled) {
            return ERXLocalizer.createLocalizerForLanguage("Nonlocalized", false);
        }
        ERXLocalizer l = null;
        l = (ERXLocalizer)localizers.objectForKey(language);
        if (l == null) {
            if (ERXLocalizer.availableLanguages().containsObject(language)) {
                l = _languagesWithoutPluralForm.containsObject(language) ? ERXLocalizer.createLocalizerForLanguage(language, false) : ERXLocalizer.createLocalizerForLanguage(language, true);
            } else {
                l = (ERXLocalizer)localizers.objectForKey(ERXLocalizer.defaultLanguage());
                if (l == null) {
                    l = _languagesWithoutPluralForm.containsObject(ERXLocalizer.defaultLanguage()) ? ERXLocalizer.createLocalizerForLanguage(ERXLocalizer.defaultLanguage(), false) : ERXLocalizer.createLocalizerForLanguage(ERXLocalizer.defaultLanguage(), true);
                    localizers.setObjectForKey(l, ERXLocalizer.defaultLanguage());
                }
            }
            localizers.setObjectForKey(l, language);
        }
        return l;
    }

    public static String defaultLanguage() {
        if (defaultLanguage == null) {
            defaultLanguage = ERXProperties.stringForKeyWithDefault("er.extensions.ERXLocalizer.defaultLanguage", "English");
        }
        return defaultLanguage;
    }

    public static void setDefaultLanguage(String value) {
        defaultLanguage = value;
        ERXLocalizer.resetCache();
    }

    public static NSArray fileNamesToWatch() {
        if (fileNamesToWatch == null) {
            fileNamesToWatch = ERXProperties.arrayForKeyWithDefault("er.extensions.ERXLocalizer.fileNamesToWatch", new NSArray<Object>(new Object[]{"Localizable.strings", "ValidationTemplate.strings"}));
            if (log.isDebugEnabled()) {
                log.debug((Object)("FileNamesToWatch: " + fileNamesToWatch));
            }
        }
        return fileNamesToWatch;
    }

    public static void setFileNamesToWatch(NSArray value) {
        fileNamesToWatch = value;
        ERXLocalizer.resetCache();
    }

    public static NSArray<String> availableLanguages() {
        if (availableLanguages == null) {
            availableLanguages = ERXProperties.arrayForKeyWithDefault("er.extensions.ERXLocalizer.availableLanguages", new NSArray<String>(new String[]{"English", "German", "Japanese"}));
            if (log.isDebugEnabled()) {
                log.debug((Object)("AvailableLanguages: " + availableLanguages));
            }
        }
        return availableLanguages;
    }

    public static void setAvailableLanguages(NSArray<String> value) {
        availableLanguages = value;
        ERXLocalizer.resetCache();
    }

    public static NSArray<String> frameworkSearchPath() {
        if (frameworkSearchPath == null) {
            frameworkSearchPath = ERXProperties.arrayForKey("er.extensions.ERXLocalizer.frameworkSearchPath");
            if (frameworkSearchPath == null) {
                NSMutableArray<String> defaultValue = new NSMutableArray<String>();
                Enumeration e = NSBundle.frameworkBundles().objectEnumerator();
                while (e.hasMoreElements()) {
                    NSBundle bundle = (NSBundle)e.nextElement();
                    String name = bundle.name();
                    if (name.equals("ERCoreBusinessLogic") || name.equals("ERDirectToWeb") || name.equals("ERExtensions")) continue;
                    defaultValue.addObject(name);
                }
                if (NSBundle.bundleForName((String)"ERCoreBusinessLogic") != null) {
                    defaultValue.addObject("ERCoreBusinessLogic");
                }
                if (NSBundle.bundleForName((String)"ERDirectToWeb") != null) {
                    defaultValue.addObject("ERDirectToWeb");
                }
                if (NSBundle.bundleForName((String)"ERExtensions") != null) {
                    defaultValue.addObject("ERExtensions");
                }
                defaultValue.insertObjectAtIndex("app", 0);
                frameworkSearchPath = defaultValue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("FrameworkSearchPath: " + frameworkSearchPath));
            }
        }
        return frameworkSearchPath;
    }

    public static void setFrameworkSearchPath(NSArray value) {
        frameworkSearchPath = value;
        ERXLocalizer.resetCache();
    }

    protected static ERXLocalizer createLocalizerForLanguage(String language, boolean pluralForm) {
        ERXLocalizer localizer = null;
        String className = null;
        className = pluralForm ? ERXProperties.stringForKeyWithDefault("er.extensions.ERXLocalizer.pluralFormClassName", ERXLocalizer.class.getName()) : ERXProperties.stringForKeyWithDefault("er.extensions.ERXLocalizer.nonPluralFormClassName", ERXNonPluralFormLocalizer.class.getName());
        try {
            Class<?> localizerClass = Class.forName(className);
            Constructor<?> constructor = localizerClass.getConstructor(ERXConstant.StringClassArray);
            localizer = (ERXLocalizer)constructor.newInstance(language);
        }
        catch (Exception e) {
            log.error((Object)("Unable to create localizer for language \"" + language + "\" class name: " + className + " exception: " + e.getMessage() + ", will use default classes"), (Throwable)e);
        }
        if (localizer == null) {
            localizer = pluralForm ? new ERXLocalizer(language) : new ERXNonPluralFormLocalizer(language);
        }
        return localizer;
    }

    public static void setLocalizerForLanguage(ERXLocalizer l, String language) {
        localizers.setObjectForKey(l, language);
    }

    public ERXLocalizer(String aLanguage) {
        NSDictionary dict;
        NSArray keys;
        this.language = aLanguage;
        this.cache = new NSMutableDictionary();
        this.createdKeys = new NSMutableDictionary();
        String shortLanguage = System.getProperty("er.extensions.ERXLocalizer." + aLanguage + ".locale");
        if (shortLanguage == null && (keys = (dict = ERXDictionaryUtilities.dictionaryFromPropertyList("Languages", NSBundle.bundleForName((String)"JavaWebObjects"))).allKeysForObject(aLanguage)).count() > 0) {
            shortLanguage = (String)keys.objectAtIndex(0);
            if (keys.count() > 1) {
                log.info((Object)("Found multiple entries for language \"" + aLanguage + "\" in Language.plist file! Found keys: " + keys));
            }
        }
        if (shortLanguage != null) {
            this.locale = new Locale(shortLanguage);
        } else {
            log.info((Object)("Locale for " + aLanguage + " not found! Using default locale: " + Locale.getDefault()));
            this.locale = Locale.getDefault();
        }
        this.load();
    }

    public NSDictionary cache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        this.cache.removeAllObjects();
        this.createdKeys.removeAllObjects();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading templates for language: " + this.language + " for files: " + ERXLocalizer.fileNamesToWatch() + " with search path: " + ERXLocalizer.frameworkSearchPath()));
        }
        NSArray<String> languages = new NSArray<String>(this.language);
        Enumeration fn = ERXLocalizer.fileNamesToWatch().objectEnumerator();
        while (fn.hasMoreElements()) {
            String fileName = (String)fn.nextElement();
            Enumeration<String> fr = ERXLocalizer.frameworkSearchPath().reverseObjectEnumerator();
            while (fr.hasMoreElements()) {
                String framework = fr.nextElement();
                URL path = ERXFileUtilities.pathURLForResourceNamed(fileName, framework, languages);
                if (path != null) {
                    try {
                        framework = "app".equals(framework) ? null : framework;
                        log.debug((Object)("Loading: " + fileName + " - " + (framework == null ? "app" : framework) + " - " + languages + path));
                        NSMutableDictionary dict = (NSMutableDictionary)ERXExtensions.readPropertyListFromFileInFramework(fileName, framework, languages);
                        if (fileName.indexOf("ValidationTemplate.") == 0) {
                            NSMutableDictionary newDict = new NSMutableDictionary();
                            Enumeration keys = dict.keyEnumerator();
                            while (keys.hasMoreElements()) {
                                String key = (String)keys.nextElement();
                                newDict.setObjectForKey(dict.objectForKey(key), "ValidationTemplate." + key);
                            }
                            dict = newDict;
                        }
                        this.addEntriesToCache(dict);
                        if (WOApplication.application().isCachingEnabled()) continue;
                        NSMutableArray nSMutableArray = monitoredFiles;
                        synchronized (nSMutableArray) {
                            if (!monitoredFiles.containsObject(path)) {
                                ERXFileNotificationCenter.defaultCenter().addObserver((Object)observer, new NSSelector("fileDidChange", ERXConstant.NotificationClassArray), path.getFile());
                                monitoredFiles.addObject(path);
                            }
                            continue;
                        }
                    }
                    catch (Exception ex) {
                        log.warn((Object)("Exception loading: " + fileName + " - " + (framework == null ? "app" : framework) + " - " + languages + ":" + ex), (Throwable)ex);
                        continue;
                    }
                }
                log.debug((Object)("Unable to create path for resource named: " + fileName + " framework: " + (framework == null ? "app" : framework) + " languages: " + languages));
            }
        }
        this._plurifyRules = this.plurifyRules();
        this._singularifyRules = this.singularifyRules();
    }

    protected Map plurifyRules() {
        LinkedHashMap<Pattern, String> plurifyRules;
        String plurifyRulesStr = ERXProperties.stringForKeyWithDefault("er.extensions.ERXLocalizer." + this.language + ".plurifyRules", null);
        if (plurifyRulesStr == null) {
            plurifyRules = this.defaultPlurifyRules();
        } else {
            plurifyRules = new LinkedHashMap<Pattern, String>();
            String[] rulePairs = plurifyRulesStr.split(":");
            for (int i = 0; i < rulePairs.length; ++i) {
                String[] rulePair = rulePairs[i].split("=");
                Pattern pattern = Pattern.compile(rulePair[0], 2);
                plurifyRules.put(pattern, rulePair[1]);
            }
        }
        return plurifyRules;
    }

    protected Map defaultPlurifyRules() {
        LinkedHashMap<Pattern, String> defaultPlurifyRules = new LinkedHashMap<Pattern, String>();
        defaultPlurifyRules.put(Pattern.compile("^equipment$", 2), "equipment");
        defaultPlurifyRules.put(Pattern.compile("^information$", 2), "information");
        defaultPlurifyRules.put(Pattern.compile("^rice$", 2), "rice");
        defaultPlurifyRules.put(Pattern.compile("^money$", 2), "money");
        defaultPlurifyRules.put(Pattern.compile("^species$", 2), "species");
        defaultPlurifyRules.put(Pattern.compile("^series$", 2), "series");
        defaultPlurifyRules.put(Pattern.compile("^fish$", 2), "fish");
        defaultPlurifyRules.put(Pattern.compile("^sheep$", 2), "sheep");
        defaultPlurifyRules.put(Pattern.compile("(.*)person$", 2), "$1people");
        defaultPlurifyRules.put(Pattern.compile("(.*)man$", 2), "$1men");
        defaultPlurifyRules.put(Pattern.compile("(.*)child$", 2), "$1children");
        defaultPlurifyRules.put(Pattern.compile("(.*)sex$", 2), "$1sexes");
        defaultPlurifyRules.put(Pattern.compile("(.*)move$", 2), "$1moves");
        defaultPlurifyRules.put(Pattern.compile("(.*)(quiz)$", 2), "$1$2zes");
        defaultPlurifyRules.put(Pattern.compile("(.*)^(ox)$", 2), "$1$2en");
        defaultPlurifyRules.put(Pattern.compile("(.*)([m|l])ouse$", 2), "$1$2ice");
        defaultPlurifyRules.put(Pattern.compile("(.*)(matr|vert|ind)ix|ex$", 2), "$1$2ices");
        defaultPlurifyRules.put(Pattern.compile("(.*)(x|ch|ss|sh)$", 2), "$1$2es");
        defaultPlurifyRules.put(Pattern.compile("(.*)([^aeiouy]|qu)y$", 2), "$1$2ies");
        defaultPlurifyRules.put(Pattern.compile("(.*)(hive)$", 2), "$1$2s");
        defaultPlurifyRules.put(Pattern.compile("(.*)(?:([^f])fe|([lr])f)$", 2), "$1$2$3ves");
        defaultPlurifyRules.put(Pattern.compile("(.*)sis$", 2), "$1ses");
        defaultPlurifyRules.put(Pattern.compile("(.*)([ti])um$", 2), "$1$2a");
        defaultPlurifyRules.put(Pattern.compile("(.*)(buffal|tomat)o$", 2), "$1$2oes");
        defaultPlurifyRules.put(Pattern.compile("(.*)(bu)s$", 2), "$1$2ses");
        defaultPlurifyRules.put(Pattern.compile("(.*)(alias|status)$", 2), "$1$2es");
        defaultPlurifyRules.put(Pattern.compile("(.*)(octop|vir)us$", 2), "$1$2i");
        defaultPlurifyRules.put(Pattern.compile("(.*)(ax|test)is$", 2), "$1$2es");
        defaultPlurifyRules.put(Pattern.compile("(.*)s$", 2), "$1s");
        defaultPlurifyRules.put(Pattern.compile("(.*)$", 2), "$1s");
        return defaultPlurifyRules;
    }

    protected Map singularifyRules() {
        LinkedHashMap<Pattern, String> singularifyRules;
        String plurifyRulesStr = ERXProperties.stringForKeyWithDefault("er.extensions.ERXLocalizer." + this.language + ".singularifyRules", null);
        if (plurifyRulesStr == null) {
            singularifyRules = this.defaultSingularifyRules();
        } else {
            singularifyRules = new LinkedHashMap<Pattern, String>();
            String[] rulePairs = plurifyRulesStr.split(":");
            for (int i = 0; i < rulePairs.length; ++i) {
                String[] rulePair = rulePairs[i].split("=");
                Pattern pattern = Pattern.compile(rulePair[0], 2);
                singularifyRules.put(pattern, rulePair[1]);
            }
        }
        return singularifyRules;
    }

    protected Map defaultSingularifyRules() {
        LinkedHashMap<Pattern, String> defaultSingularifyRules = new LinkedHashMap<Pattern, String>();
        defaultSingularifyRules.put(Pattern.compile("^equipment$", 2), "equipment");
        defaultSingularifyRules.put(Pattern.compile("^information$", 2), "information");
        defaultSingularifyRules.put(Pattern.compile("^rice$", 2), "rice");
        defaultSingularifyRules.put(Pattern.compile("^money$", 2), "money");
        defaultSingularifyRules.put(Pattern.compile("^species$", 2), "species");
        defaultSingularifyRules.put(Pattern.compile("^series$", 2), "series");
        defaultSingularifyRules.put(Pattern.compile("^fish$", 2), "fish");
        defaultSingularifyRules.put(Pattern.compile("^sheep$", 2), "sheep");
        defaultSingularifyRules.put(Pattern.compile("(.*)people$", 2), "$1person");
        defaultSingularifyRules.put(Pattern.compile("(.*)men$", 2), "$1man");
        defaultSingularifyRules.put(Pattern.compile("(.*)children$", 2), "$1child");
        defaultSingularifyRules.put(Pattern.compile("(.*)sexes$", 2), "$1sex");
        defaultSingularifyRules.put(Pattern.compile("(.*)moves$", 2), "$1move");
        defaultSingularifyRules.put(Pattern.compile("(.*)(quiz)zes$", 2), "$1$2");
        defaultSingularifyRules.put(Pattern.compile("(.*)(matr)ices$", 2), "$1$2ix");
        defaultSingularifyRules.put(Pattern.compile("(.*)(vert|ind)ices$", 2), "$1$2ex");
        defaultSingularifyRules.put(Pattern.compile("(.*)^(ox)en", 2), "$1$2");
        defaultSingularifyRules.put(Pattern.compile("(.*)(alias|status)es$", 2), "$1$2");
        defaultSingularifyRules.put(Pattern.compile("(.*)(octop|vir)i$", 2), "$1$2us");
        defaultSingularifyRules.put(Pattern.compile("(.*)(cris|ax|test)es$", 2), "$1$2is");
        defaultSingularifyRules.put(Pattern.compile("(.*)(shoe)s$", 2), "$1$2");
        defaultSingularifyRules.put(Pattern.compile("(.*)(o)es$", 2), "$1$2");
        defaultSingularifyRules.put(Pattern.compile("(.*)(bus)es$", 2), "$1$2");
        defaultSingularifyRules.put(Pattern.compile("(.*)([m|l])ice$", 2), "$1$2ouse");
        defaultSingularifyRules.put(Pattern.compile("(.*)(x|ch|ss|sh)es$", 2), "$1$2");
        defaultSingularifyRules.put(Pattern.compile("(.*)(m)ovies$", 2), "$1$2ovie");
        defaultSingularifyRules.put(Pattern.compile("(.*)(s)eries$", 2), "$1$2eries");
        defaultSingularifyRules.put(Pattern.compile("(.*)([^aeiouy]|qu)ies$", 2), "$1$2y");
        defaultSingularifyRules.put(Pattern.compile("(.*)([lr])ves$", 2), "$1$2f");
        defaultSingularifyRules.put(Pattern.compile("(.*)(tive)s$", 2), "$1$2");
        defaultSingularifyRules.put(Pattern.compile("(.*)(hive)s$", 2), "$1$2");
        defaultSingularifyRules.put(Pattern.compile("(.*)([^f])ves$", 2), "$1$2fe");
        defaultSingularifyRules.put(Pattern.compile("(.*)(^analy)ses$", 2), "$1$2sis");
        defaultSingularifyRules.put(Pattern.compile("(.*)((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)ses$", 2), "$1$2$3sis");
        defaultSingularifyRules.put(Pattern.compile("(.*)([ti])a$", 2), "$1$2um");
        defaultSingularifyRules.put(Pattern.compile("(.*)(n)ews$", 2), "$1$2ews");
        defaultSingularifyRules.put(Pattern.compile("(.*)s$", 2), "$1");
        return defaultSingularifyRules;
    }

    protected void addEntriesToCache(NSDictionary dict) {
        try {
            NSDictionary currentLEs = (NSDictionary)this.cache.valueForKey(KEY_LOCALIZER_EXCEPTIONS);
            NSDictionary newLEs = (NSDictionary)dict.valueForKey(KEY_LOCALIZER_EXCEPTIONS);
            if (currentLEs != null && newLEs != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Merging localizerExceptions " + currentLEs + " with " + newLEs));
                }
                NSMutableDictionary combinedLEs = currentLEs.mutableClone();
                combinedLEs.addEntriesFromDictionary(newLEs);
                NSMutableDictionary replacementDict = ((NSDictionary)dict).mutableClone();
                replacementDict.takeValueForKey(combinedLEs, KEY_LOCALIZER_EXCEPTIONS);
                dict = replacementDict;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Result of merge: " + combinedLEs));
                }
            }
        }
        catch (RuntimeException e) {
            log.error((Object)"Error while adding enties to cache", (Throwable)e);
        }
        this.cache.addEntriesFromDictionary(dict);
    }

    protected NSDictionary readPropertyListFromFileInFramework(String fileName, String framework, NSArray languages) {
        NSDictionary dict = (NSDictionary)ERXExtensions.readPropertyListFromFileInFramework(fileName, framework, languages);
        return dict;
    }

    public Object valueForKey(String key) {
        return this.valueForKeyPath(key);
    }

    protected void setCacheValueForKey(Object value, String key) {
        if (key != null && value != null) {
            this.cache.setObjectForKey(value, key);
        }
    }

    public Object valueForKeyPath(String key) {
        int indexOfDot;
        Object result = this.localizedValueForKey(key);
        if (result == null && (indexOfDot = key.indexOf(".")) > 0) {
            String firstComponent = key.substring(0, indexOfDot);
            String otherComponents = key.substring(indexOfDot + 1, key.length());
            result = this.cache.objectForKey(firstComponent);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Trying " + firstComponent + " . " + otherComponents));
            }
            if (result != null) {
                try {
                    result = NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)result, (String)otherComponents);
                    if (result != null) {
                        this.setCacheValueForKey(result, key);
                    } else {
                        this.setCacheValueForKey(this.NOT_FOUND, key);
                    }
                }
                catch (NSKeyValueCoding.UnknownKeyException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)e.getMessage());
                    }
                    this.setCacheValueForKey(this.NOT_FOUND, key);
                }
            }
        }
        return result;
    }

    public void takeValueForKey(Object value, String key) {
        this.setCacheValueForKey(value, key);
        this.addToCreatedKeys(value, key);
    }

    public void takeValueForKeyPath(Object value, String key) {
        this.setCacheValueForKey(value, key);
        this.addToCreatedKeys(value, key);
    }

    public String language() {
        return this.language;
    }

    public NSDictionary createdKeys() {
        return this.createdKeys;
    }

    public void dumpCreatedKeys() {
        log.info((Object)NSPropertyListSerialization.stringFromPropertyList((Object)this.createdKeys()));
    }

    public Object localizedValueForKeyWithDefault(String key) {
        if (key == null) {
            log.warn((Object)"Attempt to insert null key!");
            return null;
        }
        Object result = this.localizedValueForKey(key);
        if (result == null || result == this.NOT_FOUND) {
            if (createdKeysLog.isDebugEnabled()) {
                createdKeysLog.debug((Object)("Default key inserted: '" + key + "'/" + this.language));
            }
            this.setCacheValueForKey(key, key);
            this.addToCreatedKeys(key, key);
            result = key;
        }
        return result;
    }

    public Object localizedValueForKey(String key) {
        if (!ERXStringUtilities.stringIsNullOrEmpty(key) && '@' == key.charAt(0)) {
            int dotIndex = key.indexOf(".");
            String methodKey = dotIndex > 0 ? key.substring(1, dotIndex) : key.substring(1, key.length());
            try {
                Method m = ERXLocalizer.class.getMethod(methodKey, new Class[0]);
                return m.invoke((Object)this, (Object[])null);
            }
            catch (NoSuchMethodException nsme) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)nsme);
            }
            catch (IllegalAccessException iae) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)iae);
            }
            catch (InvocationTargetException ite) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)ite);
            }
        }
        Object result = this.cache.objectForKey(key);
        if (key == null || result == this.NOT_FOUND) {
            return null;
        }
        if (result != null) {
            return result;
        }
        if (createdKeysLog.isDebugEnabled()) {
            log.debug((Object)("Key not found: '" + key + "'/" + this.language));
        }
        if (ERXLocalizer.fallbackToDefaultLanguage() && !ERXLocalizer.defaultLanguage().equals(this.language)) {
            Object valueInDefaultLanguage = ERXLocalizer.defaultLocalizer().localizedValueForKey(key);
            this.setCacheValueForKey(valueInDefaultLanguage == null ? this.NOT_FOUND : valueInDefaultLanguage, key);
            return valueInDefaultLanguage;
        }
        this.setCacheValueForKey(this.NOT_FOUND, key);
        return null;
    }

    public String localizedStringForKeyWithDefault(String key) {
        return (String)this.localizedValueForKeyWithDefault(key);
    }

    public String localizedStringForKey(String key) {
        return (String)this.localizedValueForKey(key);
    }

    private String displayNameForKey(String key) {
        return ERXStringUtilities.displayNameForKey(key);
    }

    public String localizedDisplayNameForKey(String prefix, String key) {
        String localizerKey = prefix + "." + key;
        String result = this.localizedStringForKey(localizerKey);
        if (result == null) {
            result = this.displayNameForKey(key);
            String localized = this.localizedStringForKey(result);
            if (localized != null) {
                result = localized;
                log.info((Object)("Found an old-style entry: " + localizerKey + "->" + result));
            }
            this.takeValueForKey(result, localizerKey);
        }
        return result;
    }

    public String localizedTemplateStringForKeyWithObject(String key, Object o1) {
        return this.localizedTemplateStringForKeyWithObjectOtherObject(key, o1, null);
    }

    public String localizedTemplateStringForKeyWithObjectOtherObject(String key, Object o1, Object o2) {
        String template;
        if (key != null && (template = this.localizedStringForKeyWithDefault(key)) != null) {
            return ERXSimpleTemplateParser.sharedInstance().parseTemplateWithObject(template, null, o1, o2);
        }
        return key;
    }

    protected String plurify(String str, int howMany) {
        String plurifiedString = howMany == 1 || howMany == -1 ? str : this.applyRules(str, this._plurifyRules);
        return plurifiedString;
    }

    protected String singularify(String str) {
        return this.applyRules(str, this._singularifyRules);
    }

    protected String applyRules(String str, Map rules) {
        String result = str;
        if (str != null) {
            boolean converted = false;
            Iterator rulesIter = rules.entrySet().iterator();
            while (!converted && rulesIter.hasNext()) {
                Map.Entry rule = rulesIter.next();
                Pattern rulePattern = (Pattern)rule.getKey();
                Matcher ruleMatcher = rulePattern.matcher(str);
                if (!ruleMatcher.matches()) continue;
                String ruleReplacement = (String)rule.getValue();
                result = ruleMatcher.replaceFirst(ruleReplacement);
                converted = true;
            }
            if (converted) {
                result = ERXStringUtilities.matchCase(str, result);
            }
        }
        return result;
    }

    public String plurifiedStringWithTemplateForKey(String key, String name, int count, Object helper) {
        NSDictionary<Object, Object> dict = new NSDictionary<Object, Object>(new Object[]{this.plurifiedString(name, count), new Integer(count)}, new Object[]{"pluralString", "pluralCount"});
        return this.localizedTemplateStringForKeyWithObjectOtherObject(key, dict, helper);
    }

    public String plurifiedString(String name, int count) {
        NSKeyValueCoding exceptions;
        if (name != null && (exceptions = (NSKeyValueCoding)this.valueForKey(KEY_LOCALIZER_EXCEPTIONS)) != null) {
            String exception = (String)exceptions.valueForKey(name + "." + count);
            if (exception == null) {
                exception = (String)exceptions.valueForKey(name);
            }
            if (exception != null) {
                return exception;
            }
        }
        return this.plurify(name, count);
    }

    public String singularifiedString(String value) {
        String exception;
        NSKeyValueCoding exceptions;
        if (value != null && (exceptions = (NSKeyValueCoding)this.valueForKey(KEY_LOCALIZER_EXCEPTIONS)) != null && (exception = (String)exceptions.valueForKey(value + ".singular")) != null) {
            return exception;
        }
        return this.singularify(value);
    }

    public String toString() {
        return "<" + this.getClass().getName() + " " + this.language + ">";
    }

    public Format localizedDateFormatForKey(String formatString) {
        formatString = formatString == null ? "%m/%d/%Y" : formatString;
        Format result = (Format)this._dateFormatters.get(formatString = this.localizedStringForKeyWithDefault(formatString));
        if (result == null) {
            Locale current = this.locale();
            NSTimestampFormatter formatter = new NSTimestampFormatter(formatString, new DateFormatSymbols(current));
            result = formatter;
            this._dateFormatters.put(formatString, result);
        }
        return result;
    }

    public Format localizedNumberFormatForKey(String formatString) {
        formatString = formatString == null ? "#,##0.00;-(#,##0.00)" : formatString;
        Object result = (Format)this._numberFormatters.get(formatString = this.localizedStringForKeyWithDefault(formatString));
        if (result == null) {
            Locale current = this.locale();
            ERXNumberFormatter formatter = new ERXNumberFormatter();
            formatter.setLocale(current);
            formatter.setLocalizesPattern(true);
            formatter.setPattern(formatString);
            result = formatter;
            this._numberFormatters.put(formatString, result);
        }
        return result;
    }

    public void setLocalizedNumberFormatForKey(Format formatter, String pattern) {
        this._numberFormatters.put(pattern, formatter);
    }

    public Locale locale() {
        return this.locale;
    }

    public void setLocale(Locale value) {
        this.locale = value;
    }

    public void setLocalizedDateFormatForKey(NSTimestampFormatter formatter, String pattern) {
        this._dateFormatters.put(pattern, formatter);
    }

    public static boolean useLocalizedFormatters() {
        if (_useLocalizedFormatters == null) {
            _useLocalizedFormatters = ERXProperties.booleanForKey("er.extensions.ERXLocalizer.useLocalizedFormatters") ? Boolean.TRUE : Boolean.FALSE;
        }
        return _useLocalizedFormatters;
    }

    public String languageCode() {
        return this.locale().getLanguage();
    }

    public static boolean fallbackToDefaultLanguage() {
        if (_fallbackToDefaultLanguage == null) {
            _fallbackToDefaultLanguage = ERXProperties.booleanForKey("er.extensions.ERXLocalizer.fallbackToDefaultLanguage") ? Boolean.TRUE : Boolean.FALSE;
        }
        return _fallbackToDefaultLanguage;
    }

    static {
        observer = new Observer();
        monitoredFiles = new NSMutableArray();
        localizers = new NSMutableDictionary();
        _languagesWithoutPluralForm = new NSArray<Object>(new Object[]{"Japanese"});
    }

    public static class Observer {
        public void fileDidChange(NSNotification n) {
            ERXLocalizer.resetCache();
            NSNotificationCenter.defaultCenter().postNotification(ERXLocalizer.LocalizationDidResetNotification, null);
        }
    }
}

