/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.logging;

import com.webobjects.appserver.WOAdaptor;
import com.webobjects.appserver.WOApplication;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.formatters.ERXUnitAwareDecimalFormat;
import er.extensions.foundation.ERXDictionaryUtilities;
import er.extensions.foundation.ERXSimpleTemplateParser;
import er.extensions.foundation.ERXThreadStorage;
import er.extensions.foundation.ERXUtilities;
import java.util.Enumeration;
import org.apache.log4j.helpers.FormattingInfo;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.helpers.PatternParser;
import org.apache.log4j.spi.LoggingEvent;

class ERXPatternParser
extends PatternParser {
    public ERXPatternParser(String pattern) {
        super(pattern);
    }

    public void finalizeConverter(char c) {
        switch (c) {
            case '$': {
                this.addConverter(new AppNamePatternConverter(this.formattingInfo));
                this.currentLiteral.setLength(0);
                break;
            }
            case '#': {
                this.addConverter(new AdaptorPortNumberConverter(this.formattingInfo));
                this.currentLiteral.setLength(0);
                break;
            }
            case '@': {
                this.addConverter(new StackTracePatternConverter(this.formattingInfo));
                this.currentLiteral.setLength(0);
                break;
            }
            case 'W': {
                this.addConverter(new AppInfoPatternConverter(this.formattingInfo, this.extractOption()));
                this.currentLiteral.setLength(0);
                break;
            }
            case 'V': {
                this.addConverter(new JavaVMInfoPatternConverter(this.formattingInfo, this.extractOption()));
                this.currentLiteral.setLength(0);
                break;
            }
            case 'T': {
                this.addConverter(new ThreadStoragePatternConverter(this.formattingInfo, this.extractOption()));
                this.currentLiteral.setLength(0);
                break;
            }
            default: {
                super.finalizeConverter(c);
            }
        }
    }

    private class JavaVMInfoPatternConverter
    extends PatternConverter {
        private Runtime _runtime;
        private ERXUnitAwareDecimalFormat _decimalFormatter;
        private ERXSimpleTemplateParser _templateParser;
        private String _template;
        private boolean _constantsInitialized;
        private NSMutableDictionary _jvmInfo;
        private final NSDictionary _defaultLabels;

        JavaVMInfoPatternConverter(FormattingInfo formattingInfo, String format) {
            super(formattingInfo);
            this._constantsInitialized = false;
            this._defaultLabels = null;
            this._runtime = Runtime.getRuntime();
            this._decimalFormatter = new ERXUnitAwareDecimalFormat("byte");
            this._decimalFormatter.setMaximumFractionDigits(2);
            this._templateParser = new ERXSimpleTemplateParser("-");
            this._templateParser.isLoggingDisabled = true;
            this._jvmInfo = new NSMutableDictionary();
            format = format.replaceFirst("(^|\\W)u(\\W|$)", "$1@@usedMemory@@$2");
            format = format.replaceFirst("(^|\\W)f(\\W|$)", "$1@@freeMemory@@$2");
            format = format.replaceFirst("(^|\\W)t(\\W|$)", "$1@@totalMemory@@$2");
            this._template = format = format.replaceFirst("(^|\\W)m(\\W|$)", "$1@@maxMemory@@$2");
        }

        public String convert(LoggingEvent event) {
            if (!this._constantsInitialized) {
                this._constantsInitialized = true;
            }
            long totalMemory = this._runtime.totalMemory();
            long freeMemory = this._runtime.freeMemory();
            long maxMemory = this._runtime.maxMemory();
            long usedMemory = totalMemory - freeMemory;
            this._jvmInfo.setObjectForKey(this._decimalFormatter.format(totalMemory), "totalMemory");
            this._jvmInfo.setObjectForKey(this._decimalFormatter.format(freeMemory), "freeMemory");
            this._jvmInfo.setObjectForKey(this._decimalFormatter.format(usedMemory), "usedMemory");
            this._jvmInfo.setObjectForKey(this._decimalFormatter.format(maxMemory), "maxMemory");
            return this._templateParser.parseTemplateWithObject(this._template, "@@", this._jvmInfo);
        }
    }

    private class AppInfoPatternConverter
    extends PatternConverter {
        private ERXSimpleTemplateParser _templateParser;
        private String _template;
        private boolean _constantsInitialized;
        private NSMutableDictionary _appInfo;
        private final NSDictionary _defaultLabels;

        AppInfoPatternConverter(FormattingInfo formattingInfo, String format) {
            super(formattingInfo);
            this._constantsInitialized = false;
            this._defaultLabels = ERXDictionaryUtilities.dictionaryWithObjectsAndKeys(new Object[]{"@@sessionCount@@", "sessionCount"});
            this._templateParser = new ERXSimpleTemplateParser("-");
            this._templateParser.isLoggingDisabled = true;
            this._appInfo = new NSMutableDictionary();
            this._template = "@@appName@@[@@pid@@:@@portNumber@@ @@sessionCount@@]";
            if (format != null && format.length() > 0) {
                format = format.replaceFirst("(^|\\W)s(\\W|$)", "$1@@sessionCount@@$2");
                format = format.replaceFirst("(^|\\W)n(\\W|$)", "$1@@appName@@$2");
                format = format.replaceFirst("(^|\\W)p(\\W|$)", "$1@@portNumber@@$2");
                this._template = format = format.replaceFirst("(^|\\W)i(\\W|$)", "$1@@pid@@$2");
            }
        }

        public String convert(LoggingEvent event) {
            WOApplication app = WOApplication.application();
            if (app != null) {
                if (!this._constantsInitialized) {
                    String appName;
                    String pid = System.getProperty("com.webobjects.pid");
                    if (pid != null) {
                        this._appInfo.setObjectForKey(pid, "pid");
                    }
                    if ((appName = app.name()) != null) {
                        this._appInfo.setObjectForKey(appName, "appName");
                    }
                    if (app.port() != null && app.port().intValue() > 0) {
                        this._appInfo.setObjectForKey(app.port().toString(), "portNumber");
                    } else {
                        WOAdaptor primaryAdaptor;
                        String portNumber;
                        NSArray adaptors = app.adaptors();
                        if (adaptors != null && adaptors.count() > 0 && (portNumber = String.valueOf((primaryAdaptor = (WOAdaptor)adaptors.objectAtIndex(0)).port())) != null) {
                            this._appInfo.setObjectForKey(portNumber, "portNumber");
                        }
                    }
                    this._template = this._templateParser.parseTemplateWithObject(this._template, "@@", this._appInfo, this._defaultLabels);
                    this._constantsInitialized = true;
                }
                this._appInfo.setObjectForKey(String.valueOf(app.activeSessionsCount()), "sessionCount");
            }
            return this._templateParser.parseTemplateWithObject(this._template, "@@", this._appInfo);
        }
    }

    @Deprecated
    private class AdaptorPortNumberConverter
    extends PatternConverter {
        String _portNumber;

        AdaptorPortNumberConverter(FormattingInfo formattingInfo) {
            super(formattingInfo);
        }

        public String convert(LoggingEvent event) {
            NSArray adaptors;
            if (this._portNumber == null && WOApplication.application() != null && (adaptors = WOApplication.application().adaptors()) != null && adaptors.count() > 0) {
                WOAdaptor primaryAdaptor = (WOAdaptor)adaptors.objectAtIndex(0);
                this._portNumber = String.valueOf(primaryAdaptor.port());
            }
            return this._portNumber != null ? this._portNumber : "N/A";
        }
    }

    private class ThreadStoragePatternConverter
    extends PatternConverter {
        private String key;
        private NSArray keyParts;
        private boolean isKeyPath;

        ThreadStoragePatternConverter(FormattingInfo formattingInfo, String key) {
            super(formattingInfo);
            this.key = key;
            boolean bl = this.isKeyPath = key != null && key.indexOf(".") != -1;
            if (this.isKeyPath) {
                this.keyParts = NSArray.componentsSeparatedByString(key, ".");
            }
        }

        public String convert(LoggingEvent event) {
            Object value = null;
            if (!this.isKeyPath) {
                value = this.key != null ? ERXThreadStorage.valueForKey(this.key) : ERXThreadStorage.map();
            } else {
                value = ERXThreadStorage.map();
                for (int j = 0; j < this.keyParts.count(); ++j) {
                    String part = (String)this.keyParts.objectAtIndex(j);
                    if (j == 0) {
                        value = ERXThreadStorage.valueForKey(part);
                    } else {
                        try {
                            value = NSKeyValueCoding.Utility.valueForKey((Object)value, (String)part);
                        }
                        catch (Throwable t) {
                            value = "ERR: " + part + " ->" + t.getMessage();
                        }
                    }
                    if (value == null) break;
                }
            }
            return value != null ? value.toString() : null;
        }
    }

    @Deprecated
    private class AppNamePatternConverter
    extends PatternConverter {
        String _appName;

        AppNamePatternConverter(FormattingInfo formattingInfo) {
            super(formattingInfo);
        }

        public String convert(LoggingEvent event) {
            if (this._appName == null && WOApplication.application() != null) {
                this._appName = WOApplication.application().name();
            }
            return this._appName != null ? this._appName : "N/A";
        }
    }

    private class StackTracePatternConverter
    extends PatternConverter {
        StackTracePatternConverter(FormattingInfo formattingInfo) {
            super(formattingInfo);
        }

        public String convert(LoggingEvent event) {
            String element;
            NSArray<String> parts = NSArray.componentsSeparatedByString(ERXUtilities.stackTrace(), "\n\t");
            NSMutableArray<String> subParts = new NSMutableArray<String>();
            boolean first = true;
            Enumeration<String> e = parts.reverseObjectEnumerator();
            while (e.hasMoreElements() && (element = e.nextElement()).indexOf("org.apache.log4j") == -1) {
                if (!first) {
                    subParts.insertObjectAtIndex(element, 0);
                    continue;
                }
                first = false;
            }
            return "\t" + subParts.componentsJoinedByString("\n\t") + "\n";
        }
    }
}

