/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.migration;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOAdaptorChannel;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOGeneralAdaptorException;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.jdbcadaptor.JDBCAdaptor;
import er.extensions.eof.ERXModelGroup;
import er.extensions.foundation.ERXProperties;
import er.extensions.jdbc.ERXJDBCUtilities;
import er.extensions.jdbc.ERXSQLHelper;
import er.extensions.migration.ERXMigrationFailedException;
import er.extensions.migration.IERXMigrationLock;
import org.apache.log4j.Logger;

public class ERXJDBCMigrationLock
implements IERXMigrationLock {
    public static final Logger log = Logger.getLogger(ERXJDBCMigrationLock.class);
    private EOModel _lastUpdatedModel;
    private EOModel _dbUpdaterModelCache;

    protected String migrationTableName(JDBCAdaptor adaptor) {
        String migrationTableName = ERXProperties.stringForKey("er.migration.JDBC.dbUpdaterTableName");
        if (migrationTableName == null) {
            migrationTableName = ERXSQLHelper.newSQLHelper(adaptor).migrationTableName();
        }
        return migrationTableName;
    }

    protected boolean createIfMissing() {
        return ERXProperties.booleanForKeyWithDefault("er.migration.createTablesIfNecessary", false);
    }

    public boolean tryLock(EOAdaptorChannel channel, EOModel model, String lockOwnerName) {
        return this._tryLock(channel, model, lockOwnerName, this.createIfMissing());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean _tryLock(EOAdaptorChannel channel, EOModel model, String lockOwnerName, boolean createTableIfMissing) {
        JDBCAdaptor adaptor = (JDBCAdaptor)channel.adaptorContext().adaptor();
        try {
            int count;
            block18: {
                adaptor.externalTypesWithModel(model);
                boolean wasOpen = true;
                if (!channel.isOpen()) {
                    channel.openChannel();
                    wasOpen = false;
                }
                try {
                    EOModel dbUpdaterModel = this.dbUpdaterModelWithModel(model, adaptor);
                    NSMutableDictionary<String, Object> row = new NSMutableDictionary<String, Object>();
                    row.setObjectForKey(new Integer(1), "updateLock");
                    row.setObjectForKey(lockOwnerName, "lockOwner");
                    EOEntity dbUpdaterEntity = dbUpdaterModel.entityNamed(this.migrationTableName(adaptor));
                    try {
                        count = channel.updateValuesInRowsDescribedByQualifier(row, EOQualifier.qualifierWithQualifierFormat((String)("modelName = '" + model.name() + "' and (updateLock = 0 or lockOwner = '" + lockOwnerName + "')"), null), dbUpdaterEntity);
                        Object var12_16 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_17 = null;
                        channel.cancelFetch();
                        throw throwable;
                    }
                    channel.cancelFetch();
                    if (count == 0) {
                        NSMutableDictionary nextRow;
                        EOFetchSpecification fetchSpec = new EOFetchSpecification(this.migrationTableName(adaptor), (EOQualifier)new EOKeyValueQualifier("modelName", EOQualifier.QualifierOperatorEqual, (Object)model.name()), null);
                        try {
                            channel.selectAttributes(new NSArray<EOAttribute>(dbUpdaterEntity.attributeNamed("updateLock")), fetchSpec, false, dbUpdaterEntity);
                            nextRow = channel.fetchRow();
                            Object var14_20 = null;
                        }
                        catch (Throwable throwable) {
                            Object var14_21 = null;
                            channel.cancelFetch();
                            throw throwable;
                        }
                        channel.cancelFetch();
                        if (nextRow == null) {
                            if (!this.createIfMissing()) throw new ERXMigrationFailedException("Unable to migrate because there is not a row for the model '" + model.name() + ".");
                            row.setObjectForKey(new Integer(this.initialVersionForModel(model)), "version");
                            row.setObjectForKey(model.name(), "modelName");
                            try {
                                channel.insertRow(row, dbUpdaterEntity);
                            }
                            catch (EOGeneralAdaptorException e) {
                                if (log.isInfoEnabled()) {
                                    log.info((Object)("Exception creating row for model '" + model.name() + ", assuming another process has already added this and has the lock."), (Throwable)e);
                                }
                                boolean bl = false;
                                Object var16_25 = null;
                                if (wasOpen) return bl;
                                channel.closeChannel();
                                return bl;
                            }
                            count = 1;
                        }
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Waiting on updateLock for model '" + model.name() + "' ..."));
                        }
                    }
                    channel.adaptorContext().commitTransaction();
                    channel.adaptorContext().beginTransaction();
                    Object var16_26 = null;
                    if (wasOpen) break block18;
                }
                catch (Throwable throwable) {
                    Object var16_27 = null;
                    if (wasOpen) throw throwable;
                    channel.closeChannel();
                    throw throwable;
                }
                channel.closeChannel();
            }
            if (count != 1) return false;
            return true;
        }
        catch (ERXMigrationFailedException e) {
            throw e;
        }
        catch (Exception e) {
            channel.adaptorContext().rollbackTransaction();
            String createTableStatement = this.dbUpdaterCreateStatement(model, adaptor);
            if (!createTableIfMissing) throw new ERXMigrationFailedException("Failed to lock " + this.migrationTableName(adaptor) + " table.  It might be missing? Try executing:\n" + createTableStatement + ".", e);
            try {
                log.warn((Object)"Locking failed, but this might be OK if this is the first time you are running migrations.  If things keep running, it probably worked fine.  The original reason for the failure: ", (Throwable)e);
                ERXJDBCUtilities.executeUpdateScript(channel, createTableStatement);
                String uniqueModelNameIndex = ERXSQLHelper.newSQLHelper(model).sqlForCreateUniqueIndex("unique_model", this.migrationTableName(adaptor), "modelname");
                ERXJDBCUtilities.executeUpdateScript(channel, uniqueModelNameIndex);
                return this._tryLock(channel, model, lockOwnerName, false);
            }
            catch (Throwable t) {
                throw new ERXMigrationFailedException("Failed to create lock table. Try executing:\n" + createTableStatement + ".", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unlock(EOAdaptorChannel channel, EOModel model) {
        JDBCAdaptor adaptor = (JDBCAdaptor)channel.adaptorContext().adaptor();
        boolean wasOpen = true;
        if (!channel.isOpen()) {
            channel.openChannel();
            wasOpen = false;
        }
        try {
            try {
                EOModel dbUpdaterModel = this.dbUpdaterModelWithModel(model, adaptor);
                NSMutableDictionary<String, Integer> row = new NSMutableDictionary<String, Integer>();
                row.setObjectForKey(new Integer(0), "updateLock");
                row.setObjectForKey((Integer)NSKeyValueCoding.NullValue, "lockOwner");
                EOEntity dbUpdaterEntity = dbUpdaterModel.entityNamed(this.migrationTableName(adaptor));
                channel.adaptorContext().commitTransaction();
                try {
                    channel.updateValuesInRowsDescribedByQualifier(row, (EOQualifier)new EOKeyValueQualifier("modelName", EOQualifier.QualifierOperatorEqual, (Object)model.name()), dbUpdaterEntity);
                    Object var9_9 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    channel.cancelFetch();
                    throw throwable;
                }
                channel.cancelFetch();
                channel.adaptorContext().commitTransaction();
                channel.adaptorContext().beginTransaction();
            }
            catch (Exception e) {
                throw new ERXMigrationFailedException("Failed to unlock " + this.migrationTableName(adaptor) + " table.", e);
            }
            Object var11_12 = null;
            if (wasOpen) return;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (wasOpen) throw throwable;
            channel.closeChannel();
            throw throwable;
        }
        channel.closeChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int versionNumber(EOAdaptorChannel channel, EOModel model) {
        int version;
        JDBCAdaptor adaptor = (JDBCAdaptor)channel.adaptorContext().adaptor();
        boolean wasOpen = true;
        if (!channel.isOpen()) {
            channel.openChannel();
            wasOpen = false;
        }
        try {
            try {
                EOModel dbUpdaterModel = this.dbUpdaterModelWithModel(model, adaptor);
                EOEntity dbUpdaterEntity = dbUpdaterModel.entityNamed(this.migrationTableName(adaptor));
                EOFetchSpecification fetchSpec = new EOFetchSpecification(this.migrationTableName(adaptor), (EOQualifier)new EOKeyValueQualifier("modelName", EOQualifier.QualifierOperatorEqual, (Object)model.name()), null);
                try {
                    channel.selectAttributes(new NSArray<EOAttribute>(dbUpdaterEntity.attributeNamed("version")), fetchSpec, false, dbUpdaterEntity);
                    NSMutableDictionary nextRow = channel.fetchRow();
                    if (nextRow == null) {
                        version = this.initialVersionForModel(model);
                    } else {
                        Integer versionInteger = (Integer)nextRow.objectForKey("version");
                        version = Math.max(versionInteger, this.initialVersionForModel(model));
                    }
                    Object var12_12 = null;
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    channel.cancelFetch();
                    throw throwable;
                }
                channel.cancelFetch();
                Object var14_15 = null;
                if (wasOpen) return version;
            }
            catch (Exception e) {
                throw new ERXMigrationFailedException("Failed to get version number from " + this.migrationTableName(adaptor) + " table.", e);
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            if (wasOpen) throw throwable;
            channel.closeChannel();
            throw throwable;
        }
        channel.closeChannel();
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setVersionNumber(EOAdaptorChannel channel, EOModel model, int versionNumber) {
        JDBCAdaptor adaptor = (JDBCAdaptor)channel.adaptorContext().adaptor();
        boolean wasOpen = true;
        if (!channel.isOpen()) {
            channel.openChannel();
            wasOpen = false;
        }
        try {
            try {
                int count;
                EOModel dbUpdaterModel = this.dbUpdaterModelWithModel(model, adaptor);
                NSMutableDictionary<String, Integer> row = new NSMutableDictionary<String, Integer>();
                row.setObjectForKey(new Integer(versionNumber), "version");
                EOEntity dbUpdaterEntity = dbUpdaterModel.entityNamed(this.migrationTableName(adaptor));
                try {
                    count = channel.updateValuesInRowsDescribedByQualifier(row, (EOQualifier)new EOKeyValueQualifier("modelName", EOQualifier.QualifierOperatorEqual, (Object)model.name()), dbUpdaterEntity);
                    Object var11_11 = null;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    channel.cancelFetch();
                    throw throwable;
                }
                channel.cancelFetch();
                if (count == 0) {
                    throw new ERXMigrationFailedException("Unable to migrate because there is not a row for the model '" + model.name() + ".");
                }
                Object var13_14 = null;
                if (wasOpen) return;
            }
            catch (Exception e) {
                throw new ERXMigrationFailedException("Failed to set version number of " + this.migrationTableName(adaptor) + ".", e);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (wasOpen) throw throwable;
            channel.closeChannel();
            throw throwable;
        }
        channel.closeChannel();
    }

    protected int initialVersionForModel(EOModel model) {
        String modelName = model.name();
        int initialVersion = ERXProperties.intForKeyWithDefault(modelName + ".InitialMigrationVersion", -1);
        return initialVersion;
    }

    protected EOModel dbUpdaterModelWithModel(EOModel model, JDBCAdaptor adaptor) {
        EOModel dbUpdaterModel;
        if (this._lastUpdatedModel == model) {
            dbUpdaterModel = this._dbUpdaterModelCache;
        } else {
            EOModelGroup modelGroup = model.modelGroup();
            EOEntity prototypeEntity = modelGroup.entityNamed(ERXModelGroup.prototypeEntityNameForModel(model));
            boolean isWonderPrototype = prototypeEntity != null && prototypeEntity.model().name().equals("erprototypes");
            dbUpdaterModel = new EOModel();
            dbUpdaterModel.setConnectionDictionary(model.connectionDictionary());
            dbUpdaterModel.setAdaptorName(model.adaptorName());
            EOEntity dbUpdaterEntity = new EOEntity();
            dbUpdaterEntity.setExternalName(this.migrationTableName(adaptor));
            dbUpdaterEntity.setName(this.migrationTableName(adaptor));
            dbUpdaterModel.addEntity(dbUpdaterEntity);
            EOAttribute modelNameAttribute = new EOAttribute();
            if (isWonderPrototype) {
                modelNameAttribute.setExternalType(prototypeEntity.attributeNamed("varchar100").externalType());
            } else {
                modelNameAttribute.setExternalType(ERXSQLHelper.newSQLHelper(adaptor).externalTypeForJDBCType(adaptor, 12));
            }
            modelNameAttribute.setName("modelName");
            modelNameAttribute.setColumnName("modelname");
            modelNameAttribute.setClassName("java.lang.String");
            modelNameAttribute.setWidth(100);
            modelNameAttribute.setAllowsNull(false);
            dbUpdaterEntity.addAttribute(modelNameAttribute);
            EOAttribute versionAttribute = new EOAttribute();
            if (isWonderPrototype) {
                versionAttribute.setExternalType(prototypeEntity.attributeNamed("intNumber").externalType());
            } else {
                versionAttribute.setExternalType(ERXSQLHelper.newSQLHelper(adaptor).externalTypeForJDBCType(adaptor, 4));
            }
            versionAttribute.setName("version");
            versionAttribute.setColumnName("version");
            versionAttribute.setClassName("java.lang.Number");
            versionAttribute.setValueType("i");
            versionAttribute.setAllowsNull(false);
            dbUpdaterEntity.addAttribute(versionAttribute);
            EOAttribute updateLockAttribute = new EOAttribute();
            if (isWonderPrototype) {
                updateLockAttribute.setExternalType(prototypeEntity.attributeNamed("intNumber").externalType());
            } else {
                updateLockAttribute.setExternalType(ERXSQLHelper.newSQLHelper(adaptor).externalTypeForJDBCType(adaptor, 4));
            }
            updateLockAttribute.setName("updateLock");
            updateLockAttribute.setColumnName("updatelock");
            updateLockAttribute.setClassName("java.lang.Number");
            updateLockAttribute.setValueType("i");
            updateLockAttribute.setAllowsNull(false);
            dbUpdaterEntity.addAttribute(updateLockAttribute);
            EOAttribute lockOwnerAttribute = new EOAttribute();
            if (isWonderPrototype) {
                lockOwnerAttribute.setExternalType(prototypeEntity.attributeNamed("varchar100").externalType());
            } else {
                lockOwnerAttribute.setExternalType(ERXSQLHelper.newSQLHelper(adaptor).externalTypeForJDBCType(adaptor, 12));
            }
            lockOwnerAttribute.setName("lockOwner");
            lockOwnerAttribute.setColumnName("lockowner");
            lockOwnerAttribute.setClassName("java.lang.String");
            lockOwnerAttribute.setWidth(100);
            lockOwnerAttribute.setAllowsNull(true);
            dbUpdaterEntity.addAttribute(lockOwnerAttribute);
            this._lastUpdatedModel = model;
            this._dbUpdaterModelCache = dbUpdaterModel;
        }
        return dbUpdaterModel;
    }

    protected String dbUpdaterCreateStatement(EOModel model, JDBCAdaptor adaptor) {
        EOModel dbUpdaterModel = this.dbUpdaterModelWithModel(model, adaptor);
        NSMutableDictionary<String, String> flags = new NSMutableDictionary<String, String>();
        flags.setObjectForKey("NO", "dropTables");
        flags.setObjectForKey("NO", "dropPrimaryKeySupport");
        flags.setObjectForKey("YES", "createTables");
        flags.setObjectForKey("NO", "createPrimaryKeySupport");
        flags.setObjectForKey("NO", "primaryKeyConstraints");
        flags.setObjectForKey("NO", "foreignKeyConstraints");
        flags.setObjectForKey("NO", "createDatabase");
        flags.setObjectForKey("NO", "dropDatabase");
        String createTableScript = ERXSQLHelper.newSQLHelper(adaptor).createSchemaSQLForEntitiesWithOptions(new NSArray<EOEntity>(dbUpdaterModel.entityNamed(this.migrationTableName(adaptor))), (EOAdaptor)adaptor, flags);
        return createTableScript;
    }
}

