/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.migration;

import com.webobjects.eoaccess.EOAdaptorChannel;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import er.extensions.jdbc.ERXJDBCUtilities;
import er.extensions.migration.ERXMigrationFailedException;
import er.extensions.migration.ERXModelVersion;
import er.extensions.migration.IERXMigration;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ERXMigration
implements IERXMigration {
    private Logger log = Logger.getLogger((String)ERXMigration.class.getName());
    private Boolean _useDatabaseSpecificMigrations;

    public ERXMigration(boolean useDatabaseSpecificMigrations) {
        this._useDatabaseSpecificMigrations = useDatabaseSpecificMigrations;
    }

    public ERXMigration() {
    }

    @Override
    public NSArray<ERXModelVersion> modelDependencies() {
        return null;
    }

    @Override
    public void downgrade(EOEditingContext editingContext, EOAdaptorChannel channel, EOModel model) throws Throwable {
        String sqlString = null;
        sqlString = this.useDatabaseSpecificMigrations() ? this.getSQLForMigration(this.getClass().getSimpleName() + "_" + ERXJDBCUtilities.databaseProductName(channel) + "_Downgrade.migration") : this.getSQLForMigration(this.getClass().getSimpleName() + "_Downgrade.migration");
        if (sqlString == null) {
            if (this.useDatabaseSpecificMigrations()) {
                throw new ERXMigrationFailedException("No downgrade for migration: " + this.getClass().getName() + "found for database: " + ERXJDBCUtilities.databaseProductName(channel));
            }
            throw new ERXMigrationFailedException("No downgrade for migration: " + this.getClass().getName());
        }
        this.log.info((Object)("Applying migration for: " + this.getClass().getName()));
        ERXJDBCUtilities.executeUpdateScript(channel, sqlString);
    }

    @Override
    public void upgrade(EOEditingContext editingContext, EOAdaptorChannel channel, EOModel model) throws Throwable {
        String sqlString = null;
        sqlString = this.useDatabaseSpecificMigrations() ? this.getSQLForMigration(this.getClass().getSimpleName() + "_" + ERXJDBCUtilities.databaseProductName(channel) + "_Upgrade.migration") : this.getSQLForMigration(this.getClass().getSimpleName() + "_Upgrade.migration");
        if (sqlString == null) {
            if (this.useDatabaseSpecificMigrations()) {
                throw new ERXMigrationFailedException("No upgrade for migration: " + this.getClass().getName() + " found for database: " + ERXJDBCUtilities.databaseProductName(channel));
            }
            throw new ERXMigrationFailedException("No upgrade for migration: " + this.getClass().getName() + " found.");
        }
        this.log.info((Object)("Applying migration for: " + this.getClass().getName()));
        ERXJDBCUtilities.executeUpdateScript(channel, sqlString);
    }

    protected String getSQLForMigration(String migrationName) {
        NSBundle bundle;
        String migrationBundleName = this.migrationBundleName();
        if (migrationBundleName == null) {
            bundle = NSBundle.bundleForClass(this.getClass());
        } else {
            bundle = NSBundle.bundleForName((String)this.migrationBundleName());
            if (bundle == null) {
                bundle = NSBundle._appBundleForName((String)this.migrationBundleName());
            }
        }
        NSArray resourcePaths = bundle.resourcePathsForResources("migration", null);
        if (resourcePaths != null) {
            for (int i = 0; i < resourcePaths.count(); ++i) {
                String currentPath = (String)resourcePaths.objectAtIndex(i);
                if (!currentPath.endsWith(migrationName)) continue;
                try {
                    return new String(bundle.bytesForResourcePath(currentPath), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    this.log.error((Object)e, (Throwable)e);
                }
            }
        }
        return null;
    }

    protected String migrationBundleName() {
        return null;
    }

    protected boolean useDatabaseSpecificMigrations() {
        if (this._useDatabaseSpecificMigrations == null) {
            this._useDatabaseSpecificMigrations = new Boolean(Boolean.getBoolean("er.extensions.migration.ERXMigration.useDatabaseSpecificMigrations"));
        }
        return this._useDatabaseSpecificMigrations;
    }
}

