/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.qualifiers;

import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOKeyComparisonQualifier;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EONotQualifier;
import com.webobjects.eocontrol.EOOrQualifier;
import com.webobjects.eocontrol.EOQualifierEvaluation;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class ERXQualifierTraversal {
    public static final Logger log = Logger.getLogger(ERXQualifierTraversal.class);

    protected void visit(EOQualifierEvaluation q) {
    }

    protected boolean traverseUnknownQualifier(EOQualifierEvaluation q) {
        log.error((Object)("Found unknown qualifier type:" + q.getClass().getName()));
        return true;
    }

    protected boolean traverseNotQualifier(EONotQualifier q) {
        return true;
    }

    protected boolean traverseOrQualifier(EOOrQualifier q) {
        return true;
    }

    protected boolean traverseAndQualifier(EOAndQualifier q) {
        return true;
    }

    protected boolean traverseKeyValueQualifier(EOKeyValueQualifier q) {
        return true;
    }

    protected boolean traverseKeyComparisonQualifier(EOKeyComparisonQualifier q) {
        return true;
    }

    private boolean traverseQualifier(EOQualifierEvaluation q, boolean postOrder) {
        Boolean result = null;
        if (q == null) {
            result = Boolean.TRUE;
        } else {
            this.visit(q);
            if (q instanceof EOOrQualifier) {
                EOOrQualifier aq = (EOOrQualifier)q;
                if (!postOrder) {
                    Boolean bl = result = this.traverseOrQualifier(aq) ? Boolean.TRUE : Boolean.FALSE;
                }
                if (result == null || result.booleanValue()) {
                    Enumeration e = aq.qualifiers().objectEnumerator();
                    while (e.hasMoreElements()) {
                        if (this.traverseQualifier((EOQualifierEvaluation)e.nextElement(), postOrder)) continue;
                        result = Boolean.FALSE;
                        break;
                    }
                }
                if (postOrder && (result == null || result.booleanValue())) {
                    result = this.traverseOrQualifier(aq) ? Boolean.TRUE : Boolean.FALSE;
                }
            } else if (q instanceof EOAndQualifier) {
                EOAndQualifier aq = (EOAndQualifier)q;
                if (!postOrder) {
                    Boolean bl = result = this.traverseAndQualifier(aq) ? Boolean.TRUE : Boolean.FALSE;
                }
                if (result == null || result.booleanValue()) {
                    Enumeration e = aq.qualifiers().objectEnumerator();
                    while (e.hasMoreElements()) {
                        if (this.traverseQualifier((EOQualifierEvaluation)e.nextElement(), postOrder)) continue;
                        result = Boolean.FALSE;
                        break;
                    }
                }
                if (postOrder && (result == null || result.booleanValue())) {
                    result = this.traverseAndQualifier(aq) ? Boolean.TRUE : Boolean.FALSE;
                }
            } else if (q instanceof EONotQualifier) {
                EONotQualifier aq = (EONotQualifier)q;
                if (!postOrder) {
                    Boolean bl = result = this.traverseNotQualifier(aq) ? Boolean.TRUE : Boolean.FALSE;
                }
                if (result == null || result.booleanValue()) {
                    Boolean bl = result = this.traverseQualifier((EOQualifierEvaluation)aq.qualifier(), postOrder) ? Boolean.TRUE : Boolean.FALSE;
                }
                if (postOrder && (result == null || result.booleanValue())) {
                    result = this.traverseNotQualifier(aq) ? Boolean.TRUE : Boolean.FALSE;
                }
            } else if (q instanceof EOKeyValueQualifier) {
                result = this.traverseKeyValueQualifier((EOKeyValueQualifier)q) ? Boolean.TRUE : Boolean.FALSE;
            } else if (q instanceof EOKeyComparisonQualifier) {
                result = this.traverseKeyComparisonQualifier((EOKeyComparisonQualifier)q) ? Boolean.TRUE : Boolean.FALSE;
            } else {
                Boolean bl = result = this.traverseUnknownQualifier(q) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (result == null) {
                throw new RuntimeException("Found unknown qualifier type:" + q.getClass().getName());
            }
        }
        return result;
    }

    public void traverse(EOQualifierEvaluation q) {
        this.traverseQualifier(q, false);
    }

    public void traverse(EOQualifierEvaluation q, boolean postOrder) {
        this.traverseQualifier(q, postOrder);
    }
}

