/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.remoteSynchronizer;

import com.webobjects.eoaccess.EOEntityClassDescription;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EOKeyGlobalID;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSSet;
import er.extensions.eof.ERXDatabase;
import er.extensions.eof.ERXObjectStoreCoordinatorSynchronizer;
import er.extensions.foundation.ERXProperties;
import er.extensions.remoteSynchronizer.ERXSimpleMulticastSynchronizer;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public abstract class ERXRemoteSynchronizer {
    public static Logger log = Logger.getLogger(ERXRemoteSynchronizer.class);
    private static final int INSERT = 3;
    private static final int UPDATE = 4;
    private static final int DELETE = 5;
    private static final int TO_MANY_UPDATE = 6;
    private static final int INVALIDATE = 7;
    private static final int BYTE_TYPE = 1;
    private static final int SHORT_TYPE = 2;
    private static final int INT_TYPE = 3;
    private static final int LONG_TYPE = 4;
    private static final int DATA_TYPE = 5;
    private static final int STRING_TYPE = 6;
    private ERXObjectStoreCoordinatorSynchronizer.IChangeListener _listener;
    private NSSet _includeEntityNames;
    private NSSet _excludeEntityNames;

    public static boolean remoteSynchronizerEnabled() {
        return ERXProperties.booleanForKeyWithDefault("er.extensions.remoteSynchronizer.enabled", false);
    }

    public static ERXRemoteSynchronizer newRemoteSynchronizer(ERXObjectStoreCoordinatorSynchronizer.IChangeListener changeListener) throws Throwable {
        ERXRemoteSynchronizer remoteSynchronizer;
        String remoteSynchronizerClassName = ERXProperties.stringForKey("er.extensions.remoteSynchronizer");
        if (remoteSynchronizerClassName == null) {
            remoteSynchronizer = new ERXSimpleMulticastSynchronizer(changeListener);
        } else {
            Class<?> remoteSynchronizerClass = Class.forName(remoteSynchronizerClassName);
            Constructor<?> remoteSynchronizerConstructor = remoteSynchronizerClass.getConstructor(ERXObjectStoreCoordinatorSynchronizer.IChangeListener.class);
            remoteSynchronizer = (ERXRemoteSynchronizer)remoteSynchronizerConstructor.newInstance(changeListener);
        }
        return remoteSynchronizer;
    }

    public ERXRemoteSynchronizer(ERXObjectStoreCoordinatorSynchronizer.IChangeListener listener) {
        this._listener = listener;
        String includeEntityNames = ERXProperties.stringForKey("er.extensions.remoteSynchronizer.includeEntities");
        Object includeEntityNamesArray = null;
        if (includeEntityNames != null) {
            this._includeEntityNames = new NSSet<Object>(NSArray.componentsSeparatedByString(includeEntityNames, ",").toArray());
        }
        Object excludeEntityNamesArray = null;
        String excludeEntityNames = ERXProperties.stringForKey("er.extensions.remoteSynchronizer.excludeEntities");
        if (excludeEntityNames != null) {
            this._excludeEntityNames = new NSSet<Object>(NSArray.componentsSeparatedByString(excludeEntityNames, ",").toArray());
        }
    }

    protected void _readCacheChange(ERXObjectStoreCoordinatorSynchronizer.RemoteChange remoteChange, DataInputStream dis) throws IOException {
        byte messageType = dis.readByte();
        if (messageType == 3) {
            EOGlobalID gid = this.readGID(dis);
            ERXDatabase.SnapshotInserted change = new ERXDatabase.SnapshotInserted(gid, NSDictionary.EmptyDictionary);
            if (log.isDebugEnabled()) {
                log.info((Object)("Remote instance (" + remoteChange.identifier() + ") inserted " + change));
            }
            remoteChange.addRemoteCacheChange(change);
        } else if (messageType == 4) {
            EOGlobalID gid = this.readGID(dis);
            ERXDatabase.SnapshotUpdated change = new ERXDatabase.SnapshotUpdated(gid, NSDictionary.EmptyDictionary);
            if (log.isDebugEnabled()) {
                log.info((Object)("Remote instance (" + remoteChange.identifier() + ") updated " + change));
            }
            remoteChange.addRemoteCacheChange(change);
        } else if (messageType == 5) {
            EOGlobalID gid = this.readGID(dis);
            ERXDatabase.SnapshotDeleted change = new ERXDatabase.SnapshotDeleted(gid, NSDictionary.EmptyDictionary);
            if (log.isDebugEnabled()) {
                log.info((Object)("Remote instance (" + remoteChange.identifier() + ") deleted " + change));
            }
            remoteChange.addRemoteCacheChange(change);
        } else if (messageType == 6) {
            EOGlobalID sourceGID = this.readGID(dis);
            String name = dis.readUTF();
            NSArray addedGIDs = this.readGIDs(dis);
            NSArray removedGIDs = this.readGIDs(dis);
            boolean removeAll = dis.readBoolean();
            ERXDatabase.ToManySnapshotUpdated change = new ERXDatabase.ToManySnapshotUpdated(sourceGID, name, addedGIDs, removedGIDs, removeAll);
            if (log.isDebugEnabled()) {
                log.info((Object)("Remote instance (" + remoteChange.identifier() + ") update to-many " + change));
            }
            remoteChange.addRemoteCacheChange(change);
        } else if (!this.handleMessageType(messageType, remoteChange, dis)) {
            throw new IllegalArgumentException("Unknown remote message type #" + messageType + ".");
        }
    }

    protected boolean handleMessageType(int messageType, ERXObjectStoreCoordinatorSynchronizer.RemoteChange remoteChange, DataInputStream dis) {
        return false;
    }

    protected void _writeCacheChange(DataOutputStream dos, ERXDatabase.CacheChange cacheChange) throws IOException {
        if (cacheChange instanceof ERXDatabase.SnapshotInserted) {
            dos.writeByte(3);
            this.writeSnapshotCacheChange(dos, cacheChange);
        } else if (cacheChange instanceof ERXDatabase.SnapshotUpdated) {
            dos.writeByte(4);
            this.writeSnapshotCacheChange(dos, cacheChange);
        } else if (cacheChange instanceof ERXDatabase.SnapshotDeleted) {
            dos.writeByte(5);
            this.writeSnapshotCacheChange(dos, cacheChange);
        } else if (cacheChange instanceof ERXDatabase.ToManySnapshotUpdated) {
            dos.writeByte(6);
            ERXDatabase.ToManySnapshotUpdated toManyChange = (ERXDatabase.ToManySnapshotUpdated)cacheChange;
            NSArray addedGIDs = toManyChange.addedGIDs();
            NSArray removedGIDs = toManyChange.removedGIDs();
            this.writeGID(dos, toManyChange.gid());
            dos.writeUTF(toManyChange.name());
            this.writeGIDs(dos, addedGIDs);
            if (toManyChange.removeAll()) {
                this.writeGIDs(dos, null);
                dos.writeBoolean(true);
            } else {
                this.writeGIDs(dos, removedGIDs);
                dos.writeBoolean(false);
            }
        }
    }

    protected void writeSnapshotCacheChange(DataOutputStream dos, ERXDatabase.CacheChange cacheChange) throws IOException {
        this.writeGID(dos, cacheChange.gid());
    }

    protected void writeGIDs(DataOutputStream dos, NSArray gids) throws IOException {
        int count = gids == null ? 0 : gids.count();
        dos.writeByte(count);
        if (count > 0) {
            Enumeration gidsEnum = gids.objectEnumerator();
            while (gidsEnum.hasMoreElements()) {
                EOGlobalID gid = (EOGlobalID)gidsEnum.nextElement();
                this.writeGID(dos, gid);
            }
        }
    }

    protected void writeGID(DataOutputStream dos, EOGlobalID gid) throws IOException {
        EOKeyGlobalID keyGID = (EOKeyGlobalID)gid;
        String entityName = keyGID.entityName();
        dos.writeUTF(entityName);
        this.writeGIDKeys(dos, keyGID);
    }

    protected void writeGIDKeys(DataOutputStream dos, EOKeyGlobalID gid) throws IOException {
        Object[] values = gid._keyValuesNoCopy();
        dos.writeByte(values.length);
        for (int keyNum = 0; keyNum < values.length; ++keyNum) {
            this.writeKey(dos, values[keyNum]);
        }
    }

    protected void writeKey(DataOutputStream dos, Object key) throws IOException {
        if (key instanceof Byte) {
            dos.writeByte(1);
            dos.writeShort(((Byte)key).byteValue());
        } else if (key instanceof Short) {
            dos.writeByte(2);
            dos.writeShort(((Short)key).shortValue());
        } else if (key instanceof Integer) {
            dos.writeByte(3);
            dos.writeInt((Integer)key);
        } else if (key instanceof Long) {
            dos.writeByte(4);
            dos.writeLong((Long)key);
        } else if (key instanceof NSData) {
            NSData data = (NSData)key;
            dos.writeByte(5);
            dos.writeByte(data.length());
            data.writeToStream((OutputStream)dos);
        } else if (key instanceof String) {
            String str = (String)key;
            dos.writeByte(6);
            dos.writeUTF(str);
        } else {
            throw new IllegalArgumentException("RemoteSynchronizer can't handle key '" + key + "'.");
        }
    }

    protected NSArray readGIDs(DataInputStream dis) throws IOException {
        NSMutableArray<EOGlobalID> gids = new NSMutableArray<EOGlobalID>();
        int gidCount = dis.readByte();
        for (int gidNum = 0; gidNum < gidCount; ++gidNum) {
            EOGlobalID gid = this.readGID(dis);
            gids.addObject(gid);
        }
        return gids;
    }

    protected EOGlobalID readGID(DataInputStream dis) throws IOException {
        String entityName = dis.readUTF();
        EOEntityClassDescription classDescription = (EOEntityClassDescription)EOEntityClassDescription.classDescriptionForEntityName((String)entityName);
        return this._readGID(classDescription, entityName, dis);
    }

    protected EOGlobalID _readGID(EOEntityClassDescription classDescription, String entityName, DataInputStream dis) throws IOException {
        EOKeyGlobalID gid;
        int keyCount = dis.readByte();
        if (keyCount == -1) {
            gid = null;
        } else {
            Object[] keys = new Object[keyCount];
            for (int i = 0; i < keyCount; ++i) {
                keys[i] = this.readKey(dis);
            }
            gid = classDescription._globalIDWithEntityName(entityName, keys);
        }
        return gid;
    }

    protected Object readKey(DataInputStream dis) throws IOException {
        Object obj;
        byte keyType = dis.readByte();
        if (keyType == 1) {
            obj = new Byte(dis.readByte());
        } else if (keyType == 2) {
            obj = new Short(dis.readShort());
        } else if (keyType == 3) {
            obj = new Integer(dis.readInt());
        } else if (keyType == 4) {
            obj = new Long(dis.readLong());
        } else if (keyType == 5) {
            byte size = dis.readByte();
            byte[] data = new byte[size];
            dis.readFully(data);
            obj = new NSData(data);
        } else if (keyType == 6) {
            obj = dis.readUTF();
        } else {
            throw new IllegalArgumentException("Unknown key type #" + keyType + ".");
        }
        return obj;
    }

    public boolean shouldSynchronizeEntity(String entityName) {
        boolean shouldSynchronizeEntity = true;
        if (this._includeEntityNames != null) {
            shouldSynchronizeEntity = this._includeEntityNames.containsObject(entityName);
        }
        if (shouldSynchronizeEntity && this._excludeEntityNames != null) {
            shouldSynchronizeEntity = !this._excludeEntityNames.containsObject(entityName);
        }
        return shouldSynchronizeEntity;
    }

    public NSDictionary globalIDsGroupedByEntity(NSArray gids) {
        if (gids == null) {
            return NSDictionary.EmptyDictionary;
        }
        NSMutableDictionary<String, NSMutableSet<EOKeyGlobalID>> result = new NSMutableDictionary<String, NSMutableSet<EOKeyGlobalID>>();
        Enumeration gidsEnum = gids.objectEnumerator();
        while (gidsEnum.hasMoreElements()) {
            EOKeyGlobalID gid = (EOKeyGlobalID)gidsEnum.nextElement();
            String entityName = gid.entityName();
            if (!this.shouldSynchronizeEntity(entityName)) continue;
            NSMutableSet<EOKeyGlobalID> globalIDsForEntity = (NSMutableSet<EOKeyGlobalID>)result.objectForKey(entityName);
            if (globalIDsForEntity == null) {
                globalIDsForEntity = new NSMutableSet<EOKeyGlobalID>();
                result.setObjectForKey(globalIDsForEntity, entityName);
            }
            globalIDsForEntity.addObject(gid);
        }
        return result.immutableClone();
    }

    protected void addChange(ERXObjectStoreCoordinatorSynchronizer.RemoteChange remoteChange) {
        this._listener.addChange(remoteChange);
    }

    protected NSArray filteredCacheChanges(NSArray cacheChanges) {
        NSMutableArray<ERXDatabase.CacheChange> filteredCacheChanges;
        if (this._includeEntityNames == null && (this._excludeEntityNames == null || this._excludeEntityNames.count() == 0)) {
            filteredCacheChanges = cacheChanges;
        } else {
            NSMutableArray<ERXDatabase.CacheChange> mutableFilteredCacheChanges = new NSMutableArray<ERXDatabase.CacheChange>();
            int cacheChangeCount = ((NSArray)cacheChanges).count();
            for (int i = 0; i < cacheChangeCount; ++i) {
                EOKeyGlobalID keyGID;
                String entityName;
                ERXDatabase.CacheChange cacheChange = (ERXDatabase.CacheChange)cacheChanges.objectAtIndex(i);
                EOGlobalID gid = cacheChange.gid();
                if (!(gid instanceof EOKeyGlobalID) || !this.shouldSynchronizeEntity(entityName = (keyGID = (EOKeyGlobalID)gid).entityName())) continue;
                mutableFilteredCacheChanges.addObject(cacheChange);
            }
            filteredCacheChanges = mutableFilteredCacheChanges;
        }
        return filteredCacheChanges;
    }

    public abstract void join() throws Throwable;

    public abstract void leave() throws Throwable;

    public abstract void listen() throws Throwable;

    public void writeCacheChanges(int transactionID, NSArray cacheChanges) throws Throwable {
        this._writeCacheChanges(transactionID, this.filteredCacheChanges(cacheChanges));
    }

    protected abstract void _writeCacheChanges(int var1, NSArray var2) throws Throwable;

    public static class RefByteArrayOutputStream
    extends ByteArrayOutputStream {
        public byte[] buffer() {
            return this.buf;
        }
    }
}

