/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.statistics;

import com.webobjects.appserver.WOContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.components.ERXStatelessComponent;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.statistics.ERXStats;
import java.util.Enumeration;

public class ERXStatsSummary
extends ERXStatelessComponent {
    public String currentType;
    private NSDictionary _statsByType;
    private NSArray _statsTypes;

    public ERXStatsSummary(WOContext context) {
        super(context);
    }

    public NSDictionary statsByType() {
        if (null == this._statsByType) {
            if (this.hasBinding("aggregateStats")) {
                this._statsByType = (NSDictionary)this.valueForBinding("aggregateStats");
            } else {
                NSMutableDictionary<String, NSMutableArray<ERXStats.LogEntry>> dict = new NSMutableDictionary<String, NSMutableArray<ERXStats.LogEntry>>();
                NSArray<ERXStats.LogEntry> entries = ERXStats.aggregateLogEntries();
                for (ERXStats.LogEntry logEntry : entries) {
                    String group = ERXStringUtilities.firstPropertyKeyInKeyPath(logEntry.key());
                    NSMutableArray<ERXStats.LogEntry> eventsForType = (NSMutableArray<ERXStats.LogEntry>)dict.objectForKey(group);
                    if (null == eventsForType) {
                        eventsForType = new NSMutableArray<ERXStats.LogEntry>();
                        dict.setObjectForKey(eventsForType, group);
                    }
                    eventsForType.addObject(logEntry);
                }
                this._statsByType = dict;
            }
        }
        return this._statsByType;
    }

    public NSArray statsTypes() {
        if (null == this._statsTypes) {
            this._statsTypes = ERXArrayUtilities.sortedArrayUsingComparator(this.statsByType().allKeys(), NSComparator.AscendingCaseInsensitiveStringComparator);
        }
        return this._statsTypes;
    }

    public long durationForStatsType() {
        long result = 0L;
        NSArray statsForType = (NSArray)this.statsByType().valueForKey(this.currentType);
        Enumeration statsEnum = statsForType.objectEnumerator();
        while (statsEnum.hasMoreElements()) {
            ERXStats.LogEntry logEntry = (ERXStats.LogEntry)statsEnum.nextElement();
            result += logEntry.sum();
        }
        return result;
    }

    public boolean hasStats() {
        return this.statsTypes().count() > 0;
    }

    public void reset() {
        super.reset();
        this.currentType = null;
        this._statsByType = null;
        this._statsTypes = null;
    }
}

