/*
 * Decompiled with CFR 0.152.
 */
package com.meetup.memcached;

import java.util.Date;
import org.apache.log4j.Logger;

public class NativeHandler {
    private static Logger log = Logger.getLogger((String)NativeHandler.class.getName());

    public static boolean isHandled(Object value) {
        return value instanceof Byte || value instanceof Boolean || value instanceof Integer || value instanceof Long || value instanceof Character || value instanceof String || value instanceof StringBuffer || value instanceof Float || value instanceof Short || value instanceof Double || value instanceof Date || value instanceof StringBuilder || value instanceof byte[];
    }

    public static int getMarkerFlag(Object value) {
        if (value instanceof Byte) {
            return 1;
        }
        if (value instanceof Boolean) {
            return 8192;
        }
        if (value instanceof Integer) {
            return 4;
        }
        if (value instanceof Long) {
            return 16384;
        }
        if (value instanceof Character) {
            return 16;
        }
        if (value instanceof String) {
            return 32;
        }
        if (value instanceof StringBuffer) {
            return 64;
        }
        if (value instanceof Float) {
            return 128;
        }
        if (value instanceof Short) {
            return 256;
        }
        if (value instanceof Double) {
            return 512;
        }
        if (value instanceof Date) {
            return 1024;
        }
        if (value instanceof StringBuilder) {
            return 2048;
        }
        if (value instanceof byte[]) {
            return 4096;
        }
        return -1;
    }

    public static byte[] encode(Object value) throws Exception {
        if (value instanceof Byte) {
            return NativeHandler.encode((Byte)value);
        }
        if (value instanceof Boolean) {
            return NativeHandler.encode((Boolean)value);
        }
        if (value instanceof Integer) {
            return NativeHandler.encode((Integer)value);
        }
        if (value instanceof Long) {
            return NativeHandler.encode((Long)value);
        }
        if (value instanceof Character) {
            return NativeHandler.encode((Character)value);
        }
        if (value instanceof String) {
            return NativeHandler.encode((String)value);
        }
        if (value instanceof StringBuffer) {
            return NativeHandler.encode((StringBuffer)value);
        }
        if (value instanceof Float) {
            return NativeHandler.encode(((Float)value).floatValue());
        }
        if (value instanceof Short) {
            return NativeHandler.encode((Short)value);
        }
        if (value instanceof Double) {
            return NativeHandler.encode((Double)value);
        }
        if (value instanceof Date) {
            return NativeHandler.encode((Date)value);
        }
        if (value instanceof StringBuilder) {
            return NativeHandler.encode((StringBuilder)value);
        }
        if (value instanceof byte[]) {
            return NativeHandler.encode((byte[])value);
        }
        return null;
    }

    protected static byte[] encode(Byte value) {
        byte[] b = new byte[]{value};
        return b;
    }

    protected static byte[] encode(Boolean value) {
        byte[] b = new byte[]{value != false ? (byte)1 : 0};
        return b;
    }

    protected static byte[] encode(int value) {
        return NativeHandler.getBytes(value);
    }

    protected static byte[] encode(long value) throws Exception {
        return NativeHandler.getBytes(value);
    }

    protected static byte[] encode(Date value) {
        return NativeHandler.getBytes(value.getTime());
    }

    protected static byte[] encode(Character value) {
        return NativeHandler.encode((int)value.charValue());
    }

    protected static byte[] encode(String value) throws Exception {
        return value.getBytes("UTF-8");
    }

    protected static byte[] encode(StringBuffer value) throws Exception {
        return NativeHandler.encode(value.toString());
    }

    protected static byte[] encode(float value) throws Exception {
        return NativeHandler.encode(Float.floatToIntBits(value));
    }

    protected static byte[] encode(Short value) throws Exception {
        return NativeHandler.encode((int)value.shortValue());
    }

    protected static byte[] encode(double value) throws Exception {
        return NativeHandler.encode(Double.doubleToLongBits(value));
    }

    protected static byte[] encode(StringBuilder value) throws Exception {
        return NativeHandler.encode(value.toString());
    }

    protected static byte[] encode(byte[] value) {
        return value;
    }

    protected static byte[] getBytes(long value) {
        byte[] b = new byte[]{(byte)(value >> 56 & 0xFFL), (byte)(value >> 48 & 0xFFL), (byte)(value >> 40 & 0xFFL), (byte)(value >> 32 & 0xFFL), (byte)(value >> 24 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value >> 0 & 0xFFL)};
        return b;
    }

    protected static byte[] getBytes(int value) {
        byte[] b = new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 0 & 0xFF)};
        return b;
    }

    public static Object decode(byte[] b, int flag) throws Exception {
        if (b.length < 1) {
            return null;
        }
        if ((flag & 1) == 1) {
            return NativeHandler.decodeByte(b);
        }
        if ((flag & 0x2000) == 8192) {
            return NativeHandler.decodeBoolean(b);
        }
        if ((flag & 4) == 4) {
            return NativeHandler.decodeInteger(b);
        }
        if ((flag & 0x4000) == 16384) {
            return NativeHandler.decodeLong(b);
        }
        if ((flag & 0x10) == 16) {
            return NativeHandler.decodeCharacter(b);
        }
        if ((flag & 0x20) == 32) {
            return NativeHandler.decodeString(b);
        }
        if ((flag & 0x40) == 64) {
            return NativeHandler.decodeStringBuffer(b);
        }
        if ((flag & 0x80) == 128) {
            return NativeHandler.decodeFloat(b);
        }
        if ((flag & 0x100) == 256) {
            return NativeHandler.decodeShort(b);
        }
        if ((flag & 0x200) == 512) {
            return NativeHandler.decodeDouble(b);
        }
        if ((flag & 0x400) == 1024) {
            return NativeHandler.decodeDate(b);
        }
        if ((flag & 0x800) == 2048) {
            return NativeHandler.decodeStringBuilder(b);
        }
        if ((flag & 0x1000) == 4096) {
            return NativeHandler.decodeByteArr(b);
        }
        return null;
    }

    protected static Byte decodeByte(byte[] b) {
        return new Byte(b[0]);
    }

    protected static Boolean decodeBoolean(byte[] b) {
        boolean value = b[0] == 1;
        return value ? Boolean.TRUE : Boolean.FALSE;
    }

    protected static Integer decodeInteger(byte[] b) {
        return new Integer(NativeHandler.toInt(b));
    }

    protected static Long decodeLong(byte[] b) throws Exception {
        return new Long(NativeHandler.toLong(b));
    }

    protected static Character decodeCharacter(byte[] b) {
        return new Character((char)NativeHandler.decodeInteger(b).intValue());
    }

    protected static String decodeString(byte[] b) throws Exception {
        return new String(b, "UTF-8");
    }

    protected static StringBuffer decodeStringBuffer(byte[] b) throws Exception {
        return new StringBuffer(NativeHandler.decodeString(b));
    }

    protected static Float decodeFloat(byte[] b) throws Exception {
        Integer l = NativeHandler.decodeInteger(b);
        return new Float(Float.intBitsToFloat(l));
    }

    protected static Short decodeShort(byte[] b) throws Exception {
        return new Short((short)NativeHandler.decodeInteger(b).intValue());
    }

    protected static Double decodeDouble(byte[] b) throws Exception {
        Long l = NativeHandler.decodeLong(b);
        return new Double(Double.longBitsToDouble(l));
    }

    protected static Date decodeDate(byte[] b) {
        return new Date(NativeHandler.toLong(b));
    }

    protected static StringBuilder decodeStringBuilder(byte[] b) throws Exception {
        return new StringBuilder(NativeHandler.decodeString(b));
    }

    protected static byte[] decodeByteArr(byte[] b) {
        return b;
    }

    protected static int toInt(byte[] b) {
        return ((b[3] & 0xFF) << 32) + ((b[2] & 0xFF) << 40) + ((b[1] & 0xFF) << 48) + ((b[0] & 0xFF) << 56);
    }

    protected static long toLong(byte[] b) {
        return ((long)b[7] & 0xFFL) + (((long)b[6] & 0xFFL) << 8) + (((long)b[5] & 0xFFL) << 16) + (((long)b[4] & 0xFFL) << 24) + (((long)b[3] & 0xFFL) << 32) + (((long)b[2] & 0xFFL) << 40) + (((long)b[1] & 0xFFL) << 48) + (((long)b[0] & 0xFFL) << 56);
    }
}

