/*
 * Decompiled with CFR 0.152.
 */
package er.caching;

import com.meetup.memcached.SockIOPool;
import com.meetup.memcached.test.UnitTests;
import com.thimbleware.jmemcached.Cache;
import com.thimbleware.jmemcached.LRUCacheStorageDelegate;
import com.thimbleware.jmemcached.MemCacheDaemon;
import com.webobjects.appserver.WOApplication;
import com.webobjects.foundation.NSForwardException;
import er.extensions.ERXFrameworkPrincipal;
import er.extensions.foundation.ERXProperties;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.log4j.Logger;

public class ERCaching
extends ERXFrameworkPrincipal {
    private static Logger log = Logger.getLogger(ERCaching.class);

    public void finishInitialization() {
        ERCaching.startServer();
        ERCaching.startClient();
    }

    public static void startClient() {
        String servers = ERXProperties.stringForKey((String)"er.caching.servers");
        if (servers == null || servers.length() == 0) {
            log.error((Object)"No Servers found, set er.caching.servers=server1:port1,server2:port2...");
            return;
        }
        String[] serverlist = servers.split(",\\s*");
        SockIOPool pool = SockIOPool.getInstance();
        pool.setServers(serverlist);
        pool.setInitConn(ERXProperties.intForKeyWithDefault((String)"er.caching.initialConnections", (int)5));
        pool.setMinConn(ERXProperties.intForKeyWithDefault((String)"er.caching.minConnections", (int)5));
        pool.setMaxConn(ERXProperties.intForKeyWithDefault((String)"er.caching.maxConnections", (int)50));
        pool.setMaintSleep(ERXProperties.intForKeyWithDefault((String)"er.caching.sleepTime", (int)30));
        pool.setNagle(ERXProperties.booleanForKeyWithDefault((String)"er.caching.useNagle", (boolean)false));
        pool.initialize();
    }

    public static void startServer() {
        try {
            int port = ERXProperties.intForKeyWithDefault((String)"er.caching.server.port", (int)0);
            if (port > 0) {
                int maxItems = ERXProperties.intForKeyWithDefault((String)"er.caching.server.maxItems", (int)0);
                int maxMemory = ERXProperties.intForKeyWithDefault((String)"er.caching.server.maxMemory", (int)128);
                MemCacheDaemon daemon = new MemCacheDaemon();
                LRUCacheStorageDelegate cacheStorage = new LRUCacheStorageDelegate(maxItems, maxMemory * 1024 * 1024, 0L);
                daemon.setCache(new Cache(cacheStorage));
                String host = ERXProperties.stringForKeyWithDefault((String)"er.caching.server.host", (String)WOApplication.application().host());
                daemon.setAddr(new InetSocketAddress(host, port));
                daemon.setIdleTime(50);
                daemon.setVerbose(true);
                daemon.start();
                log.info((Object)("Server started: " + host + ":" + port + " maxItems=" + maxItems + " maxMemory=" + maxMemory));
            }
        }
        catch (IOException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    public static void runTests() {
        UnitTests.main(new String[0]);
    }

    static {
        ERCaching.setUpFrameworkPrincipalClass(ERCaching.class);
    }
}

