/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import net.spy.SpyObject;
import net.spy.memcached.ArrayModNodeLocator;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.protocol.ascii.AsciiMemcachedNodeImpl;
import net.spy.memcached.protocol.ascii.AsciiOperationFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConnectionFactory
extends SpyObject
implements ConnectionFactory {
    public static final int DEFAULT_OP_QUEUE_LEN = 16384;
    public static final int DEFAULT_READ_BUFFER_SIZE = 16384;
    public static final long DEFAULT_OPERATION_TIMEOUT = 1000L;
    private final int opQueueLen;
    private final int readBufSize;
    private final HashAlgorithm hashAlg;

    public DefaultConnectionFactory(int qLen, int bufSize, HashAlgorithm hash) {
        this.opQueueLen = qLen;
        this.readBufSize = bufSize;
        this.hashAlg = hash;
    }

    public DefaultConnectionFactory(int qLen, int bufSize) {
        this(qLen, bufSize, HashAlgorithm.NATIVE_HASH);
    }

    public DefaultConnectionFactory() {
        this(16384, 16384);
    }

    @Override
    public MemcachedNode createMemcachedNode(SocketAddress sa, SocketChannel c, int bufSize) {
        return new AsciiMemcachedNodeImpl(sa, c, bufSize, this.createReadOperationQueue(), this.createWriteOperationQueue(), this.createOperationQueue());
    }

    @Override
    public MemcachedConnection createConnection(List<InetSocketAddress> addrs) throws IOException {
        return new MemcachedConnection(this.getReadBufSize(), this, addrs);
    }

    @Override
    public BlockingQueue<Operation> createOperationQueue() {
        return new ArrayBlockingQueue<Operation>(this.getOpQueueLen());
    }

    @Override
    public BlockingQueue<Operation> createReadOperationQueue() {
        return new ArrayBlockingQueue<Operation>((int)((double)this.getOpQueueLen() * 1.1));
    }

    @Override
    public BlockingQueue<Operation> createWriteOperationQueue() {
        return this.createOperationQueue();
    }

    @Override
    public NodeLocator createLocator(List<MemcachedNode> nodes) {
        return new ArrayModNodeLocator(nodes, this.getHashAlg());
    }

    public int getOpQueueLen() {
        return this.opQueueLen;
    }

    public int getReadBufSize() {
        return this.readBufSize;
    }

    public HashAlgorithm getHashAlg() {
        return this.hashAlg;
    }

    @Override
    public OperationFactory getOperationFactory() {
        return new AsciiOperationFactory();
    }

    @Override
    public long getOperationTimeout() {
        return 1000L;
    }

    @Override
    public boolean isDaemon() {
        return false;
    }
}

