/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import net.spy.memcached.ops.CASOperation;
import net.spy.memcached.ops.ConcatenationOperation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.StoreOperation;
import net.spy.memcached.ops.StoreType;
import net.spy.memcached.protocol.binary.OperationImpl;

class StoreOperationImpl
extends OperationImpl
implements StoreOperation,
CASOperation,
ConcatenationOperation {
    private static final int SET = 1;
    private static final int ADD = 2;
    private static final int REPLACE = 3;
    private final String key;
    private final int flags;
    private final int exp;
    private final long cas;
    private final byte[] data;

    private static int cmdMap(StoreType t) {
        int rv = -1;
        switch (t) {
            case set: {
                rv = 1;
                break;
            }
            case add: {
                rv = 2;
                break;
            }
            case replace: {
                rv = 3;
            }
        }
        assert (rv != -1) : "Unhandled store type:  " + (Object)((Object)t);
        return rv;
    }

    public StoreOperationImpl(StoreType t, String k, int f, int e, byte[] d, long c, OperationCallback cb) {
        super(StoreOperationImpl.cmdMap(t), StoreOperationImpl.generateOpaque(), cb);
        this.key = k;
        this.flags = f;
        this.exp = e;
        this.data = d;
        this.cas = c;
    }

    public void initialize() {
        this.prepareBuffer(this.key, this.cas, this.data, this.flags, this.exp);
    }

    protected OperationStatus getStatusForErrorCode(int errCode, byte[] errPl) {
        OperationStatus rv = null;
        switch (errCode) {
            case 2: {
                rv = EXISTS_STATUS;
                break;
            }
            case 1: {
                rv = NOT_FOUND_STATUS;
            }
        }
        return rv;
    }
}

