/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj;

import java.io.Serializable;
import javassist.gluonj.WeaveException;
import javassist.gluonj.pc.AndPc;
import javassist.gluonj.pc.CallPc;
import javassist.gluonj.pc.CflowPc;
import javassist.gluonj.pc.GetPc;
import javassist.gluonj.pc.IfPc;
import javassist.gluonj.pc.NotPc;
import javassist.gluonj.pc.OrPc;
import javassist.gluonj.pc.PatternParser;
import javassist.gluonj.pc.PointcutNode;
import javassist.gluonj.pc.PrepareVisitor;
import javassist.gluonj.pc.SetPc;
import javassist.gluonj.pc.WithinPc;
import javassist.gluonj.plugin.MetaTag;
import javassist.gluonj.weave.AliasList;
import javassist.gluonj.weave.Gluon;

public class Pointcut
implements Serializable {
    private PointcutNode tree = null;
    private Pointcut prev;
    protected AliasList aliases;
    public Pointcut not;
    public Pointcut and;
    public Pointcut or;
    boolean _init_flag;

    protected Pointcut(Pointcut back) {
        this(back, false);
        Object var2_2 = null;
        if (!this._init_flag) {
            this._init_flag = true;
            this._init();
        }
    }

    protected Pointcut(Pointcut back, boolean withNot) {
        this.prev = back;
        this.aliases = null;
        this.or = null;
        this.and = null;
        this.not = withNot ? new Pointcut(this, false) : null;
        Object var3_3 = null;
        if (!this._init_flag) {
            this._init_flag = true;
            this._init();
        }
    }

    protected boolean isNot() {
        return false;
    }

    public String toString() {
        AliasList a = new AliasList();
        String str = this.parse(a).toString();
        if (a.next == null) {
            return str;
        }
        return a.next.toString() + " " + str;
    }

    protected static PointcutNode parse(Gluon gluon, Pointcut pc, AliasList a) throws WeaveException {
        return pc.parse(gluon, a);
    }

    private PointcutNode parse(Gluon gluon, AliasList a) throws WeaveException {
        PointcutNode pcn = this.parse(a);
        Pointcut.prepare(new PatternParser(gluon), pcn);
        return pcn;
    }

    private static void prepare(PatternParser parser, PointcutNode pcn) throws WeaveException {
        pcn.accept(new PrepareVisitor(parser));
    }

    protected PointcutNode parse(AliasList allAliases) {
        Iterator it = new Iterator();
        it.node = this;
        OrPc expr = this.parseOr(it, null, allAliases);
        if (expr.rest() == null) {
            return expr.first();
        }
        return expr;
    }

    OrPc parseOr(Iterator it, OrPc tail, AliasList allAliases) {
        Pointcut pc;
        do {
            AndPc left;
            tail = new OrPc((left = this.parseAnd(it, null, allAliases)).rest() == null ? left.first() : left, tail);
            pc = it.node;
            if (pc == null) break;
            it.node = pc.prev;
        } while (it.node != null && it.node.or == pc);
        return tail;
    }

    AndPc parseAnd(Iterator it, AndPc tail, AliasList allAliases) {
        Pointcut pc;
        while ((pc = it.node) != null) {
            boolean isNotPc = pc.prev == null ? pc.isNot() : pc.prev.not == pc;
            PointcutNode tree = isNotPc ? new NotPc(pc.tree) : pc.tree;
            tail = new AndPc(tree, tail);
            if (pc.aliases != null) {
                allAliases.next = AliasList.concat(allAliases.next, pc.aliases);
            }
            if (isNotPc && pc.prev != null) {
                pc = pc.prev;
            }
            it.node = pc.prev;
            if (it.node != null && it.node.and == pc) continue;
        }
        it.node = pc;
        return tail;
    }

    protected void setTree(PointcutNode node) {
        if (this.tree != null) {
            throw new RuntimeException("syntax error in pointcut");
        }
        this.tree = node;
        this.and = new Pointcut(this, true);
        this.or = new Pointcut(this, true);
        this.not = null;
    }

    Pointcut setAlias0(AliasList a) {
        this.aliases = a;
        return this;
    }

    public Pointcut define(String aliasName, String expr) {
        throw new RuntimeException("syntax error in define");
    }

    void define0(String aliasName, String expr) {
        AliasList a = new AliasList(aliasName, expr);
        this.aliases = AliasList.concat(this.aliases, a);
    }

    public Pointcut expr(Pointcut pc) {
        AliasList a = new AliasList();
        this.setTree(pc.parse(a));
        this.aliases = a.next;
        return this;
    }

    public Pointcut within(String className) {
        this.setTree(new WithinPc(className));
        return this;
    }

    public Pointcut call(String method) {
        this.setTree(new CallPc(method));
        return this;
    }

    public Pointcut set(String field) {
        this.setTree(new SetPc(field));
        return this;
    }

    public Pointcut get(String field) {
        this.setTree(new GetPc(field));
        return this;
    }

    public Pointcut when(String expr) {
        this.setTree(new IfPc(expr));
        return this;
    }

    public Pointcut cflow(String method) {
        this.setTree(new CflowPc(method));
        return this;
    }

    private void _init() {
    }

    public Pointcut annotate(String tag) {
        this.setTree(new MetaTag.AnnotatePc(tag));
        return this;
    }

    static class Iterator {
        Pointcut node;

        Iterator() {
        }
    }
}

