/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.embedded.bytecode.annotation;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javassist.gluonj.embedded.ClassPool;
import javassist.gluonj.embedded.CtClass;
import javassist.gluonj.embedded.CtMethod;
import javassist.gluonj.embedded.NotFoundException;
import javassist.gluonj.embedded.bytecode.ConstPool;
import javassist.gluonj.embedded.bytecode.Descriptor;
import javassist.gluonj.embedded.bytecode.annotation.AnnotationImpl;
import javassist.gluonj.embedded.bytecode.annotation.AnnotationMemberValue;
import javassist.gluonj.embedded.bytecode.annotation.AnnotationsWriter;
import javassist.gluonj.embedded.bytecode.annotation.ArrayMemberValue;
import javassist.gluonj.embedded.bytecode.annotation.BooleanMemberValue;
import javassist.gluonj.embedded.bytecode.annotation.ByteMemberValue;
import javassist.gluonj.embedded.bytecode.annotation.CharMemberValue;
import javassist.gluonj.embedded.bytecode.annotation.ClassMemberValue;
import javassist.gluonj.embedded.bytecode.annotation.DoubleMemberValue;
import javassist.gluonj.embedded.bytecode.annotation.EnumMemberValue;
import javassist.gluonj.embedded.bytecode.annotation.FloatMemberValue;
import javassist.gluonj.embedded.bytecode.annotation.IntegerMemberValue;
import javassist.gluonj.embedded.bytecode.annotation.LongMemberValue;
import javassist.gluonj.embedded.bytecode.annotation.MemberValue;
import javassist.gluonj.embedded.bytecode.annotation.ShortMemberValue;
import javassist.gluonj.embedded.bytecode.annotation.StringMemberValue;

public class Annotation {
    ConstPool pool;
    int typeIndex;
    HashMap members;

    public Annotation(int type, ConstPool cp) {
        this.pool = cp;
        this.typeIndex = type;
        this.members = null;
    }

    public Annotation(String typeName, ConstPool cp) {
        this(cp.addUtf8Info(Descriptor.of(typeName)), cp);
    }

    public Annotation(ConstPool cp, CtClass clazz) throws NotFoundException {
        this(cp.addUtf8Info(Descriptor.of(clazz.getName())), cp);
        if (!clazz.isInterface()) {
            throw new RuntimeException("Only interfaces are allowed for Annotation creation.");
        }
        CtMethod[] methods = clazz.getDeclaredMethods();
        if (methods.length > 0) {
            this.members = new HashMap();
        }
        int i = 0;
        while (i < methods.length) {
            CtClass returnType = methods[i].getReturnType();
            this.addMemberValue(methods[i].getName(), Annotation.createMemberValue(cp, returnType));
            ++i;
        }
    }

    public static MemberValue createMemberValue(ConstPool cp, CtClass type) throws NotFoundException {
        if (type == CtClass.booleanType) {
            return new BooleanMemberValue(cp);
        }
        if (type == CtClass.byteType) {
            return new ByteMemberValue(cp);
        }
        if (type == CtClass.charType) {
            return new CharMemberValue(cp);
        }
        if (type == CtClass.shortType) {
            return new ShortMemberValue(cp);
        }
        if (type == CtClass.intType) {
            return new IntegerMemberValue(cp);
        }
        if (type == CtClass.longType) {
            return new LongMemberValue(cp);
        }
        if (type == CtClass.floatType) {
            return new FloatMemberValue(cp);
        }
        if (type == CtClass.doubleType) {
            return new DoubleMemberValue(cp);
        }
        if (type.getName().equals("java.lang.Class")) {
            return new ClassMemberValue(cp);
        }
        if (type.getName().equals("java.lang.String")) {
            return new StringMemberValue(cp);
        }
        if (type.isArray()) {
            CtClass arrayType = type.getComponentType();
            MemberValue member = Annotation.createMemberValue(cp, arrayType);
            return new ArrayMemberValue(member, cp);
        }
        if (type.isInterface()) {
            Annotation info = new Annotation(cp, type);
            return new AnnotationMemberValue(info, cp);
        }
        EnumMemberValue emv = new EnumMemberValue(cp);
        emv.setType(type.getName());
        return emv;
    }

    public void addMemberValue(int nameIndex, MemberValue value) {
        Pair p = new Pair();
        p.name = nameIndex;
        p.value = value;
        this.addMemberValue(p);
    }

    public void addMemberValue(String name, MemberValue value) {
        Pair p = new Pair();
        p.name = this.pool.addUtf8Info(name);
        p.value = value;
        if (this.members == null) {
            this.members = new HashMap();
        }
        this.members.put(name, p);
    }

    private void addMemberValue(Pair pair) {
        String name = this.pool.getUtf8Info(pair.name);
        if (this.members == null) {
            this.members = new HashMap();
        }
        this.members.put(name, pair);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("@");
        buf.append(this.getTypeName());
        if (this.members != null) {
            buf.append("(");
            Iterator mit = this.members.keySet().iterator();
            while (mit.hasNext()) {
                String name = (String)mit.next();
                buf.append(name).append("=").append(this.getMemberValue(name));
                if (!mit.hasNext()) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public String getTypeName() {
        return Descriptor.toClassName(this.pool.getUtf8Info(this.typeIndex));
    }

    public Set getMemberNames() {
        if (this.members == null) {
            return null;
        }
        return this.members.keySet();
    }

    public MemberValue getMemberValue(String name) {
        if (this.members == null) {
            return null;
        }
        Pair p = (Pair)this.members.get(name);
        if (p == null) {
            return null;
        }
        return p.value;
    }

    public Object toAnnotationType(ClassLoader cl, ClassPool cp) throws ClassNotFoundException {
        return AnnotationImpl.make(cl, MemberValue.loadClass(cl, this.getTypeName()), cp, this);
    }

    public void write(AnnotationsWriter writer) throws IOException {
        String typeName = this.pool.getUtf8Info(this.typeIndex);
        if (this.members == null) {
            writer.annotation(typeName, 0);
            return;
        }
        writer.annotation(typeName, this.members.size());
        Iterator it = this.members.values().iterator();
        while (it.hasNext()) {
            Pair pair = (Pair)it.next();
            writer.memberValuePair(pair.name);
            pair.value.write(writer);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Annotation)) {
            return false;
        }
        Annotation other = (Annotation)obj;
        if (!this.getTypeName().equals(other.getTypeName())) {
            return false;
        }
        if (this.members == null && other.members != null) {
            return false;
        }
        if (this.members != null && other.members == null) {
            return false;
        }
        return this.members.equals(other.members);
    }

    static class Pair {
        int name;
        MemberValue value;

        Pair() {
        }
    }
}

