/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.pc;

import java.util.ArrayList;
import javassist.gluonj.WeaveException;
import javassist.gluonj.embedded.ClassPool;
import javassist.gluonj.embedded.CtClass;
import javassist.gluonj.embedded.bytecode.Descriptor;
import javassist.gluonj.embedded.compiler.CompileError;
import javassist.gluonj.embedded.compiler.MemberResolver;
import javassist.gluonj.pc.PcPattern;

public class Parser {
    static final char NOT = '!';
    static final char SUBCLASS = '+';
    static final char WILDCARD = '*';
    static final String ANY_PARAM = "..";
    static final String NEW = "new";
    static final String CONSTRUCTOR = "<init>";
    private MemberResolver resolver;
    private String glueName;

    public Parser(String name, ClassPool cp) {
        this.resolver = new MemberResolver(cp);
        this.glueName = name;
    }

    public String getGlueName() {
        return this.glueName;
    }

    public PcPattern parseClass(String text) throws WeaveException {
        return this.parse0(text, true);
    }

    public PcPattern parse(String text) throws WeaveException {
        return this.parse0(text, false);
    }

    private PcPattern parse0(String text, boolean onlyClass) throws WeaveException {
        int len;
        String descriptor;
        String memberName;
        String className;
        int index;
        boolean notPat;
        int textLen;
        if (text == null || (textLen = text.length()) <= 0) {
            throw new WeaveException("empty pattern");
        }
        if (text.charAt(0) == '!') {
            notPat = true;
            index = 1;
        } else {
            notPat = false;
            index = 0;
        }
        int i = text.indexOf(35);
        if (i <= index) {
            className = null;
        } else {
            className = text.substring(index, i);
            index = i + 1;
        }
        if (index >= textLen) {
            memberName = null;
            descriptor = null;
        } else {
            i = text.indexOf(40, index);
            if (i < 0) {
                memberName = text.substring(index);
                descriptor = null;
            } else {
                memberName = text.substring(index, i);
                index = i + 1;
                String[] paramList = Parser.parseParams(text, index);
                StringBuffer sbuf = new StringBuffer();
                this.makeDescriptor(sbuf, text, paramList);
                descriptor = sbuf.toString();
            }
        }
        if (className == null && onlyClass) {
            className = memberName;
            memberName = null;
        }
        boolean subclass = false;
        if (className != null && className.charAt((len = className.length()) - 1) == '+') {
            if (len > 1) {
                className = className.substring(0, len - 1);
                subclass = true;
            } else {
                className = null;
            }
        }
        if (NEW.equals(memberName)) {
            memberName = CONSTRUCTOR;
        }
        return new PcPattern(this.resolver, notPat, this.makeRegex(className), subclass, this.makeRegex(memberName), descriptor);
    }

    private String makeRegex(String pat) {
        if (pat == null) {
            return null;
        }
        StringBuffer sbuf = new StringBuffer();
        int len = pat.length();
        for (int i = 0; i < len; ++i) {
            char c = pat.charAt(i);
            if (c == '.') {
                sbuf.append('\\');
                sbuf.append('.');
                continue;
            }
            if (c == '*') {
                sbuf.append(".*");
                continue;
            }
            sbuf.append(c);
        }
        return sbuf.toString();
    }

    private void makeDescriptor(StringBuffer sbuf, String origText, String[] paramList) throws WeaveException {
        sbuf.append('(');
        for (int k = 0; k < paramList.length; ++k) {
            String type = paramList[k];
            if (type.equals(ANY_PARAM)) {
                if (k + 1 == paramList.length) {
                    return;
                }
                throw new WeaveException("bad use of ..:" + origText);
            }
            if (Parser.includesWildCards(type)) {
                throw new WeaveException("cannot use a wild card in a parameter list");
            }
            type = this.resolveClassName(type);
            Parser.toDescriptor(sbuf, type);
        }
        sbuf.append(')');
    }

    private static boolean includesWildCards(String text) {
        return text.indexOf(42) >= 0;
    }

    private String resolveClassName(String className) throws WeaveException {
        try {
            CtClass cc = this.resolver.lookupClass(className, false);
            return cc.getName();
        }
        catch (CompileError e) {
            throw new WeaveException(e.getMessage());
        }
    }

    private static String[] parseParams(String text, int index) throws WeaveException {
        int c;
        ArrayList<String> list = new ArrayList<String>();
        int len = text.length();
        StringBuffer sbuf = new StringBuffer();
        while ((c = Parser.getNext(text, index++, len)) != 41) {
            if (c == 44) {
                if (sbuf.length() < 1) {
                    throw new WeaveException("bad syntax: " + text);
                }
                list.add(sbuf.toString());
                sbuf = new StringBuffer();
                continue;
            }
            if (c == 32 || c == 9) continue;
            sbuf.append((char)c);
        }
        if (sbuf.length() > 0) {
            list.add(sbuf.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    private static int getNext(String text, int i, int len) throws WeaveException {
        if (i < len) {
            return text.charAt(i);
        }
        throw new WeaveException("bad syntax:" + text);
    }

    private static void toDescriptor(StringBuffer sbuf, String type) {
        int dim = 0;
        while (type.endsWith("[]")) {
            ++dim;
            type = type.substring(0, type.length() - 2);
        }
        while (dim-- > 0) {
            sbuf.append('[');
        }
        sbuf.append(Descriptor.of(type));
    }
}

