/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.pc;

import java.util.regex.Pattern;
import javassist.gluonj.WeaveException;
import javassist.gluonj.embedded.CtClass;
import javassist.gluonj.embedded.NotFoundException;
import javassist.gluonj.embedded.compiler.CompileError;
import javassist.gluonj.embedded.compiler.MemberResolver;

public class PcPattern {
    private MemberResolver resolver;
    boolean not;
    boolean subclass;
    private String className;
    private String memberName;
    private String descriptor;
    private Pattern classPat;
    private Pattern memberPat;
    private PcPattern orPat;

    public PcPattern(MemberResolver mr, boolean notPat, String clazz, boolean includesSubclass, String member, String desc) {
        this.resolver = mr;
        this.not = notPat;
        this.orPat = null;
        this.subclass = includesSubclass;
        this.className = clazz;
        this.memberName = member;
        this.descriptor = desc;
        this.classPat = clazz == null ? null : Pattern.compile(clazz);
        this.memberPat = member == null ? null : Pattern.compile(member);
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        if (this.not) {
            sbuf.append('!');
        }
        sbuf.append(this.className == null ? "?" : this.className);
        if (this.subclass) {
            sbuf.append('+');
        }
        sbuf.append('#').append(this.memberName == null ? "?" : this.memberName);
        sbuf.append(':').append(this.descriptor == null ? "?" : this.descriptor);
        if (this.orPat != null) {
            sbuf.append('|').append(this.orPat.toString());
        }
        return sbuf.toString();
    }

    public void setOr(PcPattern pat) {
        this.orPat = pat;
    }

    public PcPattern getOr() {
        return this.orPat;
    }

    public boolean isClassName() {
        return this.memberName == null && this.descriptor == null && this.className != null || this.orPat != null && this.orPat.isClassName();
    }

    public boolean isMethod() {
        return this.memberName != null && this.descriptor != null || this.orPat != null && this.orPat.isMethod();
    }

    public boolean isField() {
        return this.memberName != null && this.descriptor == null || this.orPat != null && this.orPat.isField();
    }

    public boolean matchClass(String name) throws WeaveException {
        boolean match = this.matchClass0(name);
        if (this.not) {
            match = !match;
        }
        return match || this.orPat != null && this.orPat.matchClass(name);
    }

    private boolean matchClass0(String name) throws WeaveException {
        if (name != null) {
            if (this.match(this.classPat, name)) {
                return true;
            }
            if (this.subclass) {
                try {
                    CtClass clazz = this.resolver.lookupClass(name, false);
                    if (this.matchClass0(clazz)) {
                        return true;
                    }
                }
                catch (CompileError ce) {
                    throw new WeaveException(ce);
                }
                catch (NotFoundException ne) {
                    throw new WeaveException(ne);
                }
            }
        }
        return false;
    }

    private boolean matchClass0(CtClass clazz) throws NotFoundException {
        if (clazz == null) {
            return false;
        }
        if (this.match(this.classPat, clazz.getName())) {
            return true;
        }
        CtClass parent = clazz.getSuperclass();
        if (this.matchClass0(parent)) {
            return true;
        }
        CtClass[] intfs = clazz.getInterfaces();
        for (int i = 0; i < intfs.length; ++i) {
            if (!this.matchClass0(intfs[0])) continue;
            return true;
        }
        return false;
    }

    private boolean match(Pattern pat, String name) {
        return pat.matcher(name).matches();
    }

    public boolean matchField(String clazz, String field) throws WeaveException {
        boolean yes;
        boolean bl = yes = (this.className == null || this.matchClass0(clazz)) && this.match(this.memberPat, field);
        if (this.not) {
            yes = !yes;
        }
        return yes || this.orPat != null && this.orPat.matchField(clazz, field);
    }

    public boolean matchMethod(String declClass, String name, String desc) throws WeaveException {
        boolean yes;
        boolean bl = yes = (this.className == null || this.matchClass0(declClass)) && this.match(this.memberPat, name) && desc != null && this.descriptor != null && desc.startsWith(this.descriptor);
        if (this.not) {
            yes = !yes;
        }
        return yes || this.orPat != null && this.orPat.matchMethod(declClass, name, desc);
    }
}

